/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.compositeDto.Address;
import at.cdes.api.dto.ActionInfo;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.Country;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrderAddress;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationOrderStep;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PlotOrderSearchModel;
import at.cdes.api.dto.PlottOrder;
import at.cdes.api.dto.PlottOrderItem;
import at.cdes.api.dto.PlottOrderItemTemplate;
import at.cdes.api.dto.PlottOrderTemplate;
import at.cdes.api.dto.PlottProperties;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ProjectParticipationOrderStep;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstancePlottOrderListener;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCyclePlottTask;
import at.cdes.api.dto.Signature;
import at.cdes.api.dto.SubProject;
import at.cdes.api.guiService.PlotService;
import at.cdes.api.guiService.TaskService;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.PersonJoin;
import at.cdes.api.joinDto.PlotOrderDeleteJoin;
import at.cdes.api.joinDto.PlotOrderEditJoin;
import at.cdes.api.joinDto.PlotOrderJoin;
import at.cdes.api.joinDto.PlotOrderTemplateJoin;
import at.cdes.api.joinDto.PlotOrderTemplatePageJoin;
import at.cdes.api.joinDto.PlotOrderZipExportJoin;
import at.cdes.api.joinDto.PlotTaskJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.joinDto.ReviewCycleSelectJoin;
import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.api.plot.compositeDto.CreatePlotOrderData;
import at.cdes.api.plot.compositeDto.OrderAddressEditInfo;
import at.cdes.api.plot.compositeDto.PlotOrderItemTemplateInfo;
import at.cdes.api.plot.compositeDto.PlotOrderSignInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplateEditInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplateInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplatePageInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplateSearchModel;
import at.cdes.api.plot.compositeDto.PlotTaskInfo;
import at.cdes.api.plot.compositeDto.PlotTaskItemInfo;
import at.cdes.api.plot.voc.OrderAddressType;
import at.cdes.api.plot.voc.PlotColor;
import at.cdes.api.plot.voc.PlotDeliveryTarget;
import at.cdes.api.plot.voc.PlotKindOfDelivery;
import at.cdes.api.plot.voc.PlotMargin;
import at.cdes.api.plot.voc.PlotPaperQuality;
import at.cdes.api.plot.voc.PlotScale;
import at.cdes.api.plot.voc.PlotTemplateResolver;
import at.cdes.api.review.compositeDto.ReviewCycleTreeInfo;
import at.cdes.api.sec.SignatureCalculator;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.OrderStepMode;
import at.cdes.api.voc.action.Action;
import at.cdes.api.voc.plot.AcceptedMode;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.CountryDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentReleaseDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.DocumentVersionTaskDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.OrderAddressDAO;
import at.cdes.impl.dao.OrderStepDAO;
import at.cdes.impl.dao.OrganisationOrderStepDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.dao.PlotOrderAcceptanceTaskDAO;
import at.cdes.impl.dao.PlottOrderDAO;
import at.cdes.impl.dao.PlottOrderItemDAO;
import at.cdes.impl.dao.PlottOrderItemTemplateDAO;
import at.cdes.impl.dao.PlottOrderTemplateDAO;
import at.cdes.impl.dao.PlottPropertiesDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectHolidayDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ProjectParticipationOrderStepDAO;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstancePlottOrderListenerDAO;
import at.cdes.impl.dao.ReviewCyclePlottTaskDAO;
import at.cdes.impl.dao.SignatureDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.dao.unionComponent.PlotOrderTemplateSearchComponent;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.digest.DocumentDigester;
import at.cdes.impl.digest.PlotOrderDigester;
import at.cdes.impl.export.plot.PlotOrderPdfCallable;
import at.cdes.impl.export.plot.PlotOrderPdfExporter;
import at.cdes.impl.export.plot.PlotOrderZipExportCallable;
import at.cdes.impl.export.plot.PlotOrderZipExporter;
import at.cdes.impl.export.plot.PlotTaskPdfCallable;
import at.cdes.impl.export.plot.PlotTaskPdfExporter;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.plot.PlotUtils;
import at.cdes.impl.reviewCycle.ReviewUtils;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SyncWithDBResult;
import at.cdes.impl.util.i18n.I18nHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotServiceImpl
implements PlotService {
    private static final Logger log = LoggerFactory.getLogger(PlotServiceImpl.class);
    private ActionDAO actionDAO;
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private CertificateDAO certificateDAO;
    private CountryDAO countryDAO;
    private DocumentDAO documentDAO;
    private DocumentReleaseDAO documentReleaseDAO;
    private DocumentDigester documentDigester;
    private DocumentVersionDAO documentVersionDAO;
    private VisitlessMimeSource documentVersionMimeSource;
    private DocumentVersionTaskDAO documentVersionTaskDAO;
    private EmailSnippetDAO emailSnippetDAO;
    private FutureEmailDAO futureEmailDAO;
    private String odfStylePrefix;
    private Long odfTimeout;
    private IOneTimeScheduler oneTimeScheduler;
    private ObjectPlannerDAO objectPlannerDAO;
    private OOoFileEngine oooFileEngine;
    private OrderAddressDAO orderAddressDAO;
    private OrderStepDAO orderStepDAO;
    private OrganisationOrderStepDAO organisationOrderStepDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonDAO personDAO;
    private PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO;
    private PlotOrderDigester plotOrderDigester;
    private PlottOrderDAO plotOrderDAO;
    private PlottOrderItemDAO plotOrderItemDAO;
    private PlottOrderItemTemplateDAO plotOrderItemTemplateDAO;
    private PlottOrderTemplateDAO plotOrderTemplateDAO;
    private PlotTaskPdfExporter plotTaskPdfExporter;
    private PlotUtils plotUtils;
    private PlottPropertiesDAO plotPropertiesDAO;
    private ProjectHolidayDAO projectHolidayDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ProjectParticipationOrderStepDAO projectParticipationOrderStepDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewCycleNodeInstancePlottOrderListenerDAO reviewCycleNodeInstancePlottOrderListenerDAO;
    private ReviewCyclePlottTaskDAO reviewCyclePlotTaskDAO;
    private SignatureCalculator signatureCalculator;
    private SignatureDAO signatureDAO;
    private TaskDAO taskDAO;
    private TaskEmailSnippetDAO taskEmailSnippetDAO;
    private ProjectDAO projectDAO;
    private ReviewUtils reviewUtils;
    private SubProjectDAO subProjectDAO;
    private TaskService taskService;
    private TaskUtils taskUtils;
    private String tempDirName;
    private PlotOrderPdfExporter plotOrderPdfExporter;
    private PlotOrderZipExporter plotOrderZipExporter;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setCountryDAO(CountryDAO countryDAO) {
        this.countryDAO = countryDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentReleaseDAO(DocumentReleaseDAO documentReleaseDAO) {
        this.documentReleaseDAO = documentReleaseDAO;
    }

    public void setDocumentDigester(DocumentDigester documentDigester) {
        this.documentDigester = documentDigester;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentVersionMimeSource(VisitlessMimeSource documentVersionMimeSource) {
        this.documentVersionMimeSource = documentVersionMimeSource;
    }

    public void setDocumentVersionTaskDAO(DocumentVersionTaskDAO documentVersionTaskDAO) {
        this.documentVersionTaskDAO = documentVersionTaskDAO;
    }

    public void setEmailSnippetDAO(EmailSnippetDAO emailSnippetDAO) {
        this.emailSnippetDAO = emailSnippetDAO;
    }

    public void setFutureEmailDAO(FutureEmailDAO futureEmailDAO) {
        this.futureEmailDAO = futureEmailDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrderAddressDAO(OrderAddressDAO orderAddressDAO) {
        this.orderAddressDAO = orderAddressDAO;
    }

    public void setOrderStepDAO(OrderStepDAO orderStepDAO) {
        this.orderStepDAO = orderStepDAO;
    }

    public void setOrganisationOrderStepDAO(OrganisationOrderStepDAO organisationOrderStepDAO) {
        this.organisationOrderStepDAO = organisationOrderStepDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setPlotOrderAcceptanceTaskDAO(PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO) {
        this.plotOrderAcceptanceTaskDAO = plotOrderAcceptanceTaskDAO;
    }

    public void setPlotOrderDigester(PlotOrderDigester plotOrderDigester) {
        this.plotOrderDigester = plotOrderDigester;
    }

    public void setPlotOrderDAO(PlottOrderDAO plotOrderDAO) {
        this.plotOrderDAO = plotOrderDAO;
    }

    public void setPlotOrderItemDAO(PlottOrderItemDAO plotOrderItemDAO) {
        this.plotOrderItemDAO = plotOrderItemDAO;
    }

    public void setPlotOrderItemTemplateDAO(PlottOrderItemTemplateDAO plotOrderItemTemplateDAO) {
        this.plotOrderItemTemplateDAO = plotOrderItemTemplateDAO;
    }

    public void setPlotOrderTemplateDAO(PlottOrderTemplateDAO plotOrderTemplateDAO) {
        this.plotOrderTemplateDAO = plotOrderTemplateDAO;
    }

    public void setPlotTaskPdfExporter(PlotTaskPdfExporter plotTaskPdfExporter) {
        this.plotTaskPdfExporter = plotTaskPdfExporter;
    }

    public void setPlotUtils(PlotUtils plotUtils) {
        this.plotUtils = plotUtils;
    }

    public void setPlotPropertiesDAO(PlottPropertiesDAO plotPropertiesDAO) {
        this.plotPropertiesDAO = plotPropertiesDAO;
    }

    public void setProjectHolidayDAO(ProjectHolidayDAO projectHolidayDAO) {
        this.projectHolidayDAO = projectHolidayDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setProjectParticipationOrderStepDAO(ProjectParticipationOrderStepDAO projectParticipationOrderStepDAO) {
        this.projectParticipationOrderStepDAO = projectParticipationOrderStepDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public ReviewCycleNodeInstancePlottOrderListenerDAO getReviewCycleNodeInstancePlottOrderListenerDAO() {
        return this.reviewCycleNodeInstancePlottOrderListenerDAO;
    }

    public void setReviewCycleNodeInstancePlottOrderListenerDAO(ReviewCycleNodeInstancePlottOrderListenerDAO reviewCycleNodeInstancePlottOrderListenerDAO) {
        this.reviewCycleNodeInstancePlottOrderListenerDAO = reviewCycleNodeInstancePlottOrderListenerDAO;
    }

    public void setReviewCyclePlotTaskDAO(ReviewCyclePlottTaskDAO reviewCyclePlottTaskDAO) {
        this.reviewCyclePlotTaskDAO = reviewCyclePlottTaskDAO;
    }

    public void setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public void setTaskEmailSnippetDAO(TaskEmailSnippetDAO taskEmailSnippetDAO) {
        this.taskEmailSnippetDAO = taskEmailSnippetDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewUtils(ReviewUtils reviewUtils) {
        this.reviewUtils = reviewUtils;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPlotOrderPdfExporter(PlotOrderPdfExporter plotOrderPdfExporter) {
        this.plotOrderPdfExporter = plotOrderPdfExporter;
    }

    public void setPlotOrderZipExporter(PlotOrderZipExporter plotOrderZipExporter) {
        this.plotOrderZipExporter = plotOrderZipExporter;
    }

    public List<PlotOrderJoin> getPlotOrderJoinByIds(Long organisationPersonId, List<Long> plotOrderIds) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        return this.doGetPlotOrderJoinByIds(plotOrderIds);
    }

    private List<PlotOrderJoin> doGetPlotOrderJoinByIds(List<Long> plotOrderIds) {
        long beforeMillis = System.currentTimeMillis();
        List<PlotOrderJoin> joinDtosFromQuery = this.plotOrderDAO.getPlotOrderJoin(plotOrderIds);
        if (log.isDebugEnabled()) {
            long afterMillis = System.currentTimeMillis();
            log.debug("Queried " + joinDtosFromQuery.size() + " dtos in " + (afterMillis - beforeMillis) + "ms.");
        }
        return this.processPlotOrderJoin(joinDtosFromQuery, true, null);
    }

    public List<PlotOrderJoin> getPlotOrderJoin(Long organisationPersonId, PlotOrderSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        long beforeMillis = System.currentTimeMillis();
        List<PlotOrderJoin> joinDtosFromQuery = this.plotOrderDAO.getPlotOrderJoin(searchModel);
        if (log.isDebugEnabled()) {
            long afterMillis = System.currentTimeMillis();
            log.debug("Queried " + joinDtosFromQuery.size() + " dtos in " + (afterMillis - beforeMillis) + "ms.");
        }
        return this.processPlotOrderJoin(joinDtosFromQuery, searchModel.getIncludeCompleted(), searchModel.getOrganisationPersonId());
    }

    private List<PlotOrderJoin> processPlotOrderJoin(List<PlotOrderJoin> joinDtosFromQuery, Boolean includeCompleted, Long organisationPersonId) {
        HashMap plotOrderIdToJoinDtos = new HashMap();
        for (PlotOrderJoin plotOrderJoin : joinDtosFromQuery) {
            Long plotOrderId = plotOrderJoin.getPlotOrderId();
            if (!plotOrderIdToJoinDtos.containsKey(plotOrderId)) {
                plotOrderIdToJoinDtos.put(plotOrderId, new ArrayList());
            }
            ((List)plotOrderIdToJoinDtos.get(plotOrderId)).add(plotOrderJoin);
        }
        HashSet<Long> completedPlotOrderIds = new HashSet<Long>();
        for (Long plotOrderId : plotOrderIdToJoinDtos.keySet()) {
            List receivedJoinDtos = (List)plotOrderIdToJoinDtos.get(plotOrderId);
            int numberOfReceivedSigned = 0;
            for (PlotOrderJoin joinDto : receivedJoinDtos) {
                if (joinDto.getReceivedStepFinished() == null) continue;
                ++numberOfReceivedSigned;
            }
            PlotOrderJoin joinDto = (PlotOrderJoin)receivedJoinDtos.get(0);
            if (!(joinDto.getAcceptanceStepAcceptedMode() != null && joinDto.getAcceptanceStepAcceptedMode().intValue() == OrderStepMode.DECLINED.getValue() || joinDto.getCompletedStepAcceptedMode() != null && joinDto.getCompletedStepAcceptedMode().intValue() == OrderStepMode.DECLINED.getValue() || receivedJoinDtos.size() > 0 && receivedJoinDtos.size() == numberOfReceivedSigned) && (joinDto.isProjectIgnorePlotOrderReceivedSteps() == null || !joinDto.isProjectIgnorePlotOrderReceivedSteps().booleanValue() || joinDto.getCompletedStepSignatureId() == null)) continue;
            completedPlotOrderIds.add(joinDto.getPlotOrderId());
        }
        ArrayList<PlotOrderJoin> arrayList = new ArrayList<PlotOrderJoin>();
        for (Long plotOrderId : plotOrderIdToJoinDtos.keySet()) {
            if ((includeCompleted == null || !includeCompleted.booleanValue()) && completedPlotOrderIds.contains(plotOrderId)) continue;
            PlotOrderJoin joinDto = (PlotOrderJoin)((List)plotOrderIdToJoinDtos.get(plotOrderId)).get(0);
            Integer countTotal = 0;
            Integer countSigned = 0;
            Integer countDeclined = 0;
            Integer countOwn = 0;
            List<PlottOrderItem> pItems = this.plotOrderItemDAO.getByOrderContractWithValidDocumentVersion(plotOrderId);
            countTotal = pItems.size();
            for (PlotOrderJoin currJoinDto : (List)plotOrderIdToJoinDtos.get(plotOrderId)) {
                Integer n;
                if (!(currJoinDto.getReceivedStepSignatureId() == null || currJoinDto.getReceivedStepFinished() == null || currJoinDto.getDocumentVersionStatus() == null || currJoinDto.getDocumentVersionStatus().equals(DocumentVersionStatus.DELETED) || currJoinDto.getDocumentVersionStatus().equals(DocumentVersionStatus.INVALIDATEDALL) || currJoinDto.getDocumentVersionStatus().equals(DocumentVersionStatus.INVALIDATEDVERSION))) {
                    n = countSigned;
                    countSigned = countSigned + 1;
                }
                if (currJoinDto.getReceivedStepAcceptedMode() != null && currJoinDto.getReceivedStepAcceptedMode().intValue() == OrderStepMode.DECLINED.getValue()) {
                    n = countDeclined;
                    countDeclined = countDeclined + 1;
                }
                if (currJoinDto.getPlotOrderItemReceiverId() == null || organisationPersonId == null || currJoinDto.getSubProjectInvalidated() != null && currJoinDto.getSubProjectInvalidated().booleanValue() || currJoinDto.getReceivedStepFinished() != null) continue;
                List<ProjectParticipant> pps = this.projectParticipantDAO.getByParticipation(currJoinDto.getPlotOrderItemReceiverId());
                for (ProjectParticipant pp : pps) {
                    if (!pp.getOrganisationPersonId().equals(organisationPersonId)) continue;
                    Integer n2 = countOwn;
                    countOwn = countOwn + 1;
                }
            }
            joinDto.setPlotOrderCountsCountTotal(countTotal);
            joinDto.setPlotOrderCountsCountSigned(countSigned);
            joinDto.setPlotOrderCountsCountDeclined(countDeclined);
            joinDto.setPlotOrderCountsCountOwn(countOwn);
            arrayList.add(joinDto);
        }
        return arrayList;
    }

    public List<PlotOrderEditJoin> getPlotOrderEditJoin(Long plotOrderId, Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<PlotOrderEditJoin> joins = this.plotOrderDAO.getPlotOrderEditJoin(plotOrderId);
        if (joins.size() <= 0) {
            return joins;
        }
        Long subProjectId = joins.get(0).getSubProjectId();
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        List<String> contentLocales = I18nHelper.getContentLocales(localisationJoin);
        for (PlotOrderEditJoin plotOrderEditJoin : joins) {
            String documentReleaseContent = plotOrderEditJoin.getDocumentReleaseContent();
            if (documentReleaseContent != null) {
                documentReleaseContent = I18nHelper.convertDatabaseToJs(documentReleaseContent, personVariablesUserLocale, contentLocales);
                plotOrderEditJoin.setDocumentReleaseContent(documentReleaseContent);
            } else {
                String documentContent = plotOrderEditJoin.getDocumentContent();
                documentContent = I18nHelper.convertDatabaseToJs(documentContent, personVariablesUserLocale, contentLocales);
                plotOrderEditJoin.setDocumentContent(documentContent);
            }
            String reviewCycleNodeName = plotOrderEditJoin.getReviewCycleNodeName();
            reviewCycleNodeName = I18nHelper.convertDatabaseToJs(reviewCycleNodeName, personVariablesUserLocale, contentLocales);
            plotOrderEditJoin.setReviewCycleNodeName(reviewCycleNodeName);
        }
        return joins;
    }

    public void deletePlotOrder(Long plotOrderId, Long organisationPersonId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Action, ActionInfo> allowedProjectActions = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.EDIT_PROJECT);
        if (!allowedProjectActions.containsKey(Action.EDIT_PROJECT)) {
            throw new SecurityException("Cannot delete the plot order due to missing project role [editProject]");
        }
        List<PlotOrderDeleteJoin> deleteJoins = this.plotOrderDAO.getPlotOrderDeleteJoin(plotOrderId);
        PlottOrder plotOrder = null;
        OrderStep acceptanceStep = null;
        HashMap<Long, PlottOrderItem> idToPlotOrderItem = new HashMap<Long, PlottOrderItem>();
        HashMap<Long, ReviewCyclePlottTask> taskIdToTask = new HashMap<Long, ReviewCyclePlottTask>();
        for (PlotOrderDeleteJoin deleteJoin : deleteJoins) {
            if (deleteJoin.getPlotOrderId() != null) {
                plotOrder = deleteJoin.getPlotOrder();
            }
            if (deleteJoin.getAcceptanceStepId() != null) {
                acceptanceStep = deleteJoin.getAcceptanceStep();
            }
            if (deleteJoin.getPlotOrderItemId() != null) {
                idToPlotOrderItem.put(deleteJoin.getPlotOrderItemId(), deleteJoin.getPlotOrderItem());
            }
            if (deleteJoin.getReviewCyclePlotTaskTaskId() == null) continue;
            taskIdToTask.put(deleteJoin.getReviewCyclePlotTaskTaskId(), deleteJoin.getReviewCyclePlotTask());
        }
        if (acceptanceStep != null && acceptanceStep.getSignatureId() != null) {
            throw new RuntimeException("Cannot delete plot order, since it was already accepted.");
        }
        ArrayList taskIdsToDelete = new ArrayList(taskIdToTask.keySet());
        this.reviewCyclePlotTaskDAO.deleteBatch(taskIdsToDelete);
        this.documentVersionTaskDAO.deleteBatch(taskIdsToDelete);
        this.taskDAO.deleteBatch(taskIdsToDelete);
        HashSet<Long> plotPropertyIdsToDelete = new HashSet<Long>();
        HashSet<Long> orderAddressIdsToDelete = new HashSet<Long>();
        for (PlottOrderItem plotOrderItem : idToPlotOrderItem.values()) {
            plotPropertyIdsToDelete.add(plotOrderItem.getPlottPropertiesId());
            orderAddressIdsToDelete.add(plotOrderItem.getDeliveryAddressId());
        }
        this.plotOrderItemDAO.deleteBatch(idToPlotOrderItem.keySet());
        this.plotPropertiesDAO.deleteBatch(plotPropertyIdsToDelete);
        this.orderAddressDAO.deleteBatch(orderAddressIdsToDelete);
        HashSet<Long> orderStepIdsToDelete = new HashSet<Long>();
        orderStepIdsToDelete.add(plotOrder.getAcceptanceId());
        orderStepIdsToDelete.add(plotOrder.getRequestId());
        this.plotOrderDAO.delete(plotOrder.getId());
        List organisationOrderSteps = this.organisationOrderStepDAO.getBatch(orderStepIdsToDelete);
        ArrayList<Long> organisationOrderStepIdsToDelete = new ArrayList<Long>();
        for (OrganisationOrderStep organisationOrderStep : organisationOrderSteps) {
            organisationOrderStepIdsToDelete.add(organisationOrderStep.getOrderStepId());
        }
        this.organisationOrderStepDAO.deleteBatch(organisationOrderStepIdsToDelete);
        List projectParticipationOrderSteps = this.projectParticipationOrderStepDAO.getBatch(orderStepIdsToDelete);
        ArrayList<Long> projectParticipationOrderStepIdsToDelete = new ArrayList<Long>();
        for (ProjectParticipationOrderStep projectParticipationOrderStep : projectParticipationOrderSteps) {
            projectParticipationOrderStepIdsToDelete.add(projectParticipationOrderStep.getOrderStepId());
        }
        this.projectParticipationOrderStepDAO.deleteBatch(projectParticipationOrderStepIdsToDelete);
        this.orderStepDAO.deleteBatch(orderStepIdsToDelete);
    }

    public void deletePlotOrderItem(Long plotOrderItemId, Long organisationPersonId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Action, ActionInfo> allowedProjectActions = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.EDIT_PROJECT);
        if (!allowedProjectActions.containsKey(Action.EDIT_PROJECT)) {
            throw new SecurityException("Cannot delete the plot order item due to missing project role [editProject]");
        }
        List<PlotOrderDeleteJoin> deleteJoins = this.plotOrderDAO.getPlotOrderDeleteJoin(plotOrderItemId);
        OrderStep acceptanceStep = null;
        PlottOrderItem plotOrderItem = null;
        for (PlotOrderDeleteJoin deleteJoin : deleteJoins) {
            if (deleteJoin.getAcceptanceStepId() != null) {
                acceptanceStep = deleteJoin.getAcceptanceStep();
            }
            if (deleteJoin.getPlotOrderItemId() == null) continue;
            plotOrderItem = deleteJoin.getPlotOrderItem();
        }
        if (acceptanceStep != null && acceptanceStep.getSignatureId() != null) {
            throw new RuntimeException("Cannot delete plot order item, since its plot order was already accepted.");
        }
        if (plotOrderItem != null) {
            if (plotOrderItem.getDeliveryAddressId() != null) {
                this.orderAddressDAO.delete(plotOrderItem.getDeliveryAddressId());
            }
            if (plotOrderItem.getPlottPropertiesId() != null) {
                this.plotPropertiesDAO.delete(plotOrderItem.getPlottPropertiesId());
            }
            this.plotOrderItemDAO.delete(plotOrderItem.getId());
        }
    }

    public void declarePlotOrdersCharged(Long organisationPersonId, Long projectId, List<Long> plotOrderIds, String password) {
        int n;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ProjectParticipant signer = this.projectParticipantDAO.getSigner(organisationPersonId, projectId, "chargePlotOrder");
        if (signer == null) {
            throw new SecurityException("No valid signer for organisationPersonId = [" + organisationPersonId + "] and projectId = [" + projectId + "] found; will NOT declare the plotOrderIds charged.");
        }
        Certificate certificate = this.certificateDAO.getSignerCertificate(organisationPersonId);
        if (certificate == null) {
            throw new SecurityException("No valid certificate found for organisationPersonId = [" + organisationPersonId + "]");
        }
        List<PlotOrderJoin> plotOrderJoins = this.doGetPlotOrderJoinByIds(plotOrderIds);
        HashMap plotOrderIdToJoins = new HashMap();
        for (PlotOrderJoin plotOrderJoin : plotOrderJoins) {
            if (plotOrderJoin.getPlotOrderCountsCountSigned() == null || plotOrderJoin.getPlotOrderCountsCountDeclined() == null || plotOrderJoin.getPlotOrderCountsCountTotal() == null || plotOrderJoin.getPlotOrderCountsCountSigned() + plotOrderJoin.getPlotOrderCountsCountDeclined() != plotOrderJoin.getPlotOrderCountsCountTotal()) {
                throw new IllegalArgumentException("Only plotOrders with countSigned == countTotal may be declared charged.");
            }
            if (plotOrderJoin.getChargedStepSignatureId() != null) {
                throw new IllegalArgumentException("Trying to declare already charged plot order charged again.");
            }
            Long plotOrderId = plotOrderJoin.getPlotOrderId();
            if (!plotOrderIdToJoins.containsKey(plotOrderId)) {
                plotOrderIdToJoins.put(plotOrderId, new ArrayList());
            }
            ((List)plotOrderIdToJoins.get(plotOrderId)).add(plotOrderJoin);
        }
        ArrayList<PlottOrder> plotOrders = new ArrayList<PlottOrder>();
        List<OrderStep> chargeOrderSteps = new ArrayList();
        List<Signature> signatures = new ArrayList();
        for (Long plotOrderId : plotOrderIdToJoins.keySet()) {
            List plotOrderJoinsForPlotOrder = (List)plotOrderIdToJoins.get(plotOrderId);
            PlottOrder plotOrder = null;
            OrderAddress billingAddress = null;
            ArrayList<PlottOrderItem> plotOrderItems = new ArrayList<PlottOrderItem>();
            ArrayList<String> plotOrderItemDigests = new ArrayList<String>();
            for (PlotOrderJoin plotOrderJoin : plotOrderJoinsForPlotOrder) {
                plotOrder = plotOrderJoin.getPlotOrder();
                billingAddress = plotOrderJoin.getBillingAddress();
                PlottOrderItem plotOrderItem = plotOrderJoin.getPlotOrderItem();
                PlottProperties plotProperties = plotOrderJoin.getPlotProperties();
                OrderAddress deliveryAddress = plotOrderJoin.getDeliveryOrderAddress();
                plotOrderItems.add(plotOrderItem);
                String plotOrderItemDigest = this.plotOrderDigester.getPlotOrderItemHash(plotOrderItem, plotProperties, deliveryAddress);
                plotOrderItemDigests.add(plotOrderItemDigest);
            }
            plotOrders.add(plotOrder);
            String plotOrderDigest = this.plotOrderDigester.getPlotOrderHash(plotOrder, billingAddress);
            String contentToSign = this.plotOrderDigester.getPlotOrderCompositeHash(plotOrderDigest, plotOrderItemDigests);
            OrderStep chargeOrderStep = new OrderStep();
            chargeOrderStep.setDigest(contentToSign);
            chargeOrderStep.setDigestCalculatorId(null);
            Double currentUtcSeconds = DateHelper.getCurrentUtcSeconds();
            chargeOrderStep.setCreated(currentUtcSeconds);
            chargeOrderStep.setFinished(currentUtcSeconds);
            chargeOrderStep.setAcceptedMode(Integer.valueOf(OrderStepMode.ACCEPTED.getValue()));
            chargeOrderStep.setComment(null);
            chargeOrderSteps.add(chargeOrderStep);
            Signature signature = this.signatureCalculator.createSignature(signer, contentToSign, certificate, password);
            signatures.add(signature);
        }
        signatures = this.signatureDAO.saveBatch(signatures);
        for (n = 0; n < signatures.size(); ++n) {
            Signature signature = (Signature)signatures.get(n);
            OrderStep chargeOrderStep = (OrderStep)chargeOrderSteps.get(n);
            chargeOrderStep.setSignatureId(signature.getId());
            chargeOrderStep.setOrderItemId(null);
        }
        chargeOrderSteps = this.orderStepDAO.saveBatch(chargeOrderSteps);
        for (n = 0; n < chargeOrderSteps.size(); ++n) {
            OrderStep chargeOrderStep = (OrderStep)chargeOrderSteps.get(n);
            PlottOrder plotOrder = (PlottOrder)plotOrders.get(n);
            plotOrder.setChargedStepId(chargeOrderStep.getId());
        }
        this.plotOrderDAO.updateBatch(plotOrders);
    }

    public String triggerExportPlotOrdersToPdf(Long organisationPersonId, Network network, Project project, List<PlotOrderJoin> plotOrderJoins, String personVariablesUserLocale) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        PlotOrderPdfCallable job = new PlotOrderPdfCallable(this.plotOrderPdfExporter, this, organisationPersonId, network, project, plotOrderJoins, personVariablesUserLocale);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String triggerExportPlotTaskToPdf(Long organisationPersonId, Long taskId, boolean plotOrderAcceptance) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        PlotTaskPdfCallable job = new PlotTaskPdfCallable(this.plotTaskPdfExporter, this, organisationPersonId, taskId, plotOrderAcceptance);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String triggerExportCompletePlotOrder(Long organisationPersonId, Long projectId, Long plotOrderId, String personVariablesUserLocale) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List<PlotOrderZipExportJoin> zipExportJoins = this.plotOrderDAO.getPlotOrderZipExportJoin(plotOrderId);
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinByProject(projectId);
        List<String> contentLocales = I18nHelper.getContentLocales(localisationJoin);
        for (PlotOrderZipExportJoin plotOrderZipExportJoin : zipExportJoins) {
            String documentContent = plotOrderZipExportJoin.getDocumentContent();
            documentContent = I18nHelper.getLocaleStringFromDatabase(documentContent, personVariablesUserLocale, contentLocales);
            plotOrderZipExportJoin.setDocumentContent(documentContent);
        }
        PlotOrderZipExportCallable job = new PlotOrderZipExportCallable(this.plotOrderZipExporter, this, this.documentVersionMimeSource, organisationPersonId, projectId, plotOrderId, zipExportJoins, this.tempDirName, personVariablesUserLocale);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String checkAndCreatePlotTask(Long organisationPersonId, Long projectId, Long plotOrderId, String personVariablesUserLocale) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        PlottOrder plotOrder = (PlottOrder)this.plotOrderDAO.get(plotOrderId);
        List<ReviewCyclePlottTask> reviewCyclePlotTasks = this.reviewCyclePlotTaskDAO.getByOrder(plotOrderId);
        if (!reviewCyclePlotTasks.isEmpty()) {
            return "ReviewCyclePlotTask for plotOrderId = [" + plotOrderId + "] allready exists";
        }
        List<PlottOrderItem> plotOrderItems = this.plotOrderItemDAO.getByOrderContract(plotOrder);
        Long documentVersionId = null;
        if (!plotOrderItems.isEmpty()) {
            PlottOrderItem plotOrderItem = plotOrderItems.get(0);
            documentVersionId = plotOrderItem.getDocumentVersionId();
        }
        PlotOrderTemplateJoin templateJoin = this.plotOrderTemplateDAO.getSignPlotOrdersJoin(plotOrder.getTemplateId(), projectId);
        String locale = templateJoin.getPlotterPersonVariablesUserLocale();
        Long plotterId = templateJoin.getPlottOrderTemplatePlotterId();
        Long participationId = templateJoin.getPlottOrderTemplatePlotterId();
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        Long objectPlannerId = contextJoin.getObjectPlannerId();
        Long localisationId = contextJoin.getProjectLocalisationId();
        Long acceptanceId = plotOrder.getAcceptanceId();
        Long missingTaskForStepId = null;
        if (acceptanceId != null) {
            OrderStep acceptanceStep = (OrderStep)this.orderStepDAO.get(acceptanceId);
            if (acceptanceStep.getFinished() == null) {
                missingTaskForStepId = acceptanceId;
            } else {
                Long completedId = plotOrder.getCompletedId();
                OrderStep completedStep = (OrderStep)this.orderStepDAO.get(completedId);
                if (completedStep.getFinished() == null) {
                    missingTaskForStepId = completedId;
                }
            }
        }
        if (missingTaskForStepId == null) {
            return "ReviewCyclePlotTask for plotOrderId = [" + plotOrderId + "] allready exists";
        }
        if (log.isInfoEnabled()) {
            log.info("Generating missing ReviewCyclePlotTask for plotOrderId = [" + plotOrderId + "]");
        }
        Long generatedTaskId = this.taskUtils.generateReviewCyclePlotTask(new DebugContext(), documentVersionId, plotOrderId, missingTaskForStepId, projectId, locale, localisationId, participationId, objectPlannerId);
        return "Generated missing ReviewCyclePlotTask with id=" + generatedTaskId;
    }

    public CreatePlotOrderData getCreateManualPlotOrderData(Long organisationPersonId, Long documentVersionId, PlotOrderTemplateSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        CreatePlotOrderData createPlotOrderData = new CreatePlotOrderData();
        Document document = this.documentDAO.getByDocumentVersion(documentVersionId);
        createPlotOrderData.setDocument(document);
        SubProject subProject = this.subProjectDAO.getByDocumentVersion(documentVersionId);
        ArrayList<Long> documentIds = new ArrayList<Long>(Arrays.asList(document.getId()));
        List<DocumentRelease> documentRelList = this.documentReleaseDAO.getReleasedDocuments(documentIds, subProject.getId());
        if (!documentRelList.isEmpty()) {
            createPlotOrderData.setDocumentRelease(documentRelList.get(0));
        }
        ArrayList<PlotOrderTemplateJoin> templateJoins = new ArrayList<PlotOrderTemplateJoin>();
        HashMap templateIdToItemJoins = new HashMap();
        List<PlotOrderTemplateJoin> joins = this.plotOrderTemplateDAO.getPlotOrderTemplateJoins(searchModel);
        for (PlotOrderTemplateJoin join : joins) {
            int unionClause = join.getUnionClause();
            if (unionClause == PlotOrderTemplateSearchComponent.PLOT_ORDER.getValue()) {
                templateJoins.add(join);
                continue;
            }
            if (unionClause == PlotOrderTemplateSearchComponent.PLOT_ORDER_ITEM.getValue()) {
                Long templateId = join.getPlottOrderItemTemplateOrderContractId();
                if (!templateIdToItemJoins.containsKey(templateId)) {
                    templateIdToItemJoins.put(templateId, new ArrayList());
                }
                ((List)templateIdToItemJoins.get(templateId)).add(join);
                continue;
            }
            throw new IllegalArgumentException("Unsupported unionClause [" + unionClause + "]");
        }
        createPlotOrderData.setTemplateJoins(templateJoins);
        createPlotOrderData.setTemplateIdToItemJoins(templateIdToItemJoins);
        if (searchModel.getWithValidReceivers() != null && searchModel.getWithValidReceivers().booleanValue()) {
            ContextJoin contextJoin = this.objectPlannerDAO.getContextJoin(document.getObjectPlannerId());
            Long projectId = contextJoin.getProjectId();
            Set<Action> projectActions = this.getProjectRequestActions(organisationPersonId, projectId);
            Set<Action> objectPlannerActions = this.getObjectPlannerRequestActions(organisationPersonId, projectId);
            boolean ownRecipient = this.hasRequestManualOwnRecipient(projectActions, objectPlannerActions);
            boolean allRecipients = this.hasRequestManualAllRecipients(projectActions, objectPlannerActions);
            boolean allRights = this.hasRequestManualAllRights(projectActions, objectPlannerActions);
            List<OrganisationPersonJoin> validReceivers = this.getValidReceivers(organisationPersonId, projectId, ownRecipient, allRecipients, allRights);
            createPlotOrderData.setValidReceivers(validReceivers);
            createPlotOrderData.setEditablePlotProperties(allRights);
        }
        return createPlotOrderData;
    }

    private List<OrganisationPersonJoin> getValidReceivers(Long organisationPersonId, Long projectId, boolean ownRecipient, boolean allRecipients, boolean allRights) {
        if (allRecipients || allRights) {
            return this.organisationPersonDAO.getOrganisationPersonJoinForProjectParticipants(projectId);
        }
        if (ownRecipient) {
            OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
            ArrayList<OrganisationPersonJoin> validReceivers = new ArrayList<OrganisationPersonJoin>();
            validReceivers.add(organisationPersonJoin);
            return validReceivers;
        }
        return new ArrayList<OrganisationPersonJoin>();
    }

    private Set<Action> getProjectRequestActions(Long organisationPersonId, Long projectId) {
        return this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.REQUEST_MANUAL_PLOT_OWN_RECIPIENT, Action.REQUEST_MANUAL_PLOT_ALL_RECIPIENTS, Action.REQUEST_MANUAL_PLOT_ALL_RIGHTS);
    }

    private Set<Action> getObjectPlannerRequestActions(Long organisationPersonId, Long objectPlannerId) {
        return this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerId, Action.REQUEST_MANUAL_PLOT_OWN_RECIPIENT_OP_CONTEXT, Action.REQUEST_MANUAL_PLOT_ALL_RECIPIENTS_OP_CONTEXT, Action.REQUEST_MANUAL_PLOT_ALL_RIGHTS_OP_CONTEXT);
    }

    private boolean hasRequestManualOwnRecipient(Set<Action> projectActions, Set<Action> objectPlannerActions) {
        return projectActions.contains(Action.REQUEST_MANUAL_PLOT_OWN_RECIPIENT) || objectPlannerActions.contains(Action.REQUEST_MANUAL_PLOT_OWN_RECIPIENT_OP_CONTEXT);
    }

    private boolean hasRequestManualAllRecipients(Set<Action> projectActions, Set<Action> objectPlannerActions) {
        return projectActions.contains(Action.REQUEST_MANUAL_PLOT_ALL_RECIPIENTS) || objectPlannerActions.contains(Action.REQUEST_MANUAL_PLOT_ALL_RECIPIENTS_OP_CONTEXT);
    }

    private boolean hasRequestManualAllRights(Set<Action> projectActions, Set<Action> objectPlannerActions) {
        return projectActions.contains(Action.REQUEST_MANUAL_PLOT_ALL_RIGHTS) || objectPlannerActions.contains(Action.REQUEST_MANUAL_PLOT_ALL_RIGHTS_OP_CONTEXT);
    }

    public void signPlotOrders(Long organisationPersonId, Long documentVersionId, String comment, String password, List<PlotOrderSignInfo> signInfos) {
        PlottOrder plotOrder;
        String actionName;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        Long projectId = contextJoin.getProjectId();
        Set<Action> projectActions = this.getProjectRequestActions(organisationPersonId, projectId);
        Set<Action> objectPlannerActions = this.getObjectPlannerRequestActions(organisationPersonId, projectId);
        boolean ownRecipient = this.hasRequestManualOwnRecipient(projectActions, objectPlannerActions);
        boolean allRecipients = this.hasRequestManualAllRecipients(projectActions, objectPlannerActions);
        boolean allRights = this.hasRequestManualAllRights(projectActions, objectPlannerActions);
        if (allRights) {
            actionName = Action.REQUEST_MANUAL_PLOT_ALL_RIGHTS.getName();
        } else if (allRecipients) {
            actionName = Action.REQUEST_MANUAL_PLOT_ALL_RECIPIENTS.getName();
        } else if (ownRecipient) {
            actionName = Action.REQUEST_MANUAL_PLOT_OWN_RECIPIENT.getName();
        } else {
            throw new SecurityException("No privilege for calling signPlotOrders found");
        }
        List<OrganisationPersonJoin> validReceivers = this.getValidReceivers(organisationPersonId, projectId, ownRecipient, allRecipients, allRights);
        this.checkReceivers(organisationPersonId, validReceivers, signInfos);
        ProjectParticipant signer = this.projectParticipantDAO.getSigner(organisationPersonId, projectId, actionName);
        if (signer == null) {
            throw new SecurityException("No valid signer for organisationPersonId = [" + organisationPersonId + "] and projectId = [" + projectId + "] found; will NOT sign the manual plot orders.");
        }
        Long plotOrderTemplateId = this.getPlotOrderTemplateId(signInfos);
        PlotOrderTemplateJoin templateJoin = this.plotOrderTemplateDAO.getSignPlotOrdersJoin(plotOrderTemplateId, projectId);
        Long plotOrderId = templateJoin.getPlottOrderId();
        if (plotOrderId == null) {
            plotOrder = new PlottOrder();
            plotOrder.setBillingAddressId(templateJoin.getBillingAddressId());
            plotOrder.setPlotterId(templateJoin.getPlotterOrganisationId());
            plotOrder.setTemplateId(templateJoin.getPlottOrderTemplateId());
            plotOrder.setProjectId(projectId);
            plotOrder.setKindOfDelivery(templateJoin.getPlottOrderTemplateKindOfDelivery());
            plotOrder.setComment(comment);
            plotOrder.setJobNumber(Long.valueOf(System.currentTimeMillis()));
            List<PlottOrderItem> plotOrderItems = this.constructPlottOrderItems(documentVersionId, contextJoin, signer, signInfos);
            OrderStep requestStep = new OrderStep();
            requestStep.setCreated(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            requestStep.setFinished(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            requestStep.setAcceptedMode(Integer.valueOf(AcceptedMode.UNDEFINED.getValue()));
            requestStep = (OrderStep)this.orderStepDAO.save(requestStep);
            ProjectParticipationOrderStep requestParticipationStep = new ProjectParticipationOrderStep();
            requestParticipationStep.setOrderStepId(requestStep.getId());
            requestParticipationStep.setProjectParticipationId(signer.getParticipationId());
            requestParticipationStep.setSignerId(signer.getId());
            this.projectParticipationOrderStepDAO.save(requestParticipationStep);
            requestStep.setDigestCalculatorId(null);
            requestStep.setDigest(this.documentDigester.getOrderStepHash(requestStep, requestParticipationStep));
            this.orderStepDAO.update(requestStep);
            OrderStep acceptanceStep = new OrderStep();
            acceptanceStep.setCreated(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            acceptanceStep.setAcceptedMode(Integer.valueOf(AcceptedMode.UNDEFINED.getValue()));
            acceptanceStep = (OrderStep)this.orderStepDAO.save(acceptanceStep);
            ProjectParticipationOrderStep acceptanceParticipationStep = new ProjectParticipationOrderStep();
            acceptanceParticipationStep.setProjectParticipationId(templateJoin.getPlottOrderTemplatePlotterId());
            acceptanceParticipationStep.setOrderStepId(acceptanceStep.getId());
            this.projectParticipationOrderStepDAO.save(acceptanceParticipationStep);
            plotOrder.setRequestId(requestStep.getId());
            plotOrder.setAcceptanceId(acceptanceStep.getId());
            plotOrder = (PlottOrder)this.plotOrderDAO.save(plotOrder);
            this.linkAndSavePlotOrderItems(plotOrderItems, plotOrder.getId());
            this.taskUtils.generateReviewCyclePlotTask(documentVersionId, plotOrder.getId(), acceptanceStep.getId(), templateJoin, contextJoin);
        } else {
            if (comment != null && comment.trim().length() > 0) {
                plotOrder = (PlottOrder)this.plotOrderDAO.get(plotOrderId);
                plotOrder.setComment(comment);
                this.plotOrderDAO.update(plotOrder);
            }
            List<PlottOrderItem> plotOrderItems = this.constructPlottOrderItems(documentVersionId, contextJoin, signer, signInfos);
            this.linkAndSavePlotOrderItems(plotOrderItems, plotOrderId);
        }
        Certificate certificate = this.certificateDAO.getSignerCertificate(organisationPersonId);
        if (certificate == null) {
            throw new SecurityException("No valid certificate found for organisationPersonId = [" + organisationPersonId + "]");
        }
    }

    private void checkReceivers(Long organisationPersonId, List<OrganisationPersonJoin> validReceivers, List<PlotOrderSignInfo> signInfos) {
        HashSet<Long> validOrganisationPersonIds = new HashSet<Long>();
        for (OrganisationPersonJoin validReceiver : validReceivers) {
            validOrganisationPersonIds.add(validReceiver.getOrganisationPersonId());
        }
        for (PlotOrderSignInfo signInfo : signInfos) {
            Long receiverOrganisationPersonId = signInfo.getReceiverOrganisationPersonId();
            if (validOrganisationPersonIds.contains(receiverOrganisationPersonId)) continue;
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to send a plot to [" + receiverOrganisationPersonId + "]");
        }
    }

    private List<PlottOrderItem> constructPlottOrderItems(Long documentVersionId, ContextJoin contextJoin, ProjectParticipant signer, List<PlotOrderSignInfo> signInfos) {
        Long projectId = contextJoin.getProjectId();
        HashSet<Long> receiverOrganisationPersonIds = new HashSet<Long>();
        for (PlotOrderSignInfo signInfo : signInfos) {
            receiverOrganisationPersonIds.add(signInfo.getReceiverOrganisationPersonId());
        }
        Map<Long, ProjectParticipation> receiverOrganisationPersonIdToParticipation = this.projectParticipationDAO.getMainOrOtherParticipationByOrganisationPersons(projectId, receiverOrganisationPersonIds);
        Long[] receiverOrganisationPersonIdArray = receiverOrganisationPersonIds.toArray(new Long[0]);
        List<OrganisationPersonJoin> receiverJoins = this.organisationPersonDAO.getOrganisationPersonJoin(receiverOrganisationPersonIdArray);
        HashMap<Long, OrganisationPersonJoin> receiverOrganisationPersonIdToJoin = new HashMap<Long, OrganisationPersonJoin>();
        for (OrganisationPersonJoin receiverJoin : receiverJoins) {
            receiverOrganisationPersonIdToJoin.put(receiverJoin.getOrganisationPersonId(), receiverJoin);
        }
        ArrayList<PlottOrderItem> plotOrderItems = new ArrayList<PlottOrderItem>();
        List<OrderAddress> orderAddresses = new ArrayList();
        List<PlottProperties> plotProperties = new ArrayList();
        for (PlotOrderSignInfo signInfo : signInfos) {
            PlottOrderItem plotOrderItem = new PlottOrderItem();
            plotOrderItem.setDocumentVersionId(documentVersionId);
            plotOrderItem.setInitiatorId(signer.getId());
            DocumentVersion documentVersion = (DocumentVersion)this.documentVersionDAO.get(documentVersionId);
            signInfo.setLlx(documentVersion.getLlx());
            signInfo.setLly(documentVersion.getLly());
            signInfo.setUrx(documentVersion.getUrx());
            signInfo.setUry(documentVersion.getUry());
            signInfo.setUserUnit(documentVersion.getUserUnit());
            Long receiverOrganisationPersonId = signInfo.getReceiverOrganisationPersonId();
            plotOrderItem.setReceiverOrganisationPersonId(receiverOrganisationPersonId);
            ProjectParticipation receiverParticipation = receiverOrganisationPersonIdToParticipation.get(receiverOrganisationPersonId);
            if (receiverParticipation == null) {
                throw new SecurityException("Found no receiverParticipation for organisationPersonId [" + receiverOrganisationPersonId + "]");
            }
            plotOrderItem.setReceiverId(receiverParticipation.getId());
            plotOrderItem.setCreated(DateHelper.getCurrentUtcSeconds());
            OrganisationPersonJoin receiverJoin = (OrganisationPersonJoin)receiverOrganisationPersonIdToJoin.get(receiverOrganisationPersonId);
            OrderAddress orderAddress = this.constructOrderAddress(receiverJoin);
            orderAddresses.add(orderAddress);
            PlottProperties plotPropertiesInstance = this.constructPlotProperties(signInfo);
            plotProperties.add(plotPropertiesInstance);
            plotOrderItems.add(plotOrderItem);
        }
        plotProperties = this.plotPropertiesDAO.saveBatch(plotProperties);
        orderAddresses = this.orderAddressDAO.saveBatch(orderAddresses);
        for (int n = 0; n < plotOrderItems.size(); ++n) {
            PlottOrderItem plotOrderItem = (PlottOrderItem)plotOrderItems.get(n);
            plotOrderItem.setDeliveryAddressId(((OrderAddress)orderAddresses.get(n)).getId());
            plotOrderItem.setPlottPropertiesId(((PlottProperties)plotProperties.get(n)).getId());
        }
        return plotOrderItems;
    }

    private void linkAndSavePlotOrderItems(List<PlottOrderItem> plotOrderItems, Long plotOrderId) {
        for (PlottOrderItem plotOrderItem : plotOrderItems) {
            plotOrderItem.setOrderContractId(plotOrderId);
        }
        plotOrderItems = this.plotOrderItemDAO.saveBatch(plotOrderItems);
    }

    private OrderAddress constructOrderAddress(OrganisationPersonJoin organisationPersonJoin) {
        OrderAddress orderAddress = new OrderAddress();
        orderAddress.setType(Integer.valueOf(0));
        orderAddress.setCountryId(organisationPersonJoin.getOrganisationPersonCountryId());
        orderAddress.setPostalAddress(organisationPersonJoin.getOrganisationPersonPostalAddress());
        orderAddress.setPostalCode(organisationPersonJoin.getOrganisationPersonPostalCode());
        orderAddress.setLocalityName(organisationPersonJoin.getOrganisationPersonLocalityName());
        orderAddress.setTitle(organisationPersonJoin.getPersonTitle());
        orderAddress.setGender(organisationPersonJoin.getPersonGender());
        orderAddress.setGivenName(organisationPersonJoin.getPersonGivenName());
        orderAddress.setSurName(organisationPersonJoin.getPersonSurName());
        orderAddress.setOrganisationalUnitName(organisationPersonJoin.getOrganisationPersonOrganisationalUnitName());
        orderAddress.setOrganisationName(organisationPersonJoin.getOrganisationName());
        return orderAddress;
    }

    private PlottProperties constructPlotProperties(PlotOrderSignInfo plotOrderSignInfo) {
        PlottProperties plotProperties = new PlottProperties();
        plotProperties.setCount(plotOrderSignInfo.getCount());
        plotProperties.setIsInColor(plotOrderSignInfo.getIsInColor());
        plotProperties.setMargin(plotOrderSignInfo.getMargin());
        plotProperties.setMirror(plotOrderSignInfo.getMirror());
        plotProperties.setPaperQuality(plotOrderSignInfo.getPaperQuality());
        plotProperties.setScale(plotOrderSignInfo.getScale());
        plotProperties.setLlx(plotOrderSignInfo.getLlx());
        plotProperties.setLly(plotOrderSignInfo.getLly());
        plotProperties.setUrx(plotOrderSignInfo.getUrx());
        plotProperties.setUry(plotOrderSignInfo.getUry());
        plotProperties.setUserUnit(plotOrderSignInfo.getUserUnit());
        return plotProperties;
    }

    private Long getPlotOrderTemplateId(List<PlotOrderSignInfo> plotOrderSignInfos) {
        Long plotOrderTemplateId = null;
        for (PlotOrderSignInfo signInfo : plotOrderSignInfos) {
            if (signInfo.getPlottOrderItemTemplateOrderContractId() == null) {
                throw new IllegalArgumentException("No plottOrderItemTemplateOrderContractId - the client did something strange...");
            }
            if (plotOrderTemplateId == null || plotOrderTemplateId.longValue() == signInfo.getPlottOrderItemTemplateOrderContractId().longValue()) {
                plotOrderTemplateId = signInfo.getPlottOrderItemTemplateOrderContractId();
                continue;
            }
            throw new IllegalArgumentException("The given PlotOrderTemplateJoin instances don't share the same plot order template.  ");
        }
        return plotOrderTemplateId;
    }

    public PlotOrderTemplatePageInfo getPlotOrderTemplatePageInfo(Long organisationPersonId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Map<Action, ActionInfo> allowedProjectActions = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.EDIT_PROJECT);
        if (!allowedProjectActions.containsKey(Action.EDIT_PROJECT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] has no permission EDIT_PROJECT for project [" + projectId + "]");
        }
        Set<Action> projectActions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.EDIT_PROJECT);
        PlotOrderTemplatePageInfo pageInfo = new PlotOrderTemplatePageInfo();
        pageInfo.setMayEditTemplate(projectActions.contains(Action.EDIT_PROJECT));
        return pageInfo;
    }

    public PlotOrderTemplateEditInfo getPlotOrderTemplateEditInfo(Long organisationPersonId, Long plotOrderTemplateId, Long projectId) {
        PlotOrderTemplateInfo templateInfo;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (plotOrderTemplateId == null) {
            templateInfo = new PlotOrderTemplateInfo();
            templateInfo.setInvalidated(Boolean.valueOf(false));
            templateInfo.setProjectId(projectId);
        } else {
            templateInfo = this.getPlotOrderTemplateInfoById(organisationPersonId, plotOrderTemplateId);
            projectId = templateInfo.getProjectId();
        }
        Set<Action> projectActions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.EDIT_PROJECT);
        if (!projectActions.contains(Action.EDIT_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to create/edit PlotOrderTemplate [" + plotOrderTemplateId + "] in project [" + projectId + "], action [" + Action.EDIT_PROJECT + "] is missing.");
        }
        Project project = (Project)this.projectDAO.get(projectId);
        Long networkId = project.getNetworkId();
        PlotOrderTemplateEditInfo editInfo = new PlotOrderTemplateEditInfo();
        editInfo.setTemplateInfo(templateInfo);
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinByProject(projectId);
        List<String> contentLocales = I18nHelper.getContentLocales(localisationJoin);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        List<ReviewCycleSelectJoin> reviewCycleSelectJoins = this.reviewCycleDAO.getReviewCycleSelectJoin(networkId);
        ReviewCycleTreeInfo treeInfo = this.reviewUtils.getReviewCycleMaps(personVariablesUserLocale, contentLocales, reviewCycleSelectJoins);
        editInfo.setReviewCycleTreeInfo(treeInfo);
        List<OrderAddress> orderAddresses = this.orderAddressDAO.getByNetworkAndType(null, OrderAddressType.MANUAL);
        editInfo.setOrderAddresses(orderAddresses);
        Integer typeId = 8;
        List<PersonJoin> plotterJoins = this.personDAO.getByProjectAndRole(projectId, typeId);
        editInfo.setPlotterJoins(plotterJoins);
        List<PersonJoin> deliveryPersonJoins = this.personDAO.getByProjectAndRole(projectId, null);
        editInfo.setDeliveryPersonJoins(deliveryPersonJoins);
        return editInfo;
    }

    public PlotOrderTemplateInfo getPlotOrderTemplateInfoById(Long organisationPersonId, Long plotOrderTemplateId) {
        PlotOrderTemplateSearchModel searchModel = new PlotOrderTemplateSearchModel();
        searchModel.setPlotOrderTemplateId(plotOrderTemplateId);
        List<PlotOrderTemplateInfo> templateInfos = this.getPlotOrderTemplateInfos(organisationPersonId, searchModel);
        return templateInfos.size() == 0 ? null : templateInfos.get(0);
    }

    public List<PlotOrderTemplateInfo> getPlotOrderTemplateInfos(Long organisationPersonId, PlotOrderTemplateSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String locale = organisationPersonJoin.getPersonVariablesUserLocale();
        List<PlotOrderTemplatePageJoin> joins = this.plotOrderTemplateDAO.getPlotOrderTemplatePageJoins(searchModel);
        HashMap idToJoins = new HashMap();
        for (PlotOrderTemplatePageJoin join : joins) {
            Long id = join.getPlottOrderTemplateId();
            Long projectId = join.getPlottOrderTemplateProjectId();
            Map<Action, ActionInfo> allowedProjectActions = this.actionDAO.getActionsForProjectMap(organisationPersonId, projectId, Action.EDIT_PROJECT);
            if (!allowedProjectActions.containsKey(Action.EDIT_PROJECT)) {
                throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] has no permission EDIT_PROJECT for project [" + projectId + "]");
            }
            if (!idToJoins.containsKey(id)) {
                idToJoins.put(id, new ArrayList());
            }
            ((List)idToJoins.get(id)).add(join);
        }
        ArrayList<PlotOrderTemplateInfo> templateInfos = new ArrayList<PlotOrderTemplateInfo>();
        for (Long id : idToJoins.keySet()) {
            List currJoins = (List)idToJoins.get(id);
            PlotOrderTemplatePageJoin someJoin = (PlotOrderTemplatePageJoin)currJoins.get(0);
            PlotOrderTemplateInfo templateInfo = new PlotOrderTemplateInfo();
            templateInfo.setId(id);
            templateInfo.setProjectId(someJoin.getPlottOrderTemplateProjectId());
            templateInfo.setName(someJoin.getPlottOrderTemplateName());
            templateInfo.setDescription(someJoin.getPlottOrderTemplateDescription());
            templateInfo.setComment(someJoin.getPlottOrderTemplateComment());
            templateInfo.setInvalidated(someJoin.getPlottOrderTemplateInvalidated());
            templateInfo.setTemplateResolver(PlotTemplateResolver.getByValue((String)someJoin.getPlottOrderTemplateTemplateResolver()));
            templateInfo.setKindOfDelivery(PlotKindOfDelivery.getByValue((String)someJoin.getPlottOrderTemplateKindOfDelivery()));
            templateInfo.setPlotterProjectParticipationId(someJoin.getPlottOrderTemplatePlotterId());
            templateInfo.setReviewCycleId(someJoin.getReviewCycleId());
            Address plotterOrganisationAddress = new Address();
            plotterOrganisationAddress.setOrganisationName(someJoin.getPlotterOrganisationName());
            plotterOrganisationAddress.setPostalAddress(someJoin.getPlotterOrganisationPostalAddress());
            plotterOrganisationAddress.setPostalCode(someJoin.getPlotterOrganisationPostalCode());
            plotterOrganisationAddress.setLocalityName(someJoin.getPlotterOrganisationLocalityName());
            plotterOrganisationAddress.setCountry(someJoin.getPlotterCountryDescDe());
            templateInfo.setPlotterOrganisationAddress(plotterOrganisationAddress);
            Address billingAddress = new Address();
            billingAddress.setOrganisationName(someJoin.getBillingAddressOrganisationName());
            billingAddress.setPostalAddress(someJoin.getBillingAddressPostalAddress());
            billingAddress.setPostalCode(someJoin.getBillingAddressPostalCode());
            billingAddress.setLocalityName(someJoin.getBillingAddressLocalityName());
            billingAddress.setCountry(someJoin.getBillingCountryDescDe());
            templateInfo.setBillingAddressId(someJoin.getBillingAddressId());
            templateInfo.setBillingAddress(billingAddress);
            ArrayList<PlotOrderItemTemplateInfo> itemInfos = new ArrayList<PlotOrderItemTemplateInfo>();
            for (PlotOrderTemplatePageJoin currJoin : currJoins) {
                if (currJoin.getPlottOrderItemTemplateId() == null) continue;
                PlotOrderItemTemplateInfo itemInfo = new PlotOrderItemTemplateInfo();
                itemInfo.setId(currJoin.getPlottOrderItemTemplateId());
                itemInfo.setDeliveryAddressId(currJoin.getPlottOrderItemTemplateDeliveryAddressId());
                itemInfo.setEvaluateMailReceivers(currJoin.getPlottOrderItemTemplateEvaluateMailReceivers());
                itemInfo.setInvalidated(currJoin.getPlottOrderItemTemplateInvalidated());
                PlottProperties plotProperties = currJoin.getPlottProperties();
                itemInfo.setPlotPropertiesId(plotProperties.getId());
                itemInfo.setPlotPropertiesCount(plotProperties.getCount());
                itemInfo.setPlotPropertiesIsInColor(PlotColor.getByValue((int)plotProperties.getIsInColor()));
                itemInfo.setPlotPropertiesLlx(plotProperties.getLlx());
                itemInfo.setPlotPropertiesLly(plotProperties.getLly());
                itemInfo.setPlotPropertiesMargin(PlotMargin.getByValue((String)plotProperties.getMargin()));
                itemInfo.setPlotPropertiesMirror(plotProperties.getMirror());
                itemInfo.setPlotPropertiesPaperQuality(PlotPaperQuality.getByValue((String)plotProperties.getPaperQuality()));
                itemInfo.setPlotPropertiesScale(PlotScale.getByValue((String)plotProperties.getScale()));
                itemInfo.setPlotPropertiesUrx(plotProperties.getUrx());
                itemInfo.setPlotPropertiesUry(plotProperties.getUry());
                itemInfo.setPlotPropertiesUserUnit(plotProperties.getUserUnit());
                if (currJoin.getDeliveryOrganisationId() != null) {
                    itemInfo.setTarget(PlotDeliveryTarget.PROJECT_PARTICIPATION);
                    itemInfo.setOrganisationName(currJoin.getDeliveryOrganisationName());
                    itemInfo.setPersonGivenName(currJoin.getDeliveryPersonGivenName());
                    itemInfo.setPersonSurName(currJoin.getDeliveryPersonSurName());
                } else if (currJoin.getReviewCycleNodeId() != null) {
                    itemInfo.setTarget(PlotDeliveryTarget.REVIEW_CYCLE_NODE);
                    itemInfo.setReviewCycleNodeName(I18nHelper.getLocaleStringFromDatabase(currJoin.getReviewCycleNodeName(), locale));
                    itemInfo.setReviewCycleName(I18nHelper.getLocaleStringFromDatabase(currJoin.getReviewCycleName(), locale));
                }
                itemInfos.add(itemInfo);
            }
            templateInfo.setItems(itemInfos);
            templateInfos.add(templateInfo);
        }
        return templateInfos;
    }

    public void saveOrUpdatePlotOrderTemplate(Long organisationPersonId, PlotOrderTemplateInfo templateInfo) {
        boolean save;
        Long projectId;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        PlottOrderTemplate plotOrderTemplate = this.getPlotOrderTemplateFromInfo(templateInfo);
        if (plotOrderTemplate.getId() != null) {
            PlottOrderTemplate oldTemplate = (PlottOrderTemplate)this.plotOrderTemplateDAO.get(plotOrderTemplate.getId());
            projectId = oldTemplate.getProjectId();
        } else {
            projectId = plotOrderTemplate.getProjectId();
        }
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_PROJECT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is missing action [" + Action.EDIT_PROJECT + "] for project [" + projectId + "], may not saveOrUpdatePlotOrderTemplate [" + plotOrderTemplate.getId() + "]");
        }
        List<PlottOrderItemTemplate> plotOrderItemTemplates = this.getPlotOrderItemTemplatesFromInfo(templateInfo);
        List<PlottProperties> plotPropertiesList = this.getPlotPropertiesFromInfo(templateInfo);
        boolean bl = save = plotOrderTemplate.getId() == null;
        if (save) {
            plotOrderTemplate = (PlottOrderTemplate)this.plotOrderTemplateDAO.save(plotOrderTemplate);
        } else {
            this.plotOrderTemplateDAO.update(plotOrderTemplate);
        }
        for (PlottOrderItemTemplate plotOrderItemTemplate : plotOrderItemTemplates) {
            plotOrderItemTemplate.setOrderContractId(plotOrderTemplate.getId());
        }
        Long plotOrderTemplateId = plotOrderTemplate.getId();
        List<Object> oldPlotPropertiesList = save ? new ArrayList() : this.plotPropertiesDAO.getByTemplate(plotOrderTemplateId);
        SyncWithDBResult<PlottProperties> plotPropertiesSyncResult = QueryHelper.syncWithDatabase(this.plotPropertiesDAO, plotPropertiesList, oldPlotPropertiesList, true);
        List<PlottProperties> newPropertiesList = plotPropertiesSyncResult.getInstances();
        for (int n = 0; n < plotOrderItemTemplates.size(); ++n) {
            PlottOrderItemTemplate itemTemplate = plotOrderItemTemplates.get(n);
            itemTemplate.setPlottPropertiesId(newPropertiesList.get(n).getId());
        }
        List<PlottOrderItemTemplate> oldItemTemplates = this.plotOrderItemTemplateDAO.getByOrderContract(plotOrderTemplateId);
        SyncWithDBResult<PlottOrderItemTemplate> itemTemplateSyncResult = QueryHelper.syncWithDatabase(this.plotOrderItemTemplateDAO, plotOrderItemTemplates, oldItemTemplates);
        Set<Long> nonDeletableItemTemplateIds = itemTemplateSyncResult.getNotDeletableIds();
        if (nonDeletableItemTemplateIds.size() > 0) {
            Map<Long, PlottOrderItemTemplate> idToOldItemTemplate = ContainerHelper.groupById(oldItemTemplates);
            for (Long nonDeletableItemTemplateId : nonDeletableItemTemplateIds) {
                PlottOrderItemTemplate oldItemTemplate = idToOldItemTemplate.get(nonDeletableItemTemplateId);
                oldItemTemplate.setInvalidated(Boolean.valueOf(true));
                this.plotOrderItemTemplateDAO.update(oldItemTemplate);
            }
        }
    }

    public String mayDeletePlotOrderTemplate(Long organisationPersonId, Long plotOrderTemplateId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        PlottOrderTemplate plotOrderTemplate = (PlottOrderTemplate)this.plotOrderTemplateDAO.get(plotOrderTemplateId);
        Long projectId = plotOrderTemplate.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_PROJECT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is missing action [" + Action.EDIT_PROJECT + "] for project [" + projectId + "], may not mayDeletePlotOrderTemplate [" + plotOrderTemplate.getId() + "]");
        }
        List<ReviewCycleNodeInstancePlottOrderListener> listeners = this.reviewCycleNodeInstancePlottOrderListenerDAO.getByReference(plotOrderTemplateId);
        if (listeners.size() > 0) {
            ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
            return resourceBundle.getString("plotOrderTemplateCannotDeleteMessage");
        }
        return null;
    }

    public void invalidatePlotOrderTemplate(Long organisationPersonId, Long plotOrderTemplateId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        PlottOrderTemplate plotOrderTemplate = (PlottOrderTemplate)this.plotOrderTemplateDAO.get(plotOrderTemplateId);
        Long projectId = plotOrderTemplate.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.EDIT_PROJECT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is missing action [" + Action.EDIT_PROJECT + "] for project [" + projectId + "], may not invalidatePlotOrderTemplate [" + plotOrderTemplate.getId() + "]");
        }
        List<ReviewCycleNodeInstancePlottOrderListener> listeners = this.reviewCycleNodeInstancePlottOrderListenerDAO.getByReference(plotOrderTemplateId);
        List<Long> listenerIds = QueryHelper.getPersistentIds(listeners);
        this.reviewCycleNodeInstancePlottOrderListenerDAO.deleteBatch(listenerIds);
        List<PlottOrderItemTemplate> itemTemplates = this.plotOrderItemTemplateDAO.getByOrderContract(plotOrderTemplateId);
        for (PlottOrderItemTemplate itemTemplate : itemTemplates) {
            itemTemplate.setInvalidated(Boolean.valueOf(true));
        }
        this.plotOrderItemTemplateDAO.updateBatch(itemTemplates);
        PlottOrderTemplate template = (PlottOrderTemplate)this.plotOrderTemplateDAO.get(plotOrderTemplateId);
        template.setInvalidated(Boolean.valueOf(true));
        this.plotOrderTemplateDAO.update(template);
    }

    private PlottOrderTemplate getPlotOrderTemplateFromInfo(PlotOrderTemplateInfo plotOrderTemplateInfo) {
        PlottOrderTemplate plotOrderTemplate = new PlottOrderTemplate();
        plotOrderTemplate.setId(plotOrderTemplateInfo.getId());
        plotOrderTemplate.setBillingAddressId(plotOrderTemplateInfo.getBillingAddressId());
        plotOrderTemplate.setPlotterId(plotOrderTemplateInfo.getPlotterProjectParticipationId());
        plotOrderTemplate.setProjectId(plotOrderTemplateInfo.getProjectId());
        plotOrderTemplate.setReviewCycleId(plotOrderTemplateInfo.getReviewCycleId());
        plotOrderTemplate.setName(plotOrderTemplateInfo.getName());
        plotOrderTemplate.setDescription(plotOrderTemplateInfo.getDescription());
        plotOrderTemplate.setComment(plotOrderTemplateInfo.getComment());
        plotOrderTemplate.setKindOfDelivery(plotOrderTemplateInfo.getKindOfDelivery() != null ? plotOrderTemplateInfo.getKindOfDelivery().getValue() : null);
        plotOrderTemplate.setTemplateResolver(plotOrderTemplateInfo.getTemplateResolver() != null ? plotOrderTemplateInfo.getTemplateResolver().getValue() : null);
        plotOrderTemplate.setInvalidated(plotOrderTemplateInfo.getInvalidated());
        return plotOrderTemplate;
    }

    private List<PlottOrderItemTemplate> getPlotOrderItemTemplatesFromInfo(PlotOrderTemplateInfo plotOrderTemplateInfo) {
        ArrayList<PlottOrderItemTemplate> items = new ArrayList<PlottOrderItemTemplate>();
        for (PlotOrderItemTemplateInfo itemInfo : plotOrderTemplateInfo.getItems()) {
            Integer count = itemInfo.getPlotPropertiesCount();
            if (count == null || count <= 0 || itemInfo.getDeliveryAddressId() == null && plotOrderTemplateInfo.getTemplateResolver() != PlotTemplateResolver.MANUAL) continue;
            PlottOrderItemTemplate item = new PlottOrderItemTemplate();
            item.setDeliveryAddressId(itemInfo.getDeliveryAddressId());
            item.setEvaluateMailReceivers(itemInfo.getEvaluateMailReceivers());
            item.setId(itemInfo.getId());
            item.setInvalidated(itemInfo.getInvalidated());
            item.setOrderContractId(plotOrderTemplateInfo.getId());
            item.setPlottPropertiesId(itemInfo.getPlotPropertiesId());
            items.add(item);
        }
        return items;
    }

    private List<PlottProperties> getPlotPropertiesFromInfo(PlotOrderTemplateInfo plotOrderTemplateInfo) {
        ArrayList<PlottProperties> plotPropertiesList = new ArrayList<PlottProperties>();
        for (PlotOrderItemTemplateInfo itemInfo : plotOrderTemplateInfo.getItems()) {
            Integer count = itemInfo.getPlotPropertiesCount();
            if (count == null || count <= 0 || itemInfo.getDeliveryAddressId() == null && plotOrderTemplateInfo.getTemplateResolver() != PlotTemplateResolver.MANUAL) continue;
            PlottProperties plotProperties = new PlottProperties();
            plotProperties.setId(itemInfo.getPlotPropertiesId());
            plotProperties.setCount(itemInfo.getPlotPropertiesCount());
            plotProperties.setIsInColor(itemInfo.getPlotPropertiesIsInColor() != null ? Integer.valueOf(itemInfo.getPlotPropertiesIsInColor().getValue()) : null);
            plotProperties.setMargin(itemInfo.getPlotPropertiesMargin() != null ? itemInfo.getPlotPropertiesMargin().getValue() : null);
            plotProperties.setPaperQuality(itemInfo.getPlotPropertiesPaperQuality() != null ? itemInfo.getPlotPropertiesPaperQuality().getValue() : null);
            plotProperties.setMirror(Boolean.valueOf(itemInfo.getPlotPropertiesMirror() != null ? itemInfo.getPlotPropertiesMirror() : false));
            plotProperties.setScale(itemInfo.getPlotPropertiesScale() != null ? itemInfo.getPlotPropertiesScale().getValue() : null);
            plotProperties.setLlx(itemInfo.getPlotPropertiesLlx());
            plotProperties.setLly(itemInfo.getPlotPropertiesLly());
            plotProperties.setUrx(itemInfo.getPlotPropertiesUrx());
            plotProperties.setUry(itemInfo.getPlotPropertiesUry());
            plotProperties.setUserUnit(itemInfo.getPlotPropertiesUserUnit());
            plotPropertiesList.add(plotProperties);
        }
        return plotPropertiesList;
    }

    public OrderAddressEditInfo getOrderAddressEditInfo(Long organisationPersonId, Long orderAddressId, Long networkId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        OrderAddress orderAddress = new OrderAddress();
        if (orderAddressId == null) {
            orderAddress = new OrderAddress();
            orderAddress.setNetworkId(networkId);
        } else {
            orderAddress = (OrderAddress)this.orderAddressDAO.get(orderAddressId);
        }
        List countries = this.countryDAO.getAll();
        OrderAddressEditInfo orderAddressEditInfo = new OrderAddressEditInfo();
        orderAddressEditInfo.setOrderAddress(orderAddress);
        orderAddressEditInfo.setCountries(countries);
        return orderAddressEditInfo;
    }

    public OrderAddress saveOrUpdateOrderAddress(Long organisationPersonId, OrderAddress orderAddress) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (orderAddress.getId() == null) {
            return (OrderAddress)this.orderAddressDAO.save(orderAddress);
        }
        this.orderAddressDAO.update(orderAddress);
        return orderAddress;
    }

    public List<PlotOrderDeleteJoin> getPlotOrderDeleteJoinsPreventingSubProjectInvalidate(Long organisationPersonId, Long subProjectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        SubProject subProject = (SubProject)this.subProjectDAO.get(subProjectId);
        Long projectId = subProject.getProjectId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.DELETE_PROJECT + "] needed for deleting sub project [" + subProjectId + "]");
        }
        List<PlotOrderDeleteJoin> allDeleteJoins = this.plotOrderDAO.getPlotOrderDeleteJoinByProjectOfSubProject(subProjectId);
        ArrayList<PlotOrderDeleteJoin> plotOrderNonDeletableJoins = new ArrayList();
        plotOrderNonDeletableJoins = this.plotUtils.getPlotOrderDeleteJoinsPreventingSubProjectInvalidate(allDeleteJoins, false, subProject.getId());
        return plotOrderNonDeletableJoins;
    }

    public List<PlotOrderDeleteJoin> getPlotOrderDeleteJoinsPreventingProjectInvalidate(Long organisationPersonId, Long projectId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.DELETE_PROJECT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is missing Action [" + Action.DELETE_PROJECT + "] needed for deleting project [" + projectId + "]");
        }
        ArrayList<PlotOrderDeleteJoin> plotOrderNonDeletableJoins = new ArrayList<PlotOrderDeleteJoin>();
        List<SubProject> subProjects = this.subProjectDAO.getByProject(projectId);
        for (SubProject subProject : subProjects) {
            List<PlotOrderDeleteJoin> allDeleteJoins = this.plotOrderDAO.getPlotOrderDeleteJoinByProjectOfSubProject(subProject.getId());
            List<PlotOrderDeleteJoin> currJoins = this.plotUtils.getPlotOrderDeleteJoinsPreventingSubProjectInvalidate(allDeleteJoins, true, subProject.getId());
            plotOrderNonDeletableJoins.addAll(currJoins);
        }
        return plotOrderNonDeletableJoins;
    }

    public PlotTaskInfo getPlotOrderAcceptanceTaskInfoByPlotOrderId(Long organisationPersonId, Long plotOrderId) {
        List<PlotTaskJoin> plotTaskJoins = this.plotOrderDAO.getPlotTaskJoinsByOrderIdWithoutTask(plotOrderId);
        return this.getPlotTaskInfo(organisationPersonId, plotTaskJoins, true, true);
    }

    public PlotTaskInfo getPlotOrderAcceptanceTaskInfo(Long organisationPersonId, Long taskId) {
        List<PlotTaskJoin> plotTaskJoins = this.plotOrderDAO.getPlotTaskJoins(taskId, "plot_order_acceptance_task");
        return this.getPlotTaskInfo(organisationPersonId, plotTaskJoins, true, true);
    }

    public PlotTaskInfo getReviewCyclePlotTaskInfo(Long organisationPersonId, Long taskId) {
        List<PlotTaskJoin> plotTaskJoins = this.plotOrderDAO.getPlotTaskJoins(taskId, "review_cycle_plott_task");
        return this.getPlotTaskInfo(organisationPersonId, plotTaskJoins, true, false);
    }

    private PlotTaskInfo getPlotTaskInfo(Long organisationPersonId, List<PlotTaskJoin> plotTaskJoins, boolean checkPrivileges, boolean acceptance) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        PlotTaskJoin someJoin = plotTaskJoins.get(0);
        Long networkId = someJoin.getNetworkId();
        if (plotTaskJoins.size() > 1) {
            ContainerHelper.logLongAttributeCompareStrings(log, plotTaskJoins);
        }
        if (checkPrivileges && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, someJoin.getNetworkId(), Action.TASKS_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to execute a plot task in network [" + networkId + "] due to missing privilege [" + Action.TASKS_OVERVIEW + "]");
        }
        Long taskParticipationId = someJoin.getDocumentVersionTaskProjectParticipationId();
        DocumentVersionTask documentVersionTask = someJoin.getDocumentVersionTask();
        PlottOrder plotOrder = someJoin.getPlotOrder();
        OrderAddress billingAddress = someJoin.getBillingAddress();
        Country billingCountry = someJoin.getBillingCountry();
        Organisation plotterOrganisation = someJoin.getPlotterOrganisation();
        Country plotterCountry = someJoin.getPlotterCountry();
        Project project = someJoin.getProject();
        Network network = someJoin.getNetwork();
        OrderStep requestStep = someJoin.getRequestStep();
        Person requestPerson = someJoin.getRequestPerson();
        OrderStep acceptanceStep = someJoin.getAcceptanceStep();
        Person acceptancePerson = someJoin.getAcceptancePerson();
        OrderStep completedStep = someJoin.getCompletedStep();
        Person completedPerson = someJoin.getCompletedPerson();
        OrderStep taskStep = someJoin.getTaskStep();
        Long documentVersionId = documentVersionTask.getDocumentVersionId();
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        PlotTaskInfo plotTaskInfo = new PlotTaskInfo();
        plotTaskInfo.setDocumentVersionTask(documentVersionTask);
        plotTaskInfo.setPlotOrder(plotOrder);
        plotTaskInfo.setBillingAddress(billingAddress);
        plotTaskInfo.setBillingCountry(billingCountry);
        plotTaskInfo.setPlotterOrganisation(plotterOrganisation);
        plotTaskInfo.setPlotterCountry(plotterCountry);
        plotTaskInfo.setProject(project);
        plotTaskInfo.setNetwork(network);
        plotTaskInfo.setRequestStep(requestStep);
        plotTaskInfo.setRequestPerson(requestPerson);
        plotTaskInfo.setAcceptanceStep(acceptanceStep);
        plotTaskInfo.setAcceptancePerson(acceptancePerson);
        plotTaskInfo.setCompletedStep(completedStep);
        plotTaskInfo.setCompletedPerson(completedPerson);
        plotTaskInfo.setTaskStep(taskStep);
        plotTaskInfo.setContextJoin(contextJoin);
        ArrayList<PlotTaskItemInfo> itemInfos = new ArrayList<PlotTaskItemInfo>();
        for (PlotTaskJoin plotTaskJoin : plotTaskJoins) {
            PlottOrderItem plotOrderItem = plotTaskJoin.getPlotOrderItem();
            Long receiverParticipationId = plotOrderItem.getReceiverId();
            if (acceptance && (!receiverParticipationId.equals(taskParticipationId) || receiverParticipationId.equals(taskParticipationId) && plotTaskJoin.getReceivedSignatureId() != null || plotTaskJoin.getReceivedStepId() == null || plotTaskJoin.isSubProjectInvalidated().booleanValue())) continue;
            DocumentVersion documentVersion = plotTaskJoin.getDocumentVersion();
            Document document = plotTaskJoin.getDocument();
            DocumentRelease documentRelease = plotTaskJoin.getDocumentRelease();
            PlottProperties plotProperties = plotTaskJoin.getPlotProperties();
            OrderAddress deliveryAddress = plotTaskJoin.getDeliveryAddress();
            Country deliveryCountry = plotTaskJoin.getDeliveryCountry();
            ProjectParticipant initiatorParticipant = plotTaskJoin.getInitiatorParticipant();
            Person initiatorPerson = plotTaskJoin.getInitiatorPerson();
            ReviewCycleNodeInstanceReleased reviewCycleNodeInstanceReleased = plotTaskJoin.getReviewCycleNodeInstanceReleased();
            ReviewCycleNode reviewCycleNode = plotTaskJoin.getReviewCycleNode();
            DocumentVersion firstVersion = plotTaskJoin.getFirstVersion();
            DocumentVersion otherVersion = plotTaskJoin.getOtherVersion();
            DocumentVersion asBuiltDocumentVersion = plotTaskJoin.getAsBuiltFirstVersion();
            DocumentVersion previewSupportDocumentVersion = plotTaskJoin.getPreviewSupportDocumentVersion();
            OrderStep receivedStep = plotTaskJoin.getReceivedStep();
            Signature receivedSignature = plotTaskJoin.getReceivedSignature();
            Person receivedPerson = plotTaskJoin.getReceivedPerson();
            PlotTaskItemInfo itemInfo = new PlotTaskItemInfo();
            itemInfo.setPlotOrderItem(plotOrderItem);
            itemInfo.setDocumentVersion(documentVersion);
            itemInfo.setDocument(document);
            itemInfo.setDocumentRelease(documentRelease);
            itemInfo.setPlotProperties(plotProperties);
            itemInfo.setDeliveryAddress(deliveryAddress);
            itemInfo.setDeliveryCountry(deliveryCountry);
            itemInfo.setInitiatorParticipant(initiatorParticipant);
            itemInfo.setInitiatorPerson(initiatorPerson);
            itemInfo.setReviewCycleNodeInstanceReleased(reviewCycleNodeInstanceReleased);
            itemInfo.setReviewCycleNode(reviewCycleNode);
            if (acceptance) {
                itemInfo.setReceivedStep(receivedStep);
                itemInfo.setReceivedPerson(receivedPerson);
            }
            itemInfo.setFirstVersion(firstVersion);
            itemInfo.setOtherVersion(otherVersion);
            itemInfo.setAsBuiltFirstVersion(asBuiltDocumentVersion);
            itemInfo.setPreviewSupportDocumentVersion(previewSupportDocumentVersion);
            itemInfos.add(itemInfo);
        }
        plotTaskInfo.setItemInfos(itemInfos);
        return plotTaskInfo;
    }

    private void doAcceptReviewCyclePlotTask(Long organisationPersonId, Long taskId, String comment, String password, boolean ok, boolean complete) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Project project = this.projectDAO.getByDocumentVersionTask(taskId);
        Long projectId = project.getId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.TASKS_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to execute doAcceptReviewCyclePlotTask for taskId [" + taskId + "] in project [" + projectId + "]; privilege [" + Action.TASKS_OVERVIEW + "] is missing.");
        }
        List<PlotTaskJoin> plotTaskJoins = this.plotOrderDAO.getPlotTaskJoins(taskId, "review_cycle_plott_task");
        PlotTaskInfo plotTaskInfo = this.getPlotTaskInfo(organisationPersonId, plotTaskJoins, false, false);
        Long participationId = plotTaskInfo.getDocumentVersionTask().getProjectParticipationId();
        ProjectParticipant participant = this.projectParticipantDAO.getByParticipationAndOrganisationPerson(participationId, organisationPersonId);
        Certificate certificate = this.certificateDAO.getSignerCertificate(organisationPersonId);
        if (certificate == null) {
            throw new RuntimeException("Didn't find a signerCertificate for organisationPersonId [" + organisationPersonId + "]");
        }
        OrderStep acceptanceStep = plotTaskInfo.getAcceptanceStep();
        Long nextTaskId = null;
        nextTaskId = acceptanceStep == null || acceptanceStep.getFinished() == null ? this.plotUtils.acceptPlotOrder(plotTaskInfo, participant, certificate, password, ok, comment) : plotTaskInfo.getDocumentVersionTask().getTaskId();
        if (complete && nextTaskId != null) {
            this.plotUtils.completePlotOrder(plotTaskInfo, nextTaskId, comment, ok, participant, certificate, password);
        }
    }

    public void acceptReviewCyclePlotTask(Long organisationPersonId, Long taskId, String comment, String password, boolean ok) {
        if (log.isDebugEnabled()) {
            log.debug("acceptReviewCyclePlotTask, taskId = [" + taskId + "], ok = [" + ok + "]");
        }
        this.doAcceptReviewCyclePlotTask(organisationPersonId, taskId, comment, password, ok, false);
    }

    public void acceptAndCompleteReviewCyclePlotTask(Long organisationPersonId, Long taskId, String comment, String password, boolean ok) {
        if (log.isDebugEnabled()) {
            log.debug("acceptAndCompleteReviewCyclePlotTask, taskId = [" + taskId + "], password = [" + password + "], ok = [" + ok + "]");
        }
        this.doAcceptReviewCyclePlotTask(organisationPersonId, taskId, comment, password, ok, true);
    }

    public void acceptPlotOrderItemTask(Long organisationPersonId, Long taskId, String comment, String password, boolean ok, Set<Long> selectedPlotOrderItemIds) {
        if (log.isDebugEnabled()) {
            log.debug("acceptPlotOrderItemTask, taskId = [" + taskId + "], password = [" + password + "], ok = [" + ok + "], selectedItemIds [" + selectedPlotOrderItemIds + "]");
        }
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Project project = this.projectDAO.getByDocumentVersionTask(taskId);
        Long projectId = project.getId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.TASKS_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to execute acceptPlotOrderAcceptanceTask for taskId [" + taskId + "] in project [" + projectId + "]; privilege [" + Action.TASKS_OVERVIEW + "] is missing.");
        }
        List<PlotTaskJoin> plotTaskJoins = this.plotOrderDAO.getPlotTaskJoins(taskId, "plot_order_acceptance_task");
        PlotTaskInfo plotTaskInfo = this.getPlotTaskInfo(organisationPersonId, plotTaskJoins, false, true);
        this.plotUtils.receivePlotOrder(organisationPersonId, plotTaskInfo, comment, password, ok, selectedPlotOrderItemIds);
    }
}

