/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.servlet;

import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.guiService.CertificateService;
import at.cdes.api.service.CdesFileService;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.util.ActionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.http.sec.HttpLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdesRepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = -8015410041300803029L;
    private static final Logger log = LoggerFactory.getLogger(CdesRepositoryServlet.class);
    private CdesFileService cdesFileService;
    private CertificateService certificateService;
    private HttpLoginService httpLoginService;
    private CertificateRequestDAO certificateRequestDAO;
    private ActionDAO actionDAO;
    private Boolean certificateAdministrationGlobal;

    public void setCdesFileService(CdesFileService cdesFileService) {
        this.cdesFileService = cdesFileService;
    }

    public void setCertificateService(CertificateService certificateService) {
        this.certificateService = certificateService;
    }

    public void setHttpLoginService(HttpLoginService httpLoginService) {
        this.httpLoginService = httpLoginService;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setCertificateAdministrationGlobal(Boolean certificateAdministrationGlobal) {
        this.certificateAdministrationGlobal = certificateAdministrationGlobal;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            try {
                this.handleMultiPartUpload(req);
            }
            catch (FileUploadException e) {
                throw new IOException("Error processing multipart request", e);
            }
        } else {
            log.error("Client sent POST request with wrong mimetype: " + req.getContentType());
            resp.sendError(500);
        }
    }

    protected void handleMultiPartUpload(HttpServletRequest req) throws FileUploadException, IOException, ServletException {
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileIt = upload.getItemIterator(req);
        while (fileIt.hasNext()) {
            Map paramMap;
            FileItemStream item = fileIt.next();
            if (item.isFormField()) {
                String v = Streams.asString((InputStream)item.openStream());
                log.info("Detected form field " + item.getFieldName() + " with content " + v);
                continue;
            }
            String filename = item.getName();
            if (filename == null || filename.length() == 0) continue;
            log.info("CdesRepositoryServlet processes filename = " + filename);
            int pos = filename.lastIndexOf(47);
            if (pos >= 0) {
                filename = filename.substring(pos + 1);
            }
            if ((pos = filename.lastIndexOf(92)) >= 0) {
                filename = filename.substring(pos + 1);
            }
            InputStream inputStream = item.openStream();
            String type = null;
            String certificateRequestIdString = null;
            String organisationPersonIdString = null;
            String qs = req.getQueryString();
            if (qs != null && (paramMap = UrlHelper.parseQuery((String)qs)) != null) {
                type = UrlHelper.getStringParameter((Map)paramMap, (String)"type");
                certificateRequestIdString = UrlHelper.getStringParameter((Map)paramMap, (String)"certificateRequest");
                organisationPersonIdString = UrlHelper.getStringParameter((Map)paramMap, (String)"organisationPerson");
            }
            if (type != null && "request".equals(type)) {
                Long certificateRequestId = Long.parseLong(certificateRequestIdString);
                Long organisationPersonId = Long.parseLong(organisationPersonIdString);
                CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
                if (!this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, certificateRequest.getNetworkId(), Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON)) {
                    throw new SecurityException("The organisation person " + organisationPersonId + " is trying to upload a certificate request pdf for certificate request " + certificateRequestId + " but it does not have the permissions for it. No privileges [editPerson, editOrganisationPerson or administrateCertificate] for network [" + certificateRequest.getNetworkId() + "]");
                }
                log.info("Calling cdesFileService.saveRequestFile for certificateRequestId = [" + certificateRequestId + "] and filename [" + filename + "].");
                this.cdesFileService.saveRequestFile(certificateRequestId, inputStream, filename);
                this.certificateService.declareCertificateRequestPdfUploaded(organisationPersonId, certificateRequestId);
                continue;
            }
            throw new IllegalArgumentException("Illegal type [" + type + "] passed to CdesRepositoryServlet.");
        }
    }

    public String getServletInfo() {
        return CdesRepositoryServlet.class.getSimpleName();
    }
}

