/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkObjectPlannerDefinition;
import at.cdes.api.dto.ObjectPlannerDefinitionTemplate;
import at.cdes.impl.dao.NetworkObjectPlannerDefinitionDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcNetworkObjectPlannerDefinitionDAO
extends AbstrIdDAO<NetworkObjectPlannerDefinition>
implements NetworkObjectPlannerDefinitionDAO {
    public JdbcNetworkObjectPlannerDefinitionDAO() {
        super(NetworkObjectPlannerDefinition.class, "networkId", "network_object_planner_definition", new String[]{"network_id", "object_planner_definition_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcNetworkObjectPlannerDefinitionDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_planner_definition_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcNetworkObjectPlannerDefinitionDAO.getSelectClauseForDto("network_object_planner_definition", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcNetworkObjectPlannerDefinitionDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".object_planner_definition_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_planner_definition_id") + " ";
    }

    protected NetworkObjectPlannerDefinition fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        NetworkObjectPlannerDefinition networkObjectPlannerDefinition = new NetworkObjectPlannerDefinition();
        networkObjectPlannerDefinition.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkObjectPlannerDefinition.setObjectPlannerDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return networkObjectPlannerDefinition;
    }

    public static NetworkObjectPlannerDefinition fillNetworkObjectPlannerDefinitionFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        NetworkObjectPlannerDefinition networkObjectPlannerDefinition = new NetworkObjectPlannerDefinition();
        networkObjectPlannerDefinition.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        networkObjectPlannerDefinition.setObjectPlannerDefinitionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return networkObjectPlannerDefinition;
    }

    public static NetworkObjectPlannerDefinition fillNetworkObjectPlannerDefinitionFromResultSet(ResultSet rs) throws SQLException {
        return JdbcNetworkObjectPlannerDefinitionDAO.fillNetworkObjectPlannerDefinitionFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteInstance(final Long objectPlannerDefinitionId, final Long networkId) {
        String sql = "DELETE FROM network_object_planner_definition WHERE object_planner_definition_id = ? AND network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, objectPlannerDefinitionId);
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(NetworkObjectPlannerDefinition dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<NetworkObjectPlannerDefinition> dtos) {
        Iterator<NetworkObjectPlannerDefinition> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, NetworkObjectPlannerDefinition networkObjectPlannerDefinition) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)networkObjectPlannerDefinition.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)networkObjectPlannerDefinition.getObjectPlannerDefinitionId());
    }

    @Override
    public List<NetworkObjectPlannerDefinition> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<NetworkObjectPlannerDefinition> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<NetworkObjectPlannerDefinition> getByObjectPlannerDefinition(ObjectPlannerDefinitionTemplate objectPlannerDefinitionTemplate) {
        return this.getByObjectPlannerDefinition(objectPlannerDefinitionTemplate.getId());
    }

    @Override
    public List<NetworkObjectPlannerDefinition> getByObjectPlannerDefinition(final Long objectPlannerDefinitionTemplateId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_planner_definition_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectPlannerDefinitionTemplateId);
            }
        });
    }

    @Override
    public List<NetworkObjectPlannerDefinition> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<NetworkObjectPlannerDefinition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<NetworkObjectPlannerDefinition> getByObjectPlannerDefinitions(Collection<Long> objectPlannerDefinitionTemplateId) {
        if (objectPlannerDefinitionTemplateId.isEmpty()) {
            return new ArrayList<NetworkObjectPlannerDefinition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectPlannerDefinitionTemplateId.size()];
        int n = 0;
        Iterator<Long> it = objectPlannerDefinitionTemplateId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_planner_definition_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

