/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.servlet;

import at.cdes.api.mime.ParameterHelper;
import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.clazzes.util.http.UrlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeSourceServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MimeSourceServlet.class);
    private VisitlessMimeSource userPolicyMimeSource;
    private ParameterHelper parameterHelper;
    private OrganisationPersonDAO organisationPersonDAO;

    public void setUserPolicyMimeSource(VisitlessMimeSource userPolicyMimeSource) {
        this.userPolicyMimeSource = userPolicyMimeSource;
    }

    public void setParameterHelper(ParameterHelper parameterHelper) {
        this.parameterHelper = parameterHelper;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        byte[] block;
        long totalBytes;
        IMimeInputStream mimeStream;
        Object[] parameters = this.parameterHelper.parseURLParametersString("sp", req.getQueryString());
        String filename = req.getParameter("filename");
        try {
            mimeStream = this.userPolicyMimeSource.getMimeStream(parameters);
        }
        catch (PreviewException e) {
            throw new ServletException("Error when constructing mime stream.", (Throwable)e);
        }
        try {
            totalBytes = mimeStream.getStreamSize();
        }
        catch (IOError e) {
            throw new ServletException("Error when attempting to calculate the total number of bytes in mime stream.", (Throwable)e);
        }
        resp.setContentLength((int)totalBytes);
        try {
            resp.setContentType(mimeStream.getMimeType());
        }
        catch (IOError e) {
            throw new ServletException("Error when attempting to get the mime type of mime stream.", (Throwable)e);
        }
        if (filename != null && filename.length() > 0) {
            String disposition = UrlHelper.getCompatibleContentDispositionAttachmentHeader((String)filename);
            resp.setHeader("Content-Disposition", disposition);
        }
        ServletOutputStream outputStream = resp.getOutputStream();
        for (long writtenBytes = 0L; writtenBytes < totalBytes; writtenBytes += (long)block.length) {
            try {
                block = mimeStream.readBlock(1024);
            }
            catch (IOError e) {
                throw new ServletException("Error while writing result.", (Throwable)e);
            }
            outputStream.write(block);
        }
        outputStream.close();
        try {
            mimeStream.close();
        }
        catch (IOError e) {
            log.warn("Error when closing user policy mime stream.", (Throwable)e);
        }
    }
}

