/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.odf;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.planning.CellTextStyles;
import at.cdes.impl.export.planning.PlanningReportHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.DateHelper;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.ParagraphStyleFactory;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.odf.util.voc.StyleFamily;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.lang.Pair;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawImage;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfHelper {
    public static ExportResult constructExportResult(String tmpFileName) {
        ExportResult exportResult = new ExportResult();
        exportResult.setTmpFileName(tmpFileName);
        return exportResult;
    }

    public static String getNumberOfEntriesLabel(ResourceBundle resourceBundle, int count) {
        if (count == 1) {
            return resourceBundle.getString("oneEntryString");
        }
        return MessageFormat.format(resourceBundle.getString("multipleEntriesString"), String.valueOf(count));
    }

    public static StyleParagraphPropertiesElement constructStandardParagraphProperties(Styles context) {
        StyleParagraphPropertiesElement paragraphProperties = context.constructParagraphProperties();
        paragraphProperties.setFoTextAlignAttribute("start");
        paragraphProperties.setStyleJustifySingleWordAttribute(Boolean.valueOf(false));
        paragraphProperties.setFoOrphansAttribute(Integer.valueOf(2));
        paragraphProperties.setFoWidowsAttribute(Integer.valueOf(2));
        paragraphProperties.setStyleTextAutospaceAttribute("ideograph-alpha");
        paragraphProperties.setStylePunctuationWrapAttribute("hanging");
        paragraphProperties.setStyleLineBreakAttribute("strict");
        paragraphProperties.setStyleWritingModeAttribute("lr-tb");
        return paragraphProperties;
    }

    public static StyleTextPropertiesElement constructStandardTextProperties(Styles context) {
        StyleTextPropertiesElement textProperties = context.constructTextProperties();
        textProperties.setFoColorAttribute("#00000a");
        textProperties.setStyleUseWindowFontColorAttribute(Boolean.valueOf(true));
        textProperties.setStyleFontNameAttribute("Arial");
        textProperties.setFoFontFamilyAttribute("Arial");
        textProperties.setStyleFontFamilyGenericAttribute("roman");
        textProperties.setStyleFontPitchAttribute("variable");
        textProperties.setFoFontSizeAttribute("10pt");
        textProperties.setFoLanguageAttribute("de");
        textProperties.setFoCountryAttribute("DE");
        textProperties.setFoHyphenateAttribute(Boolean.valueOf(false));
        textProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        textProperties.setFoHyphenationRemainCharCountAttribute(Integer.valueOf(2));
        return textProperties;
    }

    public static String constructStandardParagraphStyle(Styles context) {
        return context.getParagraphStyle("StandardParagraphStyle", "text", new OdfStylePropertiesBase[]{OdfHelper.constructStandardParagraphProperties(context), OdfHelper.constructStandardTextProperties(context)});
    }

    public static String constructStandardParagraphBoldStyle(Styles context) {
        return context.getParagraphStyle("StandardParagraphBoldStyle", "text", new OdfStylePropertiesBase[]{OdfHelper.constructStandardParagraphProperties(context), OdfHelper.constructStandardTextProperties(context), context.constructTextPropertiesWithFontWeight("bold")});
    }

    public static String constructStandardParagraphCenterStyle(Styles context) {
        return context.getParagraphStyle("StandardParagraphCenterStyle", "text", new OdfStylePropertiesBase[]{OdfHelper.constructStandardParagraphProperties(context), OdfHelper.constructStandardTextProperties(context), context.constructParagraphPropertiesWithTextAlign("center")});
    }

    public static void constructCaptionTable(OdfContext context, OfficeTextElement officeText, String standardParagraphStyle, String caption) {
        Styles styles = context.getContentAutomaticStyles();
        TableTableElement captionTableElement = officeText.newTableTableElement();
        String captionTableStyle = styles.getTableStyle(new OdfStylePropertiesBase[]{OdfHelper.constructTablePropertiesForCaptionTable(styles)});
        captionTableElement.setStyleName(captionTableStyle);
        TableFactory.appendColumnWithRelativeSize((Styles)styles, (TableTableElement)captionTableElement, (String)"100*");
        String captionRowStyle = styles.getTableRowStyle(new OdfStylePropertiesBase[]{OdfHelper.constructRowPropertiesForCaptionTable(styles)});
        String captionTextStyle = styles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{OdfHelper.constructParagraphTextPropertiesForCaptionTable(styles), OdfHelper.constructTextTextPropertiesForCaptionTable(styles)});
        String captionCellStyle = styles.getTableCellStyle(new OdfStylePropertiesBase[]{OdfHelper.constructCellPropertiesForCaptionTable(styles)});
        TableTableRowElement captionRowElement = TableFactory.appendRow((TableTableElement)captionTableElement, (String)captionRowStyle);
        TableFactory.appendCell((String)captionCellStyle, (String)captionTextStyle, (TableTableRowElement)captionRowElement, (String[])new String[]{caption});
        String emptyRowStyle = styles.getTableRowStyle(new OdfStylePropertiesBase[]{styles.constructTableRowPropertiesWithMinHeight("0.7cm")});
        TableFactory.appendRow((TableTableElement)captionTableElement, (String)emptyRowStyle);
    }

    private static StyleTablePropertiesElement constructTablePropertiesForCaptionTable(Styles styles) {
        StyleTablePropertiesElement tableProperties = styles.constructTableProperties();
        tableProperties.setTableAlignAttribute("left");
        tableProperties.setStyleWritingModeAttribute("lr-tb");
        return tableProperties;
    }

    private static StyleTableRowPropertiesElement constructRowPropertiesForCaptionTable(Styles styles) {
        StyleTableRowPropertiesElement rowProperties = styles.constructTableRowProperties();
        rowProperties.setStyleMinRowHeightAttribute("1.007cm");
        rowProperties.setFoKeepTogetherAttribute("always");
        return rowProperties;
    }

    private static StyleTableCellPropertiesElement constructCellPropertiesForCaptionTable(Styles styles) {
        StyleTableCellPropertiesElement cellProperties = styles.constructTableCellProperties();
        cellProperties.setStyleVerticalAlignAttribute("middle");
        cellProperties.setFoBackgroundColorAttribute("#e5e5e5");
        cellProperties.setFoPaddingLeftAttribute("0.123cm");
        cellProperties.setFoPaddingRightAttribute("0.123cm");
        cellProperties.setFoPaddingTopAttribute("0cm");
        cellProperties.setFoPaddingBottomAttribute("0cm");
        cellProperties.setFoBorderAttribute("none");
        cellProperties.setStyleWritingModeAttribute("lr-tb");
        return cellProperties;
    }

    private static StyleParagraphPropertiesElement constructParagraphTextPropertiesForCaptionTable(Styles styles) {
        StyleParagraphPropertiesElement paragraphProperties = styles.constructParagraphProperties();
        paragraphProperties.setFoTextAlignAttribute("center");
        paragraphProperties.setStyleJustifySingleWordAttribute(Boolean.valueOf(false));
        paragraphProperties.setStyleSnapToLayoutGridAttribute(Boolean.valueOf(false));
        return paragraphProperties;
    }

    private static StyleTextPropertiesElement constructTextTextPropertiesForCaptionTable(Styles styles) {
        StyleTextPropertiesElement textProperties = styles.constructTextProperties();
        textProperties.setFoFontFamilyAttribute("Arial");
        textProperties.setStyleFontNameAttribute("Arial");
        textProperties.setFoTextTransformAttribute("uppercase");
        textProperties.setFoFontWeightAttribute("bold");
        textProperties.setStyleTextScaleAttribute("200%");
        return textProperties;
    }

    public static void constructFooter(OdfContext context, OdfTextDocument document, String standardParagraphStyle, String documentInfoString, ResourceBundle resourceBundle) {
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        String leftFooterTextStyle = stylesAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{stylesAutomaticStyles.constructTextPropertiesWithFontWeight("bold")});
        OdfHelper.constructFooter(context, document, standardParagraphStyle, documentInfoString, leftFooterTextStyle, resourceBundle);
    }

    public static void constructFooter(OdfContext context, OdfTextDocument document, String standardParagraphStyle, String documentInfoString, String leftFooterTextStyle, ResourceBundle resourceBundle) {
        OdfHelper.constructFooter(context, document, standardParagraphStyle, documentInfoString, leftFooterTextStyle, null, resourceBundle);
    }

    public static void constructFooter(OdfContext context, OdfTextDocument document, String standardParagraphStyle, String documentInfoString, String leftFooterTextStyle, String rightFooterTextStyle, ResourceBundle resourceBundle) {
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        StyleParagraphPropertiesElement footerParagraphProperties = stylesAutomaticStyles.constructParagraphPropertiesWithLineNumbers(Boolean.valueOf(false), Integer.valueOf(0));
        ParagraphStyleFactory.addTabStops((StyleParagraphPropertiesElement)footerParagraphProperties, (Pair[])new Pair[]{new Pair((Object)"27.199cm", (Object)"right")});
        String footerStyle = stylesAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, "extra", new OdfStylePropertiesBase[]{footerParagraphProperties});
        OdfOfficeMasterStyles masterStyles = document.getOfficeMasterStyles();
        Iterator masterPages = masterStyles.getMasterPages();
        while (masterPages.hasNext()) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)masterPages.next();
            String pageLayoutName = masterPage.getStylePageLayoutNameAttribute();
            stylesAutomaticStyles.setFooterDimensions(pageLayoutName, "0.699cm", "0cm", "0cm", "0.199cm");
            StyleFooterElement footerElement = masterPage.newStyleFooterElement();
            TextPElement footerTextElement = TextFactory.constructTextNode((Node)footerElement, (String)"", (String)footerStyle);
            TextFactory.constructTextSpan((Node)footerTextElement, (String)documentInfoString, (String)leftFooterTextStyle);
            footerTextElement.newTextTabElement();
            TextSpanElement footerTextSpanElement = TextFactory.constructTextSpan((Node)footerTextElement, null, null);
            footerTextSpanElement.newTextTabElement();
            String generationDateString = DateHelper.formatUtcMillis(System.currentTimeMillis(), "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
            String generationRawString = resourceBundle.getString("generationInfo");
            String formattedGenerationString = MessageFormat.format(generationRawString, generationDateString);
            TextFactory.constructPageOfPagesSpan((Node)footerTextElement, (String)(formattedGenerationString + "\u2003" + resourceBundle.getString("page")), null);
        }
    }

    public static void constructHeader(OdfContext context, OdfTextDocument document, String standardParagraphStyle, String centeredText, boolean enableCustomerLogo) throws Exception {
        Styles styles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement headerParagraphProperties = styles.constructParagraphPropertiesWithLineNumbers(Boolean.valueOf(false), Integer.valueOf(0));
        ParagraphStyleFactory.addTabStops((StyleParagraphPropertiesElement)headerParagraphProperties, (Pair[])new Pair[]{new Pair((Object)"13.6cm", (Object)"center"), new Pair((Object)"27.199cm", (Object)"right")});
        String headerStyle = styles.getParagraphStyleWithParent(standardParagraphStyle, "extra", new OdfStylePropertiesBase[]{headerParagraphProperties});
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        OdfOfficeMasterStyles masterStyles = document.getOfficeMasterStyles();
        Iterator masterPages = masterStyles.getMasterPages();
        while (masterPages.hasNext()) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)masterPages.next();
            String pageLayoutName = masterPage.getStylePageLayoutNameAttribute();
            stylesAutomaticStyles.setHeaderDimensions(pageLayoutName, "1.80cm", "0cm", "0cm", "0cm");
            StyleHeaderElement headerElement = masterPage.newStyleHeaderElement();
            TextPElement headerTextElement = TextFactory.constructTextNode((Node)headerElement, (String)"", (String)headerStyle);
            OdfDrawFrame drawFrame = (OdfDrawFrame)((OdfFileDom)headerTextElement.getOwnerDocument()).newOdfElement(OdfDrawFrame.class);
            drawFrame.setSvgWidthAttribute("1.72cm");
            drawFrame.setSvgHeightAttribute("0.85cm");
            Styles stylesOfficeStyles = context.getStylesOfficeStyles();
            ClassLoader classLoader = PlanningReportHelper.class.getClassLoader();
            if (enableCustomerLogo) {
                StyleGraphicPropertiesElement graphicProperties = stylesOfficeStyles.constructGraphicProperties();
                graphicProperties.setFoMarginBottomAttribute("1cm");
                graphicProperties.setStyleHorizontalPosAttribute("left");
                graphicProperties.setStyleMirrorAttribute("none");
                graphicProperties.setStyleRunThroughAttribute("background");
                graphicProperties.setStyleWrapAttribute("run-through");
                graphicProperties.setStyleVerticalPosAttribute("middle");
                graphicProperties.setStyleVerticalRelAttribute("baseline");
                graphicProperties.setStyleFlowWithTextAttribute(Boolean.valueOf(true));
                String imageStyle = stylesOfficeStyles.getGraphicStyle(new OdfStylePropertiesBase[]{graphicProperties});
                headerTextElement.appendChild((Node)drawFrame);
                drawFrame.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PARAGRAPH.toString());
                drawFrame.setDrawStyleNameAttribute(imageStyle);
                URL logoUrl = classLoader.getResource("export/logos/OeBB_INFRA_black.png");
                URI logoUri = logoUrl.toURI();
                OdfDrawImage image = (OdfDrawImage)drawFrame.newDrawImageElement();
                image.newImage(logoUri);
                drawFrame.setSvgWidthAttribute("2.43cm");
                drawFrame.setSvgHeightAttribute("1.51cm");
            }
            headerTextElement.newTextTabElement();
            StyleParagraphPropertiesElement paragraphProperties = styles.constructParagraphProperties();
            String centeredStyle = styles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{paragraphProperties});
            TextSpanElement headerTextSpanElement = TextFactory.constructTextSpan((Node)headerTextElement, (String)centeredText, (String)centeredStyle);
            headerTextSpanElement.newTextTabElement();
            OdfDrawFrame drawFrame2 = (OdfDrawFrame)((OdfFileDom)headerTextElement.getOwnerDocument()).newOdfElement(OdfDrawFrame.class);
            StyleGraphicPropertiesElement graphicProperties2 = stylesOfficeStyles.constructGraphicProperties();
            graphicProperties2.setFoMarginBottomAttribute("1cm");
            graphicProperties2.setStyleHorizontalPosAttribute("right");
            graphicProperties2.setStyleHorizontalRelAttribute("paragraph-content");
            graphicProperties2.setStyleVerticalPosAttribute("middle");
            graphicProperties2.setStyleVerticalRelAttribute("baseline");
            graphicProperties2.setStyleMirrorAttribute("none");
            graphicProperties2.setStyleFlowWithTextAttribute(Boolean.valueOf(true));
            String imageStyle2 = stylesOfficeStyles.getGraphicStyle(new OdfStylePropertiesBase[]{graphicProperties2});
            headerTextElement.appendChild((Node)drawFrame2);
            drawFrame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PARAGRAPH.toString());
            drawFrame2.setDrawStyleNameAttribute(imageStyle2);
            URL logoUrl2 = classLoader.getResource("export/logos/cdes_logo_bl.png");
            URI logoUri2 = logoUrl2.toURI();
            OdfDrawImage image2 = (OdfDrawImage)drawFrame2.newDrawImageElement();
            image2.newImage(logoUri2);
            drawFrame2.setSvgWidthAttribute("2.5cm");
            drawFrame2.setSvgHeightAttribute("0.73cm");
        }
    }

    public static CellTextStyles constructNormalTextStyles(String standardParagraphStyle, Styles contentAutomaticStyles) {
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#FF0000", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        return new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle);
    }

    public static CellTextStyles constructInvalidatedTextStyles(String standardParagraphStyle, Styles contentAutomaticStyles) {
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", null)});
        return new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle);
    }

    public static String getPersonVariablesUserLocaleByPrincipal(PersonVariablesDAO personVariablesDAO) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        List<PersonVariables> personVariablesList = personVariablesDAO.getByPerson(personId);
        PersonVariables personVariables = personVariablesList.get(0);
        return personVariables.getUserLocale();
    }

    public static ResourceBundle getResourceBundleByPrincipal(PersonVariablesDAO personVariablesDAO) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        List<PersonVariables> personVariablesList = personVariablesDAO.getByPerson(personId);
        PersonVariables personVariables = personVariablesList.get(0);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariables.getUserLocale());
        return resourceBundle;
    }

    public static void appendCoveredTableCell(TableTableRowElement rowElement) {
        TableCoveredTableCellElement cellElement = rowElement.newTableCoveredTableCellElement(0.0, "string");
        cellElement.removeAttribute("office:value");
    }

    public static String getDataTableHeaderCellStyle(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        headerCellProperties.setStyleVerticalAlignAttribute("top");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        return headerCellStyle;
    }

    public static String getDataTableHeaderTextStyle(Styles contentAutomaticStyles, String standardParagraphStyle) {
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold");
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        return headerTextStyle;
    }

    public static String getDataTableDataCellStyleNoWrap(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("no-wrap");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        return dataCellStyle;
    }

    public static String getDataTableDataCellStyleNoWrapHidden(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("no-wrap");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        dataCellProperties.setStyleTextAlignSourceAttribute("fix");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        return dataCellStyle;
    }

    public static String getDataTableDataCellStyle(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("wrap");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        return dataCellStyle;
    }

    public static String getDataTableDataBoldCellStyle(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("wrap");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithFontWeight("bold");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties, dataTextProperties});
        return dataCellStyle;
    }

    public static String getDataTableDataBoldCellStyleNoWrap(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("no-wrap");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithFontWeight("bold");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties, dataTextProperties});
        return dataCellStyle;
    }

    public static String getDataTableDataBoldCellStyleNoWrapHidden(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("no-wrap");
        dataCellProperties.setStyleTextAlignSourceAttribute("fix");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithFontWeight("bold");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties, dataTextProperties});
        return dataCellStyle;
    }

    public static String getDataTableDataTextStyle(Styles contentAutomaticStyles, String standardParagraphStyle) {
        return OdfHelper.getDataTableDataTextStyle(contentAutomaticStyles, standardParagraphStyle, "#000000");
    }

    public static String getDataTableCellWithTextStyle(Styles contentAutomaticStyles, String standardParagraphStyle, String color) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("no-wrap");
        dataCellProperties.setStyleTextAlignSourceAttribute("fix");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation(color, "Arial", "9pt", null);
        String style = contentAutomaticStyles.getStyleWithParent(StyleFamily.TABLE_CELL.getValue(), standardParagraphStyle, new OdfStylePropertiesBase[]{dataCellProperties, dataTextProperties});
        return style;
    }

    public static String getDataTableDataTextStyle(Styles contentAutomaticStyles, String standardParagraphStyle, String color) {
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation(color, "Arial", "9pt", null);
        String dataTextStyle = contentAutomaticStyles.getStyleWithParent(StyleFamily.TABLE_CELL.getValue(), standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        return dataTextStyle;
    }

    public static String getDataTableDataTextBoldStyle(Styles contentAutomaticStyles, String standardParagraphStyle) {
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold");
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        return dataTextStyle;
    }

    public static String getDataTableRowStyle(Styles contentAutomaticStyles) {
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        return dataRowStyle;
    }

    public static void appendLabelledTableLine(TableTableElement tableElement, String dataRowStyle, String labelCellStyle, String labelTextStyle, String valueCellStyle, String valueTextStyle, String label, String ... values) {
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, (String)dataRowStyle);
        TableFactory.appendCell((String)labelCellStyle, (String)labelTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{label});
        if (values != null) {
            for (String value : values) {
                TableFactory.appendCell((String)valueCellStyle, (String)valueTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{value});
            }
        }
    }

    public static void appendEmptyTableLine(TableTableElement tableElement, String rowStyle, String cellStyle, String textStyle) {
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, (String)rowStyle);
        TableFactory.appendEmptyCell((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement);
    }
}

