/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DigestCalculator;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.PlottOrderItem;
import at.cdes.api.dto.Signature;
import at.cdes.api.joinDto.OrderStepJoin;
import at.cdes.impl.dao.GenOrderStepDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcOrderStepDAO
extends AbstrIdDAO<OrderStep>
implements GenOrderStepDAO {
    public AbstractJdbcOrderStepDAO() {
        super(OrderStep.class, "id", "order_step", new String[]{"id", "created", "finished", "digest", "digest_calculator_id", "signature_id", "accepted_mode", "order_item_id", "comment"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcOrderStepDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "created") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "finished") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "accepted_mode") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_item_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcOrderStepDAO.getSelectClauseForDto("order_step", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcOrderStepDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".created" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "created") + "," + entityLocalName + ".finished" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "finished") + "," + entityLocalName + ".digest" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + "," + entityLocalName + ".digest_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + "," + entityLocalName + ".signature_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + "," + entityLocalName + ".accepted_mode" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "accepted_mode") + "," + entityLocalName + ".order_item_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_item_id") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + " ";
    }

    protected OrderStep fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        OrderStep orderStep = new OrderStep();
        orderStep.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStep.setCreated(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        orderStep.setFinished(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        orderStep.setDigest(rs.getString(++columnIndex));
        orderStep.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStep.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStep.setAcceptedMode(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        orderStep.setOrderItemId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStep.setComment(rs.getString(++columnIndex));
        return orderStep;
    }

    public static OrderStep fillOrderStepFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        OrderStep orderStep = new OrderStep();
        orderStep.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderStep.setCreated(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderStep.setFinished(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderStep.setDigest(rs.getString(columnIndex.incrementAndGet()));
        orderStep.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderStep.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderStep.setAcceptedMode(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderStep.setOrderItemId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        orderStep.setComment(rs.getString(columnIndex.incrementAndGet()));
        return orderStep;
    }

    public static OrderStep fillOrderStepFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcOrderStepDAO.fillOrderStepFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 9;
    }

    public static OrderStepJoin fillOrderStepJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        OrderStepJoin orderStepJoin = new OrderStepJoin();
        orderStepJoin.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrderStepCreated(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrderStepFinished(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrderStepDigest(rs.getString(++columnIndex));
        orderStepJoin.setOrderStepDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrderStepSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrderStepAcceptedMode(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrderStepOrderItemId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrderStepComment(rs.getString(++columnIndex));
        orderStepJoin.setOrganisationOrderStepOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrganisationOrderStepOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrganisationOrderStepOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrganisationPersonOrderStepOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setOrganisationPersonOrderStepOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setProjectParticipationOrderStepOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setProjectParticipationOrderStepProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        orderStepJoin.setProjectParticipationOrderStepSignerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return orderStepJoin;
    }

    public static int getNumberOfOrderStepJoinAttributes() {
        return 17;
    }

    protected String getSelectClauseForOrderStepJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("orderStep") ? result + "order_step.id, order_step.created, order_step.finished, order_step.digest, order_step.digest_calculator_id, order_step.signature_id, order_step.accepted_mode, order_step.order_item_id, order_step.comment" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisationOrderStep") ? result + "organisation_order_step.order_step_id, organisation_order_step.organisation_person_id, organisation_order_step.organisation_id" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisationPersonOrderStep") ? result + "organisation_person_order_step.order_step_id, organisation_person_order_step.organisation_person_id" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectParticipationOrderStep") ? result + "project_participation_order_step.order_step_id, project_participation_order_step.project_participation_id, project_participation_order_step.signer_id" : result + "NULL, NULL, NULL";
        return result;
    }

    public int update(OrderStep dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<OrderStep> dtos) {
        Iterator<OrderStep> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getOrderStepJoinSelectClause() {
        return "order_step.id, order_step.created, order_step.finished, order_step.digest, order_step.digest_calculator_id, order_step.signature_id, order_step.accepted_mode, order_step.order_item_id, order_step.comment, organisation_order_step.order_step_id, organisation_order_step.organisation_person_id, organisation_order_step.organisation_id, organisation_person_order_step.order_step_id, organisation_person_order_step.organisation_person_id, project_participation_order_step.order_step_id, project_participation_order_step.project_participation_id, project_participation_order_step.signer_id ";
    }

    public static String getPrefixedOrderStepJoinSelectClause() {
        return "order_step.id AS order_step_id, order_step.created AS order_step_created, order_step.finished AS order_step_finished, order_step.digest AS order_step_digest, order_step.digest_calculator_id AS order_step_digest_calculator_id, order_step.signature_id AS order_step_signature_id, order_step.accepted_mode AS order_step_accepted_mode, order_step.order_item_id AS order_step_order_item_id, order_step.comment AS order_step_comment, organisation_order_step.order_step_id AS organisation_order_step_order_step_id, organisation_order_step.organisation_person_id AS organisation_order_step_organisation_person_id, organisation_order_step.organisation_id AS organisation_order_step_organisation_id, organisation_person_order_step.order_step_id AS organisation_person_order_step_order_step_id, organisation_person_order_step.organisation_person_id AS organisation_person_order_step_organisation_person_id, project_participation_order_step.order_step_id AS project_participation_order_step_order_step_id, project_participation_order_step.project_participation_id AS project_participation_order_step_project_participation_id, project_participation_order_step.signer_id AS project_participation_order_step_signer_id ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, OrderStep orderStep) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)orderStep.getId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)2, (Double)orderStep.getCreated());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)3, (Double)orderStep.getFinished());
        statement.setString(4, orderStep.getDigest());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)orderStep.getDigestCalculatorId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)orderStep.getSignatureId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)7, (Number)orderStep.getAcceptedMode());
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)orderStep.getOrderItemId());
        statement.setString(9, orderStep.getComment());
    }

    @Override
    public List<OrderStep> getByDigestCalculator(DigestCalculator digestCalculator) {
        return this.getByDigestCalculator(digestCalculator.getId());
    }

    @Override
    public List<OrderStep> getByDigestCalculator(final Long digestCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, digestCalculatorId);
            }
        });
    }

    @Override
    public List<OrderStep> getBySignature(Signature signature) {
        return this.getBySignature(signature.getId());
    }

    @Override
    public List<OrderStep> getBySignature(final Long signatureId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, signatureId);
            }
        });
    }

    @Override
    public List<OrderStep> getByOrderItem(PlottOrderItem plottOrderItem) {
        return this.getByOrderItem(plottOrderItem.getId());
    }

    @Override
    public List<OrderStep> getByOrderItem(final Long plottOrderItemId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_item_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, plottOrderItemId);
            }
        });
    }

    @Override
    public List<OrderStep> getByDigestCalculators(Collection<Long> digestCalculatorId) {
        if (digestCalculatorId.isEmpty()) {
            return new ArrayList<OrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[digestCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = digestCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<OrderStep> getBySignatures(Collection<Long> signatureId) {
        if (signatureId.isEmpty()) {
            return new ArrayList<OrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[signatureId.size()];
        int n = 0;
        Iterator<Long> it = signatureId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<OrderStep> getByOrderItems(Collection<Long> plottOrderItemId) {
        if (plottOrderItemId.isEmpty()) {
            return new ArrayList<OrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[plottOrderItemId.size()];
        int n = 0;
        Iterator<Long> it = plottOrderItemId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_item_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

