/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.temp;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTempDAO<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTempDAO.class);
    private final Function<T, UUID> idGetter;
    private final BiConsumer<T, UUID> idSetter;
    private final Function<T, Instant> createdGetter;
    private final BiConsumer<T, Instant> createdSetter;
    private final Map<UUID, T> store = new HashMap<UUID, T>();
    private SharedData sharedData = new SharedData();
    private Thread cleanupThread = new Thread(() -> {
        try {
            block6: while (true) {
                SharedData sharedData;
                Instant nextCleanup;
                if (log.isDebugEnabled()) {
                    log.debug("Pruning expired temporary documents");
                }
                this.sharedData.nextCleanup = nextCleanup = this.prune();
                if (log.isDebugEnabled()) {
                    log.debug("nextCleanup = {}", (Object)nextCleanup);
                }
                while (nextCleanup == null) {
                    sharedData = this.sharedData;
                    synchronized (sharedData) {
                        this.sharedData.wait();
                        if (log.isDebugEnabled()) {
                            nextCleanup = this.sharedData.nextCleanup;
                        }
                        if (!log.isDebugEnabled()) continue;
                    }
                    log.debug("nextCleanup = {}", (Object)nextCleanup);
                }
                while (true) {
                    sharedData = this.sharedData;
                    synchronized (sharedData) {
                        Duration wait = Duration.between(Instant.now(), nextCleanup);
                        if (wait.isNegative()) {
                            continue block6;
                        }
                        this.sharedData.wait(wait.toMillis());
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    });
    private Duration expiryDuration;

    public AbstractTempDAO(Function<T, UUID> idGetter, BiConsumer<T, UUID> idSetter, Function<T, Instant> createdGetter, BiConsumer<T, Instant> createdSetter) {
        this.idGetter = idGetter;
        this.idSetter = idSetter;
        this.createdGetter = createdGetter;
        this.createdSetter = createdSetter;
    }

    protected abstract void cleanup(T var1) throws Exception;

    public void setExpiryDuration(Duration expiryDuration) {
        this.expiryDuration = expiryDuration;
    }

    public void setExpiryDuration(String expiryDuration) {
        this.expiryDuration = Duration.parse(expiryDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instant prune() {
        Map<UUID, T> map = this.store;
        synchronized (map) {
            Instant now = Instant.now();
            Instant nextCleanup = null;
            for (T temp : this.store.values()) {
                if (this.expiryDuration.compareTo(Duration.between(this.createdGetter.apply(temp), now)) > 0) {
                    this.store.remove(this.idGetter.apply(temp));
                    this.doCleanup(temp);
                    continue;
                }
                if (nextCleanup != null && this.createdGetter.apply(temp).compareTo(nextCleanup) < 0) continue;
                nextCleanup = this.createdGetter.apply(temp).plus(this.expiryDuration);
            }
            return nextCleanup;
        }
    }

    public void start() {
        this.cleanupThread.start();
    }

    public void stop() throws InterruptedException {
        this.cleanupThread.interrupt();
        this.cleanupThread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(UUID id) {
        Map<UUID, T> map = this.store;
        synchronized (map) {
            return this.store.get(id);
        }
    }

    private void doCleanup(T value) {
        try {
            this.cleanup(value);
        }
        catch (Throwable e) {
            log.warn("Error during cleanup.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(T document) {
        UUID id = this.idGetter.apply(document) == null ? UUID.randomUUID() : this.idGetter.apply(document);
        Object object = this.store;
        synchronized (object) {
            this.store.put(id, document);
            this.idSetter.accept(document, id);
            this.createdSetter.accept(document, Instant.now());
        }
        object = this.sharedData;
        synchronized (object) {
            Instant prevNextCleanup = this.sharedData.nextCleanup;
            if (prevNextCleanup == null) {
                this.sharedData.nextCleanup = this.createdGetter.apply(document).plus(this.expiryDuration);
                log.debug("Notifying cleanup thread.");
                this.sharedData.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(UUID id, boolean doCleanup) {
        Map<UUID, T> map = this.store;
        synchronized (map) {
            T value = this.store.remove(id);
            if (doCleanup && value != null) {
                this.doCleanup(value);
            }
        }
    }

    public void delete(UUID id) {
        this.delete(id, true);
    }

    private static class SharedData {
        public volatile Instant nextCleanup = null;

        private SharedData() {
        }
    }
}

