/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.imp;

import at.cdes.impl.dao.DocumentNumberPartDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.imp.NewDocumentCsvCallable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDocumentImportServlet
extends HttpServlet {
    private static final long serialVersionUID = 6581453721947819393L;
    private static final Logger log = LoggerFactory.getLogger(NewDocumentImportServlet.class);
    private DocumentTypeDAO documentTypeDAO;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private ProjectDAO projectDAO;
    private IOneTimeScheduler oneTimeScheduler;

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public void setDocumentNumberPartDAO(DocumentNumberPartDAO documentNumberPartDAO) {
        this.documentNumberPartDAO = documentNumberPartDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            try {
                String uuid = this.handleMultiPartUpload(req);
                if (uuid == null) {
                    resp.sendError(500, "Invalid request");
                }
                resp.setDateHeader("Date", System.currentTimeMillis());
                resp.setContentType("text/html");
                resp.getWriter().write("<html><body>" + uuid + "</body></html>");
            }
            catch (FileUploadException e) {
                throw new IOException("Error processing multipart request", e);
            }
        } else {
            log.error("Client sent POST request with wrong mimetype: " + req.getContentType());
            resp.sendError(500);
        }
    }

    protected String handleMultiPartUpload(HttpServletRequest req) throws FileUploadException, IOException, ServletException {
        Long projectId;
        Map paramMap;
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileIt = upload.getItemIterator(req);
        byte[] data = null;
        String projectIdString = null;
        String qs = req.getQueryString();
        if (qs != null && (paramMap = UrlHelper.parseQuery((String)qs)) != null) {
            projectIdString = UrlHelper.getStringParameter((Map)paramMap, (String)"projectId");
        }
        Long l = projectId = projectIdString != null ? Long.valueOf(Long.parseLong(projectIdString)) : null;
        while (fileIt.hasNext()) {
            String filename;
            FileItemStream item = fileIt.next();
            if (item.isFormField() || !"uploadedFile".equals(item.getFieldName()) || (filename = item.getName()) == null || filename.length() == 0) continue;
            log.info("NewDocumentImportServlet processes filename = " + filename);
            int pos = filename.lastIndexOf(47);
            if (pos >= 0) {
                filename = filename.substring(pos + 1);
            }
            if ((pos = filename.lastIndexOf(92)) >= 0) {
                filename = filename.substring(pos + 1);
            }
            InputStream inputStream = item.openStream();
            data = IOUtils.toByteArray((InputStream)inputStream);
        }
        if (data == null) {
            log.error("Recevied request with no data.");
            return null;
        }
        try {
            NewDocumentCsvCallable callable = new NewDocumentCsvCallable(data, projectId, this.documentTypeDAO, this.projectDAO, this.documentNumberPartDAO);
            UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)callable));
            return uuid.toString();
        }
        catch (Exception e) {
            log.error("Caught exception: ", (Throwable)e);
            return null;
        }
    }

    public String getServletInfo() {
        return NewDocumentImportServlet.class.getSimpleName();
    }
}

