/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.DocumentTask;
import at.cdes.api.dto.EmailSnippet;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.ReviewCycleEntryTask;
import at.cdes.api.dto.TaskEmailSnippet;
import at.cdes.api.email.compositeDto.NewFutureEmailInfo;
import at.cdes.api.result.ResultSummary;
import at.cdes.api.voc.EntityVoc;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.ReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.reviewCycle.WriteOnlyTaskEmailContext;
import at.cdes.impl.util.DBChanges;
import at.cdes.impl.util.ObjectCriteria;
import java.util.ArrayList;
import java.util.List;

public class WriteOnlyReviewTaskContext
implements WriteOnlyTaskEmailContext {
    private DBChanges<BaseTask> taskChanges = new DBChanges();
    private DBChanges<DocumentTask> documentTaskChanges = new DBChanges();
    private DBChanges<ReviewCycleEntryTask> reviewCycleEntryTaskChanges = new DBChanges();
    private DBChanges<EmailSnippet> emailSnippetChanges = new DBChanges();
    private DBChanges<TaskEmailSnippet> taskEmailSnippetChanges = new DBChanges();
    private DBChanges<FutureEmail> futureEmailChanges = new DBChanges();
    private List<NewFutureEmailInfo> newFutureEmailInfos = new ArrayList<NewFutureEmailInfo>();

    @Override
    public void registerFutureEmailsForDelete(ObjectCriteria<FutureEmail> criteria) {
        this.futureEmailChanges.registerForDelete(criteria);
    }

    @Override
    public void registerNewFutureEmail(FutureEmail futureEmail, BaseTask refTask) {
        this.futureEmailChanges.registerNew(futureEmail);
        this.newFutureEmailInfos.add(new NewFutureEmailInfo(futureEmail, refTask));
    }

    @Override
    public void registerNewTaskEmailSnippet(EmailSnippet emailSnippet, TaskEmailSnippet taskEmailSnippet) {
        if (taskEmailSnippet.getTaskId() == null) {
            throw new IllegalArgumentException("Task Id needs to be set");
        }
        this.emailSnippetChanges.registerNew(emailSnippet);
        this.taskEmailSnippetChanges.registerNew(taskEmailSnippet);
    }

    @Override
    public void registerTaskForUpdate(BaseTask task) {
        this.taskChanges.registerForUpdate(task.getId(), task);
    }

    @Override
    public void registerReviewCycleEntryTaskForUpdate(ReviewCycleEntryTask reviewCycleEntryTask) {
        this.reviewCycleEntryTaskChanges.registerForUpdate(reviewCycleEntryTask.getTaskId(), reviewCycleEntryTask);
    }

    @Override
    public void registerFutureEmailForDelete(FutureEmail futureEmail) {
        this.futureEmailChanges.registerForDelete(futureEmail.getId());
    }

    @Override
    public void registerTaskEmailSnippetForDelete(TaskEmailSnippet taskEmailSnippet) {
        this.emailSnippetChanges.registerForDelete(taskEmailSnippet.getEmailSnippetId());
        this.taskEmailSnippetChanges.registerForDelete(taskEmailSnippet.getEmailSnippetId());
    }

    @Override
    public void registerReviewCycleEntryTaskForDelete(ReviewCycleEntryTask reviewCycleEntryTask) {
        this.reviewCycleEntryTaskChanges.registerForDelete(reviewCycleEntryTask.getTaskId());
    }

    @Override
    public void registerDocumentTaskForDelete(DocumentTask documentTask) {
        this.documentTaskChanges.registerForDelete(documentTask.getTaskId());
    }

    @Override
    public void registerTaskForDelete(BaseTask task) {
        this.taskChanges.registerForDelete(task.getId());
    }

    public void commitAll(ResultSummary resultSummary, EmailSnippetDAO emailSnippetDAO, TaskEmailSnippetDAO taskEmailSnippetDAO, FutureEmailDAO futureEmailDAO, TaskDAO taskDAO, DocumentTaskDAO documentTaskDAO, ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO) {
        int n;
        List<BaseTask> justInsertedTasks = this.taskChanges.saveBatch(taskDAO, EntityVoc.BASE_TASK, resultSummary);
        for (int n2 = 0; n2 < justInsertedTasks.size(); ++n2) {
            ReviewCycleEntryTask reviewCycleEntryTask;
            DocumentTask documentTask = this.documentTaskChanges.getNewInstance(n2);
            if (documentTask != null) {
                documentTask.setTaskId(justInsertedTasks.get(n2).getId());
            }
            if ((reviewCycleEntryTask = this.reviewCycleEntryTaskChanges.getNewInstance(n2)) == null) continue;
            reviewCycleEntryTask.setTaskId(justInsertedTasks.get(n2).getId());
        }
        this.documentTaskChanges.saveBatch(documentTaskDAO, EntityVoc.DOCUMENT_TASK, resultSummary);
        this.reviewCycleEntryTaskChanges.saveBatch(reviewCycleEntryTaskDAO, EntityVoc.REVIEW_CYCLE_ENTRY_TASK, resultSummary);
        List<EmailSnippet> justInsertedEmailSnippets = this.emailSnippetChanges.saveBatch(emailSnippetDAO, EntityVoc.EMAIL_SNIPPET, resultSummary);
        for (n = 0; n < justInsertedEmailSnippets.size(); ++n) {
            TaskEmailSnippet taskEmailSnippet = this.taskEmailSnippetChanges.getNewInstance(n);
            if (taskEmailSnippet == null) continue;
            taskEmailSnippet.setEmailSnippetId(justInsertedEmailSnippets.get(n).getId());
        }
        this.taskEmailSnippetChanges.saveBatch(taskEmailSnippetDAO, EntityVoc.TASK_EMAIL_SNIPPET, resultSummary);
        for (n = 0; n < this.futureEmailChanges.getNumberOfNewInstances(); ++n) {
            FutureEmail newFutureEmail = this.futureEmailChanges.getNewInstance(n);
            if (newFutureEmail == null) continue;
            for (NewFutureEmailInfo newFutureEmailInfo : this.newFutureEmailInfos) {
                if (newFutureEmailInfo.getFutureEmail() != newFutureEmail) continue;
                newFutureEmail.setTaskId(newFutureEmailInfo.getTask().getId());
            }
        }
        this.futureEmailChanges.saveBatch(futureEmailDAO, EntityVoc.FUTURE_EMAIL, resultSummary);
        this.futureEmailChanges.updateDeleteBatch(futureEmailDAO, EntityVoc.FUTURE_EMAIL, resultSummary);
        this.taskEmailSnippetChanges.updateDeleteBatch(taskEmailSnippetDAO, EntityVoc.TASK_EMAIL_SNIPPET, resultSummary);
        this.emailSnippetChanges.updateDeleteBatch(emailSnippetDAO, EntityVoc.EMAIL_SNIPPET, resultSummary);
        this.reviewCycleEntryTaskChanges.updateDeleteBatch(reviewCycleEntryTaskDAO, EntityVoc.REVIEW_CYCLE_ENTRY_TASK, resultSummary);
        this.documentTaskChanges.updateDeleteBatch(documentTaskDAO, EntityVoc.DOCUMENT_TASK, resultSummary);
        this.taskChanges.updateDeleteBatch(taskDAO, EntityVoc.BASE_TASK, resultSummary);
    }
}

