/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.plot;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.IReviewCycleNodePosition;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.OrderAddress;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.PlotOrderAcceptanceTask;
import at.cdes.api.dto.PlotOrderAcceptanceTaskDone;
import at.cdes.api.dto.PlottOrder;
import at.cdes.api.dto.PlottOrderItem;
import at.cdes.api.dto.PlottOrderItemTemplate;
import at.cdes.api.dto.PlottOrderTemplate;
import at.cdes.api.dto.PlottProperties;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ProjectParticipationOrderStep;
import at.cdes.api.dto.ReceivedPlottOrderStep;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCyclePlottTask;
import at.cdes.api.dto.ReviewCyclePlottTaskDone;
import at.cdes.api.dto.Signature;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.PlotOrderDeleteJoin;
import at.cdes.api.plot.compositeDto.PlotTaskInfo;
import at.cdes.api.plot.compositeDto.PlotTaskItemInfo;
import at.cdes.api.sec.SignatureCalculator;
import at.cdes.api.voc.plot.AcceptedMode;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.DocumentVersionTaskDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.OrderAddressDAO;
import at.cdes.impl.dao.OrderStepDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.PlotOrderAcceptanceTaskDAO;
import at.cdes.impl.dao.PlotOrderAcceptanceTaskDoneDAO;
import at.cdes.impl.dao.PlottOrderDAO;
import at.cdes.impl.dao.PlottOrderItemDAO;
import at.cdes.impl.dao.PlottOrderItemTemplateDAO;
import at.cdes.impl.dao.PlottOrderTemplateDAO;
import at.cdes.impl.dao.PlottPropertiesDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ProjectParticipationOrderStepDAO;
import at.cdes.impl.dao.ReceivedPlottOrderStepDAO;
import at.cdes.impl.dao.ReviewCycleCellInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionDAO;
import at.cdes.impl.dao.ReviewCyclePlottTaskDAO;
import at.cdes.impl.dao.ReviewCyclePlottTaskDoneDAO;
import at.cdes.impl.dao.ReviewCycleResultOptionDAO;
import at.cdes.impl.dao.SignatureDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.digest.OrderStepDigester;
import at.cdes.impl.document.util.DocumentVersionHelper;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.plot.PlotHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotUtils {
    private static final Logger log = LoggerFactory.getLogger(PlotUtils.class);
    private CertificateDAO certificateDAO;
    private DocumentDAO documentDAO;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentVersionTaskDAO documentVersionTaskDAO;
    private OrderAddressDAO orderAddressDAO;
    private OrderStepDAO orderStepDAO;
    private OrderStepDigester orderStepDigester;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonVariablesDAO personVariablesDAO;
    private PlottOrderDAO plotOrderDAO;
    private PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO;
    private PlotOrderAcceptanceTaskDoneDAO plotOrderAcceptanceTaskDoneDAO;
    private PlottOrderItemDAO plotOrderItemDAO;
    private PlottOrderItemTemplateDAO plotOrderItemTemplateDAO;
    private PlottOrderTemplateDAO plotOrderTemplateDAO;
    private PlottPropertiesDAO plotPropertiesDAO;
    private ProjectDAO projectDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ProjectParticipationOrderStepDAO projectParticipationOrderStepDAO;
    private ReceivedPlottOrderStepDAO receivedPlotOrderStepDAO;
    private ReviewCyclePlottTaskDAO reviewCyclePlotTaskDAO;
    private ReviewCyclePlottTaskDoneDAO reviewCyclePlotTaskDoneDAO;
    private SignatureCalculator signatureCalculator;
    private SignatureDAO signatureDAO;
    private TaskDAO taskDAO;
    private TaskUtils taskUtils;
    private ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO;
    private ReviewCycleCellInstanceReleasedDAO reviewCycleCellInstanceReleasedDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private ReviewCycleNodePositionDAO reviewCycleNodePositionDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentVersionTaskDAO(DocumentVersionTaskDAO documentVersionTaskDAO) {
        this.documentVersionTaskDAO = documentVersionTaskDAO;
    }

    public void setOrderAddressDAO(OrderAddressDAO orderAddressDAO) {
        this.orderAddressDAO = orderAddressDAO;
    }

    public void setOrderStepDAO(OrderStepDAO orderStepDAO) {
        this.orderStepDAO = orderStepDAO;
    }

    public void setOrderStepDigester(OrderStepDigester orderStepDigester) {
        this.orderStepDigester = orderStepDigester;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setPlotOrderDAO(PlottOrderDAO plotOrderDAO) {
        this.plotOrderDAO = plotOrderDAO;
    }

    public void setPlotOrderAcceptanceTaskDAO(PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO) {
        this.plotOrderAcceptanceTaskDAO = plotOrderAcceptanceTaskDAO;
    }

    public void setPlotOrderAcceptanceTaskDoneDAO(PlotOrderAcceptanceTaskDoneDAO plotOrderAcceptanceTaskDoneDAO) {
        this.plotOrderAcceptanceTaskDoneDAO = plotOrderAcceptanceTaskDoneDAO;
    }

    public void setPlotOrderItemDAO(PlottOrderItemDAO plotOrderItemDAO) {
        this.plotOrderItemDAO = plotOrderItemDAO;
    }

    public void setPlotOrderItemTemplateDAO(PlottOrderItemTemplateDAO plotOrderItemTemplateDAO) {
        this.plotOrderItemTemplateDAO = plotOrderItemTemplateDAO;
    }

    public void setPlotOrderTemplateDAO(PlottOrderTemplateDAO plotOrderTemplateDAO) {
        this.plotOrderTemplateDAO = plotOrderTemplateDAO;
    }

    public void setPlotPropertiesDAO(PlottPropertiesDAO plotPropertiesDAO) {
        this.plotPropertiesDAO = plotPropertiesDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setProjectParticipationOrderStepDAO(ProjectParticipationOrderStepDAO projectParticipationOrderStepDAO) {
        this.projectParticipationOrderStepDAO = projectParticipationOrderStepDAO;
    }

    public void setReceivedPlotOrderStepDAO(ReceivedPlottOrderStepDAO receivedPlotOrderStepDAO) {
        this.receivedPlotOrderStepDAO = receivedPlotOrderStepDAO;
    }

    public void setReviewCyclePlotTaskDAO(ReviewCyclePlottTaskDAO reviewCyclePlotTaskDAO) {
        this.reviewCyclePlotTaskDAO = reviewCyclePlotTaskDAO;
    }

    public void setReviewCyclePlotTaskDoneDAO(ReviewCyclePlottTaskDoneDAO reviewCyclePlotTaskDoneDAO) {
        this.reviewCyclePlotTaskDoneDAO = reviewCyclePlotTaskDoneDAO;
    }

    public void setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void setReviewCycleNodeInstanceReleasedDAO(ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO) {
        this.reviewCycleNodeInstanceReleasedDAO = reviewCycleNodeInstanceReleasedDAO;
    }

    public void setReviewCycleCellInstanceReleasedDAO(ReviewCycleCellInstanceReleasedDAO reviewCycleCellInstanceReleasedDAO) {
        this.reviewCycleCellInstanceReleasedDAO = reviewCycleCellInstanceReleasedDAO;
    }

    public void setObjectPlannerReleaseDAO(ObjectPlannerReleaseDAO objectPlannerReleaseDAO) {
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
    }

    public void setReviewCycleNodePositionDAO(ReviewCycleNodePositionDAO reviewCycleNodePositionDAO) {
        this.reviewCycleNodePositionDAO = reviewCycleNodePositionDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public PlottOrder generatePlotOrderFromTemplate(DebugContext debugContext, Long documentVersionId, Long plotOrderTemplateId, ProjectParticipant clientParticipant, ProjectParticipation plotter) {
        debugContext.openDebugNode("generatePlotOrderFromTemplate");
        PlottOrderTemplate plotOrderTemplate = (PlottOrderTemplate)this.plotOrderTemplateDAO.get(plotOrderTemplateId);
        PersonVariables plotterPersonVariables = this.personVariablesDAO.getByParticipationViaMainParticipant(plotter.getId());
        String userLocale = plotterPersonVariables.getUserLocale();
        List<PlottOrder> openPlotOrders = this.plotOrderDAO.getUnfinishedByTemplate(plotOrderTemplateId);
        boolean orderFound = false;
        PlottOrder plotOrder = null;
        for (PlottOrder openPlotOrder : openPlotOrders) {
            if (openPlotOrder.getBillingAddressId() == null || openPlotOrder.getBillingAddressId().longValue() != plotOrderTemplate.getBillingAddressId().longValue()) continue;
            plotOrder = openPlotOrder;
            orderFound = true;
            break;
        }
        if (openPlotOrders.size() == 0 || !orderFound) {
            plotOrder = new PlottOrder();
            if ((plotOrder = this.resolveProperties(documentVersionId, plotOrder, plotOrderTemplate, plotter, false)) == null) {
                debugContext.closeDebugNode("plotOrder is null (no valid recipients could be found)");
                return null;
            }
            OrderStep requestStep = this.generateRequestOrderStep(clientParticipant.getId(), clientParticipant.getParticipationId());
            OrderStep acceptanceStep = this.generateAcceptanceStep(clientParticipant.getParticipationId());
            plotOrder.setRequestId(requestStep.getId());
            plotOrder.setAcceptanceId(acceptanceStep.getId());
            this.plotOrderDAO.update(plotOrder);
            debugContext.addUpdatePlotOrderMessage(plotOrder);
            ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
            this.taskUtils.generateReviewCyclePlotTask(debugContext, documentVersionId, plotOrder.getId(), acceptanceStep.getId(), plotter.getProjectId(), userLocale, contextJoin.getProjectLocalisationId(), plotOrderTemplate.getPlotterId(), contextJoin.getObjectPlannerId());
            log.info("Generated PlottOrder [plotOrderTemplateId=" + plotOrderTemplateId + "] [documentVersionId=" + documentVersionId + "]");
        } else {
            if ((plotOrder = this.resolveProperties(documentVersionId, plotOrder, plotOrderTemplate, plotter, true)) == null) {
                return null;
            }
            this.plotOrderDAO.update(plotOrder);
            debugContext.addUpdatePlotOrderMessage(plotOrder);
            log.info("PlottOrderItem added [orderJobNumber=" + plotOrder.getJobNumber() + "] [documentVersionId=" + documentVersionId + "]");
        }
        debugContext.closeDebugNode();
        return plotOrder;
    }

    private PlottOrder resolveProperties(Long documentVersionId, PlottOrder plotOrder, PlottOrderTemplate plotOrderTemplate, ProjectParticipation plotter, boolean onlyItems) {
        String templateResolver = plotOrderTemplate.getTemplateResolver();
        if ("ProjectParticipationPlotTemplate".equals(templateResolver) || "ReviewCyclePlotProjectTemplate".equals(templateResolver)) {
            if (!onlyItems) {
                plotOrder.setJobNumber(Long.valueOf(System.currentTimeMillis()));
                plotOrder.setBillingAddressId(plotOrderTemplate.getBillingAddressId());
                plotOrder.setPlotterId(plotter.getOrganisationId());
                plotOrder.setTemplateId(plotOrderTemplate.getId());
                plotOrder.setProjectId(plotOrderTemplate.getProjectId());
                plotOrder.setComment(plotOrderTemplate.getComment());
                plotOrder.setKindOfDelivery(plotOrderTemplate.getKindOfDelivery());
            }
            if (plotOrder.getId() == null) {
                this.plotOrderDAO.save(plotOrder);
            }
            return this.resolvePropertiesInner(documentVersionId, plotOrder, plotOrderTemplate, templateResolver);
        }
        if ("ManualPlotTemplate".equals(templateResolver)) {
            if (!onlyItems) {
                plotOrder.setJobNumber(Long.valueOf(System.currentTimeMillis()));
                plotOrder.setBillingAddressId(plotOrderTemplate.getBillingAddressId());
                plotOrder.setPlotterId(plotter.getOrganisationId());
                plotOrder.setTemplateId(plotOrderTemplate.getId());
                plotOrder.setProjectId(plotOrderTemplate.getProjectId());
                plotOrder.setKindOfDelivery(plotOrderTemplate.getKindOfDelivery());
            }
            if (plotOrder.getId() == null) {
                this.plotOrderDAO.save(plotOrder);
            }
            return this.resolvePropertiesInner(documentVersionId, plotOrder, plotOrderTemplate, templateResolver);
        }
        throw new IllegalArgumentException("Unsupported templateResolver: [" + templateResolver + "]");
    }

    private PlottOrder resolvePropertiesInner(Long documentVersionId, PlottOrder plotOrder, PlottOrderTemplate plotOrderTemplate, String templateResolver) {
        DocumentVersion documentVersion = (DocumentVersion)this.documentVersionDAO.get(documentVersionId);
        ReviewCycleNodeInstanceReleased activeReviewCycleNodeInstanceReleased = this.reviewCycleNodeInstanceReleasedDAO.getActiveByDocumentVersion(documentVersionId);
        Long activeReviewCycleNodeInstanceReleasedId = activeReviewCycleNodeInstanceReleased.getId();
        Long activeReviewCycleCellInstanceRelId = activeReviewCycleNodeInstanceReleased.getReviewCycleCellInstanceId();
        ReviewCycleCellInstanceReleased activeReviewCycleCellInstanceRel = (ReviewCycleCellInstanceReleased)this.reviewCycleCellInstanceReleasedDAO.get(activeReviewCycleCellInstanceRelId);
        Long activeReviewCycleInstanceRelId = activeReviewCycleCellInstanceRel.getReviewCycleInstanceId();
        Long documentId = documentVersion.getDocumentId();
        ObjectPlannerRelease releasedObjectPlanner = this.objectPlannerReleaseDAO.getReleasedObjectPlannerForDocument(documentId);
        List<PlottOrderItemTemplate> itemTemplates = this.plotOrderItemTemplateDAO.getByOrderContract(plotOrderTemplate.getId());
        ArrayList<PlottOrderItem> newItems = new ArrayList<PlottOrderItem>();
        for (PlottOrderItemTemplate itemTemplate : itemTemplates) {
            if (itemTemplate.isInvalidated().booleanValue()) continue;
            Long deliveryReceiverId = null;
            if ("ProjectParticipationPlotTemplate".equals(templateResolver)) {
                deliveryReceiverId = itemTemplate.getDeliveryAddressId();
            } else if ("ReviewCyclePlotProjectTemplate".equals(templateResolver)) {
                Long deliveryNodeId = itemTemplate.getDeliveryAddressId();
                if (deliveryNodeId == null || itemTemplate.isInvalidated().booleanValue()) continue;
                ReviewCycleNodeInstanceReleased deliveryNodeInstanceReleased = this.reviewCycleNodeInstanceReleasedDAO.getByReviewCycleInstanceReleased(activeReviewCycleInstanceRelId, deliveryNodeId);
                if (deliveryNodeInstanceReleased == null) {
                    throw new RuntimeException("deliveryNodeInstanceReleased == null");
                }
                boolean isEndNode = this.reviewCycleResultOptionDAO.getByReviewCycleNode(deliveryNodeId).isEmpty();
                if (!isEndNode) {
                    List<IReviewCycleNodePosition> positions = this.reviewCycleNodePositionDAO.getByNodeInstanceReleasedAndDocumentVersion(deliveryNodeInstanceReleased.getId(), documentVersionId);
                    ArrayList<Long> alreadyReceiving = new ArrayList<Long>();
                    for (IReviewCycleNodePosition position : positions) {
                        deliveryReceiverId = position.getProjectParticipationId();
                        ProjectParticipation positionsPp = (ProjectParticipation)this.projectParticipationDAO.get(deliveryReceiverId);
                        if (alreadyReceiving.contains(deliveryReceiverId) || itemTemplate.isEvaluateMailReceivers().booleanValue() && !positionsPp.isMailFlag().booleanValue()) continue;
                        alreadyReceiving.add(deliveryReceiverId);
                        PlottOrderItem newItem = new PlottOrderItem();
                        newItem.setDocumentVersionId(documentVersionId);
                        newItem.setNodeInstanceReleaseId(activeReviewCycleNodeInstanceReleasedId);
                        newItem.setReceiverId(deliveryReceiverId);
                        newItem.setTemplateId(itemTemplate.getId());
                        OrganisationPersonJoin opJoin = this.organisationPersonDAO.getOrganisationPersonJoinByParticipationViaMainParticipant(deliveryReceiverId);
                        OrderAddress address = new OrderAddress();
                        address.setCountryId(opJoin.getOpCountryId());
                        address.setPostalAddress(opJoin.getOrganisationPersonPostalAddress());
                        address.setPostalCode(opJoin.getOrganisationPersonPostalCode());
                        address.setLocalityName(opJoin.getOrganisationPersonLocalityName());
                        address.setTitle(opJoin.getPersonTitle());
                        address.setGender(opJoin.getPersonGender());
                        address.setGivenName(opJoin.getPersonGivenName());
                        address.setSurName(opJoin.getPersonSurName());
                        address.setOrganisationalUnitName(opJoin.getOrganisationPersonOrganisationalUnitName());
                        address.setOrganisationName(opJoin.getOrganisationName());
                        address.setType(Integer.valueOf(0));
                        address = (OrderAddress)this.orderAddressDAO.save(address);
                        newItem.setDeliveryAddressId(address.getId());
                        Long templatePlotPropertiesId = itemTemplate.getPlottPropertiesId();
                        PlottProperties plotProperties = new PlottProperties((PlottProperties)this.plotPropertiesDAO.get(templatePlotPropertiesId));
                        plotProperties.setLlx(documentVersion.getLlx());
                        plotProperties.setLly(documentVersion.getLly());
                        plotProperties.setUrx(documentVersion.getUrx());
                        plotProperties.setUry(documentVersion.getUry());
                        plotProperties.setUserUnit(documentVersion.getUserUnit());
                        plotProperties = (PlottProperties)this.plotPropertiesDAO.save(plotProperties);
                        newItem.setPlottPropertiesId(plotProperties.getId());
                        newItem.setOrderContractId(plotOrder.getId());
                        newItems.add(newItem);
                    }
                    deliveryReceiverId = null;
                } else {
                    deliveryReceiverId = releasedObjectPlanner.getPlannerId();
                }
            }
            if (deliveryReceiverId == null) continue;
            PlottOrderItem newItem = new PlottOrderItem();
            newItem.setDocumentVersionId(documentVersionId);
            newItem.setNodeInstanceReleaseId(activeReviewCycleNodeInstanceReleasedId);
            newItem.setReceiverId(deliveryReceiverId);
            newItem.setTemplateId(itemTemplate.getId());
            ProjectParticipation pp = (ProjectParticipation)this.projectParticipationDAO.get(deliveryReceiverId);
            OrganisationPersonJoin opJoin = this.organisationPersonDAO.getOrganisationPersonJoinByParticipationViaMainParticipant(pp.getId());
            OrderAddress address = new OrderAddress();
            address.setCountryId(opJoin.getOpCountryId());
            address.setPostalAddress(opJoin.getOrganisationPersonPostalAddress());
            address.setPostalCode(opJoin.getOrganisationPersonPostalCode());
            address.setLocalityName(opJoin.getOrganisationPersonLocalityName());
            address.setTitle(opJoin.getPersonTitle());
            address.setGender(opJoin.getPersonGender());
            address.setGivenName(opJoin.getPersonGivenName());
            address.setSurName(opJoin.getPersonSurName());
            address.setOrganisationalUnitName(opJoin.getOrganisationPersonOrganisationalUnitName());
            address.setOrganisationName(opJoin.getOrganisationName());
            address.setType(Integer.valueOf(0));
            address = (OrderAddress)this.orderAddressDAO.save(address);
            newItem.setDeliveryAddressId(address.getId());
            Long templatePlotPropertiesId = itemTemplate.getPlottPropertiesId();
            PlottProperties plotProperties = new PlottProperties((PlottProperties)this.plotPropertiesDAO.get(templatePlotPropertiesId));
            plotProperties.setLlx(documentVersion.getLlx());
            plotProperties.setLly(documentVersion.getLly());
            plotProperties.setUrx(documentVersion.getUrx());
            plotProperties.setUry(documentVersion.getUry());
            plotProperties.setUserUnit(documentVersion.getUserUnit());
            plotProperties = (PlottProperties)this.plotPropertiesDAO.save(plotProperties);
            newItem.setPlottPropertiesId(plotProperties.getId());
            newItem.setOrderContractId(plotOrder.getId());
            newItem.setCreated(DateHelper.getCurrentUtcSeconds());
            newItems.add(newItem);
        }
        if (newItems.size() > 0) {
            this.plotOrderItemDAO.saveBatch(newItems);
        }
        return plotOrder;
    }

    private OrderStep generateRequestOrderStep(Long clientParticipantId, Long projectParticipationId) {
        OrderStep orderStep = new OrderStep();
        orderStep.setCreated(DateHelper.getCurrentUtcSeconds());
        orderStep.setFinished(DateHelper.getCurrentUtcSeconds());
        orderStep = (OrderStep)this.orderStepDAO.save(orderStep);
        ProjectParticipationOrderStep projectParticipationOrderStep = new ProjectParticipationOrderStep();
        projectParticipationOrderStep.setOrderStepId(orderStep.getId());
        projectParticipationOrderStep.setProjectParticipationId(projectParticipationId);
        projectParticipationOrderStep.setSignerId(clientParticipantId);
        projectParticipationOrderStep = (ProjectParticipationOrderStep)this.projectParticipationOrderStepDAO.save(projectParticipationOrderStep);
        String digest = this.orderStepDigester.getParticipationOrderStepHash(orderStep, projectParticipationOrderStep);
        orderStep.setDigest(digest);
        orderStep.setDigestCalculatorId(null);
        this.orderStepDAO.update(orderStep);
        return orderStep;
    }

    private OrderStep generateAcceptanceStep(Long projectParticipationId) {
        OrderStep orderStep = new OrderStep();
        orderStep.setCreated(DateHelper.getCurrentUtcSeconds());
        orderStep = (OrderStep)this.orderStepDAO.save(orderStep);
        ProjectParticipationOrderStep projectParticipationOrderStep = new ProjectParticipationOrderStep();
        projectParticipationOrderStep.setOrderStepId(orderStep.getId());
        projectParticipationOrderStep.setProjectParticipationId(projectParticipationId);
        projectParticipationOrderStep = (ProjectParticipationOrderStep)this.projectParticipationOrderStepDAO.save(projectParticipationOrderStep);
        return orderStep;
    }

    public void deletePlotOrderItemsByDocumentVersion(Long documentVersionId) {
        List<PlottOrderItem> plotOrderItems = this.plotOrderItemDAO.getByDocumentVersion(documentVersionId);
        Long plotOrderId = null;
        for (PlottOrderItem plotOrderItem : plotOrderItems) {
            plotOrderId = plotOrderItem.getOrderContractId();
        }
        if (plotOrderId != null) {
            List<Long> plotOrderItemIds = QueryHelper.getPersistentIds(plotOrderItems);
            ArrayList<Long> orderAddressIds = new ArrayList<Long>();
            ArrayList<Long> plotPropertiesIds = new ArrayList<Long>();
            for (PlottOrderItem plotOrderItem : plotOrderItems) {
                orderAddressIds.add(plotOrderItem.getDeliveryAddressId());
                plotPropertiesIds.add(plotOrderItem.getPlottPropertiesId());
            }
            this.orderAddressDAO.deleteBatch(orderAddressIds);
            this.plotPropertiesDAO.deleteBatch(plotPropertiesIds);
            this.plotOrderItemDAO.deleteBatch(plotOrderItemIds);
            List<PlottOrderItem> siblingPlotOrderItems = this.plotOrderItemDAO.getByOrderContract(plotOrderId);
            if (siblingPlotOrderItems.size() == plotOrderItems.size()) {
                this.deletePlotOrder(plotOrderId);
            }
        }
    }

    public void deletePlotOrder(Long plotOrderId) {
        PlottOrder plotOrder = (PlottOrder)this.plotOrderDAO.get(plotOrderId);
        Long acceptanceOrderStepId = plotOrder.getAcceptanceId();
        Long requestOrderStepId = plotOrder.getRequestId();
        List<ReviewCyclePlottTask> reviewCyclePlotTasks = this.reviewCyclePlotTaskDAO.getByOrderStep(acceptanceOrderStepId);
        ArrayList<Long> reviewCyclePlotTaskIds = new ArrayList<Long>();
        for (ReviewCyclePlottTask reviewCyclePlotTask : reviewCyclePlotTasks) {
            reviewCyclePlotTaskIds.add(reviewCyclePlotTask.getTaskId());
        }
        List<ReviewCyclePlottTaskDone> reviewCyclePlotTasksDone = this.reviewCyclePlotTaskDoneDAO.getByOrderStep(acceptanceOrderStepId);
        ArrayList<Long> reviewCyclePlotTaskDoneIds = new ArrayList<Long>();
        for (ReviewCyclePlottTaskDone reviewCyclePlotTaskDone : reviewCyclePlotTasksDone) {
            reviewCyclePlotTaskDoneIds.add(reviewCyclePlotTaskDone.getTaskId());
        }
        List<PlotOrderAcceptanceTask> plotOrderAcceptanceTasks = this.plotOrderAcceptanceTaskDAO.getByOrder(plotOrderId);
        ArrayList<Long> plotOrderAcceptanceTaskIds = new ArrayList<Long>();
        for (PlotOrderAcceptanceTask plotOrderAcceptanceTask : plotOrderAcceptanceTasks) {
            plotOrderAcceptanceTaskIds.add(plotOrderAcceptanceTask.getTaskId());
        }
        List<PlotOrderAcceptanceTaskDone> plotOrderAcceptanceTasksDone = this.plotOrderAcceptanceTaskDoneDAO.getByOrder(plotOrderId);
        ArrayList<Long> plotOrderAcceptanceTaskDoneIds = new ArrayList<Long>();
        for (PlotOrderAcceptanceTaskDone plotOrderAcceptanceTaskDone : plotOrderAcceptanceTasksDone) {
            plotOrderAcceptanceTaskDoneIds.add(plotOrderAcceptanceTaskDone.getTaskId());
        }
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.addAll(reviewCyclePlotTaskIds);
        taskIds.addAll(reviewCyclePlotTaskDoneIds);
        taskIds.addAll(plotOrderAcceptanceTaskIds);
        taskIds.addAll(plotOrderAcceptanceTaskDoneIds);
        this.reviewCyclePlotTaskDAO.deleteBatch(reviewCyclePlotTaskIds);
        this.reviewCyclePlotTaskDoneDAO.deleteBatch(reviewCyclePlotTaskDoneIds);
        this.plotOrderAcceptanceTaskDAO.deleteBatch(plotOrderAcceptanceTaskIds);
        this.plotOrderAcceptanceTaskDoneDAO.deleteBatch(plotOrderAcceptanceTaskDoneIds);
        this.documentVersionTaskDAO.deleteBatch(taskIds);
        this.taskDAO.deleteBatch(taskIds);
        this.plotOrderDAO.delete(plotOrderId);
        this.orderStepDAO.delete(acceptanceOrderStepId);
        this.orderStepDAO.delete(requestOrderStepId);
    }

    public void deletePlotOrders(Collection<Long> plotOrderIds) {
        ArrayList<Long> plotOrderItemIds = new ArrayList<Long>();
        ArrayList<Long> orderAddressIds = new ArrayList<Long>();
        ArrayList<Long> plotPropertiesIds = new ArrayList<Long>();
        ArrayList<Long> reviewCyclePlotTaskIds = new ArrayList<Long>();
        ArrayList<Long> reviewCyclePlotTaskDoneIds = new ArrayList<Long>();
        ArrayList<Long> plotOrderAcceptanceTaskIds = new ArrayList<Long>();
        ArrayList<Long> plotOrderAcceptanceTaskDoneIds = new ArrayList<Long>();
        ArrayList<Long> orderStepIdsToDelete = new ArrayList<Long>();
        ArrayList<Long> receivedPlotOrderStepsToDelete = new ArrayList<Long>();
        for (Long plotOrderId : plotOrderIds) {
            Object reviewCyclePlotTaskDone2;
            Object plotOrderItem2;
            PlottOrder plotOrder = (PlottOrder)this.plotOrderDAO.get(plotOrderId);
            Long requestOrderStepId = plotOrder.getRequestId();
            Long acceptanceOrderStepId = plotOrder.getAcceptanceId();
            Long completedOrderStepId = plotOrder.getCompletedId();
            orderStepIdsToDelete.add(requestOrderStepId);
            orderStepIdsToDelete.add(acceptanceOrderStepId);
            orderStepIdsToDelete.add(completedOrderStepId);
            List<ReceivedPlottOrderStep> receivedPlotOrderSteps = this.receivedPlotOrderStepDAO.getByOrder(plotOrderId);
            for (ReceivedPlottOrderStep receivedPlottOrderStep : receivedPlotOrderSteps) {
                orderStepIdsToDelete.add(receivedPlottOrderStep.getOrderStepId());
                receivedPlotOrderStepsToDelete.add(receivedPlottOrderStep.getOrderStepId());
            }
            List<PlottOrderItem> plotOrderItems = this.plotOrderItemDAO.getByOrderContract(plotOrderId);
            plotOrderItemIds.addAll(QueryHelper.getPersistentIds(plotOrderItems));
            for (Object plotOrderItem2 : plotOrderItems) {
                orderAddressIds.add(plotOrderItem2.getDeliveryAddressId());
                plotPropertiesIds.add(plotOrderItem2.getPlottPropertiesId());
            }
            List<ReviewCyclePlottTask> list = this.reviewCyclePlotTaskDAO.getByOrderStep(acceptanceOrderStepId);
            list.addAll(this.reviewCyclePlotTaskDAO.getByOrderStep(completedOrderStepId));
            plotOrderItem2 = list.iterator();
            while (plotOrderItem2.hasNext()) {
                ReviewCyclePlottTask reviewCyclePlottTask = (ReviewCyclePlottTask)plotOrderItem2.next();
                reviewCyclePlotTaskIds.add(reviewCyclePlottTask.getTaskId());
            }
            List<ReviewCyclePlottTaskDone> reviewCyclePlotTasksDone = this.reviewCyclePlotTaskDoneDAO.getByOrderStep(acceptanceOrderStepId);
            reviewCyclePlotTasksDone.addAll(this.reviewCyclePlotTaskDoneDAO.getByOrderStep(completedOrderStepId));
            for (Object reviewCyclePlotTaskDone2 : reviewCyclePlotTasksDone) {
                reviewCyclePlotTaskDoneIds.add(reviewCyclePlotTaskDone2.getTaskId());
            }
            List<PlotOrderAcceptanceTask> list2 = this.plotOrderAcceptanceTaskDAO.getByOrder(plotOrderId);
            reviewCyclePlotTaskDone2 = list2.iterator();
            while (reviewCyclePlotTaskDone2.hasNext()) {
                PlotOrderAcceptanceTask plotOrderAcceptanceTask = (PlotOrderAcceptanceTask)reviewCyclePlotTaskDone2.next();
                plotOrderAcceptanceTaskIds.add(plotOrderAcceptanceTask.getTaskId());
            }
            List<PlotOrderAcceptanceTaskDone> plotOrderAcceptanceTasksDone = this.plotOrderAcceptanceTaskDoneDAO.getByOrder(plotOrderId);
            for (PlotOrderAcceptanceTaskDone plotOrderAcceptanceTaskDone : plotOrderAcceptanceTasksDone) {
                plotOrderAcceptanceTaskDoneIds.add(plotOrderAcceptanceTaskDone.getTaskId());
            }
        }
        if (plotOrderItemIds.size() > 0) {
            this.plotOrderItemDAO.deleteBatch(plotOrderItemIds);
        }
        if (plotPropertiesIds.size() > 0) {
            this.plotPropertiesDAO.deleteBatch(plotPropertiesIds);
        }
        if (orderAddressIds.size() > 0) {
            this.orderAddressDAO.deleteBatch(orderAddressIds);
        }
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.addAll(reviewCyclePlotTaskIds);
        taskIds.addAll(reviewCyclePlotTaskDoneIds);
        taskIds.addAll(plotOrderAcceptanceTaskIds);
        taskIds.addAll(plotOrderAcceptanceTaskDoneIds);
        if (reviewCyclePlotTaskIds.size() > 0) {
            this.reviewCyclePlotTaskDAO.deleteBatch(reviewCyclePlotTaskIds);
        }
        if (reviewCyclePlotTaskDoneIds.size() > 0) {
            this.reviewCyclePlotTaskDoneDAO.deleteBatch(reviewCyclePlotTaskDoneIds);
        }
        if (plotOrderAcceptanceTaskIds.size() > 0) {
            this.plotOrderAcceptanceTaskDAO.deleteBatch(plotOrderAcceptanceTaskIds);
        }
        if (plotOrderAcceptanceTaskDoneIds.size() > 0) {
            this.plotOrderAcceptanceTaskDoneDAO.deleteBatch(plotOrderAcceptanceTaskDoneIds);
        }
        if (taskIds.size() > 0) {
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            this.taskDAO.deleteBatch(taskIds);
        }
        for (Long receivedPlotOrderStep : receivedPlotOrderStepsToDelete) {
            this.receivedPlotOrderStepDAO.deleteByOrderStep(receivedPlotOrderStep);
            this.projectParticipationOrderStepDAO.deleteByOrderStep(receivedPlotOrderStep);
        }
        if (plotOrderIds.size() > 0) {
            this.plotOrderDAO.deleteBatch(plotOrderIds);
        }
        if (orderStepIdsToDelete.size() > 0) {
            this.orderStepDAO.deleteBatch(orderStepIdsToDelete);
        }
    }

    public List<PlotOrderDeleteJoin> getPlotOrderDeleteJoinsPreventingSubProjectInvalidate(List<PlotOrderDeleteJoin> allDeleteJoins, boolean checkForProject, Long callingSubProjectId) {
        ArrayList<PlotOrderDeleteJoin> retNonDeletableJoins = new ArrayList<PlotOrderDeleteJoin>();
        Map<Long, List<PlotOrderDeleteJoin>> plotOrderIdToDeleteJoins = PlotHelper.groupDeleteJoinsByPlotOrder(allDeleteJoins);
        for (Long plotOrderId : plotOrderIdToDeleteJoins.keySet()) {
            List<PlotOrderDeleteJoin> currJoins = plotOrderIdToDeleteJoins.get(plotOrderId);
            PlotOrderDeleteJoin someJoin = currJoins.get(0);
            boolean orderIsOpen = someJoin.getPlotOrderAcceptanceId() == null || someJoin.getAcceptanceStepFinished() == null || someJoin.getCompletedStepId() == null || someJoin.getCompletedStepFinished() == null;
            HashSet<Long> affectedSubProjectIds = new HashSet<Long>();
            boolean callingSubProjectIsAffected = false;
            for (PlotOrderDeleteJoin currJoin : currJoins) {
                if (!affectedSubProjectIds.contains(currJoin.getSubProjectId())) {
                    affectedSubProjectIds.add(currJoin.getSubProjectId());
                }
                if (!callingSubProjectId.equals(currJoin.getSubProject().getId())) continue;
                callingSubProjectIsAffected = true;
            }
            boolean otherSubProjectsAffected = affectedSubProjectIds.size() > 1;
            boolean deletable = false;
            if (checkForProject) {
                if (!orderIsOpen) {
                    deletable = true;
                }
            } else if (!callingSubProjectIsAffected || !orderIsOpen && !otherSubProjectsAffected) {
                deletable = true;
            }
            if (deletable) continue;
            retNonDeletableJoins.addAll(currJoins);
        }
        return retNonDeletableJoins;
    }

    public void deletePlotOrdersForSubProjectInvalidate(List<PlotOrderDeleteJoin> allDeleteJoins) {
        HashSet<Long> plotOrderIdsToDelete = new HashSet<Long>();
        Map<Long, List<PlotOrderDeleteJoin>> plotOrderIdToDeleteJoins = PlotHelper.groupDeleteJoinsByPlotOrder(allDeleteJoins);
        for (Long plotOrderId : plotOrderIdToDeleteJoins.keySet()) {
            List<PlotOrderDeleteJoin> currJoins = plotOrderIdToDeleteJoins.get(plotOrderId);
            PlotOrderDeleteJoin someJoin = currJoins.get(0);
            if (someJoin.getAcceptanceStepId() != null && PlotHelper.isDeclined(someJoin.getAcceptanceStepAcceptedMode()) || someJoin.getCompletedStepId() != null && PlotHelper.isDeclined(someJoin.getCompletedStepAcceptedMode()) || someJoin.getAcceptanceStepId() == null || someJoin.getAcceptanceStepFinished() == null || someJoin.getCompletedStepId() == null || someJoin.getCompletedStepFinished() == null) continue;
            plotOrderIdsToDelete.add(someJoin.getPlotOrderId());
        }
        this.deletePlotOrders(plotOrderIdsToDelete);
    }

    private OrderStep signOrderStep(Long orderStepId, ProjectParticipant signer, Certificate certificate, Boolean accepted, String comment, String password) {
        OrderStep orderStep = (OrderStep)this.orderStepDAO.get(orderStepId);
        orderStep.setFinished(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        orderStep.setAcceptedMode(Integer.valueOf(AcceptedMode.getByBoolean((Boolean)accepted).getValue()));
        orderStep.setComment(comment);
        ProjectParticipationOrderStep participationOrderStep = (ProjectParticipationOrderStep)this.projectParticipationOrderStepDAO.get(orderStepId);
        if (participationOrderStep == null) {
            log.warn("Received participationOrderStep == null for orderStepId [" + orderStepId + "], signer [" + (signer != null ? signer.getId() : "null") + "], certificate [" + (certificate != null ? certificate.getId() : "null") + "]");
        }
        if (signer == null) {
            log.warn("Received signer == null for orderStepId [" + orderStepId + "], certificate [" + (certificate != null ? certificate.getId() : "null") + "]");
        }
        participationOrderStep.setSignerId(signer.getId());
        this.projectParticipationOrderStepDAO.update(participationOrderStep);
        String digest = this.orderStepDigester.getParticipationOrderStepHash(orderStep, participationOrderStep);
        orderStep.setDigest(digest);
        orderStep.setDigestCalculatorId(null);
        Signature signature = this.signatureCalculator.createSignature(signer, digest, certificate, password);
        signature = (Signature)this.signatureDAO.save(signature);
        orderStep.setSignatureId(signature.getId());
        this.orderStepDAO.update(orderStep);
        return orderStep;
    }

    public Long acceptPlotOrder(PlotTaskInfo plotTaskInfo, ProjectParticipant signer, Certificate certificate, String password, boolean accepted, String comment) {
        Long taskId = plotTaskInfo.getDocumentVersionTask().getTaskId();
        Long participationId = plotTaskInfo.getDocumentVersionTask().getProjectParticipationId();
        Long plotOrderId = plotTaskInfo.getPlotOrder().getId();
        PlottOrder plotOrder = (PlottOrder)this.plotOrderDAO.get(plotOrderId);
        Long acceptanceStepId = plotOrder.getAcceptanceId();
        this.signOrderStep(acceptanceStepId, signer, certificate, accepted, comment, password);
        if (accepted) {
            this.taskUtils.doReviewCyclePlotTask(taskId, acceptanceStepId);
            OrderStep completedOrderStep = new OrderStep();
            completedOrderStep.setCreated(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            completedOrderStep.setAcceptedMode(Integer.valueOf(0));
            completedOrderStep = (OrderStep)this.orderStepDAO.save(completedOrderStep);
            Long completedOrderStepId = completedOrderStep.getId();
            ProjectParticipationOrderStep participationOrderStep = new ProjectParticipationOrderStep();
            participationOrderStep.setOrderStepId(completedOrderStep.getId());
            participationOrderStep.setProjectParticipationId(participationId);
            this.projectParticipationOrderStepDAO.save(participationOrderStep);
            plotOrder.setCompletedId(completedOrderStepId);
            this.plotOrderDAO.update(plotOrder);
            if (accepted) {
                Long documentVersionId = plotTaskInfo.getDocumentVersionTask().getDocumentVersionId();
                Long projectId = plotTaskInfo.getProject().getId();
                String locale = "de";
                Long localisationId = plotTaskInfo.getProject().getLocalisationId();
                Document document = this.documentDAO.getByDocumentVersion(documentVersionId);
                Long objectPlannerId = document.getObjectPlannerId();
                Long generatedTaskId = this.taskUtils.generateReviewCyclePlotTask(new DebugContext(), documentVersionId, plotOrderId, completedOrderStepId, projectId, locale, localisationId, participationId, objectPlannerId);
                return generatedTaskId;
            }
            return taskId;
        }
        return taskId;
    }

    public void completePlotOrder(PlotTaskInfo plotTaskInfo, Long taskId, String comment, boolean ok, ProjectParticipant signer, Certificate certificate, String password) {
        Long plotOrderId = plotTaskInfo.getPlotOrder().getId();
        PlottOrder plotOrder = (PlottOrder)this.plotOrderDAO.get(plotOrderId);
        Long completedId = plotOrder.getCompletedId();
        if (completedId != null) {
            this.signOrderStep(completedId, signer, certificate, ok, comment, password);
        }
        Long stepId = completedId != null ? completedId : plotOrder.getAcceptanceId();
        BaseTask oldTask = (BaseTask)this.taskDAO.get(taskId);
        DocumentVersionTask oldDocumentVersionTask = (DocumentVersionTask)this.documentVersionTaskDAO.get(taskId);
        ReviewCyclePlottTask oldReviewCyclePlotTask = (ReviewCyclePlottTask)this.reviewCyclePlotTaskDAO.get(taskId);
        this.taskUtils.doReviewCyclePlotTask(taskId, stepId);
        plotOrder.setCompletedId(stepId);
        this.plotOrderDAO.update(plotOrder);
        HashSet<Long> receiverParticipationIds = new HashSet<Long>();
        OrderStep completedStep = (OrderStep)this.orderStepDAO.get(stepId);
        if (completedStep.getAcceptedMode() != null && completedStep.getAcceptedMode().intValue() != AcceptedMode.DECLINED.getValue()) {
            List itemInfos = plotTaskInfo.getItemInfos();
            for (PlotTaskItemInfo itemInfo : itemInfos) {
                PlottOrderItem plotOrderItem = itemInfo.getPlotOrderItem();
                Long plotOrderItemId = plotOrderItem.getId();
                DocumentVersion documentVersion = itemInfo.getDocumentVersion();
                Long receiverId = plotOrderItem.getReceiverId();
                if (receiverId == null || DocumentVersionHelper.isInvalidatedOrDeleted(documentVersion)) continue;
                receiverParticipationIds.add(receiverId);
                OrderStep receiverOrderStep = new OrderStep();
                receiverOrderStep.setCreated(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
                receiverOrderStep.setOrderItemId(plotOrderItemId);
                receiverOrderStep.setAcceptedMode(Integer.valueOf(0));
                receiverOrderStep = (OrderStep)this.orderStepDAO.save(receiverOrderStep);
                Long receiverOrderStepId = receiverOrderStep.getId();
                ProjectParticipationOrderStep participationOrderStep = new ProjectParticipationOrderStep();
                participationOrderStep.setOrderStepId(receiverOrderStep.getId());
                participationOrderStep.setProjectParticipationId(receiverId);
                this.projectParticipationOrderStepDAO.save(participationOrderStep);
                ReceivedPlottOrderStep receivedStep = new ReceivedPlottOrderStep();
                receivedStep.setOrderId(plotOrderId);
                receivedStep.setOrderStepId(receiverOrderStepId);
                this.receivedPlotOrderStepDAO.save(receivedStep);
            }
        }
        if (completedStep.getFinished() != null && completedStep.getAcceptedMode() != null && completedStep.getAcceptedMode().intValue() == AcceptedMode.ACCEPTED.getValue()) {
            this.taskUtils.generatePlotOrderAcceptanceTasks(oldTask, oldDocumentVersionTask, oldReviewCyclePlotTask, receiverParticipationIds);
        }
    }

    public void closePlotOrder(PlotTaskInfo plotTaskInfo, Long taskId, String comment, boolean ok, ProjectParticipant signer, Certificate certificate, String password) {
        Long plotOrderId = plotTaskInfo.getPlotOrder().getId();
        PlottOrder plotOrder = (PlottOrder)this.plotOrderDAO.get(plotOrderId);
        Long completedId = plotOrder.getCompletedId();
        if (completedId != null) {
            this.signOrderStep(completedId, signer, certificate, ok, comment, password);
        }
        Long stepId = completedId != null ? completedId : plotOrder.getAcceptanceId();
        plotOrder.setCompletedId(stepId);
        this.plotOrderDAO.update(plotOrder);
    }

    public void receivePlotOrder(Long organisationPersonId, PlotTaskInfo plotTaskInfo, String comment, String password, boolean ok, Set<Long> selectedPlotOrderItemIds) {
        List itemInfos = plotTaskInfo.getItemInfos();
        HashMap<Long, PlotTaskItemInfo> itemIdToItemInfo = new HashMap<Long, PlotTaskItemInfo>();
        for (PlotTaskItemInfo itemInfo : itemInfos) {
            itemIdToItemInfo.put(itemInfo.getPlotOrderItem().getId(), itemInfo);
        }
        Long plotOrderId = plotTaskInfo.getPlotOrder().getId();
        List<OrderStep> receiverSteps = this.orderStepDAO.getReceiverOrderSteps(plotOrderId);
        HashMap<Long, OrderStep> itemIdToReceiverStep = new HashMap<Long, OrderStep>();
        for (OrderStep receiverStep : receiverSteps) {
            if (itemIdToReceiverStep.containsKey(receiverStep.getOrderItemId())) {
                throw new RuntimeException("Entry for orderItemId [" + receiverStep.getOrderItemId() + "] is not unique.  Please inspect.");
            }
            if (receiverStep.getOrderItemId() == null) continue;
            itemIdToReceiverStep.put(receiverStep.getOrderItemId(), receiverStep);
        }
        HashSet<Long> selectedParticipationIds = new HashSet<Long>();
        ArrayList<Long> ppIdList = new ArrayList<Long>();
        for (Long selectedPlotOrderItemId : selectedPlotOrderItemIds) {
            OrderStep step = (OrderStep)itemIdToReceiverStep.get(selectedPlotOrderItemId);
            if (step == null) continue;
            step.setComment(comment);
            step.setAcceptedMode(Integer.valueOf(AcceptedMode.getByBoolean((Boolean)ok).getValue()));
            PlottOrderItem plotOrderItem = ((PlotTaskItemInfo)itemIdToItemInfo.get(selectedPlotOrderItemId)).getPlotOrderItem();
            Long receiverId = plotOrderItem.getReceiverId();
            selectedParticipationIds.add(receiverId);
            if (!ppIdList.contains(receiverId)) {
                ppIdList.add(receiverId);
            }
            ProjectParticipant signer = this.projectParticipantDAO.getByParticipationAndOrganisationPerson(receiverId, organisationPersonId);
            Certificate certificate = this.certificateDAO.getSignerCertificate(organisationPersonId);
            if (certificate == null) {
                throw new RuntimeException("Did not find signerCertificate for organisationPersonId [" + organisationPersonId + "]; based on participation [" + receiverId + "] and signer [" + signer.getId() + "]");
            }
            step = this.signOrderStep(step.getId(), signer, certificate, ok, comment, password);
        }
        List<DocumentVersionTask> tasksToMarkDone = this.documentVersionTaskDAO.getPlotOrderAcceptanceTasks(plotOrderId, ppIdList);
        for (DocumentVersionTask plotOrderAcceptanceTask : tasksToMarkDone) {
            Long tasksPPId = plotOrderAcceptanceTask.getProjectParticipationId();
            receiverSteps = this.orderStepDAO.getReceiverOrderSteps(plotOrderId);
            boolean allStepsSigned = true;
            for (OrderStep receiverStep : receiverSteps) {
                PlotTaskItemInfo plotTaskItemInfo = (PlotTaskItemInfo)itemIdToItemInfo.get(receiverStep.getOrderItemId());
                if (plotTaskItemInfo == null || !plotTaskItemInfo.getPlotOrderItem().getReceiverId().equals(tasksPPId) || receiverStep.getSignatureId() != null) continue;
                allStepsSigned = false;
                break;
            }
            if (!allStepsSigned) continue;
            this.taskUtils.doPlotOrderAcceptanceTask(plotOrderAcceptanceTask.getTaskId());
        }
    }
}

