/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import at.cdes.api.dto.Persistent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class ContainerHelper {
    public static List<Long> getPersistentIdsList(List<? extends Persistent> persistents) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Persistent persistent : persistents) {
            ids.add(persistent.getId());
        }
        return ids;
    }

    public static Set<Long> getPersistentIdsSet(List<? extends Persistent> persistents) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Persistent persistent : persistents) {
            ids.add(persistent.getId());
        }
        return ids;
    }

    public static <T> void registerChildInstance(Long parentId, Long childId, T child, Map<Long, List<T>> parentIdToChildren) {
        if (parentId != null && childId != null) {
            ContainerHelper.registerChildInstanceInner(parentId, child, parentIdToChildren);
        }
    }

    public static <T> void registerChildInstanceInner(Long parentId, T child, Map<Long, List<T>> parentIdToChildren) {
        if (!parentIdToChildren.containsKey(parentId)) {
            parentIdToChildren.put(parentId, new ArrayList());
        }
        parentIdToChildren.get(parentId).add(child);
    }

    public static <T extends Persistent> Set<Long> getIdsFromMultiMap(Map<Long, List<T>> multiMap) {
        HashSet<Long> retValue = new HashSet<Long>();
        for (List<T> persistents : multiMap.values()) {
            for (Persistent persistent : persistents) {
                retValue.add(persistent.getId());
            }
        }
        return retValue;
    }

    public static <T extends Persistent> List<Long> getIdsFromMultiMapAsList(Map<Long, List<T>> multiMap) {
        Set<Long> idsSet = ContainerHelper.getIdsFromMultiMap(multiMap);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.addAll(idsSet);
        return ids;
    }

    public static <T extends Persistent> Map<Long, T> groupById(List<T> persistents) {
        HashMap<Long, Persistent> idToPersistent = new HashMap<Long, Persistent>();
        for (Persistent persistent : persistents) {
            idToPersistent.put(persistent.getId(), persistent);
        }
        return idToPersistent;
    }

    public static <T extends Persistent> Map<Long, T> groupByIdIgnoreWithout(List<T> persistents) {
        HashMap<Long, Persistent> idToPersistent = new HashMap<Long, Persistent>();
        for (Persistent persistent : persistents) {
            if (persistent.getId() == null) continue;
            idToPersistent.put(persistent.getId(), persistent);
        }
        return idToPersistent;
    }

    public static <K, V> Set<K> getDeletedKeys(Map<K, V> referenceMap, Map<K, V> newMap) {
        HashSet<K> disappearedKeys = new HashSet<K>();
        for (K k : referenceMap.keySet()) {
            if (newMap.containsKey(k)) continue;
            disappearedKeys.add(k);
        }
        return disappearedKeys;
    }

    public static <K> Set<K> getDeletedKeys(Set<K> referenceSet, Set<K> newSet) {
        HashSet<K> disappearedKeys = new HashSet<K>();
        for (K k : referenceSet) {
            if (newSet.contains(k)) continue;
            disappearedKeys.add(k);
        }
        return disappearedKeys;
    }

    public static <K, V> Set<K> getNewKeys(Map<K, V> referenceMap, Map<K, V> newMap) {
        HashSet<K> additionalKeys = new HashSet<K>();
        for (K k : newMap.keySet()) {
            if (referenceMap.containsKey(k)) continue;
            additionalKeys.add(k);
        }
        return additionalKeys;
    }

    public static <K, V> Set<K> getNewKeys(Set<K> referenceSet, Set<K> newSet) {
        HashSet<K> additionalKeys = new HashSet<K>();
        for (K k : newSet) {
            if (referenceSet.contains(k)) continue;
            additionalKeys.add(k);
        }
        return additionalKeys;
    }

    public static <K, V> List<V> getAllValues(Map<K, List<V>> keyToValues) {
        ArrayList<V> retList = new ArrayList<V>();
        for (K key : keyToValues.keySet()) {
            List<V> values = keyToValues.get(key);
            if (values == null) continue;
            retList.addAll(values);
        }
        return retList;
    }

    public static <V> List<String> getLongAttributesCompareStrings(List<V> values) {
        return ContainerHelper.getLongAttributesCompareStrings(values, null);
    }

    public static <V> List<String> getLongAttributesCompareStrings(List<V> values, Integer maxCount) {
        Field[] attributes;
        ArrayList<String> retStrings = new ArrayList<String>();
        if (values.size() == 0) {
            retStrings.add("Passed values-list was empty.");
        }
        Class<?> clazz = values.get(0).getClass();
        for (Field attribute : attributes = clazz.getDeclaredFields()) {
            attribute.setAccessible(true);
            if (attribute.getType() != Long.class) continue;
            String lineString = "[" + attribute.getName() + "]: ";
            for (int n = 0; n < values.size() && (maxCount == null || n < maxCount); ++n) {
                Object v;
                V value = values.get(n);
                try {
                    v = attribute.get(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                String objString = "v" + n + " = [";
                String valueString = v != null ? objString + v.toString() + "]; " : objString + "null]; ";
                lineString = lineString + valueString;
            }
            retStrings.add(lineString);
        }
        return retStrings;
    }

    public static <V> void logLongAttributeCompareStrings(Logger log, List<V> values) {
        List<String> strings = ContainerHelper.getLongAttributesCompareStrings(values);
        for (String s : strings) {
            log.info(s);
        }
    }

    public static <V> void logLongAttributeCompareStrings(Logger log, List<V> values, Integer maxCount) {
        List<String> strings = ContainerHelper.getLongAttributesCompareStrings(values, maxCount);
        for (String s : strings) {
            log.info(s);
        }
    }
}

