/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.imp;

import at.cdes.api.compositeDto.PlanningNotificationOrderImportLine;
import at.cdes.api.dto.PlanningNotification;
import at.cdes.api.dto.PlanningNotificationOrder;
import at.cdes.api.dto.StatutoryDuty;
import at.cdes.api.dto.SubjectArea;
import at.cdes.api.guiService.PlanningNotificationService;
import at.cdes.impl.dao.PlanningNotificationDAO;
import at.cdes.impl.dao.PlanningNotificationOrderDAO;
import at.cdes.impl.dao.StatutoryDutyDAO;
import at.cdes.impl.dao.SubjectAreaDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sched.cache.IScratchBucket;
import org.clazzes.util.sched.cache.IScratchFileCache;
import org.clazzes.util.sched.cache.ScratchFile;

public class PlanningNotificationOrderImporter {
    private static final String SEPARATOR = ";";
    private static final String TIMEZONE = "Europe/Vienna";
    private PlanningNotificationDAO planningNotificationDAO;
    private PlanningNotificationOrderDAO planningNotificationOrderDAO;
    private PlanningNotificationService planningNotificationService;
    private IScratchFileCache scratchFileCache;
    private StatutoryDutyDAO statutoryDutyDAO;
    private SubjectAreaDAO subjectAreaDAO;

    public void setPlanningNotificationDAO(PlanningNotificationDAO planningNotificationDAO) {
        this.planningNotificationDAO = planningNotificationDAO;
    }

    public void setPlanningNotificationOrderDAO(PlanningNotificationOrderDAO planningNotificationOrderDAO) {
        this.planningNotificationOrderDAO = planningNotificationOrderDAO;
    }

    public void setPlanningNotificationService(PlanningNotificationService planningNotificationService) {
        this.planningNotificationService = planningNotificationService;
    }

    public void setScratchFileCache(IScratchFileCache scratchFileCache) {
        this.scratchFileCache = scratchFileCache;
    }

    public void setStatutoryDutyDAO(StatutoryDutyDAO statutoryDutyDAO) {
        this.statutoryDutyDAO = statutoryDutyDAO;
    }

    public void setSubjectAreaDAO(SubjectAreaDAO subjectAreaDAO) {
        this.subjectAreaDAO = subjectAreaDAO;
    }

    public List<Pair<PlanningNotificationOrder, Boolean>> getPlanningNotificationOrdersToImport(List<PlanningNotificationOrderImportLine> importLinesToFill, Long organisationPersonId, Long planningNotificationId, String tempFileName) {
        int n;
        ArrayList<Pair<PlanningNotificationOrder, Boolean>> planningNotificationOrders = new ArrayList<Pair<PlanningNotificationOrder, Boolean>>();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        PlanningNotification planningNotification = (PlanningNotification)this.planningNotificationDAO.get(planningNotificationId);
        if (planningNotification == null) {
            throw new RuntimeException("PlanningNotification with id [" + planningNotificationId + "] could not be found.");
        }
        Long networkId = planningNotification.getNetworkId();
        List<StatutoryDuty> statutoryDuties = this.statutoryDutyDAO.getByNetwork(networkId);
        HashMap<String, StatutoryDuty> nameToStatutoryDuty = new HashMap<String, StatutoryDuty>();
        for (StatutoryDuty statutoryDuty : statutoryDuties) {
            nameToStatutoryDuty.put(statutoryDuty.getName(), statutoryDuty);
        }
        List<SubjectArea> subjectAreas = this.subjectAreaDAO.getByNetwork(networkId);
        HashMap<String, SubjectArea> nameToSubjectArea = new HashMap<String, SubjectArea>();
        for (SubjectArea subjectArea : subjectAreas) {
            nameToSubjectArea.put(subjectArea.getName(), subjectArea);
        }
        ArrayList lines = new ArrayList();
        try (IScratchBucket bucket = this.scratchFileCache.getBucket(tempFileName);){
            ScratchFile scratchFile = bucket.getScratchFile();
            File file = scratchFile.getFile();
            CSVParser parser = CSVParser.parse((File)file, (Charset)Charset.forName("CP1252"), (CSVFormat)CSVFormat.EXCEL.withDelimiter(';'));
            List csvRecords = parser.getRecords();
            for (CSVRecord csvRecord : csvRecords) {
                ArrayList<String> tokens = new ArrayList<String>();
                for (int n2 = 0; n2 < csvRecord.size(); ++n2) {
                    tokens.add(csvRecord.get(n2));
                }
                lines.add(tokens);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (lines.size() == 0) {
            importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)1, (String)resourceBundle.getString("planningNotificationOrderImportNoHeaderError")));
            return planningNotificationOrders;
        }
        int textIndex = -1;
        int positionIndex = -1;
        int authorizedIndex = -1;
        int statutoryDutyIndex = -1;
        int commentIndex = -1;
        int pageIndex = -1;
        int sourceIndex = -1;
        int subjectAreaIndex = -1;
        int invalidatedIndex = -1;
        int submitAuthorityIndex = -1;
        List headerTokens = (List)lines.get(0);
        for (n = 0; n < headerTokens.size(); ++n) {
            String headerToken = ((String)headerTokens.get(n)).trim();
            if ("$TEXT".equals(headerToken)) {
                textIndex = n;
                continue;
            }
            if ("$POSITION".equals(headerToken)) {
                positionIndex = n;
                continue;
            }
            if ("$AUTHORIZED".equals(headerToken)) {
                authorizedIndex = n;
                continue;
            }
            if ("$STATUTORY".equals(headerToken)) {
                statutoryDutyIndex = n;
                continue;
            }
            if ("$COMMENT".equals(headerToken)) {
                commentIndex = n;
                continue;
            }
            if ("$PAGE".equals(headerToken)) {
                pageIndex = n;
                continue;
            }
            if ("$SOURCE".equals(headerToken)) {
                sourceIndex = n;
                continue;
            }
            if ("$SUBJECT_AREA".equals(headerToken)) {
                subjectAreaIndex = n;
                continue;
            }
            if ("$INVALIDATED".equals(headerToken)) {
                invalidatedIndex = n;
                continue;
            }
            if ("$SUBMIT_AUTHORITY".equals(headerToken)) {
                submitAuthorityIndex = n;
                continue;
            }
            String message = MessageFormat.format(resourceBundle.getString("planningNotificationOrderImportIllegalHeaderToken"), headerToken);
            importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)1, (String)message));
            return planningNotificationOrders;
        }
        if (textIndex == -1) {
            String message = resourceBundle.getString("planningNotificationOrderTextMissing");
            importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)1, (String)message));
            return planningNotificationOrders;
        }
        for (n = 1; n < lines.size(); ++n) {
            boolean submitAuthorityBool;
            String message;
            boolean invalidatedBool;
            String message2;
            String submitAuthority;
            PlanningNotificationOrderImportLine importLine = new PlanningNotificationOrderImportLine();
            List lineTokens = (List)lines.get(n);
            String text = textIndex != -1 && textIndex < lineTokens.size() ? (String)lineTokens.get(textIndex) : null;
            String position = positionIndex != -1 && positionIndex < lineTokens.size() ? (String)lineTokens.get(positionIndex) : null;
            String authorizedInspector = authorizedIndex != -1 && authorizedIndex < lineTokens.size() ? (String)lineTokens.get(authorizedIndex) : null;
            String statutoryDutyName = statutoryDutyIndex != -1 && statutoryDutyIndex < lineTokens.size() ? (String)lineTokens.get(statutoryDutyIndex) : null;
            String comment = commentIndex != -1 && commentIndex < lineTokens.size() ? (String)lineTokens.get(commentIndex) : null;
            String page = pageIndex != -1 && pageIndex < lineTokens.size() ? (String)lineTokens.get(pageIndex) : null;
            String source = sourceIndex != -1 && sourceIndex < lineTokens.size() ? (String)lineTokens.get(sourceIndex) : null;
            String subjectAreaName = subjectAreaIndex != -1 && subjectAreaIndex < lineTokens.size() ? (String)lineTokens.get(subjectAreaIndex) : null;
            String invalidated = invalidatedIndex != -1 && invalidatedIndex < lineTokens.size() ? (String)lineTokens.get(invalidatedIndex) : null;
            String string = submitAuthority = submitAuthorityIndex != -1 && submitAuthorityIndex < lineTokens.size() ? (String)lineTokens.get(submitAuthorityIndex) : null;
            if (textIndex != -1 && text == null || positionIndex != -1 && position == null || authorizedIndex != -1 && authorizedInspector == null || statutoryDutyIndex != -1 && statutoryDutyName == null || commentIndex != -1 && comment == null) {
                message2 = MessageFormat.format(resourceBundle.getString("planningNotificationOrderLineTooShort"), n);
                importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)n, (String)message2));
                return planningNotificationOrders;
            }
            if (text == null || text.trim().length() == 0) {
                message2 = MessageFormat.format(resourceBundle.getString("planningNotificationOrderTextCellMissing"), n);
                importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)n, (String)message2));
                return planningNotificationOrders;
            }
            Long statutoryDutyId = null;
            if (statutoryDutyName != null && statutoryDutyName.trim().length() > 0) {
                StatutoryDuty statutoryDuty;
                StatutoryDuty statutoryDuty2 = statutoryDuty = statutoryDutyName != null ? (StatutoryDuty)nameToStatutoryDuty.get(statutoryDutyName) : null;
                if (statutoryDuty == null) {
                    String message3 = MessageFormat.format(resourceBundle.getString("planningNotificationOrderImportIllegalStatutoryDuty"), n, statutoryDutyName);
                    importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)n, (String)message3));
                    return planningNotificationOrders;
                }
                statutoryDutyId = statutoryDuty.getId();
            }
            Long subjectAreaId = null;
            if (subjectAreaName != null && subjectAreaName.trim().length() > 0) {
                SubjectArea subjectArea;
                SubjectArea subjectArea2 = subjectArea = subjectAreaName != null ? (SubjectArea)nameToSubjectArea.get(subjectAreaName) : null;
                if (subjectArea == null) {
                    String message4 = MessageFormat.format(resourceBundle.getString("planningNotificationOrderImportIllegalSubjectArea"), n, subjectAreaName);
                    importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)n, (String)message4));
                    return planningNotificationOrders;
                }
                subjectAreaId = subjectArea.getId();
            }
            if ("Nein".equals(invalidated) || "nein".equals(invalidated) || "0".equals(invalidated) || "falsch".equals(invalidated) || "false".equals(invalidated)) {
                invalidatedBool = false;
            } else if ("Ja".equals(invalidated) || "ja".equals(invalidated) || "1".equals(invalidated) || "wahr".equals(invalidated) || "true".equals(invalidated)) {
                invalidatedBool = true;
            } else {
                message = MessageFormat.format(resourceBundle.getString("planningNotificationOrderImportIllegalInvalidated"), n);
                importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)n, (String)message));
                return planningNotificationOrders;
            }
            if ("Nein".equals(submitAuthority) || "nein".equals(submitAuthority) || "0".equals(submitAuthority) || "falsch".equals(submitAuthority) || "false".equals(submitAuthority)) {
                submitAuthorityBool = false;
            } else if ("Ja".equals(submitAuthority) || "ja".equals(submitAuthority) || "1".equals(submitAuthority) || "wahr".equals(submitAuthority) || "true".equals(submitAuthority)) {
                submitAuthorityBool = true;
            } else {
                message = MessageFormat.format(resourceBundle.getString("planningNotificationOrderImportIllegalSubmitAuthority"), n);
                importLinesToFill.add(PlanningNotificationOrderImportLine.constructError((Integer)n, (String)message));
                return planningNotificationOrders;
            }
            PlanningNotificationOrder planningNotificationOrder = new PlanningNotificationOrder();
            planningNotificationOrder.setText(text);
            planningNotificationOrder.setDocumentPosition(position);
            planningNotificationOrder.setAuthorizedInspector(authorizedInspector);
            planningNotificationOrder.setStatutoryDutyId(statutoryDutyId);
            planningNotificationOrder.setComment(comment);
            planningNotificationOrder.setPlanningNotificationId(planningNotificationId);
            planningNotificationOrder.setDocumentPage(page);
            planningNotificationOrder.setSource(source);
            planningNotificationOrder.setSubjectAreaId(subjectAreaId);
            planningNotificationOrder.setSubmitAuthority(Boolean.valueOf(submitAuthorityBool));
            planningNotificationOrders.add((Pair<PlanningNotificationOrder, Boolean>)new Pair((Object)planningNotificationOrder, (Object)invalidatedBool));
        }
        return planningNotificationOrders;
    }

    public List<PlanningNotificationOrderImportLine> doImport(Long organisationPersonId, Long planningNotificationId, String tempFileName) {
        ArrayList<PlanningNotificationOrderImportLine> importLines = new ArrayList<PlanningNotificationOrderImportLine>();
        List<Pair<PlanningNotificationOrder, Boolean>> planningNotificationOrderPairs = this.getPlanningNotificationOrdersToImport(importLines, organisationPersonId, planningNotificationId, tempFileName);
        if (importLines.size() > 0) {
            return importLines;
        }
        for (int n = 0; n < planningNotificationOrderPairs.size(); ++n) {
            Pair<PlanningNotificationOrder, Boolean> planningNotificationOrderPair = planningNotificationOrderPairs.get(n);
            PlanningNotificationOrder planningNotificationOrder = (PlanningNotificationOrder)planningNotificationOrderPair.getFirst();
            boolean invalidated = (Boolean)planningNotificationOrderPair.getSecond();
            Long workflowEntityId = this.planningNotificationService.saveOrUpdatePlanningNotificationOrder(organisationPersonId, planningNotificationOrder, invalidated, new ArrayList(), new ArrayList(), new ArrayList());
            PlanningNotificationOrder orderAfterSave = (PlanningNotificationOrder)this.planningNotificationOrderDAO.get(workflowEntityId);
            Long serialNumber = orderAfterSave.getSerialNumber();
            PlanningNotificationOrderImportLine importLine = new PlanningNotificationOrderImportLine();
            importLine.setError(Boolean.valueOf(false));
            importLine.setLineNumber(Integer.valueOf(n));
            importLine.setMessage(null);
            importLine.setWorkflowEntityId(workflowEntityId);
            importLine.setSerialNumber(serialNumber);
            importLines.add(importLine);
        }
        return importLines;
    }
}

