/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.SubProjectType;
import at.cdes.impl.dao.GenSubProjectTypeDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcSubProjectTypeDAO
extends AbstrIdDAO<SubProjectType>
implements GenSubProjectTypeDAO {
    public AbstractJdbcSubProjectTypeDAO() {
        super(SubProjectType.class, "id", "sub_project_type", new String[]{"id", "network_id", "code", "name", "comment", "master_data_set_id", "is_as_built_type"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcSubProjectTypeDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "is_as_built_type") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcSubProjectTypeDAO.getSelectClauseForDto("sub_project_type", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcSubProjectTypeDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + "," + entityLocalName + ".master_data_set_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + "," + entityLocalName + ".is_as_built_type" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "is_as_built_type") + " ";
    }

    protected SubProjectType fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        SubProjectType subProjectType = new SubProjectType();
        subProjectType.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subProjectType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subProjectType.setCode(rs.getString(++columnIndex));
        subProjectType.setName(rs.getString(++columnIndex));
        subProjectType.setComment(rs.getString(++columnIndex));
        subProjectType.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        subProjectType.setIsAsBuiltType(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return subProjectType;
    }

    public static SubProjectType fillSubProjectTypeFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        SubProjectType subProjectType = new SubProjectType();
        subProjectType.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subProjectType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subProjectType.setCode(rs.getString(columnIndex.incrementAndGet()));
        subProjectType.setName(rs.getString(columnIndex.incrementAndGet()));
        subProjectType.setComment(rs.getString(columnIndex.incrementAndGet()));
        subProjectType.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        subProjectType.setIsAsBuiltType(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return subProjectType;
    }

    public static SubProjectType fillSubProjectTypeFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcSubProjectTypeDAO.fillSubProjectTypeFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 7;
    }

    @Override
    public void deleteByNetworkId(final Long networkId) {
        String sql = "DELETE FROM sub_project_type WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(SubProjectType dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<SubProjectType> dtos) {
        Iterator<SubProjectType> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, SubProjectType subProjectType) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectType.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)subProjectType.getNetworkId());
        statement.setString(3, subProjectType.getCode());
        statement.setString(4, subProjectType.getName());
        statement.setString(5, subProjectType.getComment());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)subProjectType.getMasterDataSetId());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)7, (Boolean)subProjectType.getIsAsBuiltType());
    }

    @Override
    public List<SubProjectType> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<SubProjectType> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<SubProjectType> getByMasterDataSet(MasterDataSet masterDataSet) {
        return this.getByMasterDataSet(masterDataSet.getId());
    }

    @Override
    public List<SubProjectType> getByMasterDataSet(final Long masterDataSetId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, masterDataSetId);
            }
        });
    }

    @Override
    public List<SubProjectType> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<SubProjectType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<SubProjectType> getByMasterDataSets(Collection<Long> masterDataSetId) {
        if (masterDataSetId.isEmpty()) {
            return new ArrayList<SubProjectType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[masterDataSetId.size()];
        int n = 0;
        Iterator<Long> it = masterDataSetId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

