/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.searchModel.PlanningNotificationOrderSearchModel;
import at.cdes.api.dto.searchModel.PlanningNotificationSearchModel;
import at.cdes.api.joinDto.PlanningNotificationOrderExtraJoin;
import at.cdes.api.joinDto.PlanningNotificationOrderJoin;
import at.cdes.api.joinDto.PlanningNotificationOrderProjectJoin;
import at.cdes.api.joinDto.PlanningNotificationReportJoin;
import at.cdes.api.joinDto.PlanningNotificationTaskJoin;
import at.cdes.api.planning.compositeDto.PlanningNotificationTaskSearchModel;
import at.cdes.api.planning.voc.DueDateRemarkOption;
import at.cdes.api.planning.voc.PlanningNotificationTaskSearchMode;
import at.cdes.impl.dao.PlanningNotificationOrderDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcPlanningNotificationOrderDAO;
import at.cdes.impl.dao.jdbc.JdbcPlanningNotificationDAO;
import at.cdes.impl.dao.unionComponent.PlanningNotificationOrderExtraComponent;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPlanningNotificationOrderDAO
extends AbstractJdbcPlanningNotificationOrderDAO
implements PlanningNotificationOrderDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcPlanningNotificationOrderDAO.class);

    private StringBuffer getPlanningNotificationOrderJoinSelectFromClause() {
        StringBuffer sql = new StringBuffer("SELECT " + JdbcPlanningNotificationOrderDAO.getPlanningNotificationOrderJoinSelectClause() + "FROM ((((((planning_notification_order LEFT JOIN planning_notification                       ON planning_notification_order.planning_notification_id = planning_notification.id) LEFT JOIN person_in_charge                            ON planning_notification_order.person_in_charge_id = person_in_charge.id) LEFT JOIN subject_area                                ON planning_notification_order.subject_area_id = subject_area.id) LEFT JOIN statutory_duty                              ON planning_notification_order.statutory_duty_id = statutory_duty.id) LEFT JOIN workflow_entity                             ON planning_notification_order.workflow_entity_id = workflow_entity.id) LEFT JOIN workflow_entity_status                      ON workflow_entity.workflow_entity_status_id = workflow_entity_status.id) WHERE 1=1 ");
        return sql;
    }

    @Override
    public List<PlanningNotificationOrderJoin> getPlanningNotificationOrderJoins(PlanningNotificationOrderSearchModel searchModel) {
        final Collection ids = searchModel.getIds();
        final Long networkId = searchModel.getNetworkId();
        final Long serialNumber = searchModel.getSerialNumber();
        final Long projectId = searchModel.getProjectId();
        final Long planningNotificationId = searchModel.getPlanningNotificationId();
        final List planningNotificationIds = searchModel.getPlanningNotificationIds();
        final Long subjectAreaId = searchModel.getSubjectAreaId();
        final String subjectAreaName = searchModel.getSubjectAreaName();
        final Boolean invalidated = searchModel.getInvalidated();
        final Long stateId = searchModel.getState();
        final List planningNotificationTitles = searchModel.getPlanningNotificationTitles();
        String referenceString = searchModel.getReference();
        Boolean environmentallyRelevant = searchModel.getEnvironmentallyRelevant();
        final Long statutoryDutyId = searchModel.getStatutoryDutyId();
        final Boolean allStatutoryDuties = searchModel.getAllStatutoryDuties();
        final String text = searchModel.getText();
        final String orderBaulos = searchModel.getBaulos();
        final String authorizedInspector = searchModel.getAuthorizedInspector();
        final Long statutoryDutyFromFrom = searchModel.getStatutoryDutyFromFrom();
        final Long statutoryDutyFromTo = searchModel.getStatutoryDutyFromTo();
        final Long statutoryDutyToFrom = searchModel.getStatutoryDutyToFrom();
        final Long statutoryDutyToTo = searchModel.getStatutoryDutyToTo();
        final Integer statutoryDutyInterval = searchModel.getStatutoryDutyInterval();
        final Integer statutoryDutyLeadTime = searchModel.getStatutoryDutyLeadTime();
        Boolean statutoryDutyExpired = searchModel.getStatutoryDutyExpired();
        final String documentPage = searchModel.getDocumentPage();
        final String documentPosition = searchModel.getDocumentPosition();
        final String source = searchModel.getSource();
        final Long personInChargeId = searchModel.getPersonInChargeId();
        String tagString = searchModel.getTags();
        final Boolean submitAuthority = searchModel.getSubmitAuthority();
        final String comment = searchModel.getComment();
        final List<Long> referenceIds = JdbcPlanningNotificationOrderDAO.getReferenceIdsFromReferenceString(referenceString);
        final List<String> tags = JdbcPlanningNotificationOrderDAO.getTagsFromTagString(tagString);
        StringBuffer sql = this.getPlanningNotificationOrderJoinSelectFromClause();
        JdbcPlanningNotificationOrderDAO.appendNetworkClause(sql, networkId);
        JdbcPlanningNotificationOrderDAO.appendWorkflowEntityClause(sql, ids);
        JdbcPlanningNotificationOrderDAO.appendSerialNumberClause(sql, serialNumber);
        JdbcPlanningNotificationOrderDAO.appendProjectClause(sql, projectId);
        JdbcPlanningNotificationOrderDAO.appendPlanningNotificationIdClause(sql, planningNotificationId);
        JdbcPlanningNotificationDAO.appendPlanningNotificationIdsClause(sql, planningNotificationIds, planningNotificationTitles);
        JdbcPlanningNotificationOrderDAO.appendSubjectAreaClause(sql, subjectAreaId, subjectAreaName);
        JdbcPlanningNotificationOrderDAO.appendInvalidatedClause(sql, invalidated);
        JdbcPlanningNotificationOrderDAO.appendStateClause(sql, stateId);
        JdbcPlanningNotificationOrderDAO.appendReferenceClause(sql, referenceIds);
        JdbcPlanningNotificationOrderDAO.appendEnvironmentallyRelevantClause(sql, environmentallyRelevant);
        if (allStatutoryDuties != null && allStatutoryDuties.booleanValue()) {
            JdbcPlanningNotificationOrderDAO.appendAllStatutoryDutiesClause(sql);
        } else {
            JdbcPlanningNotificationOrderDAO.appendStatutoryDutyClause(sql, statutoryDutyId);
        }
        JdbcPlanningNotificationOrderDAO.appendTextClause(sql, text);
        JdbcPlanningNotificationOrderDAO.appendOrderBaulosClause(sql, orderBaulos);
        JdbcPlanningNotificationOrderDAO.appendAuthorizedInspectorClause(sql, authorizedInspector);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyFromFromClause(sql, statutoryDutyFromFrom);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyFromToClause(sql, statutoryDutyFromTo);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyToFromClause(sql, statutoryDutyToFrom);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyToToClause(sql, statutoryDutyToTo);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyIntervalClause(sql, statutoryDutyInterval);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyLeadTimeClause(sql, statutoryDutyLeadTime);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyExpiredClause(sql, statutoryDutyExpired);
        JdbcPlanningNotificationOrderDAO.appendDocumentPageClause(sql, documentPage);
        JdbcPlanningNotificationOrderDAO.appendDocumentPositionClause(sql, documentPosition);
        JdbcPlanningNotificationOrderDAO.appendSourceClause(sql, source);
        JdbcPlanningNotificationOrderDAO.appendPersonInChargeClause(sql, personInChargeId);
        JdbcPlanningNotificationOrderDAO.appendTagsClause(sql, tags);
        JdbcPlanningNotificationOrderDAO.appendSubmitAuthorityClause(sql, submitAuthority);
        JdbcPlanningNotificationOrderDAO.appendOrderCommentClause(sql, comment);
        long beforeMillis = System.currentTimeMillis();
        List planningNotificationOrderJoins = (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationOrderJoin>>(){

            public List<PlanningNotificationOrderJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = JdbcPlanningNotificationOrderDAO.setNetworkIdOnStatement(statement, currIndex, networkId);
                currIndex = JdbcPlanningNotificationOrderDAO.setOrderIdsOnStatement(statement, currIndex, ids);
                currIndex = JdbcPlanningNotificationOrderDAO.setSerialNumberOnStatement(statement, currIndex, serialNumber);
                currIndex = JdbcPlanningNotificationOrderDAO.setProjectIdOnStatement(statement, currIndex, projectId);
                currIndex = JdbcPlanningNotificationOrderDAO.setPlanningNotificationIdOnStatement(statement, currIndex, planningNotificationId);
                currIndex = JdbcPlanningNotificationDAO.setPlanningNotificationIdsOnStatement(statement, currIndex, planningNotificationIds, planningNotificationTitles);
                currIndex = JdbcPlanningNotificationOrderDAO.setSubjectAreaOnStatement(statement, currIndex, subjectAreaId, subjectAreaName);
                currIndex = JdbcPlanningNotificationOrderDAO.setInvalidatedOnStatement(statement, currIndex, invalidated);
                currIndex = JdbcPlanningNotificationOrderDAO.setStateOnStatement(statement, currIndex, stateId);
                currIndex = JdbcPlanningNotificationOrderDAO.setReferenceIdsOnStatement(statement, currIndex, referenceIds);
                if (allStatutoryDuties == null || !allStatutoryDuties.booleanValue()) {
                    currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyIdOnStatement(statement, currIndex, statutoryDutyId);
                }
                currIndex = JdbcPlanningNotificationOrderDAO.setTextOnStatement(statement, currIndex, text);
                currIndex = JdbcPlanningNotificationOrderDAO.setOrderBaulosOnStatement(statement, currIndex, orderBaulos);
                currIndex = JdbcPlanningNotificationOrderDAO.setAuthorizedInspectorOnStatement(statement, currIndex, authorizedInspector);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyFromFromOnStatement(statement, currIndex, statutoryDutyFromFrom);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyFromToOnStatement(statement, currIndex, statutoryDutyFromTo);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyToFromOnStatement(statement, currIndex, statutoryDutyToFrom);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyToToOnStatement(statement, currIndex, statutoryDutyToTo);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyIntervalOnStatement(statement, currIndex, statutoryDutyInterval);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyLeadTimeOnStatement(statement, currIndex, statutoryDutyLeadTime);
                currIndex = JdbcPlanningNotificationOrderDAO.setDocumentPageOnStatement(statement, currIndex, documentPage);
                currIndex = JdbcPlanningNotificationOrderDAO.setDocumentPositionOnStatement(statement, currIndex, documentPosition);
                currIndex = JdbcPlanningNotificationOrderDAO.setSourceOnStatement(statement, currIndex, source);
                currIndex = JdbcPlanningNotificationOrderDAO.setPersonInChargeIdOnStatement(statement, currIndex, personInChargeId);
                currIndex = JdbcPlanningNotificationOrderDAO.setTagsOnStatement(statement, currIndex, tags);
                currIndex = JdbcPlanningNotificationOrderDAO.setSubmitAuthorityOnStatement(statement, currIndex, submitAuthority);
                currIndex = JdbcPlanningNotificationOrderDAO.setOrderCommentOnStatement(statement, currIndex, comment);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanningNotificationOrderJoin> ret = new ArrayList<PlanningNotificationOrderJoin>();
                while (rs.next()) {
                    PlanningNotificationOrderJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationOrderJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        long afterMillis = System.currentTimeMillis();
        double seconds = ((double)afterMillis - (double)beforeMillis) / 1000.0;
        if (log.isDebugEnabled()) {
            log.debug("Query for planning notifications completed in [" + seconds + "s], retrieved [" + planningNotificationOrderJoins.size() + "] rows.");
        }
        return planningNotificationOrderJoins;
    }

    @Override
    public List<PlanningNotificationOrderJoin> getPlanningNotificationOrderJoins(final List<Long> workflowEntityIds) {
        if (workflowEntityIds.size() == 0) {
            return new ArrayList<PlanningNotificationOrderJoin>();
        }
        StringBuffer sql = this.getPlanningNotificationOrderJoinSelectFromClause();
        sql.append("AND planning_notification_order.workflow_entity_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") ");
        List planningNotificationOrderJoins = (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationOrderJoin>>(){

            public List<PlanningNotificationOrderJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long workflowEntityId : workflowEntityIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)workflowEntityId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanningNotificationOrderJoin> ret = new ArrayList<PlanningNotificationOrderJoin>();
                while (rs.next()) {
                    PlanningNotificationOrderJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationOrderJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        return planningNotificationOrderJoins;
    }

    @Override
    public List<PlanningNotificationOrderJoin> getOrderJoinsByPlanningNotificationIds(final List<Long> planningNotificationIds) {
        if (planningNotificationIds.size() == 0) {
            return new ArrayList<PlanningNotificationOrderJoin>();
        }
        StringBuffer sql = this.getPlanningNotificationOrderJoinSelectFromClause();
        sql.append("AND planning_notification.id IN (" + QueryHelper.getPlaceHolderSequence(planningNotificationIds.size()) + ") ");
        List planningNotificationOrderJoins = (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationOrderJoin>>(){

            public List<PlanningNotificationOrderJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long planningNotificationId : planningNotificationIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)planningNotificationId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanningNotificationOrderJoin> ret = new ArrayList<PlanningNotificationOrderJoin>();
                while (rs.next()) {
                    PlanningNotificationOrderJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationOrderJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        return planningNotificationOrderJoins;
    }

    @Override
    public List<PlanningNotificationReportJoin> getPlanningNotificationReportJoins(PlanningNotificationSearchModel notificationSearchModel, PlanningNotificationOrderSearchModel orderSearchModel) {
        final Long notificationId = notificationSearchModel.getId();
        final Collection planningNotificationIds = notificationSearchModel.getPlanningNotificationIds();
        final List planningNotificationTitles = notificationSearchModel.getPlanningNotificationTitles();
        final String notificationComment = notificationSearchModel.getComment();
        final Long networkId = notificationSearchModel.getNetworkId();
        final Long projectId = notificationSearchModel.getProjectId();
        final Map textMetaTagIdToValue = notificationSearchModel.getTextMetaTagIdToValue() != null ? notificationSearchModel.getTextMetaTagIdToValue() : new HashMap();
        final Map dateMetaTagIdToFrom = notificationSearchModel.getDateMetaTagIdToFrom() != null ? notificationSearchModel.getDateMetaTagIdToFrom() : new HashMap();
        final Map dateMetaTagIdToTo = notificationSearchModel.getDateMetaTagIdToTo() != null ? notificationSearchModel.getDateMetaTagIdToTo() : new HashMap();
        final Set<Long> dateMetaTagIds = JdbcPlanningNotificationDAO.getDateMetaTagIds(dateMetaTagIdToFrom, dateMetaTagIdToTo);
        final Collection orderIds = orderSearchModel.getIds();
        final Long serialNumber = orderSearchModel.getSerialNumber();
        final Long subjectAreaId = orderSearchModel.getSubjectAreaId();
        final String subjectAreaName = orderSearchModel.getSubjectAreaName();
        final Boolean invalidated = orderSearchModel.getInvalidated();
        final Long stateId = orderSearchModel.getState();
        String referenceString = orderSearchModel.getReference();
        final Boolean environmentallyRelevant = orderSearchModel.getEnvironmentallyRelevant();
        final Long statutoryDutyId = orderSearchModel.getStatutoryDutyId();
        final Boolean allStatutoryDuties = orderSearchModel.getAllStatutoryDuties();
        final String text = orderSearchModel.getText();
        final String authorizedInspector = orderSearchModel.getAuthorizedInspector();
        final Long statutoryDutyFromFrom = orderSearchModel.getStatutoryDutyFromFrom();
        final Long statutoryDutyFromTo = orderSearchModel.getStatutoryDutyFromTo();
        final Long statutoryDutyToFrom = orderSearchModel.getStatutoryDutyToFrom();
        final Long statutoryDutyToTo = orderSearchModel.getStatutoryDutyToTo();
        final Integer statutoryDutyInterval = orderSearchModel.getStatutoryDutyInterval();
        final Integer statutoryDutyLeadTime = orderSearchModel.getStatutoryDutyLeadTime();
        final Boolean statutoryDutyExpired = orderSearchModel.getStatutoryDutyExpired();
        final String documentPage = orderSearchModel.getDocumentPage();
        final String documentPosition = orderSearchModel.getDocumentPosition();
        final String source = orderSearchModel.getSource();
        final Long personInChargeId = orderSearchModel.getPersonInChargeId();
        String tagString = orderSearchModel.getTags();
        final Boolean submitAuthority = orderSearchModel.getSubmitAuthority();
        final String orderComment = orderSearchModel.getComment();
        final String orderBaulos = orderSearchModel.getBaulos();
        final Long dueDateFrom = orderSearchModel.getDueDateFrom();
        final Long dueDateTo = orderSearchModel.getDueDateTo();
        final String dueDateRemark = orderSearchModel.getDueDateRemark();
        final List participationIds = orderSearchModel.getOrganisationPersonIds();
        final List<Long> referenceIds = JdbcPlanningNotificationOrderDAO.getReferenceIdsFromReferenceString(referenceString);
        final List<String> tags = JdbcPlanningNotificationOrderDAO.getTagsFromTagString(tagString);
        StringBuffer sql = new StringBuffer("SELECT " + JdbcPlanningNotificationOrderDAO.getPlanningNotificationReportJoinSelectClause() + "FROM (((((((((((((   planning_notification_order LEFT JOIN person_in_charge                            ON planning_notification_order.person_in_charge_id = person_in_charge.id) LEFT JOIN subject_area                                ON planning_notification_order.subject_area_id = subject_area.id) LEFT JOIN statutory_duty                              ON planning_notification_order.statutory_duty_id = statutory_duty.id) LEFT JOIN workflow_entity                             ON planning_notification_order.workflow_entity_id = workflow_entity.id) LEFT JOIN workflow_entity_status                      ON workflow_entity.workflow_entity_status_id = workflow_entity_status.id) LEFT JOIN planning_notification                       ON planning_notification_order.planning_notification_id = planning_notification.id) LEFT JOIN planning_notification_project_map           ON planning_notification_project_map.planning_notification_id = planning_notification.id) LEFT JOIN project                                     ON planning_notification_project_map.project_id = project.id) LEFT JOIN planning_notification_meta_information      ON planning_notification_meta_information.planning_notification_id = planning_notification.id) LEFT JOIN meta_information                            ON planning_notification_meta_information.meta_information_id = meta_information.id) LEFT JOIN meta_tag                                    ON meta_information.meta_tag_id = meta_tag.id) LEFT JOIN planning_notification_text_meta_information ON planning_notification_text_meta_information.meta_information_id = planning_notification_meta_information.meta_information_id) LEFT JOIN planning_notification_date_meta_information ON planning_notification_date_meta_information.meta_information_id = planning_notification_meta_information.meta_information_id) WHERE 1=1 ");
        JdbcPlanningNotificationDAO.appendPlanningNotificationIdClause(sql, notificationId);
        JdbcPlanningNotificationDAO.appendPlanningNotificationIdsClause(sql, planningNotificationIds, planningNotificationTitles);
        JdbcPlanningNotificationDAO.appendNotificationCommentClause(sql, notificationComment);
        JdbcPlanningNotificationDAO.appendNetworkClause(sql, networkId);
        JdbcPlanningNotificationDAO.appendProjectClause(sql, projectId);
        JdbcPlanningNotificationDAO.appendTextMetaTagClause(sql, textMetaTagIdToValue);
        JdbcPlanningNotificationDAO.appendDateMetaTagClause(sql, dateMetaTagIds, dateMetaTagIdToFrom, dateMetaTagIdToTo);
        JdbcPlanningNotificationOrderDAO.appendWorkflowEntityClause(sql, orderIds);
        JdbcPlanningNotificationOrderDAO.appendSerialNumberClause(sql, serialNumber);
        JdbcPlanningNotificationOrderDAO.appendSubjectAreaClause(sql, subjectAreaId, subjectAreaName);
        JdbcPlanningNotificationOrderDAO.appendInvalidatedClause(sql, invalidated);
        JdbcPlanningNotificationOrderDAO.appendStateClause(sql, stateId);
        JdbcPlanningNotificationOrderDAO.appendReferenceClause(sql, referenceIds);
        JdbcPlanningNotificationOrderDAO.appendEnvironmentallyRelevantClause(sql, environmentallyRelevant);
        if (allStatutoryDuties != null && allStatutoryDuties.booleanValue()) {
            JdbcPlanningNotificationOrderDAO.appendAllStatutoryDutiesClause(sql);
        } else {
            JdbcPlanningNotificationOrderDAO.appendStatutoryDutyClause(sql, statutoryDutyId);
        }
        JdbcPlanningNotificationOrderDAO.appendTextClause(sql, text);
        JdbcPlanningNotificationOrderDAO.appendAuthorizedInspectorClause(sql, authorizedInspector);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyFromFromClause(sql, statutoryDutyFromFrom);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyFromToClause(sql, statutoryDutyFromTo);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyToFromClause(sql, statutoryDutyToFrom);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyToToClause(sql, statutoryDutyToTo);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyIntervalClause(sql, statutoryDutyInterval);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyLeadTimeClause(sql, statutoryDutyLeadTime);
        JdbcPlanningNotificationOrderDAO.appendStatutoryDutyExpiredClause(sql, statutoryDutyExpired);
        JdbcPlanningNotificationOrderDAO.appendDocumentPageClause(sql, documentPage);
        JdbcPlanningNotificationOrderDAO.appendDocumentPositionClause(sql, documentPosition);
        JdbcPlanningNotificationOrderDAO.appendSourceClause(sql, source);
        JdbcPlanningNotificationOrderDAO.appendPersonInChargeClause(sql, personInChargeId);
        JdbcPlanningNotificationOrderDAO.appendTagsClause(sql, tags);
        JdbcPlanningNotificationOrderDAO.appendSubmitAuthorityClause(sql, submitAuthority);
        JdbcPlanningNotificationOrderDAO.appendOrderCommentClause(sql, orderComment);
        JdbcPlanningNotificationOrderDAO.appendOrderBaulosClause(sql, orderBaulos);
        JdbcPlanningNotificationOrderDAO.appendDueDateClause(sql, dueDateFrom, dueDateTo);
        JdbcPlanningNotificationOrderDAO.appendDueDateRemarkClause(sql, dueDateRemark);
        JdbcPlanningNotificationOrderDAO.appendWorkflowNodePositionParticipationClause(sql, participationIds);
        long beforeMillis = System.currentTimeMillis();
        List planningNotificationReportJoins = (List)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationReportJoin>>(){

            public List<PlanningNotificationReportJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = JdbcPlanningNotificationDAO.setNotificationIdOnStatement(statement, currIndex, notificationId);
                currIndex = JdbcPlanningNotificationDAO.setPlanningNotificationIdsOnStatement(statement, currIndex, planningNotificationIds, planningNotificationTitles);
                currIndex = JdbcPlanningNotificationDAO.setNotificationCommentOnStatement(statement, currIndex, notificationComment);
                currIndex = JdbcPlanningNotificationDAO.setNetworkOnStatement(statement, currIndex, networkId);
                currIndex = JdbcPlanningNotificationDAO.setProjectOnStatement(statement, currIndex, projectId);
                currIndex = JdbcPlanningNotificationDAO.setTextMetaTagsOnStatement(statement, currIndex, textMetaTagIdToValue);
                currIndex = JdbcPlanningNotificationDAO.setDateMetaTagsOnStatement(statement, currIndex, dateMetaTagIds, dateMetaTagIdToFrom, dateMetaTagIdToTo);
                currIndex = JdbcPlanningNotificationOrderDAO.setOrderIdsOnStatement(statement, currIndex, orderIds);
                currIndex = JdbcPlanningNotificationOrderDAO.setSerialNumberOnStatement(statement, currIndex, serialNumber);
                currIndex = JdbcPlanningNotificationOrderDAO.setSubjectAreaOnStatement(statement, currIndex, subjectAreaId, subjectAreaName);
                currIndex = JdbcPlanningNotificationOrderDAO.setInvalidatedOnStatement(statement, currIndex, invalidated);
                currIndex = JdbcPlanningNotificationOrderDAO.setStateOnStatement(statement, currIndex, stateId);
                currIndex = JdbcPlanningNotificationOrderDAO.setReferenceIdsOnStatement(statement, currIndex, referenceIds);
                currIndex = JdbcPlanningNotificationOrderDAO.setEnvironmentallyRelevantOnStatement(statement, currIndex, environmentallyRelevant);
                if (allStatutoryDuties == null || !allStatutoryDuties.booleanValue()) {
                    currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyIdOnStatement(statement, currIndex, statutoryDutyId);
                }
                currIndex = JdbcPlanningNotificationOrderDAO.setTextOnStatement(statement, currIndex, text);
                currIndex = JdbcPlanningNotificationOrderDAO.setAuthorizedInspectorOnStatement(statement, currIndex, authorizedInspector);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyFromFromOnStatement(statement, currIndex, statutoryDutyFromFrom);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyFromToOnStatement(statement, currIndex, statutoryDutyFromTo);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyToFromOnStatement(statement, currIndex, statutoryDutyToFrom);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyToToOnStatement(statement, currIndex, statutoryDutyToTo);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyIntervalOnStatement(statement, currIndex, statutoryDutyInterval);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyLeadTimeOnStatement(statement, currIndex, statutoryDutyLeadTime);
                currIndex = JdbcPlanningNotificationOrderDAO.setStatutoryDutyExpiredOnStatement(statement, currIndex, statutoryDutyExpired);
                currIndex = JdbcPlanningNotificationOrderDAO.setDocumentPageOnStatement(statement, currIndex, documentPage);
                currIndex = JdbcPlanningNotificationOrderDAO.setDocumentPositionOnStatement(statement, currIndex, documentPosition);
                currIndex = JdbcPlanningNotificationOrderDAO.setSourceOnStatement(statement, currIndex, source);
                currIndex = JdbcPlanningNotificationOrderDAO.setPersonInChargeIdOnStatement(statement, currIndex, personInChargeId);
                currIndex = JdbcPlanningNotificationOrderDAO.setTagsOnStatement(statement, currIndex, tags);
                currIndex = JdbcPlanningNotificationOrderDAO.setSubmitAuthorityOnStatement(statement, currIndex, submitAuthority);
                currIndex = JdbcPlanningNotificationOrderDAO.setOrderCommentOnStatement(statement, currIndex, orderComment);
                currIndex = JdbcPlanningNotificationOrderDAO.setOrderBaulosOnStatement(statement, currIndex, orderBaulos);
                currIndex = JdbcPlanningNotificationOrderDAO.setDueDateFromOnStatement(statement, currIndex, dueDateFrom);
                currIndex = JdbcPlanningNotificationOrderDAO.setDueDateToOnStatement(statement, currIndex, dueDateTo);
                currIndex = JdbcPlanningNotificationOrderDAO.setDueDateRemarkOnStatement(statement, currIndex, dueDateRemark);
                currIndex = JdbcPlanningNotificationOrderDAO.setPositionParticipationOnStatement(statement, currIndex, participationIds);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanningNotificationReportJoin> ret = new ArrayList<PlanningNotificationReportJoin>();
                while (rs.next()) {
                    PlanningNotificationReportJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationReportJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        long afterMillis = System.currentTimeMillis();
        double seconds = ((double)afterMillis - (double)beforeMillis) / 1000.0;
        if (log.isDebugEnabled()) {
            log.debug("Query for planning notifications completed in [" + seconds + "s], retrieved [" + planningNotificationReportJoins.size() + "] rows.");
        }
        return planningNotificationReportJoins;
    }

    private static void appendNetworkClause(StringBuffer sql, Long networkId) {
        if (networkId != null) {
            sql.append("AND planning_notification.network_id = ? ");
        }
    }

    private static void appendWorkflowEntityClause(StringBuffer sql, Collection<Long> ids) {
        if (ids != null && ids.size() > 0) {
            sql.append("AND planning_notification_order.workflow_entity_id IN (" + QueryHelper.getPlaceHolderSequence(ids.size()) + ") ");
        }
    }

    private static void appendSerialNumberClause(StringBuffer sql, Long serialNumber) {
        if (serialNumber != null) {
            sql.append("AND planning_notification_order.serial_number = ? ");
        }
    }

    private static void appendProjectClause(StringBuffer sql, Long projectId) {
        if (projectId != null) {
            sql.append("AND EXISTS (SELECT 1 FROM planning_notification_project_map WHERE planning_notification_project_map.planning_notification_id = planning_notification.id AND planning_notification_project_map.project_id = ?) ");
        }
    }

    private static void appendPlanningNotificationIdClause(StringBuffer sql, Long planningNotificationId) {
        if (planningNotificationId != null) {
            sql.append("AND planning_notification.id = ? ");
        }
    }

    private static void appendPlanningNotificationIdsClause(StringBuffer sql, List<Long> planningNotificationIds) {
        if (planningNotificationIds != null) {
            for (Long planningNotificationId : planningNotificationIds) {
                JdbcPlanningNotificationOrderDAO.appendPlanningNotificationIdClause(sql, planningNotificationId);
            }
        }
    }

    private static void appendSubjectAreaClause(StringBuffer sql, Long subjectAreaId, String subjectAreaName) {
        if (subjectAreaId != null) {
            sql.append("AND subject_area.id = ? ");
        }
        if (SearchHelper.isStringFilled(subjectAreaName)) {
            sql.append("AND subject_area.name LIKE ? ");
        }
    }

    private static void appendInvalidatedClause(StringBuffer sql, Boolean invalidated) {
        if (invalidated != null) {
            if (invalidated.booleanValue()) {
                sql.append("AND workflow_entity.invalidated = 1 ");
            } else {
                sql.append("AND (workflow_entity.invalidated IS NULL OR workflow_entity.invalidated = 0) ");
            }
        }
    }

    private static void appendStateClause(StringBuffer sql, Long stateId) {
        if (stateId != null) {
            if (stateId == -1L) {
                sql.append("AND workflow_entity_status.id IS NULL ");
            } else {
                sql.append("AND workflow_entity_status.id = ? ");
            }
        }
    }

    private static void appendPlanningNotificationTitlesClause(StringBuffer sql, List<String> planningNotificationTitles) {
        if (planningNotificationTitles != null && planningNotificationTitles.size() > 0) {
            sql.append("AND (");
            for (int n = 0; n < planningNotificationTitles.size(); ++n) {
                if (n > 0) {
                    sql.append("OR ");
                }
                sql.append("planning_notification.title LIKE ? ");
            }
            sql.append(")");
        }
    }

    private static void appendReferenceClause(StringBuffer sql, List<Long> referenceIds) {
        for (int n = 0; n < referenceIds.size(); ++n) {
            sql.append("AND EXISTS (SELECT 1 FROM (       planning_notification_order_map JOIN planning_notification_order dest_planning_notification_order ON planning_notification_order_map.destination_id = dest_planning_notification_order.workflow_entity_id) WHERE planning_notification_order_map.source_id = planning_notification_order.workflow_entity_id AND dest_planning_notification_order.serial_number = ?) ");
        }
    }

    private static void appendEnvironmentallyRelevantClause(StringBuffer sql, Boolean environmentallyRelevant) {
        if (environmentallyRelevant != null) {
            if (environmentallyRelevant.booleanValue()) {
                sql.append("AND planning_notification_order.environmentally_relevant = 1 ");
            } else {
                sql.append("AND (planning_notification_order.environmentally_relevant IS NULL OR planning_notification_order.environmentally_relevant = 0) ");
            }
        }
    }

    private static void appendStatutoryDutyClause(StringBuffer sql, Long statutoryDutyId) {
        if (statutoryDutyId != null) {
            sql.append("AND statutory_duty.id = ? ");
        }
    }

    private static void appendAllStatutoryDutiesClause(StringBuffer sql) {
        sql.append("AND statutory_duty.is_statutory_duty = 1 ");
    }

    private static void appendTextClause(StringBuffer sql, String text) {
        if (SearchHelper.isStringFilled(text)) {
            sql.append("AND planning_notification_order.text LIKE ? ");
        }
    }

    private static void appendAuthorizedInspectorClause(StringBuffer sql, String authorizedInspector) {
        if (SearchHelper.isStringFilled(authorizedInspector)) {
            sql.append("AND planning_notification_order.authorized_inspector LIKE ? ");
        }
    }

    private static void appendStatutoryDutyFromFromClause(StringBuffer sql, Long statutoryDutyFromFrom) {
        if (statutoryDutyFromFrom != null) {
            sql.append("AND planning_notification_order.statutory_duty_from >= ? ");
        }
    }

    private static void appendStatutoryDutyFromToClause(StringBuffer sql, Long statutoryDutyFromTo) {
        if (statutoryDutyFromTo != null) {
            sql.append("AND planning_notification_order.statutory_duty_from <= ? ");
        }
    }

    private static void appendStatutoryDutyToFromClause(StringBuffer sql, Long statutoryDutyToFrom) {
        if (statutoryDutyToFrom != null) {
            sql.append("AND planning_notification_order.statutory_duty_to >= ? ");
        }
    }

    private static void appendStatutoryDutyToToClause(StringBuffer sql, Long statutoryDutyToTo) {
        if (statutoryDutyToTo != null) {
            sql.append("AND planning_notification_order.statutory_duty_to <= ? ");
        }
    }

    private static void appendStatutoryDutyIntervalClause(StringBuffer sql, Integer statutoryDutyInterval) {
        if (statutoryDutyInterval != null) {
            sql.append("AND planning_notification_order.statutory_duty_interval = ? ");
        }
    }

    private static void appendStatutoryDutyLeadTimeClause(StringBuffer sql, Integer statutoryDutyLeadTime) {
        if (statutoryDutyLeadTime != null) {
            sql.append("AND planning_notification_order.statutory_duty_lead_time = ? ");
        }
    }

    private static void appendStatutoryDutyExpiredClause(StringBuffer sql, Boolean statutoryDutyExpired) {
        if (statutoryDutyExpired != null) {
            if (statutoryDutyExpired.booleanValue()) {
                sql.append("AND planning_notification_order.statutory_duty_expired = 1 ");
            } else {
                sql.append("AND (planning_notification_order.statutory_duty_expired IS NULL OR planning_notification_order.statutory_duty_expired = 0) ");
            }
        }
    }

    private static void appendDocumentPageClause(StringBuffer sql, String documentPage) {
        if (SearchHelper.isStringFilled(documentPage)) {
            sql.append("AND planning_notification_order.document_page LIKE ? ");
        }
    }

    private static void appendDocumentPositionClause(StringBuffer sql, String documentPosition) {
        if (SearchHelper.isStringFilled(documentPosition)) {
            sql.append("AND planning_notification_order.document_position LIKE ? ");
        }
    }

    private static void appendSourceClause(StringBuffer sql, String source) {
        if (SearchHelper.isStringFilled(source)) {
            sql.append("AND planning_notification_order.source LIKE ? ");
        }
    }

    private static void appendPersonInChargeClause(StringBuffer sql, Long personInChargeId) {
        if (personInChargeId != null) {
            sql.append("AND person_in_charge.id = ? ");
        }
    }

    private static void appendTagsClause(StringBuffer sql, List<String> tags) {
        for (int n = 0; n < tags.size(); ++n) {
            sql.append("AND EXISTS (SELECT 1 FROM (      planning_notification_order_tag_map JOIN planning_notification_order_tag        ON planning_notification_order_tag_map.planning_notification_order_tag_id = planning_notification_order_tag.id) WHERE planning_notification_order_tag_map.planning_notification_order_id = planning_notification_order.workflow_entity_id AND planning_notification_order_tag.label LIKE ?) ");
        }
    }

    private static void appendSubmitAuthorityClause(StringBuffer sql, Boolean submitAuthority) {
        if (submitAuthority != null) {
            if (submitAuthority.booleanValue()) {
                sql.append("AND planning_notification_order.submit_authority = 1 ");
            } else {
                sql.append("AND (planning_notification_order.submit_authority IS NULL OR planning_notification_order.submit_authority = 0) ");
            }
        }
    }

    private static void appendOrderCommentClause(StringBuffer sql, String comment) {
        if (SearchHelper.isStringFilled(comment)) {
            sql.append("AND planning_notification_order.comment LIKE ? ");
        }
    }

    private static void appendOrderBaulosClause(StringBuffer sql, String baulos) {
        if (SearchHelper.isStringFilled(baulos)) {
            List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(baulos);
            sql.append(" AND EXISTS (SELECT 1 FROM ((((( workflow_node  JOIN workflow_node_position ON workflow_node_position.workflow_node_id = workflow_node.id) JOIN workflow_node_position_meta_information_map map ON map.workflow_node_position_id = workflow_node_position.id) JOIN meta_information                  ON map.meta_information_id = meta_information.id) JOIN meta_tag                          ON meta_information.meta_tag_id = meta_tag.id) JOIN planning_notification_text_meta_information ON planning_notification_text_meta_information.meta_information_id = meta_information.id) WHERE workflow_node.workflow_id = workflow_entity.workflow_id  AND meta_tag.name = 'Baulos' AND (0=1 ");
            for (int n = 0; n < searchedNames.size(); ++n) {
                sql.append("OR planning_notification_text_meta_information.value LIKE ? ");
            }
            sql.append(")) ");
        }
    }

    private static void appendDueDateClause(StringBuffer sql, Long dueDateFrom, Long dueDateTo) {
        if (dueDateFrom != null || dueDateTo != null) {
            sql.append("AND EXISTS (SELECT 1 FROM  (workflow_node LEFT JOIN workflow_node_position ON workflow_node_position.workflow_node_id = workflow_node.id) WHERE workflow_node.workflow_id = workflow_entity.workflow_id ");
            if (dueDateFrom != null) {
                sql.append("AND (workflow_node_position.optional_due_date >= ? OR (workflow_node_position.optional_due_date IS NULL AND workflow_node_position.due_date >= ?)) ");
            }
            if (dueDateTo != null) {
                sql.append("AND (workflow_node_position.optional_due_date <= ? OR (workflow_node_position.optional_due_date IS NULL AND workflow_node_position.due_date <= ?)) ");
            }
            sql.append(")");
        }
    }

    private static void appendDueDateRemarkClause(StringBuffer sql, String dueDateRemark) {
        if (dueDateRemark != null) {
            sql.append("AND EXISTS (SELECT 1 FROM  (            workflow_node LEFT JOIN workflow_node_position ON workflow_node_position.workflow_node_id = workflow_node.id) WHERE workflow_node.workflow_id = workflow_entity.workflow_id AND workflow_node_position.due_date_remark = ?) ");
        }
    }

    private static void appendWorkflowNodePositionParticipationClause(StringBuffer sql, List<Long> organisationPersonIds) {
        if (organisationPersonIds != null && organisationPersonIds.size() > 0) {
            sql.append("AND EXISTS (SELECT 1 FROM  (((          workflow_node LEFT JOIN workflow_node_position ON workflow_node_position.workflow_node_id = workflow_node.id) LEFT JOIN project_participation  ON workflow_node_position.project_participation_id = project_participation.id) LEFT JOIN project_participant    ON project_participant.participation_id = project_participation.id) WHERE workflow_node.workflow_id = workflow_entity.workflow_id AND (");
            for (int n = 0; n < organisationPersonIds.size(); ++n) {
                if (n > 0) {
                    sql.append("OR ");
                }
                sql.append("project_participant.organisation_person_id = ? ");
            }
            sql.append(")) ");
        }
    }

    private static List<Long> getReferenceIdsFromReferenceString(String referenceString) {
        if (SearchHelper.isStringFilled(referenceString)) {
            String[] referenceArray;
            ArrayList<Long> referenceIds = new ArrayList<Long>();
            for (String reference : referenceArray = referenceString.split(",")) {
                String trimmedReference = reference.trim();
                if (trimmedReference.length() <= 0) continue;
                try {
                    Long referenceLong = Long.parseLong(trimmedReference);
                    referenceIds.add(referenceLong);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return referenceIds;
        }
        return new ArrayList<Long>();
    }

    private static List<String> getTagsFromTagString(String tagString) {
        if (SearchHelper.isStringFilled(tagString)) {
            String[] tagArray;
            ArrayList<String> tags = new ArrayList<String>();
            for (String tag : tagArray = tagString.split(",")) {
                String trimmedTag = tag.trim();
                if (trimmedTag.length() <= 0) continue;
                tags.add(trimmedTag);
            }
            return tags;
        }
        return new ArrayList<String>();
    }

    private static int setNetworkIdOnStatement(PreparedStatement statement, int currIndex, Long networkId) throws SQLException {
        if (networkId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        }
        return currIndex;
    }

    private static int setOrderIdsOnStatement(PreparedStatement statement, int currIndex, Collection<Long> ids) throws SQLException {
        if (ids != null && ids.size() > 0) {
            for (Long id : ids) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)id);
            }
        }
        return currIndex;
    }

    private static int setSerialNumberOnStatement(PreparedStatement statement, int currIndex, Long serialNumber) throws SQLException {
        if (serialNumber != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)serialNumber);
        }
        return currIndex;
    }

    private static int setProjectIdOnStatement(PreparedStatement statement, int currIndex, Long projectId) throws SQLException {
        if (projectId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        }
        return currIndex;
    }

    private static int setPlanningNotificationIdOnStatement(PreparedStatement statement, int currIndex, Long planningNotificationId) throws SQLException {
        if (planningNotificationId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)planningNotificationId);
        }
        return currIndex;
    }

    private static int setPlanningNotificationIdsOnStatement(PreparedStatement statement, int currIndex, Collection<Long> planningNotificationIds) throws SQLException {
        if (planningNotificationIds != null) {
            for (Long planningNotificationId : planningNotificationIds) {
                currIndex = JdbcPlanningNotificationOrderDAO.setPlanningNotificationIdOnStatement(statement, currIndex, planningNotificationId);
            }
        }
        return currIndex;
    }

    private static int setSubjectAreaOnStatement(PreparedStatement statement, int currIndex, Long subjectAreaId, String subjectAreaName) throws SQLException {
        if (subjectAreaId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subjectAreaId);
        }
        if (SearchHelper.isStringFilled(subjectAreaName)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(subjectAreaName));
        }
        return currIndex;
    }

    private static int setInvalidatedOnStatement(PreparedStatement statement, int currIndex, Boolean invalidated) throws SQLException {
        if (invalidated != null) {
            // empty if block
        }
        return currIndex;
    }

    private static int setStateOnStatement(PreparedStatement statement, int currIndex, Long stateId) throws SQLException {
        if (stateId != null && stateId != -1L) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)stateId);
        }
        return currIndex;
    }

    private static int setTitlesOnStatement(PreparedStatement statement, int currIndex, List<String> planningNotificationTitles) throws SQLException {
        if (planningNotificationTitles != null) {
            for (String planningNotificationTitle : planningNotificationTitles) {
                statement.setString(currIndex++, SearchHelper.convertForSearch(planningNotificationTitle));
            }
        }
        return currIndex;
    }

    private static int setReferenceIdsOnStatement(PreparedStatement statement, int currIndex, List<Long> referenceIds) throws SQLException {
        for (Long referenceId : referenceIds) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)referenceId);
        }
        return currIndex;
    }

    private static int setEnvironmentallyRelevantOnStatement(PreparedStatement statement, int currIndex, Boolean environmentallyRelevant) {
        return currIndex;
    }

    private static int setStatutoryDutyIdOnStatement(PreparedStatement statement, int currIndex, Long statutoryDutyId) throws SQLException {
        if (statutoryDutyId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)statutoryDutyId);
        }
        return currIndex;
    }

    private static int setTextOnStatement(PreparedStatement statement, int currIndex, String text) throws SQLException {
        if (SearchHelper.isStringFilled(text)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(text));
        }
        return currIndex;
    }

    private static int setAuthorizedInspectorOnStatement(PreparedStatement statement, int currIndex, String authorizedInspector) throws SQLException {
        if (SearchHelper.isStringFilled(authorizedInspector)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(authorizedInspector));
        }
        return currIndex;
    }

    private static int setStatutoryDutyFromFromOnStatement(PreparedStatement statement, int currIndex, Long statutoryDutyFromFrom) throws SQLException {
        if (statutoryDutyFromFrom != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)statutoryDutyFromFrom);
        }
        return currIndex;
    }

    private static int setStatutoryDutyFromToOnStatement(PreparedStatement statement, int currIndex, Long statutoryDutyFromTo) throws SQLException {
        if (statutoryDutyFromTo != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)statutoryDutyFromTo);
        }
        return currIndex;
    }

    private static int setStatutoryDutyToFromOnStatement(PreparedStatement statement, int currIndex, Long statutoryDutyToFrom) throws SQLException {
        if (statutoryDutyToFrom != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)statutoryDutyToFrom);
        }
        return currIndex;
    }

    private static int setStatutoryDutyToToOnStatement(PreparedStatement statement, int currIndex, Long statutoryDutyToTo) throws SQLException {
        if (statutoryDutyToTo != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)statutoryDutyToTo);
        }
        return currIndex;
    }

    private static int setStatutoryDutyIntervalOnStatement(PreparedStatement statement, int currIndex, Integer statutoryDutyInterval) throws SQLException {
        if (statutoryDutyInterval != null) {
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)statutoryDutyInterval);
        }
        return currIndex;
    }

    private static int setStatutoryDutyLeadTimeOnStatement(PreparedStatement statement, int currIndex, Integer statutoryDutyLeadTime) throws SQLException {
        if (statutoryDutyLeadTime != null) {
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)statutoryDutyLeadTime);
        }
        return currIndex;
    }

    private static int setStatutoryDutyExpiredOnStatement(PreparedStatement statement, int currIndex, Boolean statutoryDutyExpired) {
        return currIndex;
    }

    private static int setDocumentPageOnStatement(PreparedStatement statement, int currIndex, String documentPage) throws SQLException {
        if (SearchHelper.isStringFilled(documentPage)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(documentPage));
        }
        return currIndex;
    }

    private static int setDocumentPositionOnStatement(PreparedStatement statement, int currIndex, String documentPosition) throws SQLException {
        if (SearchHelper.isStringFilled(documentPosition)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(documentPosition));
        }
        return currIndex;
    }

    private static int setSourceOnStatement(PreparedStatement statement, int currIndex, String source) throws SQLException {
        if (SearchHelper.isStringFilled(source)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(source));
        }
        return currIndex;
    }

    private static int setPersonInChargeIdOnStatement(PreparedStatement statement, int currIndex, Long personInChargeId) throws SQLException {
        if (personInChargeId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personInChargeId);
        }
        return currIndex;
    }

    private static int setTagsOnStatement(PreparedStatement statement, int currIndex, List<String> tags) throws SQLException {
        for (String tag : tags) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(tag));
        }
        return currIndex;
    }

    private static int setSubmitAuthorityOnStatement(PreparedStatement statement, int currIndex, Boolean submitAuthority) throws SQLException {
        if (submitAuthority != null) {
            // empty if block
        }
        return currIndex;
    }

    private static int setOrderCommentOnStatement(PreparedStatement statement, int currIndex, String comment) throws SQLException {
        if (SearchHelper.isStringFilled(comment)) {
            statement.setString(currIndex++, SearchHelper.convertForSearch(comment));
        }
        return currIndex;
    }

    private static int setOrderBaulosOnStatement(PreparedStatement statement, int currIndex, String baulos) throws SQLException {
        if (SearchHelper.isStringFilled(baulos)) {
            List<String> searchedNames = SearchHelper.extractAndConvertSearchTokens(baulos);
            for (String searchedName : searchedNames) {
                statement.setString(currIndex++, searchedName);
            }
        }
        return currIndex;
    }

    private static int setDueDateFromOnStatement(PreparedStatement statement, int currIndex, Long dueDateFrom) throws SQLException {
        if (dueDateFrom != null) {
            long utcMillis = (long)(dueDateFrom.doubleValue() * 1000.0);
            Timestamp timeStamp = new Timestamp(utcMillis);
            statement.setTimestamp(currIndex++, timeStamp);
            statement.setTimestamp(currIndex++, timeStamp);
        }
        return currIndex;
    }

    private static int setDueDateToOnStatement(PreparedStatement statement, int currIndex, Long dueDateTo) throws SQLException {
        if (dueDateTo != null) {
            long utcMillis = (long)(dueDateTo.doubleValue() * 1000.0);
            Timestamp timeStamp = new Timestamp(utcMillis);
            statement.setTimestamp(currIndex++, timeStamp);
            statement.setTimestamp(currIndex++, timeStamp);
        }
        return currIndex;
    }

    private static int setDueDateRemarkOnStatement(PreparedStatement statement, int currIndex, String dueDateRemark) throws SQLException {
        if (dueDateRemark != null) {
            statement.setString(currIndex++, dueDateRemark);
        }
        return currIndex;
    }

    private static int setPositionParticipationOnStatement(PreparedStatement statement, int currIndex, List<Long> participationIds) throws SQLException {
        if (participationIds != null) {
            for (Long participationId : participationIds) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
            }
        }
        return currIndex;
    }

    @Override
    public List<PlanningNotificationOrderExtraJoin> getPlanningNotificationOrderExtraJoins(final List<Long> workflowEntityIds) {
        String sql = "SELECT DISTINCT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.PROJECT, "planningNotificationOrder", "project", "projectConfig") + "FROM (((         planning_notification_order LEFT JOIN planning_notification_project_map       ON planning_notification_project_map.planning_notification_id = planning_notification_order.planning_notification_id) LEFT JOIN project                                 ON planning_notification_project_map.project_id = project.id) LEFT JOIN project_config                          ON project.project_config_id = project_config.id) WHERE planning_notification_order.workflow_entity_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") UNION ALL SELECT DISTINCT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.BAULOS, "planningNotificationOrder", "baulosTextMetaInformation") + "FROM ((((        planning_notification_order LEFT JOIN planning_notification_meta_information          ON planning_notification_meta_information.planning_notification_id = planning_notification_order.planning_notification_id) LEFT JOIN planning_notification_text_meta_information baulos_text_meta_information ON baulos_text_meta_information.meta_information_id = planning_notification_meta_information.meta_information_id) LEFT JOIN meta_information                                ON planning_notification_meta_information.meta_information_id = meta_information.id) LEFT JOIN meta_tag                                        ON meta_information.meta_tag_id = meta_tag.id) WHERE planning_notification_order.workflow_entity_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") AND meta_tag.name = ? UNION ALL SELECT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.REFERENCE, "planningNotificationOrder", "referencedWorkflowEntity", "referencedPlanningNotificationOrder", "planningNotification", "project") + "FROM ((((((    planning_notification_order LEFT JOIN planning_notification_order_map                 ON planning_notification_order_map.source_id = planning_notification_order.workflow_entity_id) LEFT JOIN planning_notification_order referenced_planning_notification_order ON planning_notification_order_map.destination_id = referenced_planning_notification_order.workflow_entity_id) LEFT JOIN workflow_entity referenced_workflow_entity      ON referenced_planning_notification_order.workflow_entity_id = referenced_workflow_entity.id) LEFT JOIN planning_notification                           ON referenced_planning_notification_order.planning_notification_id = planning_notification.id) LEFT JOIN planning_notification_project_map               ON planning_notification_project_map.planning_notification_id = planning_notification.id) LEFT JOIN project                                 ON planning_notification_project_map.project_id = project.id) WHERE planning_notification_order_map.source_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") UNION ALL SELECT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.TAG, "planningNotificationOrder", "planningNotificationOrderTag") + "FROM ((        planning_notification_order LEFT JOIN planning_notification_order_tag_map             ON planning_notification_order_tag_map.planning_notification_order_id = planning_notification_order.workflow_entity_id) LEFT JOIN planning_notification_order_tag ON planning_notification_order_tag_map.planning_notification_order_tag_id = planning_notification_order_tag.id) WHERE planning_notification_order_tag_map.planning_notification_order_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") UNION ALL SELECT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.SITE_TYPE, "planningNotificationOrder", "siteType") + "FROM ((        planning_notification_order LEFT JOIN site_type_map             ON site_type_map.planning_notification_order_id = planning_notification_order.workflow_entity_id) LEFT JOIN site_type                 ON site_type_map.site_type_id = site_type.id) WHERE site_type_map.planning_notification_order_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationOrderExtraJoin>>(){

            public List<PlanningNotificationOrderExtraJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                statement.setString(currIndex++, "Baulos");
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                ArrayList<PlanningNotificationOrderExtraJoin> results = new ArrayList<PlanningNotificationOrderExtraJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PlanningNotificationOrderExtraJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationOrderExtraJoinFromResultSet(rs);
                    currIndex = AbstractJdbcPlanningNotificationOrderDAO.getNumberOfPlanningNotificationOrderExtraJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    @Override
    public List<PlanningNotificationOrderProjectJoin> getPlanningNotificationOrderProjectJoins(final Long networkId) {
        String sql = "SELECT " + JdbcPlanningNotificationOrderDAO.getPlanningNotificationOrderProjectJoinSelectClause() + "FROM ((((      planning_notification_order LEFT JOIN workflow_entity                                 ON planning_notification_order.workflow_entity_id = workflow_entity.id) LEFT JOIN planning_notification                           ON planning_notification_order.planning_notification_id = planning_notification.id) LEFT JOIN planning_notification_project_map               ON planning_notification_project_map.planning_notification_id = planning_notification.id) LEFT JOIN project                                         ON planning_notification_project_map.project_id = project.id) WHERE project.network_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationOrderProjectJoin>>(){

            public List<PlanningNotificationOrderProjectJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                ArrayList<PlanningNotificationOrderProjectJoin> results = new ArrayList<PlanningNotificationOrderProjectJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PlanningNotificationOrderProjectJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationOrderProjectJoinFromResultSet(rs);
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    @Override
    public List<PlanningNotificationTaskJoin> getPlanningNotificationTaskJoins(final Collection<Long> projectIds, final PlanningNotificationTaskSearchModel searchModel) {
        String sql = this.getTaskSql(projectIds, searchModel, JdbcPlanningNotificationOrderDAO.getPlanningNotificationTaskJoinSelectClause());
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationTaskJoin>>(){

            public List<PlanningNotificationTaskJoin> perform(PreparedStatement statement) throws Exception {
                JdbcPlanningNotificationOrderDAO.this.populateTaskQuery(statement, projectIds, searchModel);
                ArrayList<PlanningNotificationTaskJoin> results = new ArrayList<PlanningNotificationTaskJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PlanningNotificationTaskJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationTaskJoinFromResultSet(rs);
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTaskSql(Collection<Long> projectIds, PlanningNotificationTaskSearchModel searchModel, String selectClause) {
        Long projectId;
        Long workflowEntityId;
        String sql = "SELECT " + selectClause + "FROM ((((((((((((((((((((((((( (((( project_participant participant JOIN project_participation                                   ON participant.participation_id = project_participation.id) JOIN workflow_node_position                                  ON workflow_node_position.project_participation_id = project_participation.id) JOIN workflow_token                                          ON workflow_token.owner_position_id = workflow_node_position.id) LEFT JOIN workflow_token_review                                   ON workflow_token_review.workflow_token_id = workflow_token.id) LEFT JOIN workflow_node_position_result_option workflow_token_review_option ON workflow_token_review.workflow_node_position_result_option_id = workflow_token_review_option.id) LEFT JOIN project_participant main_participant                    ON main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 AND (main_participant.inactive_flag IS NULL OR main_participant.inactive_flag = 0)) LEFT JOIN organisation_person                                     ON main_participant.organisation_person_id = organisation_person.id) LEFT JOIN organisation                                            ON organisation_person.organisation_id = organisation.id) LEFT JOIN person                                                  ON organisation_person.person_id = person.id) LEFT JOIN workflow_node_position initiator_workflow_node_position ON workflow_token.initiator_position_id = initiator_workflow_node_position.id) LEFT JOIN workflow_node_position_meta_information_map initiator_workflow_node_position_meta_information_map    ON initiator_workflow_node_position_meta_information_map.workflow_node_position_id = initiator_workflow_node_position.id) LEFT JOIN meta_information initiator_meta_information             ON initiator_workflow_node_position_meta_information_map.meta_information_id = initiator_meta_information.id) LEFT JOIN meta_tag initiator_meta_tag                             ON initiator_meta_information.meta_tag_id = initiator_meta_tag.id AND initiator_meta_tag.name = 'Baulos') LEFT JOIN planning_notification_text_meta_information initiator_workflow_node_position_meta_information    ON initiator_workflow_node_position_meta_information.meta_information_id = initiator_meta_information.id) LEFT JOIN project_participation initiator_project_participation   ON initiator_workflow_node_position.project_participation_id = initiator_project_participation.id) LEFT JOIN project_participant initiator_project_participant       ON initiator_project_participant.participation_id = initiator_project_participation.id AND initiator_project_participant.main_participant_flag = 1 AND (initiator_project_participant.inactive_flag IS NULL OR initiator_project_participant.inactive_flag = 0)) LEFT JOIN organisation_person initiator_organisation_person       ON initiator_project_participant.organisation_person_id = initiator_organisation_person.id) LEFT JOIN organisation initiator_organisation                     ON initiator_organisation_person.organisation_id = initiator_organisation.id) LEFT JOIN person initiator_person                                 ON initiator_organisation_person.person_id = initiator_person.id) LEFT JOIN workflow_node                                           ON workflow_node_position.workflow_node_id = workflow_node.id) LEFT JOIN workflow_node_template                                  ON workflow_node.workflow_node_template_id = workflow_node_template.id) LEFT JOIN workflow                                                ON workflow_node.workflow_id = workflow.id) LEFT JOIN workflow_entity                                         ON workflow_entity.workflow_id = workflow.id) LEFT JOIN workflow_entity_status                                  ON workflow_entity.workflow_entity_status_id = workflow_entity_status.id) LEFT JOIN planning_notification_order                             ON planning_notification_order.workflow_entity_id = workflow_entity.id) LEFT JOIN person_in_charge                                        ON planning_notification_order.person_in_charge_id = person_in_charge.id) LEFT JOIN statutory_duty                                          ON planning_notification_order.statutory_duty_id = statutory_duty.id) LEFT JOIN subject_area                                            ON planning_notification_order.subject_area_id = subject_area.id) LEFT JOIN planning_notification                                   ON planning_notification_order.planning_notification_id = planning_notification.id) WHERE (workflow_entity.invalidated IS NULL OR workflow_entity.invalidated = 0) ";
        PlanningNotificationTaskSearchMode mode = searchModel.getMode();
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        if (mode != null) {
            if (mode == PlanningNotificationTaskSearchMode.OWN) {
                sql = sql + "AND participant.organisation_person_id = ? AND workflow_token_review.id IS NULL ";
            } else if (mode == PlanningNotificationTaskSearchMode.OPEN || mode == PlanningNotificationTaskSearchMode.LATE) {
                sql = sql + "AND workflow_token_review.id IS NULL ";
                if (organisationPersonId != null) {
                    sql = sql + "AND (    participant.organisation_person_id = ? ";
                    if (projectIds.size() > 0) {
                        sql = sql + "OR EXISTS (SELECT 1 FROM planning_notification_project_map WHERE     planning_notification_project_map.planning_notification_id = planning_notification.id AND planning_notification_project_map.project_id IN (" + QueryHelper.getPlaceHolderSequence(projectIds.size()) + ")) ";
                    }
                    sql = sql + ") ";
                }
                if (mode == PlanningNotificationTaskSearchMode.LATE) {
                    sql = sql + "AND (        (initiator_workflow_node_position.optional_due_date IS NOT NULL AND initiator_workflow_node_position.optional_due_date <= ?) OR      (initiator_workflow_node_position.optional_due_date IS NULL AND initiator_workflow_node_position.due_date <= ?)) ";
                }
            } else {
                if (mode != PlanningNotificationTaskSearchMode.BATCH) throw new IllegalArgumentException("Unsupported PlanningNotificationTaskSearchMode: " + mode);
                sql = sql + "AND participant.organisation_person_id = ? AND workflow_token_review.id IS NOT NULL ";
            }
        } else if (searchModel.getOrganisationPersonId() != null) {
            sql = sql + "AND participant.organisation_person_id = ? ";
        }
        if (searchModel.getWorkflowTokenId() != null) {
            sql = sql + "AND workflow_token.id = ? ";
        }
        Double from = searchModel.getFrom();
        Double to = searchModel.getTo();
        DueDateRemarkOption remarkOption = searchModel.getRemarkOption();
        if (remarkOption != null) {
            sql = sql + "AND initiator_workflow_node_position.due_date IS NULL AND initiator_workflow_node_position.optional_due_date IS NULL AND initiator_workflow_node_position.due_date_remark = ? ";
        } else {
            if (from != null) {
                sql = sql + "AND (        (initiator_workflow_node_position.optional_due_date IS NOT NULL AND initiator_workflow_node_position.optional_due_date >= ?) OR      (initiator_workflow_node_position.optional_due_date IS NULL AND initiator_workflow_node_position.due_date >= ?)) ";
            }
            if (to != null) {
                sql = sql + "AND (        (initiator_workflow_node_position.optional_due_date IS NOT NULL AND initiator_workflow_node_position.optional_due_date <= ?) OR      (initiator_workflow_node_position.optional_due_date IS NULL AND initiator_workflow_node_position.due_date <= ?)) ";
            }
        }
        Long serialNumber = searchModel.getSerialNumber();
        if (serialNumber != null) {
            sql = sql + "AND planning_notification_order.serial_number = ? ";
        }
        if ((workflowEntityId = searchModel.getWorkflowEntityId()) != null) {
            sql = sql + "AND planning_notification_order.workflow_entity_id = ? ";
        }
        if ((projectId = searchModel.getProjectId()) == null) return sql + "AND (participant.inactive_flag IS NULL OR participant.inactive_flag = 0) AND (project_participation.invalidated IS NULL OR project_participation.invalidated = 0) ";
        sql = sql + "AND EXISTS (SELECT 1 FROM planning_notification_project_map WHERE planning_notification_project_map.planning_notification_id = planning_notification.id AND planning_notification_project_map.project_id = ?) ";
        return sql + "AND (participant.inactive_flag IS NULL OR participant.inactive_flag = 0) AND (project_participation.invalidated IS NULL OR project_participation.invalidated = 0) ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateTaskQuery(PreparedStatement statement, Collection<Long> projectIds, PlanningNotificationTaskSearchModel searchModel) throws SQLException {
        PlanningNotificationTaskSearchMode mode = searchModel.getMode();
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        DueDateRemarkOption remarkOption = searchModel.getRemarkOption();
        Double from = searchModel.getFrom();
        Double to = searchModel.getTo();
        Long serialNumber = searchModel.getSerialNumber();
        Long workflowEntityId = searchModel.getWorkflowEntityId();
        Long projectId = searchModel.getProjectId();
        int currIndex = 1;
        if (mode != null) {
            if (mode == PlanningNotificationTaskSearchMode.OWN) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
            } else if (mode == PlanningNotificationTaskSearchMode.OPEN || mode == PlanningNotificationTaskSearchMode.LATE) {
                if (organisationPersonId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                    for (Long currProjectId : projectIds) {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)currProjectId);
                    }
                }
                if (mode == PlanningNotificationTaskSearchMode.LATE) {
                    Long lateTo = System.currentTimeMillis();
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)new Double((double)lateTo.longValue() / 1000.0));
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)new Double((double)lateTo.longValue() / 1000.0));
                }
            } else {
                if (mode != PlanningNotificationTaskSearchMode.BATCH) throw new IllegalArgumentException("Unsupported PlanningNotificationTaskSearchMode: " + mode);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
            }
        } else if (searchModel.getOrganisationPersonId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        }
        if (searchModel.getWorkflowTokenId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getWorkflowTokenId());
        }
        if (remarkOption != null) {
            statement.setString(currIndex++, remarkOption.getValue());
        } else {
            if (from != null) {
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)new Double(from));
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)new Double(from));
            }
            if (to != null) {
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)new Double(to));
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)new Double(to));
            }
        }
        if (serialNumber != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)serialNumber);
        }
        if (workflowEntityId != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)workflowEntityId);
        }
        if (projectId == null) return;
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
    }

    @Override
    public List<PlanningNotificationOrderExtraJoin> getPlanningNotificationTaskExtraJoins(final List<Long> workflowEntityIds) {
        String sql = "SELECT DISTINCT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.PROJECT, "planningNotificationOrder", "project") + "FROM ((          planning_notification_order LEFT JOIN planning_notification_project_map       ON planning_notification_project_map.planning_notification_id = planning_notification_order.planning_notification_id) LEFT JOIN project                                 ON planning_notification_project_map.project_id = project.id) WHERE planning_notification_order.workflow_entity_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") UNION ALL SELECT DISTINCT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.BAULOS, "planningNotificationOrder", "baulosTextMetaInformation") + "FROM ((((        planning_notification_order LEFT JOIN planning_notification_meta_information          ON planning_notification_meta_information.planning_notification_id = planning_notification_order.planning_notification_id) LEFT JOIN planning_notification_text_meta_information baulos_text_meta_information ON baulos_text_meta_information.meta_information_id = planning_notification_meta_information.meta_information_id) LEFT JOIN meta_information                                ON planning_notification_meta_information.meta_information_id = meta_information.id) LEFT JOIN meta_tag                                        ON meta_information.meta_tag_id = meta_tag.id) WHERE planning_notification_order.workflow_entity_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") AND meta_tag.name = ? UNION ALL SELECT " + this.getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent.REFERENCE, "planningNotificationOrder", "referencedPlanningNotificationOrder", "planningNotification", "project") + "FROM (((((     planning_notification_order LEFT JOIN planning_notification_order_map                 ON planning_notification_order_map.source_id = planning_notification_order.workflow_entity_id) LEFT JOIN planning_notification_order referenced_planning_notification_order ON planning_notification_order_map.destination_id = referenced_planning_notification_order.workflow_entity_id) LEFT JOIN planning_notification                           ON planning_notification_order.planning_notification_id = planning_notification.id) LEFT JOIN planning_notification_project_map               ON planning_notification_project_map.planning_notification_id = planning_notification.id) LEFT JOIN project                                 ON planning_notification_project_map.project_id = project.id) WHERE planning_notification_order_map.source_id IN (" + QueryHelper.getPlaceHolderSequence(workflowEntityIds.size()) + ") ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanningNotificationOrderExtraJoin>>(){

            public List<PlanningNotificationOrderExtraJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                statement.setString(currIndex++, "Baulos");
                currIndex = QueryHelper.setIdsToStatement(statement, currIndex, workflowEntityIds);
                ArrayList<PlanningNotificationOrderExtraJoin> results = new ArrayList<PlanningNotificationOrderExtraJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    PlanningNotificationOrderExtraJoin joinDto = AbstractJdbcPlanningNotificationOrderDAO.fillPlanningNotificationOrderExtraJoinFromResultSet(rs);
                    currIndex = AbstractJdbcPlanningNotificationOrderDAO.getNumberOfPlanningNotificationOrderExtraJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getExtraUnionSelectClause(PlanningNotificationOrderExtraComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForPlanningNotificationOrderExtraJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public Set<Long> getAllSerialNumbersInPlanningNotificationProject(final Long planningNotificationId) {
        String sql = "SELECT planning_notification_order.serial_number FROM ((      planning_notification_project_map JOIN planning_notification              ON planning_notification_project_map.planning_notification_id = planning_notification.id) JOIN planning_notification_order        ON planning_notification_order.planning_notification_id = planning_notification.id) WHERE planning_notification_project_map.project_id IN (SELECT local_map.project_id FROM planning_notification_project_map local_map WHERE local_map.planning_notification_id = ?) ORDER BY planning_notification_order.serial_number";
        return (Set)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Set<Long>>(){

            public Set<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)planningNotificationId);
                HashSet<Long> results = new HashSet<Long>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    results.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
                }
                return results;
            }
        });
    }

    @Override
    public Set<Long> getAllSerialNumbersInProject(final Long projectId) {
        String sql = "SELECT planning_notification_order.serial_number FROM ((      planning_notification_project_map JOIN planning_notification              ON planning_notification_project_map.planning_notification_id = planning_notification.id) JOIN planning_notification_order        ON planning_notification_order.planning_notification_id = planning_notification.id) WHERE planning_notification_project_map.project_id = ? ORDER BY planning_notification_order.serial_number";
        return (Set)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Set<Long>>(){

            public Set<Long> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                HashSet<Long> results = new HashSet<Long>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    results.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
                }
                return results;
            }
        });
    }
}

