/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.archive;

import at.cdes.api.document.compositeDto.ArchiveJobStatus;
import at.cdes.api.document.compositeDto.DocumentListData;
import at.cdes.api.document.compositeDto.DocumentListRow;
import at.cdes.api.document.searchModel.DocumentSearchModel;
import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.DocumentReference;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.Job;
import at.cdes.api.guiService.DocumentService;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.DocumentArchiveJoin;
import at.cdes.api.joinDto.DocumentArchivePathJoin;
import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.api.voc.ArchiveFileFormat;
import at.cdes.api.voc.ArchiveScope;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.job.JobState;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.JobDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.unionComponent.DocumentArchiveComponent;
import at.cdes.impl.export.archive.ArchiveBulkDownloadEntry;
import at.cdes.impl.export.archive.ArchiveCreationException;
import at.cdes.impl.export.archive.ArchiveHelper;
import at.cdes.impl.export.archive.ArchiveTableOfContentsWriter;
import at.cdes.impl.export.document.ReviewProtocolPdfExporter;
import at.cdes.impl.file.RepositoryHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.BatchedDAOGetter;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.pdfbox.io.IOUtils;
import org.clazzes.util.sched.api.LogPriority;
import org.clazzes.util.sched.cache.IScratchBucket;
import org.clazzes.util.sched.cache.IScratchFileCache;
import org.clazzes.util.sched.cache.ScratchFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentArchiveExporter {
    private String applicationUrl;
    private String attachmentRepository;
    private String planRepository;
    private String documentReferenceRepository;
    private DocumentService documentService;
    private DocumentVersionDAO documentVersionDAO;
    private VisitlessMimeSource documentVersionMimeSource;
    private JobDAO jobDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private VisitlessMimeSource pdfMimeSource;
    private VisitlessMimeSource redliningMimeSource;
    private ReviewProtocolPdfExporter reviewProtocolPdfExporter;
    private IScratchFileCache scratchFileCache;
    private SubProjectDAO subProjectDAO;
    private int sqlQueryBatchSize;
    private String tempRepository;
    private boolean enableCustomerLogo;
    private String costumerLabel;
    private static final Logger log = LoggerFactory.getLogger(DocumentArchiveExporter.class);

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public void setAttachmentRepository(String attachmentRepository) {
        this.attachmentRepository = attachmentRepository;
    }

    public void setPlanRepository(String planRepository) {
        this.planRepository = planRepository;
    }

    public void setDocumentReferenceRepository(String documentReferenceRepository) {
        this.documentReferenceRepository = documentReferenceRepository;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentVersionMimeSource(VisitlessMimeSource documentVersionMimeSource) {
        this.documentVersionMimeSource = documentVersionMimeSource;
    }

    public void setJobDAO(JobDAO jobDAO) {
        this.jobDAO = jobDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPdfMimeSource(VisitlessMimeSource pdfMimeSource) {
        this.pdfMimeSource = pdfMimeSource;
    }

    public void setRedliningMimeSource(VisitlessMimeSource redliningMimeSource) {
        this.redliningMimeSource = redliningMimeSource;
    }

    public void setReviewProtocolPdfExporter(ReviewProtocolPdfExporter reviewProtocolPdfExporter) {
        this.reviewProtocolPdfExporter = reviewProtocolPdfExporter;
    }

    public void setScratchFileCache(IScratchFileCache scratchFileCache) {
        this.scratchFileCache = scratchFileCache;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setSqlQueryBatchSize(int sqlQueryBatchSize) {
        this.sqlQueryBatchSize = sqlQueryBatchSize;
    }

    public void setTempRepository(String tempRepository) {
        this.tempRepository = tempRepository;
    }

    public void setEnableCustomerLogo(boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    /*
     * Loose catch block
     */
    public ScratchFile export(DocumentSearchModel searchModel, ArchiveFileFormat archiveFileFormat, ArchiveScope archiveScope, boolean doIncludeReviewHistory, Long jobId) {
        ScratchFile scratchFile;
        IScratchBucket bucket;
        Job job;
        block16: {
            ArchiveJobStatus jobStatus = new ArchiveJobStatus();
            job = (Job)this.jobDAO.get(jobId);
            if (log.isDebugEnabled()) {
                log.debug("Received jobId [" + jobId + "]");
            }
            File zipFile = File.createTempFile("documentArchive", ".zip", new File(this.tempRepository));
            bucket = this.scratchFileCache.getBucket(zipFile.getName());
            ScratchFile scratchFile2 = bucket.provideScratchFile(zipFile, "application/zip", "attachment");
            this.doExport(jobStatus, scratchFile2, searchModel, archiveFileFormat, archiveScope, doIncludeReviewHistory, this.enableCustomerLogo);
            File file = scratchFile2.getFile();
            String fileName = file.getAbsolutePath();
            if (fileName.startsWith(this.tempRepository) && (fileName = fileName.substring(this.tempRepository.length())).startsWith("/")) {
                fileName = fileName.substring(1);
            }
            ArchiveResult archiveResult = new ArchiveResult(fileName);
            ArrayList<ArchiveMessage> archiveMessages = new ArrayList<ArchiveMessage>();
            List errorMessages = jobStatus.getErrorMessages();
            for (String errorMessage : errorMessages) {
                ArchiveMessage archiveMessage = new ArchiveMessage();
                archiveMessage.setCategory(LogPriority.ERROR);
                archiveMessage.setMessage(errorMessage);
                archiveMessages.add(archiveMessage);
            }
            archiveResult.setArchiveMessages(archiveMessages);
            Gson gson = new GsonBuilder().registerTypeAdapter(ArchiveResult.class, (Object)new ArchiveResultSerializer()).registerTypeAdapter(ArchiveMessage.class, (Object)new ArchiveMessageSerializer()).create();
            String result = gson.toJson((Object)archiveResult);
            job.setResult(result);
            job.setState(Integer.valueOf(JobState.FINISHED.getValue()));
            scratchFile = scratchFile2;
            if (bucket == null) break block16;
            bucket.close();
        }
        if (log.isDebugEnabled()) {
            log.debug("Ending up here with job [" + (job != null ? job.getId() : "null") + "]");
        }
        job.setEndTimestamp(Long.valueOf(System.currentTimeMillis()));
        this.jobDAO.update(job);
        return scratchFile;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (bucket != null) {
                            try {
                                bucket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        log.warn("Caught InterruptedException");
                        job.setState(Integer.valueOf(JobState.FAILED.getValue()));
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        log.warn("Caught Exception", (Throwable)e);
                        job.setState(Integer.valueOf(JobState.FAILED.getValue()));
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable3) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ending up here with job [" + (job != null ? job.getId() : "null") + "]");
                    }
                    job.setEndTimestamp(Long.valueOf(System.currentTimeMillis()));
                    this.jobDAO.update(job);
                    throw throwable3;
                }
            }
        }
    }

    private void doExport(ArchiveJobStatus jobStatus, ScratchFile scratchFile, DocumentSearchModel searchModel, ArchiveFileFormat archiveFileFormat, ArchiveScope archiveScope, boolean doIncludeReviewHistory, boolean enableCustomerLogo) throws IOException {
        File zipFile = scratchFile.getFile();
        try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            zipOutputStream.setEncoding("UTF-8");
            zipOutputStream.setUseZip64(Zip64Mode.Always);
            this.fetchDataAndFillStream(jobStatus, zipOutputStream, searchModel, archiveFileFormat, archiveScope, doIncludeReviewHistory, enableCustomerLogo);
        }
    }

    private void fetchDataAndFillStream(ArchiveJobStatus jobStatus, ZipArchiveOutputStream zipOutputStream, DocumentSearchModel searchModel, ArchiveFileFormat archiveFileFormat, ArchiveScope archiveScope, boolean doIncludeReviewHistory, boolean enableCustomerLogo) {
        Long subProjectId = searchModel.getSubProjectId();
        ContextJoin contextJoin = this.subProjectDAO.getSubProjectContextJoin(subProjectId);
        DocumentListData documentListData = this.documentService.getDocumentListJoin(searchModel);
        List<Long> documentVersionIds = this.extractDocumentVersionIds(documentListData);
        HashSet<Long> documentVersionIdSet = new HashSet<Long>();
        documentVersionIdSet.addAll(documentVersionIds);
        final boolean allDocumentVersions = archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALL || archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALLWITHHISTORY;
        List<DocumentArchiveJoin> archiveJoins = QueryHelper.executeDAOGetter(documentVersionIds, this.sqlQueryBatchSize / 4, new BatchedDAOGetter<DocumentArchiveJoin, Long>(){

            @Override
            public List<DocumentArchiveJoin> execute(List<Long> ids) {
                return DocumentArchiveExporter.this.documentVersionDAO.getArchiveJoin(ids, allDocumentVersions);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Fetched [" + archiveJoins.size() + "] archive joins.");
        }
        HashMap<Long, DocumentArchiveJoin> documentVersionIdToVersionJoin = new HashMap<Long, DocumentArchiveJoin>();
        HashMap<Long, List<DocumentArchiveJoin>> documentIdToVersionJoins = new HashMap<Long, List<DocumentArchiveJoin>>();
        HashMap<Long, List<DocumentReference>> documentIdToReferences = new HashMap<Long, List<DocumentReference>>();
        HashMap<Long, List<Attachment>> documentVersionIdToAttachments = new HashMap<Long, List<Attachment>>();
        HashMap<Long, DocumentArchiveJoin> documentVersionIdToReviewJoin = new HashMap<Long, DocumentArchiveJoin>();
        for (DocumentArchiveJoin archiveJoin : archiveJoins) {
            Long documentVersionId;
            int component = archiveJoin.getUnionClause();
            if (component == DocumentArchiveComponent.DOCUMENT_VERSION.getValue()) {
                Long documentId;
                documentVersionId = archiveJoin.getDocumentVersionId();
                if (documentVersionIdSet.contains(documentVersionId)) {
                    documentVersionIdToVersionJoin.put(documentVersionId, archiveJoin);
                }
                if (!documentIdToVersionJoins.containsKey(documentId = archiveJoin.getDocumentId())) {
                    documentIdToVersionJoins.put(documentId, new ArrayList());
                }
                ((List)documentIdToVersionJoins.get(documentId)).add(archiveJoin);
                continue;
            }
            if (component == DocumentArchiveComponent.DOCUMENT_REFERENCE.getValue()) {
                Long documentId = archiveJoin.getDocumentReferenceDocumentId();
                if (!documentIdToReferences.containsKey(documentId)) {
                    documentIdToReferences.put(documentId, new ArrayList());
                }
                ((List)documentIdToReferences.get(documentId)).add(archiveJoin.getDocumentReference());
                continue;
            }
            if (component == DocumentArchiveComponent.ATTACHMENT.getValue()) {
                documentVersionId = archiveJoin.getDocumentVersionId();
                if (!documentVersionIdToAttachments.containsKey(documentVersionId)) {
                    documentVersionIdToAttachments.put(documentVersionId, new ArrayList());
                }
                ((List)documentVersionIdToAttachments.get(documentVersionId)).add(archiveJoin.getAttachment());
                continue;
            }
            if (component == DocumentArchiveComponent.REVIEW_CYCLE.getValue()) {
                documentVersionId = archiveJoin.getDocumentVersionId();
                documentVersionIdToReviewJoin.put(documentVersionId, archiveJoin);
                continue;
            }
            throw new IllegalArgumentException("Unsupported join component: [" + component + "]");
        }
        if (log.isDebugEnabled()) {
            log.debug("Fetched [" + archiveJoins.size() + "] archive joins.");
            log.debug("... Resulting in [" + documentVersionIdToVersionJoin.size() + "] documentVersionIdToVersionJoin instances");
            log.debug("... Resulting in [" + documentIdToVersionJoins.size() + "] documentIdToVersionJoins instances");
            log.debug("... Resulting in [" + documentIdToReferences.size() + "] documentIdToReferences instances");
            log.debug("... Resulting in [" + documentVersionIdToAttachments.size() + "] documentVersionIdToAttachments instances");
            log.debug("... Resulting in [" + documentVersionIdToReviewJoin.size() + "] documentVersionIdToReviewJoin instances");
        }
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        this.fillStream(organisationPersonId, jobStatus, zipOutputStream, contextJoin, documentVersionIdToVersionJoin, documentIdToVersionJoins, documentIdToReferences, documentVersionIdToAttachments, documentVersionIdToReviewJoin, archiveFileFormat, archiveScope, doIncludeReviewHistory);
    }

    private List<Long> extractDocumentVersionIds(DocumentListData documentListData) {
        List documentListRows = documentListData.getDocumentListRows();
        ArrayList<Long> documentVersionIds = new ArrayList<Long>();
        for (DocumentListRow documentListRow : documentListRows) {
            Long documentVersionId = documentListRow.getDocumentVersionId();
            if (documentVersionId == null) continue;
            documentVersionIds.add(documentVersionId);
        }
        return documentVersionIds;
    }

    private void fillStream(Long organisationPersonId, ArchiveJobStatus jobStatus, ZipArchiveOutputStream zipOutputStream, ContextJoin contextJoin, Map<Long, DocumentArchiveJoin> documentVersionIdToVersionJoin, Map<Long, List<DocumentArchiveJoin>> documentIdToVersionJoins, Map<Long, List<DocumentReference>> documentIdToReferences, Map<Long, List<Attachment>> documentVersionIdToAttachments, Map<Long, DocumentArchiveJoin> documentVersionIdToReviewJoin, ArchiveFileFormat archiveFileFormat, ArchiveScope archiveScope, boolean doIncludeReviewHistory) {
        HashMap<Long, ArchiveBulkDownloadEntry> archiveEntries = new HashMap<Long, ArchiveBulkDownloadEntry>();
        String locale = contextJoin.getProjectCountryCode2();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        int initialPoint = archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALLWITHHISTORY || doIncludeReviewHistory ? 1 : 2;
        for (Long documentVersionId : documentVersionIdToVersionJoin.keySet()) {
            DocumentArchiveJoin baseJoin = documentVersionIdToVersionJoin.get(documentVersionId);
            Long documentId = baseJoin.getDocumentVersionDocumentId();
            if (log.isDebugEnabled()) {
                log.debug("Processing DocumentArchiveJoin for document version [" + baseJoin.getDocumentVersionId() + "]");
            }
            String fileType = baseJoin.getDocumentVersionFiletype();
            boolean hasFiles = false;
            ArchiveBulkDownloadEntry lastVersion = new ArchiveBulkDownloadEntry(documentVersionId);
            if (archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALL || archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALLWITHHISTORY) {
                List<Object> versionJoins = documentIdToVersionJoins.containsKey(documentId) ? documentIdToVersionJoins.get(documentId) : new ArrayList();
                for (DocumentArchiveJoin documentArchiveJoin : versionJoins) {
                    if (log.isDebugEnabled()) {
                        log.debug("... Processing dependent version [" + documentArchiveJoin.getDocumentVersionId() + "]");
                    }
                    ArchiveBulkDownloadEntry currentVersion = null;
                    currentVersion = documentArchiveJoin.getDocumentVersionId().longValue() == lastVersion.getDocumentVersionId().longValue() ? lastVersion : new ArchiveBulkDownloadEntry(documentArchiveJoin.getDocumentVersionId());
                    hasFiles |= this.addOriginalFile(jobStatus, zipOutputStream, currentVersion, documentArchiveJoin, resourceBundle, initialPoint, archiveFileFormat, true);
                    hasFiles |= this.addPdfPreview(jobStatus, zipOutputStream, currentVersion, documentArchiveJoin, resourceBundle, initialPoint, archiveFileFormat, fileType);
                    this.addAttachments(jobStatus, zipOutputStream, currentVersion, lastVersion, documentVersionIdToAttachments, documentArchiveJoin, documentArchiveJoin.getDocumentVersionId(), resourceBundle, initialPoint, archiveScope, doIncludeReviewHistory);
                }
            } else {
                hasFiles |= this.addOriginalFile(jobStatus, zipOutputStream, lastVersion, baseJoin, resourceBundle, initialPoint, archiveFileFormat, false);
                hasFiles |= this.addPdfPreview(jobStatus, zipOutputStream, lastVersion, baseJoin, resourceBundle, initialPoint, archiveFileFormat, fileType);
                this.addAttachments(jobStatus, zipOutputStream, lastVersion, lastVersion, documentVersionIdToAttachments, baseJoin, documentVersionId, resourceBundle, initialPoint, archiveScope, doIncludeReviewHistory);
            }
            if (!hasFiles) continue;
            Integer status = baseJoin.getDocumentVersionStatus();
            boolean deleted = status != null && status.intValue() == DocumentVersionStatus.DELETED.getValue();
            int n = this.getNumberOfNonDeletedDocumentVersions(documentIdToVersionJoins, documentId);
            if (archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALLWITHHISTORY || doIncludeReviewHistory && (!deleted || deleted && n > 0)) {
                this.addReviewProtocol(organisationPersonId, jobStatus, zipOutputStream, lastVersion, contextJoin, baseJoin, documentVersionId, resourceBundle, initialPoint, archiveScope, archiveFileFormat);
                List<DocumentReference> documentReferences = documentIdToReferences.get(documentId);
                if (documentReferences != null) {
                    for (DocumentReference documentReference : documentReferences) {
                        if (documentReference.getAttachmentFilename() == null && documentReference.getReferencedVersionId() != null) {
                            DocumentVersion referencedVersion = (DocumentVersion)this.documentVersionDAO.get(documentReference.getReferencedVersionId());
                            documentReference.setAttachmentFiletype(referencedVersion.getFiletype());
                        }
                        String documentReferencePath = ArchiveHelper.getDocumentReferenceFilename(documentReference, baseJoin, resourceBundle, initialPoint);
                        this.addDocumentReferenceToZip(documentReference, zipOutputStream, documentReferencePath, jobStatus, resourceBundle, lastVersion);
                    }
                }
            }
            lastVersion.setName(baseJoin.getDocumentVersionName());
            lastVersion.setTitle(baseJoin.getDocumentContent());
            lastVersion.setPlanner(baseJoin.getOrganisationName());
            lastVersion.setObject(baseJoin.getObjectReleaseCode() + " " + baseJoin.getObjectReleaseName());
            lastVersion.setObjectplanner(baseJoin.getObjectPlannerReleaseCode() + " " + baseJoin.getObjectPlannerReleaseArea());
            lastVersion.setObjectkm(baseJoin.getObjectReleaseStretchKmFrom() + " - " + baseJoin.getObjectReleaseStretchKmTo());
            Integer documentVersionStatus = baseJoin.getDocumentVersionStatus();
            String statusString = CodeHelper.getI18nDocumentVersionStatus(resourceBundle, documentVersionStatus);
            lastVersion.setStatus(statusString);
            if (documentVersionStatus != null && documentVersionStatus.intValue() == DocumentVersionStatus.RELEASEDPOSITIV.getValue()) {
                DocumentArchiveJoin reviewJoin = documentVersionIdToReviewJoin.get(documentVersionId);
                if (reviewJoin == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring reviewJoin code for documentVersionId [" + documentVersionId + "] since there is no review join.");
                    }
                } else {
                    String dateFormatPattern;
                    if (log.isDebugEnabled()) {
                        log.debug("Processing reviewJoin code for documentVersionId [" + documentVersionId + "]");
                    }
                    if (reviewJoin.getReviewCyclePositionResultId() == null) {
                        if (reviewJoin.getReviewCycleNodeResultId() != null) {
                            Double arrivalDate = reviewJoin.getReviewCycleNodeResultArrivalDate();
                            dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                            String arrivalDateString = DateHelper.formatUtcSeconds(arrivalDate, "Europe/Vienna", dateFormatPattern);
                            lastVersion.setStatusSuffix("[" + arrivalDateString + "]");
                        }
                    } else if (reviewJoin.getReviewCycleResultOptionId() != null && reviewJoin.getReviewCycleResultOptionDocumentVersionStatus() != null && reviewJoin.getReviewCycleResultOptionDocumentVersionStatus().intValue() == DocumentVersionStatus.RELEASEDPOSITIV.getValue()) {
                        Double resultDate = reviewJoin.getReviewCyclePositionResultResultDate();
                        dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                        String resultDateString = DateHelper.formatUtcSeconds(resultDate, "Europe/Vienna", dateFormatPattern);
                        lastVersion.setStatusSuffix("[" + resultDateString + "]");
                    }
                }
            }
            archiveEntries.put(documentVersionId, lastVersion);
        }
        if (log.isDebugEnabled()) {
            log.debug("About to write resources to ZIP with [" + archiveEntries.size() + "] archive entries.");
        }
        try {
            ArchiveTableOfContentsWriter writer = new ArchiveTableOfContentsWriter();
            writer.writeTableOfContents(resourceBundle, zipOutputStream, archiveEntries.values(), contextJoin, jobStatus, this.enableCustomerLogo);
            String prefix = "at/cdes/archive/html/";
            this.writeResourceToZip(zipOutputStream, prefix + "archive.css", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "archive.css"));
            this.writeResourceToZip(zipOutputStream, prefix + "table.js", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "table.js"));
            this.writeResourceToZip(zipOutputStream, prefix + "bgImageTop.png", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "bgImageTop.png"));
            this.writeResourceToZip(zipOutputStream, prefix + "li_o_c8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "li_o_c8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "li_o_f3.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "li_o_f3.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "li_u_c8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "li_u_c8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "li_u_f3.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "li_u_f3.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "logoCdes.png", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "logoCdes.png"));
            this.writeResourceToZip(zipOutputStream, prefix + "planvorschau_pdf.gif", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "planvorschau_pdf.gif"));
            this.writeResourceToZip(zipOutputStream, prefix + "pruefprotokoll.gif", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "pruefprotokoll.gif"));
            this.writeResourceToZip(zipOutputStream, prefix + "re_o_c8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "re_o_c8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "re_o_f3.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "re_o_f3.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "re_u_c8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "re_u_c8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "re_u_f3.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "re_u_f3.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "sortable.gif", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "sortable.gif"));
            this.writeResourceToZip(zipOutputStream, prefix + "sorted_down.gif", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "sorted_down.gif"));
            this.writeResourceToZip(zipOutputStream, prefix + "sorted_up.gif", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "sorted_up.gif"));
            this.writeResourceToZip(zipOutputStream, prefix + "speichern.gif", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "speichern.gif"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_li_o_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_li_o_C8C8C8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_li_o.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_li_o.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_li_u_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_li_u_C8C8C8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_li_u.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_li_u.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_re_o_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_re_o_C8C8C8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_re_o.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_re_o.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_re_u_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_re_u_C8C8C8.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "tab_re_u.jpg", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "tab_re_u.jpg"));
            this.writeResourceToZip(zipOutputStream, prefix + "error_small.png", ArchiveHelper.getHTMLRessourcePath(resourceBundle, "error_small.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDocumentVersionToZip(ZipArchiveOutputStream zipOutputStream, VisitlessMimeSource mimeSource, DocumentArchiveJoin versionJoin, String fileNamePostfix, String forcedFilename) {
        IMimeInputStream mimeStream = null;
        try {
            byte[] data;
            do {
                try {
                    mimeStream = mimeSource.getMimeStream(new Object[]{versionJoin.getDocumentVersionId()});
                }
                catch (Timeout e) {
                    log.info("Retrieving data for document version [" + versionJoin.getDocumentVersionName() + "] timed out, retrying...");
                }
            } while (mimeStream == null);
            String prettyFilename = "";
            prettyFilename = forcedFilename != null ? forcedFilename : ("application/pdf".equals(mimeStream.getMimeType()) ? versionJoin.getDocumentVersionName() + fileNamePostfix + ".pdf" : versionJoin.getDocumentVersionName() + fileNamePostfix + "." + versionJoin.getDocumentVersionFiletype());
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(prettyFilename);
            if (log.isDebugEnabled()) {
                log.debug("addDocumentVersionToZip for documentVersion [" + versionJoin.getDocumentVersionId() + "] adds entry [" + zipArchiveEntry + "] to bulk download.");
            }
            zipOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
            for (long lengthToBeWritten = mimeStream.getStreamSize(); lengthToBeWritten > 0L; lengthToBeWritten -= (long)data.length) {
                data = mimeStream.readBlock(4096);
                zipOutputStream.write(data);
            }
            zipOutputStream.closeArchiveEntry();
        }
        catch (Exception e) {
            log.error("Caught exception while adding document version [" + versionJoin.getDocumentVersionName() + "] to zip file.", (Throwable)e);
            throw new ArchiveCreationException("Caught exception while adding document version [" + versionJoin.getDocumentVersionName() + "] to zip file.", e);
        }
        finally {
            if (mimeStream != null) {
                try {
                    mimeStream.close();
                }
                catch (Throwable e) {
                    log.warn("Caught exception while closing document version [" + versionJoin.getDocumentVersionName() + "] added to zip file.", e);
                }
            }
        }
    }

    private void addAttachmentToZip(ZipArchiveOutputStream zipOutputStream, Attachment attachment, String attachmentRepository, String fileName) {
        if (attachment.isIsRedliningDelta().booleanValue()) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            int length;
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(fileName);
            if (log.isDebugEnabled()) {
                log.debug("addAttachmentToZip for attachment [" + attachment.getId() + "] adds entry [" + zipEntry + "] to bulk download.");
            }
            File attachmentFile = RepositoryHelper.getFileInRepository(attachmentRepository, attachment.getFilename());
            fileInputStream = new FileInputStream(attachmentFile);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = fileInputStream.read(buffer)) >= 0) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            zipOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            zipOutputStream.write(byteArray);
            zipOutputStream.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Caught exception while adding attachment [" + attachment.getOriginalName() + "] to zip file.", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception closing stream: ", e);
                }
            }
        }
    }

    private void addFileNotInterpretableError(ArchiveJobStatus jobStatus, ResourceBundle resourceBundle, DocumentArchiveJoin archiveJoin) {
        String message = resourceBundle.getString("archiveFileCouldNotBeInterpreted");
        String formattedMessage = MessageFormat.format(message, archiveJoin.getDocumentVersionName() + "." + archiveJoin.getDocumentVersionFiletype());
        jobStatus.addErrorMessage(formattedMessage);
    }

    private boolean addOriginalFile(ArchiveJobStatus jobStatus, ZipArchiveOutputStream zipOutputStream, ArchiveBulkDownloadEntry currentVersion, DocumentArchiveJoin versionJoin, ResourceBundle resourceBundle, int initialPoint, ArchiveFileFormat archiveFileFormat, boolean setPdfPreviewPath) {
        if (log.isDebugEnabled()) {
            log.debug("...... Calling addOriginalFile for version [" + versionJoin.getDocumentVersionId() + "]");
        }
        if (archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_BOTH || archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_ORIGINAL) {
            String fileName = ArchiveHelper.getDocumentVersionFilename((DocumentArchivePathJoin)versionJoin, versionJoin.getObjectReleaseCode(), versionJoin.getObjectTypeCode(), resourceBundle, initialPoint, false);
            try {
                this.addDocumentVersionToZip(zipOutputStream, this.documentVersionMimeSource, versionJoin, null, fileName);
                currentVersion.setDocumentPath(fileName);
                String fileType = versionJoin.getDocumentVersionFiletype();
                if (setPdfPreviewPath && fileType != null && fileType.equalsIgnoreCase("pdf")) {
                    currentVersion.setPdfPreviewPath(fileName);
                }
            }
            catch (ArchiveCreationException e) {
                this.addFileNotInterpretableError(jobStatus, resourceBundle, versionJoin);
            }
            jobStatus.recordFileAddition();
            return true;
        }
        return false;
    }

    private boolean addPdfPreview(ArchiveJobStatus jobStatus, ZipArchiveOutputStream zipOutputStream, ArchiveBulkDownloadEntry currentVersion, DocumentArchiveJoin versionJoin, ResourceBundle resourceBundle, int initialPoint, ArchiveFileFormat archiveFileFormat, String fileType) {
        if (log.isDebugEnabled()) {
            log.debug("...... Adding pdf preview for version [" + versionJoin.getDocumentVersionId() + "]");
        }
        if (archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_PDF || versionJoin.getDocumentVersionFiletype() != null && !versionJoin.getDocumentVersionFiletype().equalsIgnoreCase("pdf") && archiveFileFormat == ArchiveFileFormat.ARCHIVE_TYPE_BOTH) {
            if (this.isFileTypeSupportedForPreview(fileType)) {
                String fileName = ArchiveHelper.getDocumentVersionFilename((DocumentArchivePathJoin)versionJoin, versionJoin.getObjectReleaseCode(), versionJoin.getObjectTypeCode(), resourceBundle, initialPoint, true);
                try {
                    this.addDocumentVersionToZip(zipOutputStream, this.pdfMimeSource, versionJoin, null, fileName);
                    currentVersion.setPdfPreviewPath(fileName);
                }
                catch (ArchiveCreationException e) {
                    this.addFileNotInterpretableError(jobStatus, resourceBundle, versionJoin);
                }
                jobStatus.recordFileAddition();
                return true;
            }
            log.info("Skipping non-previewable document version [" + versionJoin.getDocumentVersionName() + "] in bulk download.");
            return false;
        }
        return false;
    }

    private void addAttachments(ArchiveJobStatus jobStatus, ZipArchiveOutputStream zipOutputStream, ArchiveBulkDownloadEntry currentVersion, ArchiveBulkDownloadEntry lastVersion, Map<Long, List<Attachment>> documentVersionIdToAttachments, DocumentArchiveJoin versionJoin, Long documentVersionId, ResourceBundle resourceBundle, int initialPoint, ArchiveScope archiveScope, boolean doIncludeReviewHistory) {
        List<Attachment> attachments;
        if (log.isDebugEnabled()) {
            log.debug("... Calling addAttachments for version [" + versionJoin.getDocumentVersionId() + "]");
        }
        if ((attachments = documentVersionIdToAttachments.get(documentVersionId)) != null && attachments.size() > 0 && (archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALLWITHHISTORY || doIncludeReviewHistory)) {
            boolean hasRedlinings = false;
            for (Attachment attachment : attachments) {
                if (attachment.isIsRedliningDelta().booleanValue()) {
                    hasRedlinings = true;
                    continue;
                }
                String attachmentFileName = ArchiveHelper.getAttachmentFilename((DocumentArchivePathJoin)versionJoin, versionJoin.getObjectReleaseCode(), versionJoin.getObjectTypeCode(), resourceBundle, initialPoint, attachment);
                try {
                    this.addAttachmentToZip(zipOutputStream, attachment, this.attachmentRepository, attachmentFileName);
                    jobStatus.recordFileAddition();
                    currentVersion.getAttachments().put(attachment.getId(), attachmentFileName);
                }
                catch (Exception e) {
                    String fileName = attachment.getFilename();
                    String documentVersionName = versionJoin.getDocumentVersionName();
                    String unformattedError = resourceBundle.getString("archiveFileNotFound");
                    String formattedError = MessageFormat.format(unformattedError, fileName, documentVersionName);
                    jobStatus.addErrorMessage(formattedError);
                }
            }
            if (hasRedlinings) {
                String redliningFilename = ArchiveHelper.getRedliningFilename((DocumentArchivePathJoin)versionJoin, versionJoin.getObjectReleaseCode(), versionJoin.getObjectTypeCode(), resourceBundle, initialPoint);
                try {
                    this.addDocumentVersionToZip(zipOutputStream, this.redliningMimeSource, versionJoin, null, redliningFilename);
                    currentVersion.getRedlinings().put(versionJoin.getDocumentVersionId(), redliningFilename);
                }
                catch (ArchiveCreationException e) {
                    String documentVersionName = versionJoin.getDocumentVersionName();
                    String unformattedError = resourceBundle.getString("archiveFileRedliningError");
                    String formattedError = MessageFormat.format(unformattedError, documentVersionName);
                    jobStatus.addErrorMessage(formattedError);
                }
                jobStatus.recordFileAddition();
            }
            if (!lastVersion.getDocumentVersionId().equals(currentVersion.getDocumentVersionId())) {
                lastVersion.getPreviousVersions().put(currentVersion.getDocumentVersionId(), currentVersion);
            }
        }
    }

    private boolean isFileTypeSupportedForPreview(String type) {
        return type != null && (type.equalsIgnoreCase("hpgl") || type.equalsIgnoreCase("hpg") || type.equalsIgnoreCase("plt") || type.equalsIgnoreCase("pdf"));
    }

    private int getNumberOfNonDeletedDocumentVersions(Map<Long, List<DocumentArchiveJoin>> documentIdToVersionJoins, Long documentId) {
        List<DocumentArchiveJoin> archiveJoins = documentIdToVersionJoins.get(documentId);
        if (archiveJoins == null) {
            return 0;
        }
        int count = 0;
        for (DocumentArchiveJoin archiveJoin : archiveJoins) {
            Integer status = archiveJoin.getDocumentVersionStatus();
            if (status == null || status.intValue() == DocumentVersionStatus.DELETED.getValue()) continue;
            ++count;
        }
        return count;
    }

    private void addReviewProtocollPdfToZip(ZipArchiveOutputStream zos, Long organisationPersonId, Long documentVersionId, ArchiveScope archiveScope, ArchiveFileFormat archiveFileFormat, Locale locale, String fn) {
        try {
            ScratchFile scratchFile = this.reviewProtocolPdfExporter.export(organisationPersonId, documentVersionId, archiveScope, archiveFileFormat, this.enableCustomerLogo);
            File file = scratchFile.getFile();
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] dataAsByteArray = IOUtils.toByteArray((InputStream)fileInputStream);
            ZipArchiveEntry ze = new ZipArchiveEntry(fn);
            if (log.isDebugEnabled()) {
                log.debug("addReviewProtocollPdfToZip for document version [" + documentVersionId + "] adds entry [" + ze + "] to bulk download.");
            }
            zos.putArchiveEntry((ArchiveEntry)ze);
            zos.write(dataAsByteArray);
            zos.closeArchiveEntry();
        }
        catch (Exception e) {
            log.error("Caught exception while adding page ReviewProtocoll pdf to zip file.", (Throwable)e);
            throw new ArchiveCreationException("Caught exception while adding page ReviewProtocoll pdf to zip file.", e);
        }
    }

    private void addReviewProtocol(Long organisationPersonId, ArchiveJobStatus jobStatus, ZipArchiveOutputStream zipOutputStream, ArchiveBulkDownloadEntry lastVersion, ContextJoin contextJoin, DocumentArchiveJoin baseJoin, Long documentVersionId, ResourceBundle resourceBundle, int initialPoint, ArchiveScope archiveScope, ArchiveFileFormat archiveFileFormat) {
        if (log.isDebugEnabled()) {
            log.debug("Calling addReviewProtocol for document version [" + documentVersionId + "]");
        }
        String reviewProtocolFileName = ArchiveHelper.getReviewProtocollFilename(baseJoin, resourceBundle, initialPoint);
        boolean allDocumentVersions = archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALL || archiveScope == ArchiveScope.ARCHIVE_SCOPE_ALLWITHHISTORY;
        Locale projectLocale = new Locale(contextJoin.getProjectCountryCode2());
        try {
            this.addReviewProtocollPdfToZip(zipOutputStream, organisationPersonId, documentVersionId, archiveScope, archiveFileFormat, projectLocale, reviewProtocolFileName);
        }
        catch (Exception e) {
            String documentVersionName = baseJoin.getDocumentVersionName();
            String unformattedError = resourceBundle.getString("archiveFileErrorCreatingReviewProcotol");
            String formattedError = MessageFormat.format(unformattedError, documentVersionName);
            log.error("Error creating review protocoll for documentVersion [" + documentVersionName + "]", (Throwable)e);
            jobStatus.addErrorMessage(formattedError);
        }
        jobStatus.recordFileAddition();
        lastVersion.setReviewProtocolPath(reviewProtocolFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocumentReferenceToZip(DocumentReference documentReference, ZipArchiveOutputStream zipOutputStream, String documentReferencePath, ArchiveJobStatus jobStatus, ResourceBundle resourceBundle, ArchiveBulkDownloadEntry lastVersion) {
        if (documentReference.getAttachmentFilename() != null || documentReference.getReferencedVersionId() != null) {
            FileInputStream fis = null;
            try {
                int length;
                ZipArchiveEntry ze = new ZipArchiveEntry(documentReferencePath);
                if (log.isDebugEnabled()) {
                    log.debug("addDocumentReferenceToZip for documentReference [" + documentReference.getId() + "] adds entry [" + ze + "] to bulk download.");
                }
                File file = null;
                if (documentReference.getAttachmentFilename() != null) {
                    file = RepositoryHelper.getFileInRepository(this.documentReferenceRepository, documentReference.getAttachmentFilename());
                } else {
                    DocumentVersion referencedVersion = (DocumentVersion)this.documentVersionDAO.get(documentReference.getReferencedVersionId());
                    file = RepositoryHelper.getFileInRepository(this.planRepository, referencedVersion.getFileName());
                }
                fis = new FileInputStream(file);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = fis.read(buffer)) >= 0) {
                    bos.write(buffer, 0, length);
                }
                zipOutputStream.putArchiveEntry((ArchiveEntry)ze);
                byte[] ba = bos.toByteArray();
                zipOutputStream.write(ba);
                zipOutputStream.closeArchiveEntry();
                jobStatus.recordFileAddition();
                lastVersion.getDocumentRefs().put(documentReference.getId(), documentReferencePath);
            }
            catch (IOException e) {
                log.warn("Caught IOException: ", (Throwable)e);
                String message = resourceBundle.getString("archiveDocumentReferenceFileCouldNotBeInterpreted");
                String formattedMessage = MessageFormat.format(message, documentReferencePath);
                jobStatus.addErrorMessage(formattedMessage);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error while closing stream", e);
                    }
                }
            }
        }
    }

    private void writeResourceToZip(ZipArchiveOutputStream zos, String sourceFileName, String destinationFileName) throws IOException {
        int numRead;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(sourceFileName);
        if (is == null) {
            log.error("Could not add resource '" + sourceFileName + "' to zip.");
            return;
        }
        ZipArchiveEntry ze = new ZipArchiveEntry(destinationFileName);
        if (log.isTraceEnabled()) {
            log.trace("Adding entry [" + ze + "] to bulk download.");
        }
        zos.putArchiveEntry((ArchiveEntry)ze);
        byte[] buf = new byte[4096];
        while ((numRead = is.read(buf)) >= 0) {
            zos.write(buf, 0, numRead);
        }
        zos.closeArchiveEntry();
    }

    private static class ArchiveMessageSerializer
    implements JsonSerializer<ArchiveMessage> {
        private ArchiveMessageSerializer() {
        }

        public JsonElement serialize(ArchiveMessage archiveMessage, Type type, JsonSerializationContext context) {
            String message;
            JsonObject result = new JsonObject();
            LogPriority category = archiveMessage.getCategory();
            if (category != null) {
                result.add("category", (JsonElement)new JsonPrimitive(archiveMessage.getCategory().toString()));
            }
            result.add("message", (JsonElement)((message = archiveMessage.getMessage()) != null ? new JsonPrimitive(archiveMessage.getMessage()) : JsonNull.INSTANCE));
            return result;
        }
    }

    private static class ArchiveResultSerializer
    implements JsonSerializer<ArchiveResult> {
        private ArchiveResultSerializer() {
        }

        public JsonElement serialize(ArchiveResult archiveResult, Type type, JsonSerializationContext context) {
            String fileName = archiveResult.getFileName();
            List<ArchiveMessage> archiveMessages = archiveResult.getArchiveMessages();
            JsonObject result = new JsonObject();
            result.add("fileName", (JsonElement)(fileName != null ? new JsonPrimitive(fileName) : JsonNull.INSTANCE));
            JsonElement archiveMessagesElement = context.serialize(archiveMessages);
            JsonArray archiveMessagesArray = archiveMessagesElement.getAsJsonArray();
            result.add("archiveMessages", (JsonElement)archiveMessagesArray);
            return result;
        }
    }

    private static class ArchiveMessage {
        private LogPriority category;
        private String message;

        private ArchiveMessage() {
        }

        public LogPriority getCategory() {
            return this.category;
        }

        public void setCategory(LogPriority category) {
            this.category = category;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    private static class ArchiveResult {
        private String fileName;
        private List<ArchiveMessage> archiveMessages;

        private ArchiveResult(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public List<ArchiveMessage> getArchiveMessages() {
            return this.archiveMessages;
        }

        public void setArchiveMessages(List<ArchiveMessage> archiveMessages) {
            this.archiveMessages = archiveMessages;
        }
    }
}

