/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.compositeDto.PlanningNotificationTaskInfo;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.dto.Project;
import at.cdes.api.joinDto.PlanningNotificationTaskJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.export.planning.PlanningExportHelper;
import at.cdes.impl.export.planning.PlanningNotificationOrderListExporter;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PlanningNotificationTaskListExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private String tempDirName;
    private PersonVariablesDAO personVariablesDAO;
    private static final Logger log = LoggerFactory.getLogger(PlanningNotificationTaskListExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public ScratchFile export(List<PlanningNotificationTaskInfo> taskInfos, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, String filter, boolean batch, boolean enableCustomerLogo) throws Exception {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(personId);
        PersonVariables personVariables = personVariablesList.get(0);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariables.getUserLocale());
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        ClassLoader classLoader = PlanningNotificationOrderListExporter.class.getClassLoader();
        URL logoUrl = classLoader.getResource("export/logos/OeBB_INFRA_black_eps_small.png");
        URI logoUri = logoUrl.toURI();
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = batch ? resourceBundle.getString("planningNotificationTaskBatchListFooterGeneratedString") : resourceBundle.getString("planningNotificationTaskListFooterGeneratedString");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw, null, null, resourceBundle);
        TextHElement textHElement = officeText.newTextHElement(2);
        if (batch) {
            textHElement.setTextContent(resourceBundle.getString("planningNotificationTaskBatchListExportCaption"));
        } else {
            textHElement.setTextContent(resourceBundle.getString("planningNotificationTaskListExportCaption"));
        }
        officeText.newTextPElement();
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold")});
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000")});
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataBoldRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#FF0000", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#FF0000", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        columnSortSpecs = this.translateSortColumns(columnSortSpecs);
        FancyOdfTable<PlanningNotificationTaskInfo> odfTable = this.constructPlanningNotificationTaskTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, dataBoldTextStyle, dataBoldRedTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle, columnToWidth);
        odfTable.setDataRowStyle(dataRowStyle);
        odfTable.setFilter(filter);
        odfTable.render((Node)officeText, taskInfos, columnSortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_BUEK_Aufgaben_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Aufgaben";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private FancyOdfTable<PlanningNotificationTaskInfo> constructPlanningNotificationTaskTable(final ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final String dataCellStyle, final String dataTextStyle, final String dataBoldTextStyle, final String dataBoldRedTextStyle, String dataItalicTextStyle, String dataCaptionTextStyle, String dataRedTextStyle, Map<String, Double> relativeColumnWidths) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("task", resourceBundle.getString("planningNotificationTaskTaskColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo taskInfo) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                PlanningNotificationTaskJoin taskJoin = taskInfo.getTaskJoin();
                Organisation organisation = taskJoin.getOrganisation();
                Person person = taskJoin.getPerson();
                String taskName = taskJoin.getWorkflowNodeTemplateName();
                String reviewerName = PersonHelper.getOrganisationAndInverseCommonName(organisation, person);
                String baulosString = "";
                List baulosMetaInformations = taskInfo.getWorkflowNodePositionBaulose();
                if (baulosMetaInformations != null && baulosMetaInformations.size() > 0) {
                    for (int n = 0; n < baulosMetaInformations.size(); ++n) {
                        baulosString = baulosString + ((PlanningNotificationTextMetaInformation)baulosMetaInformations.get(n)).getValue();
                        if (n >= baulosMetaInformations.size() - 1) continue;
                        baulosString = baulosString + ", ";
                    }
                }
                TextPElement taskNamePElement = TextFactory.constructTextNode((Node)cellElement, (String)"", null);
                PlanningNotificationTaskListExporter.constructTextSpanNode((Node)taskNamePElement, taskName, dataBoldTextStyle);
                TextFactory.constructTextNode((Node)cellElement, (String)reviewerName, (String)dataTextStyle);
                if (baulosString.length() > 0) {
                    TextFactory.constructTextNode((Node)cellElement, (String)(" [" + baulosString + "]"), (String)dataTextStyle);
                }
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                PlanningNotificationTaskJoin taskJoin = taskInfo.getTaskJoin();
                Organisation organisation = taskJoin.getOrganisation();
                Person person = taskJoin.getPerson();
                String taskName = taskJoin.getWorkflowNodeTemplateName();
                String reviewerName = PersonHelper.getOrganisationAndInverseCommonName(organisation, person);
                String baulosString = "";
                List baulosMetaInformations = taskInfo.getWorkflowNodePositionBaulose();
                if (baulosMetaInformations != null && baulosMetaInformations.size() > 0) {
                    for (int n = 0; n < baulosMetaInformations.size(); ++n) {
                        baulosString = baulosString + ((PlanningNotificationTextMetaInformation)baulosMetaInformations.get(n)).getValue();
                        if (n >= baulosMetaInformations.size() - 1) continue;
                        baulosString = baulosString + ", ";
                    }
                }
                return (taskName != null ? taskName : "---") + (reviewerName != null ? reviewerName : "---") + (baulosString.length() > 0 ? " [" + baulosString + "]" : "");
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                return this.getOutput(taskInfo).toLowerCase().contains(filter.toLowerCase());
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("tokenInitiator", resourceBundle.getString("workflowActivityResultTokenInitiatorColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                PlanningNotificationTaskJoin taskJoin = taskInfo.getTaskJoin();
                if (!taskJoin.getInitiatorWorkflowNodePositionId().equals(taskJoin.getWorkflowTokenOwnerPositionId())) {
                    Person person = taskJoin.getInitiatorPerson();
                    Organisation organisation = taskJoin.getInitiatorOrganisation();
                    String initiatorName = PersonHelper.getOrganisationAndInverseCommonName(organisation, person);
                    String initiatorBaulosString = "";
                    List initiatorBaulosMetaInformations = taskInfo.getWorkflowNodeInitiatorPositionBaulose();
                    if (initiatorBaulosMetaInformations != null && initiatorBaulosMetaInformations.size() > 0) {
                        for (int n = 0; n < initiatorBaulosMetaInformations.size(); ++n) {
                            initiatorBaulosString = initiatorBaulosString + ((PlanningNotificationTextMetaInformation)initiatorBaulosMetaInformations.get(n)).getValue();
                            if (n >= initiatorBaulosMetaInformations.size() - 1) continue;
                            initiatorBaulosString = initiatorBaulosString + ", ";
                        }
                    }
                    String tokenInitiatorStringWithMarkup = initiatorName + (initiatorBaulosString.length() > 0 ? " [" + initiatorBaulosString + "]" : "");
                    return tokenInitiatorStringWithMarkup;
                }
                return "-";
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("serialNumber", resourceBundle.getString("planningNotificationOrderSerialNumberColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getTaskJoin().getPlanningNotificationOrderSerialNumber(), (Long)dataTwo.getTaskJoin().getPlanningNotificationOrderSerialNumber(), (boolean)descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                Long serialNumber = taskInfo.getTaskJoin().getPlanningNotificationOrderSerialNumber();
                return serialNumber != null ? serialNumber.toString() : "";
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                return this.getOutput(taskInfo).contains(filter);
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("text", resourceBundle.getString("planningNotificationOrderTextColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getPlanningNotificationOrderText();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("planningNotification", resourceBundle.getString("planningNotificationOrderPlanningNotificationColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getPlanningNotificationTitle();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("baulos", resourceBundle.getString("planningNotificationOrderBaulosColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                String baulosString = "";
                List baulosMetaInformations = taskInfo.getPlanningNotificationBaulose();
                if (baulosMetaInformations != null && baulosMetaInformations.size() > 0) {
                    Collections.sort(baulosMetaInformations, new Comparator<PlanningNotificationTextMetaInformation>(){

                        @Override
                        public int compare(PlanningNotificationTextMetaInformation referenceInfoOne, PlanningNotificationTextMetaInformation referenceInfoTwo) {
                            return referenceInfoOne.getValue().compareTo(referenceInfoTwo.getValue());
                        }
                    });
                    for (int n = 0; n < baulosMetaInformations.size(); ++n) {
                        baulosString = baulosString + ((PlanningNotificationTextMetaInformation)baulosMetaInformations.get(n)).getValue();
                        if (n >= baulosMetaInformations.size() - 1) continue;
                        baulosString = baulosString + ", ";
                    }
                }
                return baulosString.length() > 0 ? baulosString : "";
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("project", resourceBundle.getString("planningNotificationOrderProjectColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo taskInfo) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                TextPElement textPElement = (TextPElement)((OdfFileDom)cellElement.getOwnerDocument()).newOdfElement(TextPElement.class);
                textPElement.setTextStyleNameAttribute(dataTextStyle);
                cellElement.appendChild((Node)textPElement);
                List projects = taskInfo.getProjects();
                for (int n = 0; n < projects.size(); ++n) {
                    Project project = (Project)projects.get(n);
                    PlanningNotificationTaskListExporter.constructTextSpanNode((Node)textPElement, "(" + project.getCode() + ")", dataBoldTextStyle);
                    PlanningNotificationTaskListExporter.constructTextSpanNode((Node)textPElement, " " + project.getName(), null);
                }
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                String projectString = "";
                List projects = taskInfo.getProjects();
                for (int n = 0; n < projects.size(); ++n) {
                    projectString = projectString + ((Project)projects.get(n)).getCode() + " " + ((Project)projects.get(n)).getName() + (n < projects.size() - 1 ? ", " : "");
                }
                return projectString;
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("subjectArea", resourceBundle.getString("planningNotificationOrderSubjectAreaColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getSubjectAreaName();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("authorizedInspector", resourceBundle.getString("planningNotificationOrderAuthorizedInspectorColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getPlanningNotificationOrderAuthorizedInspector();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("reference", resourceBundle.getString("planningNotificationOrderReferenceColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                List referenceInfos = taskInfo.getReferenceInfos();
                return PlanningExportHelper.getReferenceOutput(referenceInfos);
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("statutoryDuty", resourceBundle.getString("planningNotificationOrderStatutoryDutyColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getStatutoryDutyName();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("documentPosition", resourceBundle.getString("planningNotificationOrderDocumentPositionColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getPlanningNotificationOrderDocumentPosition();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("documentPage", resourceBundle.getString("planningNotificationOrderDocumentPageColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getPlanningNotificationOrderDocumentPage();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("personInCharge", resourceBundle.getString("planningNotificationOrderPersonInChargeColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getPersonInChargeName();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("dueDate", resourceBundle.getString("planningNotificationTaskDueDateColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                PlanningNotificationTaskJoin taskJoin = data.getTaskJoin();
                Double optionalDueDate = taskJoin.getInitiatorWorkflowNodePositionOptionalDueDate();
                String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                if (optionalDueDate != null) {
                    String optionalDueDateString = DateHelper.formatUtcSeconds(optionalDueDate, "Europe/Vienna", dateFormatPattern);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataBoldRedTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{optionalDueDateString});
                } else {
                    Double dueDate = taskJoin.getInitiatorWorkflowNodePositionDueDate();
                    if (dueDate != null) {
                        String dueDateString = DateHelper.formatUtcSeconds(dueDate, "Europe/Vienna", dateFormatPattern);
                        TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{dueDateString});
                    } else {
                        String dueDateRemark = CodeHelper.getI18nDueDateRemark(resourceBundle, taskJoin.getInitiatorWorkflowNodePositionDueDateRemark());
                        TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{dueDateRemark});
                    }
                }
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getSortString(dataOne), (String)this.getSortString(dataTwo), (boolean)descending);
            }

            private String getSortString(PlanningNotificationTaskInfo taskInfo) {
                PlanningNotificationTaskJoin taskJoin = taskInfo.getTaskJoin();
                Double optionalDueDate = taskJoin.getInitiatorWorkflowNodePositionOptionalDueDate();
                String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                if (optionalDueDate != null) {
                    String optionalDueDateString = DateHelper.formatUtcSeconds(optionalDueDate, "Europe/Vienna", dateFormatPattern);
                    return optionalDueDateString;
                }
                Double dueDate = taskJoin.getInitiatorWorkflowNodePositionDueDate();
                if (dueDate != null) {
                    String dueDateString = DateHelper.formatUtcSeconds(dueDate, "Europe/Vienna", dateFormatPattern);
                    return dueDateString;
                }
                String dueDateRemark = CodeHelper.getI18nDueDateRemark(resourceBundle, taskJoin.getInitiatorWorkflowNodePositionDueDateRemark());
                return dueDateRemark;
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getSortString(taskInfo);
                return output != null ? output.contains(filter) : false;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationTaskInfo>("state", resourceBundle.getString("planningNotificationTaskStateColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationTaskInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationTaskInfo dataOne, PlanningNotificationTaskInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationTaskInfo taskInfo) {
                return taskInfo.getTaskJoin().getWorkflowEntityStatusName();
            }

            public boolean filter(PlanningNotificationTaskInfo taskInfo, String filter) {
                String output = this.getOutput(taskInfo);
                return output != null ? output.toLowerCase().contains(filter.toLowerCase()) : false;
            }
        });
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private List<ColumnSortSpec> translateSortColumns(List<ColumnSortSpec> columnSortSpecs) {
        ArrayList<ColumnSortSpec> newColumnSortSpecs = new ArrayList<ColumnSortSpec>();
        for (ColumnSortSpec columnSortSpec : columnSortSpecs) {
            String property = columnSortSpec.getProperty();
            Boolean descending = columnSortSpec.getDescending();
            if ("_taskString".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("task", descending));
                continue;
            }
            if ("_tokenInitiator".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("tokenInitiator", descending));
                continue;
            }
            if ("planningNotificationOrderSerialNumber".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("serialNumber", descending));
                continue;
            }
            if ("planningNotificationOrderText".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("text", descending));
                continue;
            }
            if ("_planningNotification".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("planningNotification", descending));
                continue;
            }
            if ("_baulos".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("baulos", descending));
                continue;
            }
            if ("_projectString".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("project", descending));
                continue;
            }
            if ("subjectAreaName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("subjectArea", descending));
                continue;
            }
            if ("planningNotificationOrderAuthorizedInspector".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("authorizedInspector", descending));
                continue;
            }
            if ("_reference".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("reference", descending));
                continue;
            }
            if ("statutoryDutyName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDuty", descending));
                continue;
            }
            if ("planningNotificationOrderDocumentPosition".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentPosition", descending));
                continue;
            }
            if ("planningNotificationOrderDocumentPage".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentPage", descending));
                continue;
            }
            if ("personInChargeName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("personInCharge", descending));
                continue;
            }
            if ("_dueDateString".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("dueDate", descending));
                continue;
            }
            if ("workflowEntityStatusName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("state", descending));
                continue;
            }
            log.warn("Unknown column [" + property + "] delivered from client.");
        }
        return newColumnSortSpecs;
    }

    private static TextSpanElement constructTextSpanNode(Node parentNode, String textContent, String textStyle) {
        TextSpanElement textElement = (TextSpanElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        if (textContent != null) {
            textElement.setTextContent(textContent);
        }
        if (textStyle != null) {
            textElement.setTextStyleNameAttribute(textStyle);
        }
        parentNode.appendChild((Node)textElement);
        return textElement;
    }
}

