/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.dto.ReviewTask;
import at.cdes.api.dto.ReviewTaskPositionMap;
import at.cdes.impl.dao.GenReviewTaskPositionMapDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcReviewTaskPositionMapDAO
extends AbstrIdDAO<ReviewTaskPositionMap>
implements GenReviewTaskPositionMapDAO {
    public AbstractJdbcReviewTaskPositionMapDAO() {
        super(ReviewTaskPositionMap.class, "reviewTaskId", "review_task_position_map", new String[]{"review_task_id", "review_cycle_node_position_released_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcReviewTaskPositionMapDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_task_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_node_position_released_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcReviewTaskPositionMapDAO.getSelectClauseForDto("review_task_position_map", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcReviewTaskPositionMapDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".review_task_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_task_id") + "," + entityLocalName + ".review_cycle_node_position_released_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_node_position_released_id") + " ";
    }

    protected ReviewTaskPositionMap fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ReviewTaskPositionMap reviewTaskPositionMap = new ReviewTaskPositionMap();
        reviewTaskPositionMap.setReviewTaskId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        reviewTaskPositionMap.setReviewCycleNodePositionReleasedId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return reviewTaskPositionMap;
    }

    public static ReviewTaskPositionMap fillReviewTaskPositionMapFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ReviewTaskPositionMap reviewTaskPositionMap = new ReviewTaskPositionMap();
        reviewTaskPositionMap.setReviewTaskId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        reviewTaskPositionMap.setReviewCycleNodePositionReleasedId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return reviewTaskPositionMap;
    }

    public static ReviewTaskPositionMap fillReviewTaskPositionMapFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcReviewTaskPositionMapDAO.fillReviewTaskPositionMapFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByTask(final Long reviewTaskId) {
        String sql = "DELETE FROM review_task_position_map WHERE review_task_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, reviewTaskId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByNodePositionReleasedId(final Long reviewCycleNodePositionReleasedId) {
        String sql = "DELETE FROM review_task_position_map WHERE review_cycle_node_position_released_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, reviewCycleNodePositionReleasedId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteInstance(final Long reviewTaskId, final Long reviewCycleNodePositionReleasedId) {
        String sql = "DELETE FROM review_task_position_map WHERE review_task_id = ? AND review_cycle_node_position_released_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, reviewTaskId);
                statement.setLong(currIndex++, reviewCycleNodePositionReleasedId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(ReviewTaskPositionMap dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ReviewTaskPositionMap> dtos) {
        Iterator<ReviewTaskPositionMap> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ReviewTaskPositionMap reviewTaskPositionMap) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)reviewTaskPositionMap.getReviewTaskId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)reviewTaskPositionMap.getReviewCycleNodePositionReleasedId());
    }

    @Override
    public List<ReviewTaskPositionMap> getByReviewTask(ReviewTask reviewTask) {
        return this.getByReviewTask(reviewTask.getTaskId());
    }

    @Override
    public List<ReviewTaskPositionMap> getByReviewTask(final Long reviewTaskId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_task_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, reviewTaskId);
            }
        });
    }

    @Override
    public List<ReviewTaskPositionMap> getByReviewCycleNodePositionReleased(ReviewCycleNodePositionReleased reviewCycleNodePositionReleased) {
        return this.getByReviewCycleNodePositionReleased(reviewCycleNodePositionReleased.getId());
    }

    @Override
    public List<ReviewTaskPositionMap> getByReviewCycleNodePositionReleased(final Long reviewCycleNodePositionReleasedId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_node_position_released_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, reviewCycleNodePositionReleasedId);
            }
        });
    }

    @Override
    public List<ReviewTaskPositionMap> getByReviewTasks(Collection<Long> reviewTaskId) {
        if (reviewTaskId.isEmpty()) {
            return new ArrayList<ReviewTaskPositionMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[reviewTaskId.size()];
        int n = 0;
        Iterator<Long> it = reviewTaskId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_task_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ReviewTaskPositionMap> getByReviewCycleNodePositionReleaseds(Collection<Long> reviewCycleNodePositionReleasedId) {
        if (reviewCycleNodePositionReleasedId.isEmpty()) {
            return new ArrayList<ReviewTaskPositionMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[reviewCycleNodePositionReleasedId.size()];
        int n = 0;
        Iterator<Long> it = reviewCycleNodePositionReleasedId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_node_position_released_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

