/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.OriginalDocumentOrder;
import at.cdes.api.dto.ReceivedOriginalDocumentOrderStep;
import at.cdes.impl.dao.ReceivedOriginalDocumentOrderStepDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcReceivedOriginalDocumentOrderStepDAO
extends AbstrIdDAO<ReceivedOriginalDocumentOrderStep>
implements ReceivedOriginalDocumentOrderStepDAO {
    public JdbcReceivedOriginalDocumentOrderStepDAO() {
        super(ReceivedOriginalDocumentOrderStep.class, "orderId", "received_original_document_order_step", new String[]{"order_id", "order_step_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcReceivedOriginalDocumentOrderStepDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcReceivedOriginalDocumentOrderStepDAO.getSelectClauseForDto("received_original_document_order_step", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcReceivedOriginalDocumentOrderStepDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".order_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_id") + "," + entityLocalName + ".order_step_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + " ";
    }

    protected ReceivedOriginalDocumentOrderStep fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ReceivedOriginalDocumentOrderStep receivedOriginalDocumentOrderStep = new ReceivedOriginalDocumentOrderStep();
        receivedOriginalDocumentOrderStep.setOrderId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        receivedOriginalDocumentOrderStep.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return receivedOriginalDocumentOrderStep;
    }

    public static ReceivedOriginalDocumentOrderStep fillReceivedOriginalDocumentOrderStepFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ReceivedOriginalDocumentOrderStep receivedOriginalDocumentOrderStep = new ReceivedOriginalDocumentOrderStep();
        receivedOriginalDocumentOrderStep.setOrderId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        receivedOriginalDocumentOrderStep.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return receivedOriginalDocumentOrderStep;
    }

    public static ReceivedOriginalDocumentOrderStep fillReceivedOriginalDocumentOrderStepFromResultSet(ResultSet rs) throws SQLException {
        return JdbcReceivedOriginalDocumentOrderStepDAO.fillReceivedOriginalDocumentOrderStepFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByOrder(final Long orderId) {
        String sql = "DELETE FROM received_original_document_order_step WHERE order_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, orderId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(ReceivedOriginalDocumentOrderStep dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ReceivedOriginalDocumentOrderStep> dtos) {
        Iterator<ReceivedOriginalDocumentOrderStep> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ReceivedOriginalDocumentOrderStep receivedOriginalDocumentOrderStep) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)receivedOriginalDocumentOrderStep.getOrderId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)receivedOriginalDocumentOrderStep.getOrderStepId());
    }

    @Override
    public List<ReceivedOriginalDocumentOrderStep> getByOrder(OriginalDocumentOrder originalDocumentOrder) {
        return this.getByOrder(originalDocumentOrder.getId());
    }

    @Override
    public List<ReceivedOriginalDocumentOrderStep> getByOrder(final Long originalDocumentOrderId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, originalDocumentOrderId);
            }
        });
    }

    @Override
    public List<ReceivedOriginalDocumentOrderStep> getByOrderStep(OrderStep orderStep) {
        return this.getByOrderStep(orderStep.getId());
    }

    @Override
    public List<ReceivedOriginalDocumentOrderStep> getByOrderStep(final Long orderStepId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, orderStepId);
            }
        });
    }

    @Override
    public List<ReceivedOriginalDocumentOrderStep> getByOrders(Collection<Long> originalDocumentOrderId) {
        if (originalDocumentOrderId.isEmpty()) {
            return new ArrayList<ReceivedOriginalDocumentOrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[originalDocumentOrderId.size()];
        int n = 0;
        Iterator<Long> it = originalDocumentOrderId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ReceivedOriginalDocumentOrderStep> getByOrderSteps(Collection<Long> orderStepId) {
        if (orderStepId.isEmpty()) {
            return new ArrayList<ReceivedOriginalDocumentOrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[orderStepId.size()];
        int n = 0;
        Iterator<Long> it = orderStepId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

