/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkType;
import at.cdes.api.dto.PersonInCharge;
import at.cdes.impl.dao.PersonInChargeDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcPersonInChargeDAO
extends AbstrIdDAO<PersonInCharge>
implements PersonInChargeDAO {
    public JdbcPersonInChargeDAO() {
        super(PersonInCharge.class, "id", "person_in_charge", new String[]{"id", "name", "description", "network_id", "network_type_id", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcPersonInChargeDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcPersonInChargeDAO.getSelectClauseForDto("person_in_charge", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcPersonInChargeDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".network_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected PersonInCharge fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        PersonInCharge personInCharge = new PersonInCharge();
        personInCharge.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        personInCharge.setName(rs.getString(++columnIndex));
        personInCharge.setDescription(rs.getString(++columnIndex));
        personInCharge.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        personInCharge.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        personInCharge.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        personInCharge.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        personInCharge.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return personInCharge;
    }

    public static PersonInCharge fillPersonInChargeFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        PersonInCharge personInCharge = new PersonInCharge();
        personInCharge.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        personInCharge.setName(rs.getString(columnIndex.incrementAndGet()));
        personInCharge.setDescription(rs.getString(columnIndex.incrementAndGet()));
        personInCharge.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        personInCharge.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        personInCharge.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        personInCharge.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        personInCharge.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return personInCharge;
    }

    public static PersonInCharge fillPersonInChargeFromResultSet(ResultSet rs) throws SQLException {
        return JdbcPersonInChargeDAO.fillPersonInChargeFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 8;
    }

    @Override
    public void deleteByNetworkId(final Long networkId) {
        String sql = "DELETE FROM person_in_charge WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(PersonInCharge dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<PersonInCharge> dtos) {
        Iterator<PersonInCharge> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, PersonInCharge personInCharge) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)personInCharge.getId());
        statement.setString(2, personInCharge.getName());
        statement.setString(3, personInCharge.getDescription());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)personInCharge.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)personInCharge.getNetworkTypeId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)(personInCharge.getCreateTrx() != null ? personInCharge.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)System.currentTimeMillis());
    }

    @Override
    public List<PersonInCharge> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<PersonInCharge> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<PersonInCharge> getByNetworkType(NetworkType networkType) {
        return this.getByNetworkType(networkType.getId());
    }

    @Override
    public List<PersonInCharge> getByNetworkType(final Long networkTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkTypeId);
            }
        });
    }

    @Override
    public List<PersonInCharge> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<PersonInCharge>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<PersonInCharge> getByNetworkTypes(Collection<Long> networkTypeId) {
        if (networkTypeId.isEmpty()) {
            return new ArrayList<PersonInCharge>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkTypeId.size()];
        int n = 0;
        Iterator<Long> it = networkTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

