/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.compositeDto.PlanningNotificationInfo;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.MetaTag;
import at.cdes.api.dto.Project;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.MetaTagDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.export.planning.PlanningExportHelper;
import at.cdes.impl.export.planning.PlanningReviewProtocolExporter;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PlanningNotificationListExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private MetaTagDAO metaTagDAO;
    private OOoFileEngine oooFileEngine = null;
    private String tempDirName;
    private PersonVariablesDAO personVariablesDAO;
    private static final Logger log = LoggerFactory.getLogger(PlanningNotificationListExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setMetaTagDAO(MetaTagDAO metaTagDAO) {
        this.metaTagDAO = metaTagDAO;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public ScratchFile export(List<PlanningNotificationInfo> planningNotificationInfos, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        ResourceBundle resourceBundle = OdfHelper.getResourceBundleByPrincipal(this.personVariablesDAO);
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        ClassLoader classLoader = PlanningReviewProtocolExporter.class.getClassLoader();
        URL logoUrl = classLoader.getResource("export/logos/OeBB_INFRA_black_eps_small.png");
        URI logoUri = logoUrl.toURI();
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String emptyParagraphStyle = stylesOfficeStyles.getParagraphStyleWithClass("text", new OdfStylePropertiesBase[0]);
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("planningNotificationListFooterGeneratedString");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw, null, null, resourceBundle);
        TextHElement textHElement = officeText.newTextHElement(2);
        textHElement.setTextContent(resourceBundle.getString("planningNotificationListExportCaption"));
        officeText.newTextPElement();
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold")});
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000")});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        List metaTags = this.metaTagDAO.getAll();
        HashMap<Long, MetaTag> idToMetaTag = new HashMap<Long, MetaTag>();
        for (MetaTag metaTag : metaTags) {
            idToMetaTag.put(metaTag.getId(), metaTag);
        }
        columnSortSpecs = this.translateSortColumns(columnSortSpecs, idToMetaTag);
        FancyOdfTable<PlanningNotificationInfo> odfTable = this.constructPlanningNotificationTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, columnToWidth, metaTags);
        odfTable.setDataRowStyle(dataRowStyle);
        odfTable.render((Node)officeText, planningNotificationInfos, columnSortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_BUEK_Bescheide_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private FancyOdfTable<PlanningNotificationInfo> constructPlanningNotificationTable(final ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final String dataCellStyle, final String dataTextStyle, Map<String, Double> relativeColumnWidths, List<MetaTag> metaTags) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<PlanningNotificationInfo>("title", resourceBundle.getString("planningNotificationListTitleColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationInfo data) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, data.getPlanningNotification().getTitle());
            }

            public int compare(PlanningNotificationInfo dataOne, PlanningNotificationInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, dataOne.getPlanningNotification().getTitle(), dataTwo.getPlanningNotification().getTitle(), descending);
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationInfo>("notificationComment", resourceBundle.getString("planningNotificationListCommentColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationInfo data) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, data.getPlanningNotification().getComment());
            }

            public int compare(PlanningNotificationInfo dataOne, PlanningNotificationInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, dataOne.getPlanningNotification().getComment(), dataTwo.getPlanningNotification().getComment(), descending);
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationInfo>("project", resourceBundle.getString("planningNotificationListProjectColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationInfo data) {
                TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])this.getProjectStrings(data));
            }

            public int compare(PlanningNotificationInfo dataOne, PlanningNotificationInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getProjectStrings(dataOne), this.getProjectStrings(dataTwo), descending);
            }

            private String[] getProjectStrings(PlanningNotificationInfo data) {
                List projects = data.getProjects();
                String[] projectNames = new String[2 * projects.size()];
                for (int n = 0; n < projects.size(); ++n) {
                    projectNames[2 * n] = "(" + ((Project)projects.get(n)).getCode() + ")";
                    projectNames[2 * n + 1] = ((Project)projects.get(n)).getName();
                }
                return projectNames;
            }
        });
        Collections.sort(metaTags, new Comparator<MetaTag>(){

            @Override
            public int compare(MetaTag metaTagOne, MetaTag metaTagTwo) {
                return metaTagOne.getPosition() - metaTagTwo.getPosition();
            }
        });
        for (final MetaTag metaTag : metaTags) {
            String metaName = metaTag.getName().replaceAll("\\s", "");
            columns.add(new FancyOdfTableColumn<PlanningNotificationInfo>(metaTag.getCssClass(), resourceBundle.getString("planningNotificationMetaTag_" + metaName)){

                public void appendCell(TableTableRowElement rowElement, PlanningNotificationInfo data) {
                    List<String> tokens = this.getTokens(data);
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, tokens);
                }

                public int compare(PlanningNotificationInfo dataOne, PlanningNotificationInfo dataTwo, boolean descending) {
                    return CompareHelper.defaultStringCompare(collator, this.getTokens(dataOne), this.getTokens(dataTwo), descending);
                }

                private List<String> getTokens(PlanningNotificationInfo data) {
                    return PlanningExportHelper.getMetaTagTokens(resourceBundle, metaTag, data.getMetaTagIdToTextMetaInformations(), data.getMetaTagIdToDateMetaInformations());
                }
            });
        }
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private List<ColumnSortSpec> translateSortColumns(List<ColumnSortSpec> columnSortSpecs, Map<Long, MetaTag> idToMetaTag) {
        ArrayList<ColumnSortSpec> newColumnSortSpecs = new ArrayList<ColumnSortSpec>();
        for (ColumnSortSpec columnSortSpec : columnSortSpecs) {
            String property = columnSortSpec.getProperty();
            Boolean descending = columnSortSpec.getDescending();
            if ("_planningNotificationTitle".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("title", descending));
                continue;
            }
            if ("_planningNotificationComment".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("comment", descending));
                continue;
            }
            if ("_project".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("project", descending));
                continue;
            }
            if (property.startsWith("_metaTag")) {
                MetaTag metaTag;
                Long metaTagId;
                String idString = property.substring("_metaTag".length());
                try {
                    metaTagId = Long.parseLong(idString);
                }
                catch (NumberFormatException e) {
                    metaTagId = null;
                }
                if (metaTagId == null || (metaTag = idToMetaTag.get(metaTagId)) == null || metaTag.getCssClass() == null) continue;
                newColumnSortSpecs.add(new ColumnSortSpec(metaTag.getCssClass(), descending));
                continue;
            }
            log.warn("Unknown column [" + property + "] delivered from client.");
        }
        return newColumnSortSpecs;
    }
}

