/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec.login;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.api.sec.PasswordStatusChecker;
import at.cdes.api.sec.UserPolicyStatus;
import at.cdes.api.sec.UserPolicyStatusChecker;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.util.PasswordUtil;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.clazzes.util.sec.DomainGroup;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdesLoginService
implements DomainPasswordLoginService {
    private Logger log = LoggerFactory.getLogger(CdesLoginService.class);
    private PersonDAO personDAO;
    private PersonVariablesDAO personVariablesDAO;
    private Long passwordMaxAge;
    private PasswordStatusChecker passwordStatusChecker;
    private UserPolicyStatusChecker userPolicyStatusChecker;
    private Set<String> suPrincipals;

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setPasswordMaxAge(Long passwordMaxAge) {
        this.passwordMaxAge = passwordMaxAge;
    }

    public void setPasswordStatusChecker(PasswordStatusChecker passwordStatusChecker) {
        this.passwordStatusChecker = passwordStatusChecker;
    }

    public void setUserPolicyStatusChecker(UserPolicyStatusChecker userPolicyStatusChecker) {
        this.userPolicyStatusChecker = userPolicyStatusChecker;
    }

    public void setSuPrincipal(String suPrincipalString) {
        this.suPrincipals = new HashSet<String>();
        if (suPrincipalString != null) {
            String[] suPrincipals;
            for (String suPrincipal : suPrincipals = suPrincipalString.split(",")) {
                if (suPrincipal == null) continue;
                this.suPrincipals.add(suPrincipal.trim());
            }
        }
    }

    public int getSupportedFeatures(String domain) {
        int features = 0;
        return features;
    }

    public String getDefaultDomain() {
        return "CDES";
    }

    public List<String> getDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("CDES");
        return domains;
    }

    public DomainPrincipal tryLogin(String domain, String username, String password) {
        boolean suPrincipal;
        PersonVariables personVariables;
        Person person = this.personDAO.getPerson(username);
        if (person == null) {
            throw new SecurityException("Did not find user [" + username + "]");
        }
        List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(person);
        PersonVariables personVariables2 = personVariables = personVariablesList.size() > 0 ? personVariablesList.get(0) : null;
        if (this.passwordStatusChecker.checkPasswordStatus(person.getId(), null) == PasswordStatus.EXPIRED) {
            throw new SecurityException("Password has expired.");
        }
        if (this.userPolicyStatusChecker.checkStatus(person.getId()) == UserPolicyStatus.EXPIRED) {
            throw new SecurityException("User policy has expired.");
        }
        boolean ok = PasswordUtil.checkPassword(person.getPassword(), password);
        if (!ok) {
            throw new SecurityException("Passwords did not match for username [" + username + "].");
        }
        boolean validCertificate = false;
        boolean expiredCertificate = true;
        long now = System.currentTimeMillis();
        List<Certificate> certificates = this.personDAO.getCertificatesByPerson(person.getId(), false);
        for (Certificate certificate : certificates) {
            if (certificate.getPrivateKey() == null || !certificate.isMayLogin().booleanValue() || !certificate.isMaySign().booleanValue() || !(validCertificate = true) || certificate.getCertValidTo() == null || (long)(certificate.getCertValidTo() * 1000.0) <= now) continue;
            expiredCertificate = false;
            break;
        }
        if (!validCertificate) {
            throw new RuntimeException(new CertificateNotYetValidException("User [" + username + "] has no valid certificate."));
        }
        if (expiredCertificate) {
            throw new RuntimeException(new CertificateExpiredException("User [" + username + "] has a valid but expired certificate."));
        }
        String userWithDomain = "CDES/" + username;
        boolean bl = suPrincipal = this.suPrincipals != null && this.suPrincipals.contains(userWithDomain);
        if (this.log.isDebugEnabled()) {
            if (suPrincipal) {
                this.log.debug("Successful login as suPrincipal [" + userWithDomain + "]");
            } else {
                this.log.debug("Successful login as ordinary user [" + userWithDomain + "]");
            }
        }
        CdesPrincipal principal = new CdesPrincipal(person, personVariables, Boolean.valueOf(suPrincipal));
        return principal;
    }

    public void changePassword(String domain, String username, String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public void sendPassword(String domain, String username) {
        throw new UnsupportedOperationException();
    }

    public DomainPrincipal searchUser(String domain, String username) {
        throw new UnsupportedOperationException();
    }

    public void deactivateUser(String domain, String username, String reason) {
        throw new UnsupportedOperationException();
    }

    public List<DomainGroup> getGroups(String domain, String userName) {
        throw new UnsupportedOperationException();
    }

    public List<DomainPrincipal> getGroupMembers(String domain, String groupName) {
        throw new UnsupportedOperationException();
    }
}

