/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Country;
import at.cdes.impl.dao.CountryDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcCountryDAO
extends AbstrIdDAO<Country>
implements CountryDAO {
    public JdbcCountryDAO() {
        super(Country.class, "id", "countries", new String[]{"id", "code2", "code3", "desc_en", "desc_de"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcCountryDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code2") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code3") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "desc_en") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "desc_de") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcCountryDAO.getSelectClauseForDto("countries", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcCountryDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".code2" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code2") + "," + entityLocalName + ".code3" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code3") + "," + entityLocalName + ".desc_en" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "desc_en") + "," + entityLocalName + ".desc_de" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "desc_de") + " ";
    }

    protected Country fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Country country = new Country();
        country.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        country.setCode2(rs.getString(++columnIndex));
        country.setCode3(rs.getString(++columnIndex));
        country.setDescEn(rs.getString(++columnIndex));
        country.setDescDe(rs.getString(++columnIndex));
        return country;
    }

    public static Country fillCountryFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Country country = new Country();
        country.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        country.setCode2(rs.getString(columnIndex.incrementAndGet()));
        country.setCode3(rs.getString(columnIndex.incrementAndGet()));
        country.setDescEn(rs.getString(columnIndex.incrementAndGet()));
        country.setDescDe(rs.getString(columnIndex.incrementAndGet()));
        return country;
    }

    public static Country fillCountryFromResultSet(ResultSet rs) throws SQLException {
        return JdbcCountryDAO.fillCountryFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    public int update(Country dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Country> dtos) {
        Iterator<Country> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Country country) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)country.getId());
        statement.setString(2, country.getCode2());
        statement.setString(3, country.getCode3());
        statement.setString(4, country.getDescEn());
        statement.setString(5, country.getDescDe());
    }
}

