/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkOrganisation;
import at.cdes.api.dto.Organisation;
import at.cdes.impl.dao.NetworkOrganisationDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcNetworkOrganisationDAO
extends AbstrIdDAO<NetworkOrganisation>
implements NetworkOrganisationDAO {
    public JdbcNetworkOrganisationDAO() {
        super(NetworkOrganisation.class, "organisationId", "network_organisation", new String[]{"organisation_id", "network_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcNetworkOrganisationDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcNetworkOrganisationDAO.getSelectClauseForDto("network_organisation", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcNetworkOrganisationDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".organisation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_id") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    protected NetworkOrganisation fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        NetworkOrganisation networkOrganisation = new NetworkOrganisation();
        networkOrganisation.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkOrganisation.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return networkOrganisation;
    }

    public static NetworkOrganisation fillNetworkOrganisationFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        NetworkOrganisation networkOrganisation = new NetworkOrganisation();
        networkOrganisation.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        networkOrganisation.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return networkOrganisation;
    }

    public static NetworkOrganisation fillNetworkOrganisationFromResultSet(ResultSet rs) throws SQLException {
        return JdbcNetworkOrganisationDAO.fillNetworkOrganisationFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByOrganisation(final Long organisationId) {
        String sql = "DELETE FROM network_organisation WHERE organisation_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, organisationId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByNetwork(final Long networkId) {
        String sql = "DELETE FROM network_organisation WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(NetworkOrganisation dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<NetworkOrganisation> dtos) {
        Iterator<NetworkOrganisation> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, NetworkOrganisation networkOrganisation) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)networkOrganisation.getOrganisationId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)networkOrganisation.getNetworkId());
    }

    @Override
    public List<NetworkOrganisation> getByOrganisation(Organisation organisation) {
        return this.getByOrganisation(organisation.getId());
    }

    @Override
    public List<NetworkOrganisation> getByOrganisation(final Long organisationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationId);
            }
        });
    }

    @Override
    public List<NetworkOrganisation> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<NetworkOrganisation> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<NetworkOrganisation> getByOrganisations(Collection<Long> organisationId) {
        if (organisationId.isEmpty()) {
            return new ArrayList<NetworkOrganisation>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationId.size()];
        int n = 0;
        Iterator<Long> it = organisationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<NetworkOrganisation> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<NetworkOrganisation>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

