/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.dto.ReviewCycleCellInstance;
import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodePosition;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.impl.reviewCycle.InstanceDurationCalcContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InstanceDurationCalcContextImpl
implements InstanceDurationCalcContext {
    private ReviewCycleInfo cycleInfo;
    private Map<Long, ReviewCycleInstance> idToInstance = new HashMap<Long, ReviewCycleInstance>();
    private Map<Long, ReviewCycleCellInstance> idToCellInstance = new HashMap<Long, ReviewCycleCellInstance>();
    private Map<Long, List<ReviewCycleNodeInstance>> cellInstanceIdToNodeInstances = new HashMap<Long, List<ReviewCycleNodeInstance>>();
    private Map<Long, List<ReviewCycleNodePosition>> nodeInstanceIdToNodePositions = new HashMap<Long, List<ReviewCycleNodePosition>>();

    public InstanceDurationCalcContextImpl(ReviewCycleInfo cycleInfo, ReviewCycleInstance instance, List<ReviewCycleCellInstance> cellInstances, List<ReviewCycleNodeInstance> nodeInstances, List<ReviewCycleNodePosition> nodePositions) {
        this.cycleInfo = cycleInfo;
        this.idToInstance.put(instance.getId(), instance);
        for (ReviewCycleCellInstance cellInstance : cellInstances) {
            this.idToCellInstance.put(cellInstance.getId(), cellInstance);
        }
        for (ReviewCycleNodeInstance nodeInstance : nodeInstances) {
            Long cellInstanceId = nodeInstance.getReviewCycleCellInstanceId();
            if (!this.cellInstanceIdToNodeInstances.containsKey(cellInstanceId)) {
                this.cellInstanceIdToNodeInstances.put(cellInstanceId, new ArrayList());
            }
            this.cellInstanceIdToNodeInstances.get(cellInstanceId).add(nodeInstance);
        }
        for (ReviewCycleNodePosition nodePosition : nodePositions) {
            Long nodeInstanceId = nodePosition.getReviewCycleNodeInstanceId();
            if (!this.nodeInstanceIdToNodePositions.containsKey(nodeInstanceId)) {
                this.nodeInstanceIdToNodePositions.put(nodeInstanceId, new ArrayList());
            }
            this.nodeInstanceIdToNodePositions.get(nodeInstanceId).add(nodePosition);
        }
    }

    @Override
    public ReviewCycleInstance getInstanceById(Long instanceId) {
        return this.idToInstance.get(instanceId);
    }

    @Override
    public ReviewCycleCellInstance getCellInstanceById(Long cellInstanceId) {
        return this.idToCellInstance.get(cellInstanceId);
    }

    @Override
    public boolean isEndNode(Long nodeId) {
        return this.cycleInfo.isEndNode(nodeId);
    }

    @Override
    public ReviewCycleNode getNodeById(Long nodeId) {
        return this.cycleInfo.getNodeById(nodeId);
    }

    @Override
    public ReviewCycleCell getCellById(Long cellId) {
        return this.cycleInfo.getCellById(cellId);
    }

    @Override
    public boolean hasNodePosition(Long nodeInstanceId) {
        return this.nodeInstanceIdToNodePositions.containsKey(nodeInstanceId);
    }

    @Override
    public List<ReviewCycleCellConnection> getLeavingConnectionsForCell(Long cellId) {
        return this.cycleInfo.getLeavingConnectionsForCell(cellId);
    }

    @Override
    public List<ReviewCycleNodeInstance> getNodeInstanceByCellInstanceId(Long cellInstanceId) {
        return this.cellInstanceIdToNodeInstances.containsKey(cellInstanceId) ? this.cellInstanceIdToNodeInstances.get(cellInstanceId) : new ArrayList<ReviewCycleNodeInstance>();
    }

    @Override
    public Collection<ReviewCycleCellInstance> getAllCellInstances() {
        return this.idToCellInstance.values();
    }
}

