/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import at.cdes.impl.planning.PlanningReportResult;
import java.io.File;
import java.util.UUID;
import org.clazzes.util.http.PathGetter;
import org.clazzes.util.sched.IJobStatus;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.clazzes.util.sched.cache.ScratchFile;

public class PathFromJobResultGetter
implements PathGetter {
    private IOneTimeScheduler oneTimeScheduler;

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public String getPath(String jobId) {
        return PathFromJobResultGetter.getPath(this.oneTimeScheduler, jobId);
    }

    public static String getPath(IOneTimeScheduler oneTimeScheduler, String jobId) {
        ScratchFile scratchFile = PathFromJobResultGetter.getFile(oneTimeScheduler, jobId);
        File file = scratchFile != null ? scratchFile.getFile() : null;
        return file != null ? file.getName() : null;
    }

    public static ScratchFile getFile(IOneTimeScheduler oneTimeScheduler, String jobId) {
        UUID jobIdAsUuid = UUID.fromString(jobId);
        IJobStatus jobStatus = oneTimeScheduler.getJobStatus(jobIdAsUuid);
        if (jobStatus != null) {
            Object jobResult = jobStatus.getResult();
            if (jobResult instanceof ScratchFile) {
                ScratchFile scratchFile = (ScratchFile)jobResult;
                return scratchFile;
            }
            if (jobResult instanceof PlanningReportResult) {
                PlanningReportResult result = (PlanningReportResult)jobResult;
                return result.getScratchFile();
            }
            return null;
        }
        return null;
    }
}

