/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.sched.cache.IScratchBucket;
import org.clazzes.util.sched.cache.IScratchFileCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = -4949222700880328195L;
    private static final Logger log = LoggerFactory.getLogger(TempFileUploadServlet.class);
    private String basePath;
    private String formFieldName;
    private IScratchFileCache scratchFileCache;

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setFormFieldName(String formFieldName) {
        this.formFieldName = formFieldName;
    }

    public void setScratchFileCache(IScratchFileCache scratchFileCache) {
        this.scratchFileCache = scratchFileCache;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block5: {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                try {
                    String result = this.handleMultiPartUpload(req);
                    if (result == null) {
                        resp.sendError(500, "Invalid request");
                        break block5;
                    }
                    resp.setDateHeader("Date", System.currentTimeMillis());
                    resp.setContentType("text/html");
                    resp.getWriter().write("<html><body>" + result + "</body></html>");
                }
                catch (FileUploadException e) {
                    resp.sendError(415, "Unsupported Media Type");
                }
            } else {
                log.error("Client sent POST request with wrong mimetype: " + req.getContentType());
                resp.sendError(500);
            }
        }
    }

    private File createResource(InputStream inputStream) throws IOException {
        File outputFile = File.createTempFile("tempUpload", "", new File(this.basePath));
        log.info("Created temp file [" + outputFile.getAbsolutePath() + "], basePath = [" + this.basePath + "]");
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            int n;
            byte[] buf = new byte[16384];
            while ((n = inputStream.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, n);
            }
        }
        return outputFile;
    }

    protected String handleMultiPartUpload(HttpServletRequest req) throws IOException, FileUploadException {
        Map paramMap;
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileIt = upload.getItemIterator(req);
        String allowedDocType = null;
        String qs = req.getQueryString();
        if (qs != null && (paramMap = UrlHelper.parseQuery((String)qs)) != null) {
            allowedDocType = UrlHelper.getStringParameter((Map)paramMap, (String)"allowedDocType");
        }
        while (fileIt.hasNext()) {
            FileItemStream item = fileIt.next();
            if (item.isFormField() || !this.formFieldName.equals(item.getFieldName())) continue;
            InputStream is = null;
            String filename = item.getName();
            if (filename == null || filename.length() == 0) continue;
            is = item.openStream();
            if (log.isDebugEnabled()) {
                log.debug("Processing filename [" + filename + "]");
            }
            File file = this.createResource(is);
            String key = file.getName();
            if (allowedDocType != null && allowedDocType.equals("pdfNoFileAttachment")) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Postprocessing file [" + filename + "]");
                    }
                    int numberOfAnnotation = 0;
                    FileInputStream fis = new FileInputStream(file);
                    PDDocument pdDocument = PDDocument.load((InputStream)fis);
                    List allPages = pdDocument.getDocumentCatalog().getAllPages();
                    for (int i = 0; i < allPages.size(); ++i) {
                        PDPage page = (PDPage)allPages.get(i);
                        List annotations = page.getAnnotations();
                        for (PDAnnotation pdAnnotation : annotations) {
                            String annotationName = pdAnnotation.getAnnotationName();
                            if (!"FileAttachment".equals(pdAnnotation.getSubtype())) continue;
                            ++numberOfAnnotation;
                        }
                    }
                    pdDocument.close();
                    if (numberOfAnnotation > 0) {
                        log.info("file " + filename + " has " + numberOfAnnotation + " annotations of subType " + "FileAttachment" + ", deleting it before throwing up");
                        file.delete();
                        throw new InterruptedIOException();
                    }
                    log.info("file " + filename + " has NO annotations of subType " + "FileAttachment");
                }
                catch (IOException e) {
                    log.info("file " + filename + " is NO valid pdf document");
                    throw new FileUploadException();
                }
            }
            try (IScratchBucket bucket = this.scratchFileCache.getBucket(key);){
                bucket.provideScratchFile(file, null, "inline");
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            return key;
        }
        return null;
    }

    public String getServletInfo() {
        return TempFileUploadServlet.class.getSimpleName();
    }
}

