/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.IReviewCycleNodePosition;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodePosition;
import at.cdes.api.joinDto.RoleConflictJoin;
import at.cdes.impl.dao.GenReviewCycleNodePositionDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcReviewCycleNodePositionDAO
extends AbstrIdDAO<ReviewCycleNodePosition>
implements GenReviewCycleNodePositionDAO {
    public AbstractJdbcReviewCycleNodePositionDAO() {
        super(ReviewCycleNodePosition.class, "id", "review_cycle_node_position", new String[]{"id", "review_cycle_node_instance_id", "project_participation_id", "realm_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcReviewCycleNodePositionDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_node_instance_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "realm_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcReviewCycleNodePositionDAO.getSelectClauseForDto("review_cycle_node_position", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcReviewCycleNodePositionDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".review_cycle_node_instance_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_node_instance_id") + "," + entityLocalName + ".project_participation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + "," + entityLocalName + ".realm_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "realm_id") + " ";
    }

    protected ReviewCycleNodePosition fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ReviewCycleNodePosition reviewCycleNodePosition = new ReviewCycleNodePosition();
        reviewCycleNodePosition.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        reviewCycleNodePosition.setReviewCycleNodeInstanceId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        reviewCycleNodePosition.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        reviewCycleNodePosition.setRealmId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return reviewCycleNodePosition;
    }

    public static ReviewCycleNodePosition fillReviewCycleNodePositionFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ReviewCycleNodePosition reviewCycleNodePosition = new ReviewCycleNodePosition();
        reviewCycleNodePosition.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        reviewCycleNodePosition.setReviewCycleNodeInstanceId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        reviewCycleNodePosition.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        reviewCycleNodePosition.setRealmId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return reviewCycleNodePosition;
    }

    public static ReviewCycleNodePosition fillReviewCycleNodePositionFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcReviewCycleNodePositionDAO.fillReviewCycleNodePositionFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 4;
    }

    public static RoleConflictJoin fillRoleConflictJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        RoleConflictJoin roleConflictJoin = new RoleConflictJoin();
        roleConflictJoin.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setOrganisationName(rs.getString(++columnIndex));
        roleConflictJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setPersonGivenName(rs.getString(++columnIndex));
        roleConflictJoin.setPersonSurName(rs.getString(++columnIndex));
        roleConflictJoin.setProjectParticipantId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setRealmId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setRealmCode(rs.getString(++columnIndex));
        roleConflictJoin.setRealmName(rs.getString(++columnIndex));
        roleConflictJoin.setReviewCycleCellId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setReviewCycleCellName(rs.getString(++columnIndex));
        roleConflictJoin.setReviewCycleInstanceId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setReviewCycleInstanceName(rs.getString(++columnIndex));
        roleConflictJoin.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleConflictJoin.setSubProjectCode(rs.getString(++columnIndex));
        roleConflictJoin.setSubProjectName(rs.getString(++columnIndex));
        roleConflictJoin.setSubProjectNumber(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        return roleConflictJoin;
    }

    public static int getNumberOfRoleConflictJoinAttributes() {
        return 18;
    }

    public static String getSelectClauseForIReviewCycleNodePositionUsingReviewCycleNodePosition() {
        return "review_cycle_node_position.id, review_cycle_node_position.review_cycle_node_instance_id, review_cycle_node_position.project_participation_id, review_cycle_node_position.realm_id ";
    }

    public static String getSelectClauseForIReviewCycleNodePositionUsingAttachedReviewCycleNodePosition() {
        return "attached_review_cycle_node_position.id, attached_review_cycle_node_position.review_cycle_node_instance_id, attached_review_cycle_node_position.project_participation_id, attached_review_cycle_node_position.realm_id ";
    }

    public static String getSelectClauseForIReviewCycleNodePositionUsingReviewCycleNodePositionReleased() {
        return "review_cycle_node_position_released.id, review_cycle_node_position_released.review_cycle_node_instance_id, review_cycle_node_position_released.project_participation_id, review_cycle_node_position_released.realm_id ";
    }

    public static IReviewCycleNodePosition fillIReviewCycleNodePositionFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        IReviewCycleNodePositionImpl iReviewCycleNodePositionImpl = new IReviewCycleNodePositionImpl();
        iReviewCycleNodePositionImpl.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        iReviewCycleNodePositionImpl.setReviewCycleNodeInstanceId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        iReviewCycleNodePositionImpl.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        iReviewCycleNodePositionImpl.setRealmId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return iReviewCycleNodePositionImpl;
    }

    public static int getNumberOfIReviewCycleNodePositionAttributes() {
        return 4;
    }

    @Override
    public void deleteByParticipation(final Long projectParticipationId) {
        String sql = "DELETE FROM review_cycle_node_position WHERE project_participation_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, projectParticipationId);
                statement.execute();
                return null;
            }
        });
    }

    protected String getSelectClauseForRoleConflictJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("organisation") ? result + "organisation.id, organisation.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectParticipant") ? result + "project_participant.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectParticipation") ? result + "project_participation.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("realm") ? result + "realm.id, realm.code, realm.name" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleCell") ? result + "review_cycle_cell.id, review_cycle_cell.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("reviewCycleInstance") ? result + "review_cycle_instance.id, review_cycle_instance.name" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("subProject") ? result + "sub_project.id, sub_project.code, sub_project.name, sub_project.number" : result + "NULL, NULL, NULL, NULL";
        return result;
    }

    public int update(ReviewCycleNodePosition dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ReviewCycleNodePosition> dtos) {
        Iterator<ReviewCycleNodePosition> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getRoleConflictJoinSelectClause() {
        return "organisation.id, organisation.name, person.id, person.givenName, person.surName, project_participant.id, project_participation.id, realm.id, realm.code, realm.name, review_cycle_cell.id, review_cycle_cell.name, review_cycle_instance.id, review_cycle_instance.name, sub_project.id, sub_project.code, sub_project.name, sub_project.number ";
    }

    public static String getPrefixedRoleConflictJoinSelectClause() {
        return "organisation.id AS organisation_id, organisation.name AS organisation_name, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName, project_participant.id AS project_participant_id, project_participation.id AS project_participation_id, realm.id AS realm_id, realm.code AS realm_code, realm.name AS realm_name, review_cycle_cell.id AS review_cycle_cell_id, review_cycle_cell.name AS review_cycle_cell_name, review_cycle_instance.id AS review_cycle_instance_id, review_cycle_instance.name AS review_cycle_instance_name, sub_project.id AS sub_project_id, sub_project.code AS sub_project_code, sub_project.name AS sub_project_name, sub_project.number AS sub_project_number ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ReviewCycleNodePosition reviewCycleNodePosition) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)reviewCycleNodePosition.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)reviewCycleNodePosition.getReviewCycleNodeInstanceId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)reviewCycleNodePosition.getProjectParticipationId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)reviewCycleNodePosition.getRealmId());
    }

    @Override
    public List<ReviewCycleNodePosition> getByReviewCycleNodeInstance(ReviewCycleNodeInstance reviewCycleNodeInstance) {
        return this.getByReviewCycleNodeInstance(reviewCycleNodeInstance.getId());
    }

    @Override
    public List<ReviewCycleNodePosition> getByReviewCycleNodeInstance(final Long reviewCycleNodeInstanceId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_node_instance_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, reviewCycleNodeInstanceId);
            }
        });
    }

    @Override
    public List<ReviewCycleNodePosition> getByProjectParticipation(ProjectParticipation projectParticipation) {
        return this.getByProjectParticipation(projectParticipation.getId());
    }

    @Override
    public List<ReviewCycleNodePosition> getByProjectParticipation(final Long projectParticipationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipationId);
            }
        });
    }

    @Override
    public List<ReviewCycleNodePosition> getByRealm(Realm realm) {
        return this.getByRealm(realm.getId());
    }

    @Override
    public List<ReviewCycleNodePosition> getByRealm(final Long realmId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"realm_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, realmId);
            }
        });
    }

    @Override
    public List<ReviewCycleNodePosition> getByReviewCycleNodeInstances(Collection<Long> reviewCycleNodeInstanceId) {
        if (reviewCycleNodeInstanceId.isEmpty()) {
            return new ArrayList<ReviewCycleNodePosition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[reviewCycleNodeInstanceId.size()];
        int n = 0;
        Iterator<Long> it = reviewCycleNodeInstanceId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_node_instance_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ReviewCycleNodePosition> getByProjectParticipations(Collection<Long> projectParticipationId) {
        if (projectParticipationId.isEmpty()) {
            return new ArrayList<ReviewCycleNodePosition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipationId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ReviewCycleNodePosition> getByRealms(Collection<Long> realmId) {
        if (realmId.isEmpty()) {
            return new ArrayList<ReviewCycleNodePosition>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[realmId.size()];
        int n = 0;
        Iterator<Long> it = realmId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"realm_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    protected static class IReviewCycleNodePositionImpl
    implements IReviewCycleNodePosition {
        private Long id;
        private Long reviewCycleNodeInstanceId;
        private Long projectParticipationId;
        private Long realmId;

        protected IReviewCycleNodePositionImpl() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getReviewCycleNodeInstanceId() {
            return this.reviewCycleNodeInstanceId;
        }

        public void setReviewCycleNodeInstanceId(Long reviewCycleNodeInstanceId) {
            this.reviewCycleNodeInstanceId = reviewCycleNodeInstanceId;
        }

        public Long getProjectParticipationId() {
            return this.projectParticipationId;
        }

        public void setProjectParticipationId(Long projectParticipationId) {
            this.projectParticipationId = projectParticipationId;
        }

        public Long getRealmId() {
            return this.realmId;
        }

        public void setRealmId(Long realmId) {
            this.realmId = realmId;
        }
    }
}

