/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.guiService.EmailService;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.email.EmailUtils;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.QueryHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class EmailServiceImpl
implements EmailService {
    private ActionDAO actionDAO;
    private EmailUtils emailUtils;
    private NetworkDAO networkDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectDAO projectDAO;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setEmailUtils(EmailUtils emailUtils) {
        this.emailUtils = emailUtils;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void sendEmail(Long senderOrganisationPersonId, Long receiverOrganisationPersonId, Long networkId, Long projectId, String subject, String body) {
        ArrayList<Long> receiverOrganisationPersonIds = new ArrayList<Long>();
        receiverOrganisationPersonIds.add(receiverOrganisationPersonId);
        this.doSendEmail(senderOrganisationPersonId, receiverOrganisationPersonIds, networkId, projectId, subject, body);
    }

    private void doSendEmail(Long senderOrganisationPersonId, List<Long> receiverOrganisationPersonIds, Long networkId, Long projectId, String subject, String body) {
        String suffix;
        String suffixRaw;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, senderOrganisationPersonId);
        ArrayList<Long> queryOrgPersonIds = new ArrayList<Long>();
        queryOrgPersonIds.add(senderOrganisationPersonId);
        queryOrgPersonIds.addAll(receiverOrganisationPersonIds);
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoin(queryOrgPersonIds.toArray(new Long[0]));
        Map<Long, OrganisationPersonJoin> idToOrganisationPersonJoin = PersonHelper.groupById(organisationPersonJoins);
        OrganisationPersonJoin senderJoin = idToOrganisationPersonJoin.get(senderOrganisationPersonId);
        if (senderJoin == null) {
            throw new IllegalArgumentException("OrganisationPersonJoin of sender [" + senderOrganisationPersonId + "] doesn't exist, something is wrong here.");
        }
        for (Long receiverId : receiverOrganisationPersonIds) {
            if (idToOrganisationPersonJoin.get(receiverId) != null) continue;
            throw new IllegalArgumentException("OrganisationPersonJoin of receiver [" + receiverId + "] doesn't exist, something is wrong here.");
        }
        Long senderPersonId = senderJoin.getPersonId();
        List<Network> networks = this.networkDAO.getNetworksByPerson(senderPersonId);
        List<Long> networkIds = ContainerHelper.getPersistentIdsList(networks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(senderOrganisationPersonId, networkIds, Action.EDIT_PERSON, Action.SHOW_PERSON);
        if (!ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.EDIT_PERSON) && !ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.SHOW_PERSON)) {
            throw new SecurityException("OrganisationPerson [" + senderOrganisationPersonId + "] is not allowed to send an email, since neither permission [" + Action.SHOW_PERSON.getName() + "] nor permission [" + Action.EDIT_PERSON + "] exists for any of its networks.");
        }
        if (!networkIds.contains(networkId)) {
            throw new IllegalArgumentException("Passed networkId [" + networkId + "] does not belong to senderOrganisationPerson [" + senderOrganisationPersonId + "]");
        }
        Network network = null;
        Project project = null;
        if (projectId != null) {
            ContextJoin contextJoin = this.projectDAO.getProjectContextJoin(projectId);
            network = contextJoin.getNetwork();
            project = contextJoin.getProject();
            if (!network.getId().equals(networkId)) {
                throw new IllegalArgumentException("Passed inconsistent network/project pair [" + networkId + "/" + projectId + "]");
            }
        } else {
            network = (Network)this.networkDAO.get(networkId);
        }
        String locale = senderJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        Person senderPerson = senderJoin.getPerson();
        String personCommonName = PersonHelper.getCommonName(senderPerson);
        if (project != null) {
            suffixRaw = resourceBundle.getString("emailServiceSendEmailProjectSuffix");
            suffix = MessageFormat.format(suffixRaw, project.getName(), network.getName(), personCommonName);
        } else {
            suffixRaw = resourceBundle.getString("emailServiceSendEmailNetworkSuffix");
            suffix = MessageFormat.format(suffixRaw, network.getName(), personCommonName);
        }
        body = body + suffix;
        String replyTo = senderJoin.getOrganisationPersonEmailAddress();
        for (Long receiverOrganisationPersonId : receiverOrganisationPersonIds) {
            OrganisationPersonJoin receiverJoin = idToOrganisationPersonJoin.get(receiverOrganisationPersonId);
            OrganisationPerson receiverOrganisationPerson = receiverJoin.getOrganisationPerson();
            Person receiverPerson = receiverJoin.getPerson();
            this.emailUtils.createMail(receiverOrganisationPerson, receiverPerson, subject, body, replyTo, null, null);
        }
        String copyBody = resourceBundle.getString("emailServiceSendEmailCopyPrefix") + body;
        OrganisationPerson senderOrganisationPerson = senderJoin.getOrganisationPerson();
        this.emailUtils.createMail(senderOrganisationPerson, senderPerson, subject, copyBody, replyTo, null, null);
    }

    public void sendEmails(Long senderOrganisationPersonId, List<Long> receiverOrganisationPersonIds, Long networkId, Long projectId, String subject, String body) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, senderOrganisationPersonId);
        OrganisationPersonJoin senderJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(senderOrganisationPersonId);
        Long senderPersonId = senderJoin.getPersonId();
        List<Network> networks = this.networkDAO.getNetworksByPerson(senderPersonId);
        List<Long> networkIds = ContainerHelper.getPersistentIdsList(networks);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkToActionMap(senderOrganisationPersonId, networkIds, Action.EDIT_PERSON, Action.SHOW_PERSON);
        if (!ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.EDIT_PERSON) && !ActionHelper.hasActionsForAnyNetwork(networkIdToActions, Action.SHOW_PERSON)) {
            throw new SecurityException("OrganisationPerson [" + senderOrganisationPersonId + "] is not allowed to send an email, since neither permission [" + Action.SHOW_PERSON.getName() + "] nor permission [" + Action.EDIT_PERSON + "] exists for any of its networks.");
        }
        this.doSendEmail(senderOrganisationPersonId, receiverOrganisationPersonIds, networkId, projectId, subject, body);
    }

    public void sendEmailsToProject(Long senderOrganisationPersonId, Long targetProjectId, Long networkId, Long projectId, String subject, String body) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, senderOrganisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, senderOrganisationPersonId, targetProjectId, Action.SHOW_PROJECT_PARTICIPATION)) {
            throw new SecurityException("OrganisationPersonId [" + senderOrganisationPersonId + "] is not allowed to execute sendEmailsToProject, privilege [" + Action.SHOW_PROJECT_PARTICIPATION + "] is missing.");
        }
        List<OrganisationPerson> organisationPersons = this.organisationPersonDAO.getActiveOrganisationPersonsByProject(targetProjectId);
        List<Long> organisationPersonIds = QueryHelper.getPersistentIds(organisationPersons);
        this.doSendEmail(senderOrganisationPersonId, organisationPersonIds, networkId, projectId, subject, body);
    }
}

