/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.joinDto.DocumentListReleaseVersion;
import at.cdes.api.joinDto.PlanDeliverSearchJoin;
import at.cdes.impl.dao.DocumentListReleaseDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcDocumentListReleaseDAO;
import at.cdes.impl.dao.unionComponent.PlanDeliverSearchComponent;
import at.cdes.impl.dao.util.RoleHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDocumentListReleaseDAO
extends AbstractJdbcDocumentListReleaseDAO
implements DocumentListReleaseDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcDocumentListReleaseDAO.class);

    @Override
    public List<DocumentListReleaseVersion> getDocumentListReleaseVersions(final Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentListReleaseDAO.getDocumentListReleaseVersionSelectClause() + "FROM document_list  LEFT JOIN ((((document_list_release  JOIN signature           ON document_list_release.signature_id = signature.id)  JOIN project_participant ON signature.project_participant_id = project_participant.id)  JOIN organisation_person ON project_participant.organisation_person_id = organisation_person.id)  JOIN person              ON organisation_person.person_id = person.id)  ON document_list_release.document_list_id = document_list.id WHERE document_list.sub_project_id = ? ORDER BY document_list_release.version DESC";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentListReleaseVersion>>(){

            public List<DocumentListReleaseVersion> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentListReleaseVersion> ret = new ArrayList<DocumentListReleaseVersion>();
                while (rs.next()) {
                    ret.add(AbstractJdbcDocumentListReleaseDAO.fillDocumentListReleaseVersionFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    private String getPlanDeliverSearchUnionSelectClause(PlanDeliverSearchComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForPlanDeliverSearchJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<PlanDeliverSearchJoin> getPlanDeliverSearchJoin(final Long subProjectId) {
        String sql = "SELECT " + this.getPlanDeliverSearchUnionSelectClause(PlanDeliverSearchComponent.DOCUMENT_LIST_RELEASE_VERSION, "documentList", "documentListRelease", "signature", "person") + "FROM document_list  LEFT JOIN ((((document_list_release  JOIN signature           ON document_list_release.signature_id = signature.id)  JOIN project_participant ON signature.project_participant_id = project_participant.id)  JOIN organisation_person ON project_participant.organisation_person_id = organisation_person.id)  JOIN person              ON organisation_person.person_id = person.id)  ON document_list_release.document_list_id = document_list.id WHERE document_list.sub_project_id = ? UNION ALL SELECT " + this.getPlanDeliverSearchUnionSelectClause(PlanDeliverSearchComponent.OBJECT_PLANNER_POSITION_PERSON, "cdesRole", "person", "organisation", "organisationPerson") + RoleHelper.getObjectPlannerPositionRoleClause() + "UNION ALL SELECT " + this.getPlanDeliverSearchUnionSelectClause(PlanDeliverSearchComponent.OBJECT_PLANNER_PERSON, "cdesRole", "person", "organisation", "organisationPerson") + RoleHelper.getObjectPlannerRoleClause() + "UNION ALL SELECT " + this.getPlanDeliverSearchUnionSelectClause(PlanDeliverSearchComponent.OBJECT_PLANNER, "objectRelease", "objectType", "objectPlannerRelease") + "FROM ((((object_list JOIN object_list_release      ON object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1) JOIN object_release           ON object_release.object_list_release_id = object_list_release.id) LEFT JOIN object_planner_release   ON object_planner_release.object_id = object_release.id) LEFT JOIN object_type              ON object_release.object_type_id = object_type.id)WHERE object_list.sub_project_id = ? UNION ALL SELECT " + this.getPlanDeliverSearchUnionSelectClause(PlanDeliverSearchComponent.CDES_ROLE, "cdesRole") + "FROM (((    cdes_role JOIN network                 ON cdes_role.network_id = network.id) JOIN project                 ON project.network_id = network.id) JOIN sub_project             ON sub_project.project_id = project.id) WHERE sub_project.id = ? AND cdes_role.project_flag NOT IN (7, 8) ";
        if (log.isDebugEnabled()) {
            log.debug("Executing sql: " + sql);
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlanDeliverSearchJoin>>(){

            public List<PlanDeliverSearchJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<PlanDeliverSearchJoin> ret = new ArrayList<PlanDeliverSearchJoin>();
                while (rs.next()) {
                    PlanDeliverSearchJoin joinDto = AbstractJdbcDocumentListReleaseDAO.fillPlanDeliverSearchJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentListReleaseDAO.getNumberOfPlanDeliverSearchJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }
}

