/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.DocumentArchiveJoin;
import at.cdes.api.joinDto.DocumentVersionContextJoin;
import at.cdes.api.joinDto.DocumentVersionObjectJoin;
import at.cdes.api.joinDto.GenSelectCellTaskVersionJoin;
import at.cdes.api.joinDto.ObjectReleaseDocumentVersionJoin;
import at.cdes.api.joinDto.RequestOriginalsJoin;
import at.cdes.api.joinDto.ReviewProtocolBaseJoin;
import at.cdes.api.joinDto.ReviewProtocolVersionJoin;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcDocumentVersionDAO;
import at.cdes.impl.dao.jdbc.JdbcNetworkDAO;
import at.cdes.impl.dao.unionComponent.DocumentArchiveComponent;
import at.cdes.impl.dao.unionComponent.ReviewProtocolVersionComponent;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDocumentVersionDAO
extends AbstractJdbcDocumentVersionDAO
implements DocumentVersionDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcDocumentVersionDAO.class);

    @Override
    public List<DocumentVersion> getViewableVersions(final Long documentId, final List<String> fileTypes) {
        String fileTypeCondition = "0=1 ";
        for (int n = 0; n < fileTypes.size(); ++n) {
            fileTypeCondition = fileTypeCondition + "OR document_version.filetype LIKE ? ";
        }
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document_version WHERE document_version.document_id = ? AND (" + fileTypeCondition + ") UNION ALL SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM ((       document_version start_version LEFT JOIN document_version reactivated_version ON start_version.reactivated_document_version_id = reactivated_version.id) JOIN document_version                     ON     (     reactivated_version.id IS NULL AND start_version.as_built_reference = document_version.id) OR (     reactivated_version.id IS NOT NULL AND reactivated_version.as_built_reference = document_version.id)) WHERE (" + fileTypeCondition + ") AND start_version.id = ( SELECT max(local_version_one.id) FROM document_version local_version_one WHERE local_version_one.document_id = ? AND local_version_one.uploaded = (SELECT max(local_version_two.uploaded) FROM document_version local_version_two WHERE local_version_two.document_id = ?)) ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentVersion>>(){

            public List<DocumentVersion> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
                for (String fileType : fileTypes) {
                    statement.setString(currIndex++, fileType);
                }
                for (String fileType : fileTypes) {
                    statement.setString(currIndex++, fileType);
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentVersion> ret = new ArrayList<DocumentVersion>();
                while (rs.next()) {
                    DocumentVersion documentVersion = JdbcDocumentVersionDAO.fillDocumentVersionFromResultSet(rs);
                    ret.add(documentVersion);
                }
                return ret;
            }
        });
    }

    @Override
    public List<DocumentVersion> getByDocumentIds(final Collection<Long> documentIds) {
        if (documentIds.size() == 0) {
            return new ArrayList<DocumentVersion>();
        }
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document_version WHERE document_version.document_id IN (" + QueryHelper.getPlaceHolderSequence(documentIds.size()) + ") ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentVersion>>(){

            public List<DocumentVersion> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long documentId : documentIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentVersion> ret = new ArrayList<DocumentVersion>();
                while (rs.next()) {
                    DocumentVersion documentVersion = JdbcDocumentVersionDAO.fillDocumentVersionFromResultSet(rs);
                    ret.add(documentVersion);
                }
                return ret;
            }
        });
    }

    @Override
    public List<DocumentVersionContextJoin> getContextJoinsByObject(Long objectId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getDocumentVersionContextJoinSelectClause() + "FROM document_version JOIN document          ON document_version.document_id = document.id JOIN object_planner    ON document.object_planner_id = object_planner.id JOIN object            ON object_planner.object_id = object.id JOIN object_list       ON object.object_list_id = object_list.id JOIN sub_project       ON object_list.sub_project_id = sub_project.id JOIN project           ON sub_project.project_id = project.id JOIN network           ON project.network_id = network.id WHERE object.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcDocumentVersionDAO::fillDocumentVersionContextJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
        });
    }

    @Override
    public RequestOriginalsJoin getRequestOriginalsJoin(final Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getRequestOriginalsJoinSelectClause() + "FROM (((((((((((((((((( document_version JOIN document                   ON document_version.document_id = document.id) JOIN document_list              ON document.document_list_id = document_list.id) JOIN sub_project                ON document_list.sub_project_id = sub_project.id) JOIN project                    ON sub_project.project_id = project.id) JOIN network                    ON project.network_id = network.id) JOIN object_planner             ON document.object_planner_id = object_planner.id) JOIN object                     ON object_planner.object_id = object.id) JOIN object_list_release        ON     object_list_release.sub_project_id = sub_project.id AND object_list_release.version = (SELECT max(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = sub_project.id)) JOIN object_release             ON     object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) JOIN object_planner_release     ON     object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) JOIN project_participation      ON object_planner_release.planner_id = project_participation.id) JOIN project_participant        ON project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) JOIN organisation_person        ON project_participant.organisation_person_id = organisation_person.id) JOIN person                     ON organisation_person.person_id = person.id) JOIN person_variables           ON person_variables.person_id = person.id) JOIN project participation_project ON project_participation.project_id = participation_project.id) JOIN localisation                  ON participation_project.localisation_id = localisation.id) JOIN countries                     ON localisation.country_id = countries.id) WHERE document_version.id = ? ";
        return (RequestOriginalsJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<RequestOriginalsJoin>(){

            public RequestOriginalsJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ResultSet rs = statement.executeQuery();
                RequestOriginalsJoin join = null;
                while (rs.next()) {
                    if (join == null) {
                        join = JdbcDocumentVersionDAO.fillRequestOriginalsJoinFromResultSet(rs);
                        continue;
                    }
                    throw new DAOException("Found more than one RequestOriginalsJoin instance for documentVersionId = [" + documentVersionId + "]; expected not more than one; either the join is wrong, or some data on the database corrupted.");
                }
                return join;
            }
        });
    }

    @Override
    public ContextJoin getContextJoin(Long documentVersionId) {
        ArrayList<Long> documentVersionIds = new ArrayList<Long>();
        documentVersionIds.add(documentVersionId);
        List<ContextJoin> contextJoins = this.getContextJoins(documentVersionIds);
        if (contextJoins.size() == 0) {
            return null;
        }
        if (contextJoins.size() == 1) {
            return contextJoins.get(0);
        }
        throw new IllegalArgumentException("Found [" + contextJoins.size() + "] ContextJoins for documentVersionId [" + documentVersionId + "], something is very weird here.");
    }

    @Override
    public List<ContextJoin> getContextJoins(final Collection<Long> documentVersionIds) {
        if (documentVersionIds.size() == 0) {
            return new ArrayList<ContextJoin>();
        }
        String sql = "SELECT " + JdbcNetworkDAO.getContextJoinSelectClause() + "FROM (((((((((( document_version JOIN document                  ON document_version.document_id = document.id) JOIN object_planner            ON document.object_planner_id = object_planner.id) JOIN object                    ON object_planner.object_id = object.id) JOIN object_list               ON object.object_list_id = object_list.id) JOIN sub_project               ON object_list.sub_project_id = sub_project.id) JOIN sub_project_type          ON sub_project.sub_project_type_id = sub_project_type.id) JOIN project                   ON sub_project.project_id = project.id) JOIN network                   ON project.network_id = network.id) LEFT JOIN localisation              ON project.localisation_id = localisation.id) LEFT JOIN countries project_country ON localisation.country_id = project_country.id) WHERE document_version.id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ")";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ContextJoin>>(){

            public List<ContextJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long documentVersionId : documentVersionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                ArrayList<ContextJoin> contextJoins = new ArrayList<ContextJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ContextJoin contextJoin = JdbcNetworkDAO.fillContextJoinFromResultSet(rs);
                    contextJoins.add(contextJoin);
                }
                return contextJoins;
            }
        });
    }

    @Override
    public List<DocumentArchiveJoin> getArchiveJoin(final List<Long> documentVersionIds, boolean allDocumentVersions) {
        if (documentVersionIds.size() == 0) {
            return new ArrayList<DocumentArchiveJoin>();
        }
        String whereClauseDocumentVersion = allDocumentVersions ? "base_version" : "document_version";
        final String sql = "SELECT " + this.getArchiveUnionSelectClause(DocumentArchiveComponent.DOCUMENT_VERSION, "documentVersion", "document", "objectRelease", "objectPlannerRelease", "objectType", "organisation") + "FROM " + (allDocumentVersions ? "(" : "") + "(((((((((((( " + (allDocumentVersions ? "document_version base_version JOIN document_version                ON base_version.document_id = document_version.document_id) " : "document_version ") + "JOIN document                   ON document_version.document_id = document.id) JOIN object_planner             ON document.object_planner_id = object_planner.id) JOIN object                     ON object_planner.object_id = object.id) JOIN object_list                ON object.object_list_id = object_list.id) JOIN object_list_release        ON object_list_release.sub_project_id = object_list.sub_project_id AND object_list_release.version = object_list.version - 1) JOIN object_release             ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) JOIN object_planner_release     ON object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) LEFT JOIN object_type                ON object_release.object_type_id = object_type.id) LEFT JOIN project_participation      ON object_planner_release.planner_id = project_participation.id) LEFT JOIN project_participant        ON project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1 AND project_participant.inactive_flag = 0) LEFT JOIN organisation_person        ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN organisation               ON organisation_person.organisation_id = organisation.id) WHERE " + whereClauseDocumentVersion + ".id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ") UNION ALL SELECT " + this.getArchiveUnionSelectClause(DocumentArchiveComponent.DOCUMENT_REFERENCE, "documentReference") + "FROM (document_version JOIN document_reference  ON document_version.document_id = document_reference.document_id) WHERE document_version.id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ") UNION ALL SELECT " + this.getArchiveUnionSelectClause(DocumentArchiveComponent.ATTACHMENT, "documentVersion", "attachment") + "FROM " + (allDocumentVersions ? "(" : "") + "( " + (allDocumentVersions ? "document_version base_version JOIN document_version                ON base_version.document_id = document_version.document_id) " : "document_version ") + "JOIN attachment            ON attachment.document_version_id = document_version.id) WHERE " + whereClauseDocumentVersion + ".id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ") UNION ALL SELECT " + this.getArchiveUnionSelectClause(DocumentArchiveComponent.REVIEW_CYCLE, "documentVersion", "reviewCyclePositionResult", "reviewCycleNodeResult", "reviewCycleResultOption") + "FROM ((((( document_version LEFT JOIN review_cycle_position_result    ON review_cycle_position_result.id = (SELECT max(id) FROM review_cycle_position_result local_one_result WHERE local_one_result.document_version_id = document_version.id AND local_one_result.comment_reference_id IS NULL AND local_one_result.result_date = (SELECT max(result_date) FROM review_cycle_position_result local_two_result WHERE local_two_result.document_version_id = document_version.id AND local_two_result.comment_reference_id IS NULL))) LEFT JOIN review_cycle_node_instance  ON        review_cycle_position_result.id IS NULL AND document_version.active_node_instance_id = review_cycle_node_instance.id) LEFT JOIN review_cycle_node           ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_node_result    ON review_cycle_node_result.id = (SELECT max(id) FROM review_cycle_node_result local_one_result WHERE local_one_result.document_version_id = document_version.id AND local_one_result.review_cycle_node_id = review_cycle_node.id AND local_one_result.arrivalDate = (SELECT max(arrivalDate) FROM review_cycle_node_result local_two_result WHERE local_two_result.document_version_id = document_version.id AND local_two_result.review_cycle_node_id = review_cycle_node.id))) LEFT JOIN review_cycle_result_option  ON        review_cycle_position_result.review_cycle_result_option_id = review_cycle_result_option.id) WHERE document_version.id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ") AND document_version.status = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentArchiveJoin>>(){

            public List<DocumentArchiveJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long documentVersionId : documentVersionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                for (Long documentVersionId : documentVersionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                for (Long documentVersionId : documentVersionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                for (Long documentVersionId : documentVersionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.RELEASEDPOSITIV.getValue());
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                if (log.isDebugEnabled()) {
                    log.debug("Will query archiveJoin for [" + documentVersionIds.size() + "] document versions, and [" + currIndex + "] query parameters");
                }
                ArrayList<DocumentArchiveJoin> results = new ArrayList<DocumentArchiveJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    DocumentArchiveJoin joinDto = AbstractJdbcDocumentVersionDAO.fillDocumentArchiveJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentVersionDAO.getNumberOfDocumentArchiveJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getArchiveUnionSelectClause(DocumentArchiveComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForDocumentArchiveJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public DocumentVersionObjectJoin getDocumentVersionObjectJoin(Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getDocumentVersionObjectJoinSelectClause() + "FROM document_version JOIN document               ON document_version.document_id = document.id JOIN object_planner         ON document.object_planner_id = object_planner.id JOIN object                 ON object_planner.object_id = object.id JOIN object_list            ON object.object_list_id = object_list.id LEFT JOIN object_list_release    ON object_list_release.version = object_list.version - 1 LEFT JOIN signature              ON object_list_release.signature_id = signature.id LEFT JOIN object_release         ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id LEFT JOIN object_planner_release ON object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id WHERE document_version.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, AbstractJdbcDocumentVersionDAO::fillDocumentVersionObjectJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
        });
    }

    @Override
    public List<DocumentVersionObjectJoin> getReviewProtocolObjectJoins(final Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getDocumentVersionObjectJoinSelectClause() + "FROM (((((((( document_version JOIN document                        ON document_version.document_id = document.id) JOIN object_planner                  ON document.object_planner_id = object_planner.id) JOIN object                          ON object_planner.object_id = object.id) JOIN object_list                     ON object.object_list_id = object_list.id) JOIN object_list_release             ON object_list_release.object_list_id = object_list.id) JOIN object_release                  ON     object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) JOIN object_planner_release          ON     object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) LEFT JOIN signature                       ON object_list_release.signature_id = signature.id) WHERE document_version.id = ? ";
        long prevMillis = System.currentTimeMillis();
        List results = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentVersionObjectJoin>>(){

            public List<DocumentVersionObjectJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ArrayList<DocumentVersionObjectJoin> results = new ArrayList<DocumentVersionObjectJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    DocumentVersionObjectJoin joinDto = AbstractJdbcDocumentVersionDAO.fillDocumentVersionObjectJoinFromResultSet(rs);
                    results.add(joinDto);
                }
                return results;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Queried [" + results.size() + "] DocumentVersionObjectJoins in [" + (System.currentTimeMillis() - prevMillis) + "ms].");
        }
        return results;
    }

    @Override
    public ReviewProtocolBaseJoin getReviewProtocolBaseJoin(final Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getReviewProtocolBaseJoinSelectClause() + "FROM (((((((((((((((((((((( document_version JOIN document                           ON document_version.document_id = document.id) JOIN object_planner                     ON document.object_planner_id = object_planner.id) JOIN object                             ON object_planner.object_id = object.id) JOIN object_list                        ON object.object_list_id = object_list.id) JOIN sub_project                        ON object_list.sub_project_id = sub_project.id) JOIN project                            ON sub_project.project_id = project.id) JOIN object_list_release                ON     object_list_release.sub_project_id = sub_project.id AND object_list_release.version = (SELECT max(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = sub_project.id)) JOIN object_release                     ON     object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) JOIN object_planner_release             ON     object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) LEFT JOIN object_type                        ON object_release.object_type_id = object_type.id) LEFT JOIN document_list_release              ON     document_list_release.sub_project_id = sub_project.id AND document_list_release.version = (SELECT max(local_document_list_release.version) FROM document_list_release local_document_list_release WHERE local_document_list_release.sub_project_id = sub_project.id)) LEFT JOIN document_release                   ON     document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id) LEFT JOIN localisation                       ON project.localisation_id = localisation.id) LEFT JOIN countries                          ON localisation.country_id = countries.id) LEFT JOIN review_cycle_instance_released     ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN document_version first_document_version ON first_document_version.id = (SELECT max(local_document_version.id) FROM document_version local_document_version WHERE local_document_version.document_id = document.id AND local_document_version.uploaded = (SELECT MAX(local_document_version_two.uploaded) FROM document_version local_document_version_two WHERE local_document_version_two.document_id = document.id))) LEFT JOIN document_version as_built_document_version ON first_document_version.as_built_reference = as_built_document_version.id) LEFT JOIN project_participation planner_participation ON object_planner_release.planner_id = planner_participation.id) LEFT JOIN organisation planner_organisation  ON planner_participation.organisation_id = planner_organisation.id) LEFT JOIN project_participant planner_main_participant ON     planner_main_participant.participation_id = planner_participation.id AND planner_main_participant.main_participant_flag = 1 AND planner_main_participant.inactive_flag != 1) LEFT JOIN organisation_person planner_organisation_person ON planner_main_participant.organisation_person_id = planner_organisation_person.id) LEFT JOIN person planner_person              ON planner_organisation_person.person_id = planner_person.id) WHERE document_version.id = ?";
        return (ReviewProtocolBaseJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ReviewProtocolBaseJoin>(){

            public ReviewProtocolBaseJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ReviewProtocolBaseJoin result = null;
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ReviewProtocolBaseJoin joinDto = AbstractJdbcDocumentVersionDAO.fillReviewProtocolBaseJoinFromResultSet(rs);
                    if (result == null) {
                        result = joinDto;
                        continue;
                    }
                    throw new DAOException("Found multiple occurrences of ReviewProtocolBaseJoin for documentVersionId [" + documentVersionId + "], although just one is expected.");
                }
                return result;
            }
        });
    }

    private void queryVersionJoinComponent(final Long documentVersionId, final Long reviewCycleInstanceReleasedId, final Long objectPlannerReleaseIdByVersion, final Long objectPlannerReleaseIdByTime, final ReviewProtocolVersionComponent component, String sql) {
        long prevMillis = System.currentTimeMillis();
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewProtocolVersionJoin>>(){

            public List<ReviewProtocolVersionJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (component == ReviewProtocolVersionComponent.VERSIONS) {
                    currIndex = JdbcDocumentVersionDAO.populatePreviewSupportDocumentVersionClause(statement, currIndex);
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                } else if (component == ReviewProtocolVersionComponent.PROJECT_HOLIDAYS || component == ReviewProtocolVersionComponent.RESULT || component == ReviewProtocolVersionComponent.ATTACHMENT || component == ReviewProtocolVersionComponent.CELL_CONNECTION_RESULTS || component == ReviewProtocolVersionComponent.ENTRY_RESULTS || component == ReviewProtocolVersionComponent.OEBB_COMMENTS) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                } else if (component == ReviewProtocolVersionComponent.NODE_POSITIONS || component == ReviewProtocolVersionComponent.ATTACHED_NODE_POSITIONS) {
                    boolean getNodePositionViaObjectPlannerRelease;
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                    boolean bl = getNodePositionViaObjectPlannerRelease = objectPlannerReleaseIdByVersion != null || objectPlannerReleaseIdByTime != null;
                    if (getNodePositionViaObjectPlannerRelease) {
                        if (objectPlannerReleaseIdByVersion != null) {
                            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseIdByVersion);
                        } else {
                            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseIdByTime);
                        }
                    }
                } else if (component == ReviewProtocolVersionComponent.DOCUMENT_REFERENCES) {
                    currIndex = JdbcDocumentVersionDAO.populatePreviewSupportDocumentVersionClause(statement, currIndex);
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                } else if (component == ReviewProtocolVersionComponent.CYCLE_INSTANCES) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleInstanceReleasedId);
                }
                ArrayList<ReviewProtocolVersionJoin> results = new ArrayList<ReviewProtocolVersionJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ReviewProtocolVersionJoin joinDto = AbstractJdbcDocumentVersionDAO.fillReviewProtocolVersionJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentVersionDAO.getNumberOfReviewProtocolVersionJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
        log.debug("Queried [" + joins.size() + "] " + component.toString() + " instances in [" + (System.currentTimeMillis() - prevMillis) + "ms]");
    }

    private String getVersionComponentSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.VERSIONS, "documentVersion", "asBuiltDocumentVersion", "revisedDocumentVersion", "previewSupportDocumentVersion", "document", "subProject", "destVersionCellConnectionResult", "connectionResultPerson", "connectionResultOrganisation", "reviewCycleEntryResult", "entryResultPerson", "reviewCycleCell", "reviewCycleNode", "entryResultOrganisation") + "FROM ((((((((((((((((((((((((( document_version own_version JOIN document                                      ON own_version.document_id = document.id) JOIN object_planner                                ON document.object_planner_id = object_planner.id) JOIN object                                        ON object_planner.object_id = object.id) JOIN object_list                                   ON object.object_list_id = object_list.id) JOIN sub_project                                   ON object_list.sub_project_id = sub_project.id) JOIN document_version                              ON document_version.document_id = document.id) LEFT JOIN document_version as_built_document_version    ON document_version.as_built_reference = as_built_document_version.id) " + JdbcDocumentVersionDAO.getPreviewSupportDocumentVersionClause() + "LEFT JOIN document_version revised_document_version     ON document_version.revised_document_version_id = revised_document_version.id) LEFT JOIN review_cycle_cell_connection_result dest_version_cell_connection_result ON dest_version_cell_connection_result.destination_document_version_id = document_version.id) LEFT JOIN project_participant connection_result_participant ON dest_version_cell_connection_result.project_participant_id = connection_result_participant.id) LEFT JOIN organisation_person connection_result_organisation_person ON connection_result_participant.organisation_person_id = connection_result_organisation_person.id) LEFT JOIN person connection_result_person ON connection_result_organisation_person.person_id = connection_result_person.id) LEFT JOIN organisation connection_result_organisation ON connection_result_organisation_person.organisation_id = connection_result_organisation.id) LEFT JOIN review_cycle_entry_result                     ON review_cycle_entry_result.document_version_id = document_version.id) LEFT JOIN project_participant entry_result_participant  ON review_cycle_entry_result.project_participant_id = entry_result_participant.id) LEFT JOIN organisation_person entry_result_organisation_person ON entry_result_participant.organisation_person_id = entry_result_organisation_person.id) LEFT JOIN person entry_result_person                    ON entry_result_organisation_person.person_id = entry_result_person.id) LEFT JOIN organisation entry_result_organisation        ON entry_result_organisation_person.organisation_id = entry_result_organisation.id) LEFT JOIN review_cycle_node_instance                    ON document_version.active_node_instance_id = review_cycle_node_instance.id) LEFT JOIN review_cycle_node                             ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_cell                             ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id) WHERE own_version.id = ? ";
    }

    private String getDocumentReferencesSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.DOCUMENT_REFERENCES, "documentVersion", "document", "documentReference", "sinceDocumentVersion", "untilDocumentVersion", "subProject") + "FROM (((((((((((((( document_version base_version JOIN document                      ON base_version.document_id = document.id) JOIN document_reference            ON document_reference.document_id = document.id) LEFT JOIN document_version              ON document_reference.referenced_version_id = document_version.id) LEFT JOIN document_version since_document_version ON document_reference.since_docversion_id = since_document_version.id) LEFT JOIN document_version until_document_version ON document_reference.until_docversion_id = until_document_version.id) LEFT JOIN document ref_document         ON document_version.document_id = ref_document.id) LEFT JOIN object_planner                ON ref_document.object_planner_id = object_planner.id) LEFT JOIN object                        ON object_planner.object_id = object.id) LEFT JOIN object_list                   ON object.object_list_id = object_list.id) LEFT JOIN sub_project                   ON object_list.sub_project_id = sub_project.id) " + JdbcDocumentVersionDAO.getPreviewSupportDocumentVersionClause() + "WHERE base_version.id = ? ";
    }

    private String getProjectHolidaysSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.PROJECT_HOLIDAYS, "projectHoliday") + "FROM ((((( document_version JOIN document                     ON document_version.document_id = document.id) JOIN document_list                ON document.document_list_id = document_list.id) JOIN sub_project                  ON document_list.sub_project_id = sub_project.id) JOIN project                      ON sub_project.project_id = project.id) JOIN project_holiday              ON project_holiday.project_id = project.id) WHERE document_version.id = ? ";
    }

    private String getResultSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.RESULT, "documentVersion", "reviewCycleCellResult", "cellResultOption", "reviewCycleNodeResult", "reviewCycleNode", "crossCommentNode", "endNode", "nodeResultCell", "reviewCycleCell", "reviewCycle", "reviewCycleCellInstanceReleased", "reviewCycleNodeInstanceReleased", "reviewCyclePositionResult", "attachedPositionResult", "reviewCycleCommentOption", "positionParticipant", "positionRole", "positionPerson", "positionOrganisation", "positionMainPerson", "positionMainOrganisation", "departureObjectListSignature", "departureReviewCycleNodeInstanceReleased", "realm", "positionOverridingPerson") + "FROM (((((((((((((((((((((((((((((((((((((((((((((( document_version base_version JOIN document_version                ON document_version.document_id = base_version.document_id) JOIN document                        ON document_version.document_id = document.id) JOIN object_planner                  ON document.object_planner_id = object_planner.id) JOIN object                          ON object_planner.object_id = object.id) JOIN object_list                     ON object.object_list_id = object_list.id) JOIN review_cycle_node_instance      ON document_version.active_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_node active_node   ON review_cycle_node_instance.review_cycle_node_id = active_node.id) JOIN review_cycle_cell               ON active_node.review_cycle_cell_id = review_cycle_cell.id) JOIN review_cycle                    ON review_cycle_cell.review_cycle_id = review_cycle.id) LEFT JOIN review_cycle_cell_result        ON      review_cycle_cell_result.review_cycle_cell_id = review_cycle_cell.id AND review_cycle_cell_result.document_version_id = document_version.id) LEFT JOIN object_list_release             ON     object_list_release.sub_project_id = object_list.sub_project_id AND object_list_release.version = (SELECT max(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = object_list.sub_project_id)) LEFT JOIN object_release                  ON     object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) LEFT JOIN object_planner_release          ON     object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) LEFT JOIN review_cycle_instance_released  ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle_result_option cell_result_option ON review_cycle_cell_result.review_cycle_result_option_id = cell_result_option.id) LEFT JOIN review_cycle_node_result        ON review_cycle_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id) LEFT JOIN review_cycle_node review_cycle_node ON review_cycle_node_result.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_cell node_result_cell ON review_cycle_node.review_cycle_cell_id = node_result_cell.id) LEFT JOIN review_cycle_node cross_comment_node ON      review_cycle_node.id = cross_comment_node.id AND EXISTS (SELECT 1 FROM node_cross_comment_connection WHERE node_cross_comment_connection.commented_id = cross_comment_node.id)) LEFT JOIN review_cycle_node end_node ON        end_node.id = review_cycle_node.id AND  end_node.position > 0 AND  end_node.position = (SELECT count(1) FROM review_cycle_node local_node WHERE local_node.review_cycle_cell_id = node_result_cell.id) - node_result_cell.is_end_cell) LEFT JOIN review_cycle_cell_instance_released ON        review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id AND review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_node.review_cycle_cell_id) LEFT JOIN review_cycle_node_instance_released ON        review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id AND review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_position_result    ON        review_cycle_position_result.review_cycle_node_result_id = review_cycle_node_result.id) LEFT JOIN review_cycle_position_result attached_position_result ON        attached_position_result.id = review_cycle_position_result.id AND EXISTS (SELECT 1 FROM attached_review_task_done_results_map WHERE attached_review_task_done_results_map.review_cycle_position_result_id = attached_position_result.id)) LEFT JOIN review_cycle_comment_option     ON review_cycle_position_result.review_cycle_comment_option_id = review_cycle_comment_option.id) LEFT JOIN object_list_release departure_object_list_release ON review_cycle_node_result.departure_object_list_id = departure_object_list_release.id) LEFT JOIN signature departure_object_list_signature ON departure_object_list_release.signature_id = departure_object_list_signature.id) LEFT JOIN object_release departure_object_release ON      departure_object_release.object_list_release_id = departure_object_list_release.id AND departure_object_release.object_id = object.id) LEFT JOIN object_planner_release departure_object_planner_release ON      departure_object_planner_release.object_id = departure_object_release.id AND departure_object_planner_release.object_planner_id = object_planner.id) LEFT JOIN review_cycle_instance_released departure_review_cycle_instance_released ON departure_object_planner_release.review_cycle_instance_id = departure_review_cycle_instance_released.id) LEFT JOIN review_cycle_cell_instance_released departure_review_cycle_cell_instance_released ON        departure_review_cycle_cell_instance_released.review_cycle_instance_id = departure_review_cycle_instance_released.id AND departure_review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_node.review_cycle_cell_id) LEFT JOIN review_cycle_node_instance_released departure_review_cycle_node_instance_released ON        departure_review_cycle_node_instance_released.review_cycle_cell_instance_id = departure_review_cycle_cell_instance_released.id AND departure_review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) LEFT JOIN project_participant position_participant ON review_cycle_position_result.project_participant_id = position_participant.id) LEFT JOIN project_participation position_participation ON position_participant.participation_id = position_participation.id) LEFT JOIN cdes_role position_role  ON position_participation.role_id = position_role.id) LEFT JOIN organisation_person position_organisation_person ON position_participant.organisation_person_id = position_organisation_person.id) LEFT JOIN person position_person ON position_organisation_person.person_id = position_person.id) LEFT JOIN organisation position_organisation ON position_organisation_person.organisation_id = position_organisation.id) LEFT JOIN project_participant position_main_participant ON      position_main_participant.participation_id = position_participant.participation_id AND position_main_participant.main_participant_flag = 1 AND position_main_participant.inactive_flag != 1) LEFT JOIN organisation_person position_main_org_person ON position_main_participant.organisation_person_id = position_main_org_person.id) LEFT JOIN organisation position_main_organisation ON position_main_org_person.organisation_id = position_main_organisation.id) LEFT JOIN person position_main_person ON position_main_org_person.person_id = position_main_person.id) LEFT JOIN project_participant position_overriding_participant ON review_cycle_position_result.overriding_project_participant_id = position_overriding_participant.id) LEFT JOIN organisation_person position_overriding_org_person ON position_overriding_participant.organisation_person_id = position_overriding_org_person.id) LEFT JOIN person position_overriding_person ON position_overriding_org_person.person_id = position_overriding_person.id) LEFT JOIN realm                           ON review_cycle_position_result.realm_id = realm.id) WHERE base_version.id = ? ";
    }

    private String getResultOptionSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.RESULT_OPTIONS, "reviewCycleResultOption") + "FROM review_cycle_result_option ";
    }

    private String getCycleInstancesSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.CYCLE_INSTANCES, "reviewCycleCellInstanceReleased", "reviewCycleNodeInstanceReleased", "nonEmptyNodeInstanceReleased", "reviewCycleNode", "endNode", "reviewCycleCell", "destCell") + "FROM (((((((  review_cycle_cell_instance_released LEFT JOIN review_cycle_node_instance_released   ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id) LEFT JOIN review_cycle_node_instance_released non_empty_node_instance_released ON      non_empty_node_instance_released.id = review_cycle_node_instance_released.id AND (SELECT count(1) FROM review_cycle_node_position_released WHERE review_cycle_node_position_released.review_cycle_node_instance_id = non_empty_node_instance_released.id) > 0) LEFT JOIN review_cycle_cell                     ON review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_cell.id) LEFT JOIN review_cycle_node                     ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_node end_node ON       end_node.id = review_cycle_node.id AND  end_node.position > 0 AND  end_node.position = (SELECT count(1) FROM review_cycle_node local_node WHERE local_node.review_cycle_cell_id = review_cycle_cell.id) - review_cycle_cell.is_end_cell) LEFT JOIN review_cycle_cell_connection          ON      review_cycle_cell_connection.source_cell_id = review_cycle_cell.id AND review_cycle_cell_connection.is_default_connection = 1) LEFT JOIN review_cycle_cell dest_cell           ON review_cycle_cell_connection.destination_cell_id = dest_cell.id) WHERE review_cycle_cell_instance_released.review_cycle_instance_id = ? ";
    }

    private String getNodePositionsSql(boolean getNodePositionViaObjectPlannerRelease) {
        String fromClause = getNodePositionViaObjectPlannerRelease ? "FROM (((((((((((((((( " : "FROM (((((((((((((( ";
        String nodePositionClause = getNodePositionViaObjectPlannerRelease ? "CROSS JOIN object_planner_release ) LEFT JOIN review_cycle_instance_released ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle_node_instance_released ON      review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id AND review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_node_position_released node_position ON node_position.review_cycle_node_instance_id = review_cycle_node_instance_released.id) " : "LEFT JOIN review_cycle_node_position node_position ON node_position.review_cycle_node_instance_id = review_cycle_node_instance.id) ";
        String whereClause = getNodePositionViaObjectPlannerRelease ? "WHERE base_version.id = ? AND object_planner_release.id = ? " : "WHERE base_version.id = ? ";
        String sql = "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.NODE_POSITIONS, "documentVersion", "nodePosition", "reviewCycleNode", "positionMainPerson", "positionMainOrganisation", "positionRole", "roleType", "realm") + fromClause + "document_version base_version JOIN document_version                ON base_version.document_id = document_version.document_id) JOIN review_cycle_node_instance      ON document_version.active_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_node               ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id) " + nodePositionClause + "LEFT JOIN role_type                  ON role_type.id = review_cycle_node.role_type_id) LEFT JOIN project_participation position_participation ON node_position.project_participation_id = position_participation.id) LEFT JOIN cdes_role position_role    ON       position_participation.role_id = position_role.id) LEFT JOIN project_participant position_main_participant ON      position_main_participant.participation_id = node_position.project_participation_id AND position_main_participant.main_participant_flag = 1 AND position_main_participant.inactive_flag != 1) LEFT JOIN organisation_person position_main_org_person ON position_main_participant.organisation_person_id = position_main_org_person.id) LEFT JOIN organisation position_main_organisation ON position_main_org_person.organisation_id = position_main_organisation.id) LEFT JOIN person position_main_person ON position_main_org_person.person_id = position_main_person.id) LEFT JOIN realm                      ON node_position.realm_id = realm.id) " + whereClause;
        if (log.isTraceEnabled()) {
            log.trace(sql);
        }
        return sql;
    }

    private String getAttachedNodePositionsSql(boolean getNodePositionViaObjectPlannerRelease) {
        String fromClause = getNodePositionViaObjectPlannerRelease ? "FROM ((((((((((((((((((( " : "FROM (((((((((((((( ";
        String nodePositionClause = getNodePositionViaObjectPlannerRelease ? "CROSS JOIN object_planner_release ) LEFT JOIN review_cycle_instance_released ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id) LEFT JOIN review_cycle_node_instance_released ON      review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id AND review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_node_instance second_node_instance ON review_cycle_node_instance_released.review_cycle_node_instance_id = second_node_instance.id) LEFT JOIN attached_review_cycle_node_position attached_node_position ON      attached_node_position.document_version_id = document_version.id AND attached_node_position.review_cycle_node_instance_id = second_node_instance.id) " : "LEFT JOIN attached_review_cycle_node_position attached_node_position ON      attached_node_position.document_version_id = document_version.id AND attached_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id) ";
        String whereClause = getNodePositionViaObjectPlannerRelease ? "WHERE base_version.id = ? AND object_planner_release.id = ? " : "WHERE base_version.id = ? ";
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.ATTACHED_NODE_POSITIONS, "documentVersion", "attachedNodePosition", "reviewCycleNode", "positionMainPerson", "positionMainOrganisation", "positionRole", "roleType", "realm") + fromClause + "document_version base_version JOIN document_version                ON base_version.document_id = document_version.document_id) JOIN review_cycle_node_instance      ON document_version.active_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_node               ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id) " + nodePositionClause + "LEFT JOIN review_cycle_node_instance node_position_node_instance ON attached_node_position.review_cycle_node_instance_id = node_position_node_instance.id) LEFT JOIN review_cycle_node node_position_node ON node_position_node_instance.review_cycle_node_id = node_position_node.id) LEFT JOIN role_type ON role_type.id = node_position_node.role_type_id) LEFT JOIN project_participation position_participation ON attached_node_position.project_participation_id = position_participation.id) LEFT JOIN cdes_role position_role    ON       position_participation.role_id = position_role.id) LEFT JOIN project_participant position_main_participant ON      position_main_participant.participation_id = attached_node_position.project_participation_id AND position_main_participant.main_participant_flag = 1 AND position_main_participant.inactive_flag != 1) LEFT JOIN organisation_person position_main_org_person ON position_main_participant.organisation_person_id = position_main_org_person.id) LEFT JOIN organisation position_main_organisation ON position_main_org_person.organisation_id = position_main_organisation.id) LEFT JOIN person position_main_person ON position_main_org_person.person_id = position_main_person.id) LEFT JOIN realm                      ON attached_node_position.realm_id = realm.id) " + whereClause;
    }

    private String getAttachmentSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.ATTACHMENT, "reviewCyclePositionResult", "attachment") + "FROM ((((((((( document_version base_version JOIN document_version                ON document_version.document_id = base_version.document_id) JOIN review_cycle_node_instance      ON document_version.active_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_node active_node   ON review_cycle_node_instance.review_cycle_node_id = active_node.id) JOIN review_cycle_cell               ON active_node.review_cycle_cell_id = review_cycle_cell.id) JOIN review_cycle_cell_result        ON      review_cycle_cell_result.review_cycle_cell_id = review_cycle_cell.id AND review_cycle_cell_result.document_version_id = document_version.id) JOIN review_cycle_node_result        ON review_cycle_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id) JOIN review_cycle_position_result    ON        review_cycle_position_result.review_cycle_node_result_id = review_cycle_node_result.id) JOIN position_result_attachment_map  ON position_result_attachment_map.result_id = review_cycle_position_result.id) JOIN attachment                      ON position_result_attachment_map.attachment_id = attachment.id) WHERE base_version.id = ? ";
    }

    private String getCellConnectionResultsSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.CELL_CONNECTION_RESULTS, "documentVersion", "destVersionCellConnectionResult", "connectionResultStatementResult", "positionParticipant", "positionMainOrganisation", "positionMainPerson", "positionPerson", "positionOrganisation", "realm") + "FROM (((((((((((( document_version base_version JOIN document_version              ON document_version.document_id = base_version.document_id) JOIN review_cycle_cell_connection_result dest_version_cell_connection_result ON dest_version_cell_connection_result.destination_document_version_id = document_version.id) JOIN review_cycle_cell_connection_statement_result connection_result_statement_result ON connection_result_statement_result.review_cycle_cell_connection_result_id = dest_version_cell_connection_result.id) LEFT JOIN realm                         ON connection_result_statement_result.realm_id = realm.id) LEFT JOIN project_participant position_participant ON dest_version_cell_connection_result.project_participant_id = position_participant.id) LEFT JOIN organisation_person position_org_person ON position_participant.organisation_person_id = position_org_person.id) LEFT JOIN person position_person        ON position_org_person.person_id = position_person.id) LEFT JOIN organisation position_organisation ON position_org_person.organisation_id = position_organisation.id) LEFT JOIN project_participant position_main_participant ON      position_main_participant.participation_id = position_participant.participation_id AND position_main_participant.main_participant_flag = 1 AND position_main_participant.inactive_flag != 1) LEFT JOIN organisation_person position_main_org_person ON position_main_participant.organisation_person_id = position_main_org_person.id) LEFT JOIN organisation position_main_organisation ON position_main_org_person.organisation_id = position_main_organisation.id) LEFT JOIN person position_main_person   ON position_main_org_person.person_id = position_main_person.id) WHERE base_version.id = ? ";
    }

    private String getEntryResultsSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.ENTRY_RESULTS, "documentVersion", "reviewCycleEntryResult", "reviewCycleEntryStatementResult", "positionParticipant", "positionMainOrganisation", "positionMainPerson", "positionPerson", "positionOrganisation", "realm") + "FROM (((((((((((( document_version base_version JOIN document_version              ON document_version.document_id = base_version.document_id) JOIN review_cycle_entry_result     ON review_cycle_entry_result.document_version_id = document_version.id) JOIN review_cycle_entry_statement_result ON review_cycle_entry_statement_result.review_cycle_entry_result_id = review_cycle_entry_result.id) LEFT JOIN realm                         ON review_cycle_entry_statement_result.realm_id = realm.id) LEFT JOIN project_participant position_participant ON review_cycle_entry_result.project_participant_id = position_participant.id) LEFT JOIN organisation_person position_org_person ON position_participant.organisation_person_id = position_org_person.id) LEFT JOIN person position_person        ON position_org_person.person_id = position_person.id) LEFT JOIN organisation position_organisation ON position_org_person.organisation_id = position_organisation.id) LEFT JOIN project_participant position_main_participant ON      position_main_participant.participation_id = position_participant.participation_id AND position_main_participant.main_participant_flag = 1 AND position_main_participant.inactive_flag != 1) LEFT JOIN organisation_person position_main_org_person ON position_main_participant.organisation_person_id = position_main_org_person.id) LEFT JOIN organisation position_main_organisation ON position_main_org_person.organisation_id = position_main_organisation.id) LEFT JOIN person position_main_person   ON position_main_org_person.person_id = position_main_person.id) WHERE base_version.id = ? ";
    }

    private String getOebbCommentsSql() {
        return "SELECT " + this.getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent.OEBB_COMMENTS, "oebbComment", "reviewCycleNodeResult") + "FROM ((((((( document_version base_version JOIN document_version                ON document_version.document_id = base_version.document_id) JOIN review_cycle_node_instance      ON document_version.active_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_node active_node   ON review_cycle_node_instance.review_cycle_node_id = active_node.id) JOIN review_cycle_cell               ON active_node.review_cycle_cell_id = review_cycle_cell.id) JOIN review_cycle_cell_result        ON      review_cycle_cell_result.review_cycle_cell_id = review_cycle_cell.id AND review_cycle_cell_result.document_version_id = document_version.id) JOIN review_cycle_node_result        ON review_cycle_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id) JOIN oebb_comment                    ON oebb_comment.review_cycle_node_result_id = review_cycle_node_result.id) WHERE base_version.id = ? ";
    }

    @Override
    public List<ReviewProtocolVersionJoin> getReviewProtocolVersionJoin(final Long documentVersionId, final Long reviewCycleInstanceReleasedId, final Long objectPlannerReleaseIdByVersion, final Long objectPlannerReleaseIdByTime) {
        boolean getNodePositionViaObjectPlannerRelease;
        boolean bl = getNodePositionViaObjectPlannerRelease = objectPlannerReleaseIdByVersion != null || objectPlannerReleaseIdByTime != null;
        if (log.isDebugEnabled()) {
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.VERSIONS, this.getVersionComponentSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.DOCUMENT_REFERENCES, this.getDocumentReferencesSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.PROJECT_HOLIDAYS, this.getProjectHolidaysSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.RESULT, this.getResultSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.RESULT_OPTIONS, this.getResultOptionSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.CYCLE_INSTANCES, this.getCycleInstancesSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.NODE_POSITIONS, this.getNodePositionsSql(getNodePositionViaObjectPlannerRelease));
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.ATTACHED_NODE_POSITIONS, this.getAttachedNodePositionsSql(getNodePositionViaObjectPlannerRelease));
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.ATTACHMENT, this.getAttachmentSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.CELL_CONNECTION_RESULTS, this.getCellConnectionResultsSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.ENTRY_RESULTS, this.getEntryResultsSql());
            this.queryVersionJoinComponent(documentVersionId, reviewCycleInstanceReleasedId, objectPlannerReleaseIdByVersion, objectPlannerReleaseIdByTime, ReviewProtocolVersionComponent.OEBB_COMMENTS, this.getOebbCommentsSql());
        }
        String sql = this.getVersionComponentSql() + "UNION ALL " + this.getDocumentReferencesSql() + "UNION ALL " + this.getProjectHolidaysSql() + "UNION ALL " + this.getResultSql() + "UNION ALL " + this.getResultOptionSql() + "UNION ALL " + this.getCycleInstancesSql() + "UNION ALL " + this.getNodePositionsSql(getNodePositionViaObjectPlannerRelease) + "UNION ALL " + this.getAttachedNodePositionsSql(getNodePositionViaObjectPlannerRelease) + "UNION ALL " + this.getAttachmentSql() + "UNION ALL " + this.getCellConnectionResultsSql() + "UNION ALL " + this.getEntryResultsSql() + "UNION ALL " + this.getOebbCommentsSql();
        long prevMillis = System.currentTimeMillis();
        List results = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewProtocolVersionJoin>>(){

            public List<ReviewProtocolVersionJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                currIndex = JdbcDocumentVersionDAO.populatePreviewSupportDocumentVersionClause(statement, currIndex);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                currIndex = JdbcDocumentVersionDAO.populatePreviewSupportDocumentVersionClause(statement, currIndex);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleInstanceReleasedId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                if (getNodePositionViaObjectPlannerRelease) {
                    if (objectPlannerReleaseIdByVersion != null) {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseIdByVersion);
                    } else {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseIdByTime);
                    }
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                if (getNodePositionViaObjectPlannerRelease) {
                    if (objectPlannerReleaseIdByVersion != null) {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseIdByVersion);
                    } else {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseIdByTime);
                    }
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ArrayList<ReviewProtocolVersionJoin> results = new ArrayList<ReviewProtocolVersionJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ReviewProtocolVersionJoin joinDto = AbstractJdbcDocumentVersionDAO.fillReviewProtocolVersionJoinFromResultSet(rs);
                    currIndex = AbstractJdbcDocumentVersionDAO.getNumberOfReviewProtocolVersionJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Queried [" + results.size() + "] joins in [" + (System.currentTimeMillis() - prevMillis) + "ms] in one join.");
        }
        return results;
    }

    private String getReviewProtocolVersionUnionSelectClause(ReviewProtocolVersionComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForReviewProtocolVersionJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    public static List<ReviewProtocolVersionJoin> extractForComponent(ReviewProtocolVersionComponent component, List<ReviewProtocolVersionJoin> joins) {
        ArrayList<ReviewProtocolVersionJoin> retJoins = new ArrayList<ReviewProtocolVersionJoin>();
        for (ReviewProtocolVersionJoin join : joins) {
            if (join.getUnionClause().intValue() != component.getValue()) continue;
            retJoins.add(join);
        }
        return retJoins;
    }

    public static String getPreviewSupportDocumentVersionClause() {
        return "LEFT JOIN document_version first_version   ON first_version.id = (SELECT min(local_version.id)\n FROM document_version local_version\n WHERE     local_version.document_id = document.id\n AND local_version.status != ?\n AND local_version.uploaded =\n (SELECT min(local_version_two.uploaded)\n FROM document_version local_version_two\n WHERE   local_version_two.document_id = document.id\n AND local_version_two.status != ?)))\n LEFT JOIN document_version other_version   ON other_version.id = (\n SELECT min(local_version.id)\n FROM document_version local_version\n WHERE local_version.document_id = document.id\n AND local_version.id != first_version.id\n AND local_version.status != ?\n AND (   local_version.filetype LIKE ?\n OR local_version.filetype LIKE ?\n OR local_version.filetype LIKE ?\n OR local_version.filetype LIKE ?)))\n LEFT JOIN document_version as_built_first_version\n ON first_version.as_built_reference = as_built_first_version.id)\n LEFT JOIN document_version preview_support_document_version\n ON preview_support_document_version.id = first_version.id\n AND other_version.id IS NOT NULL\n AND (document_version.id != first_version.id\n OR (      as_built_first_version.id IS NOT NULL\n AND (    as_built_first_version.filetype LIKE ?\n OR as_built_first_version.filetype LIKE ?\n OR as_built_first_version.filetype LIKE ?\n OR as_built_first_version.filetype LIKE ?))))\n ";
    }

    public static int populatePreviewSupportDocumentVersionClause(PreparedStatement statement, int currIndex) throws SQLException {
        JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.DELETED.getValue());
        JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.DELETED.getValue());
        JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)DocumentVersionStatus.DELETED.getValue());
        statement.setString(currIndex++, "hpgl");
        statement.setString(currIndex++, "hpg");
        statement.setString(currIndex++, "plt");
        statement.setString(currIndex++, "pdf");
        statement.setString(currIndex++, "hpgl");
        statement.setString(currIndex++, "hpg");
        statement.setString(currIndex++, "plt");
        statement.setString(currIndex++, "pdf");
        return currIndex;
    }

    @Override
    public GenSelectCellTaskVersionJoin getGenSelectCellTaskVersionJoin(final Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getGenSelectCellTaskVersionJoinSelectClause() + "FROM (((((((((((((((((((((((((((((( document_version JOIN document                           ON document_version.document_id = document.id) JOIN document_list                      ON document.document_list_id = document_list.id) JOIN sub_project                        ON document_list.sub_project_id = sub_project.id) JOIN project                            ON sub_project.project_id = project.id) JOIN network                            ON project.network_id = network.id) JOIN object_planner                     ON document.object_planner_id = object_planner.id) JOIN object                             ON object_planner.object_id = object.id) JOIN object_list                        ON object.object_list_id = object_list.id) JOIN object_list_release                ON     object_list_release.sub_project_id = sub_project.id AND object_list_release.version = (SELECT max(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = sub_project.id)) JOIN object_release                     ON     object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id) JOIN object_planner_release             ON     object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id) LEFT JOIN localisation                       ON project.localisation_id = localisation.id) LEFT JOIN countries                          ON localisation.country_id = countries.id) LEFT JOIN document_list_release              ON     document_list_release.document_list_id = document_list.id AND document_list_release.version = (SELECT max(local_list_release.version) FROM document_list_release local_list_release WHERE local_list_release.sub_project_id = sub_project.id)) LEFT JOIN document_release                   ON     document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id) LEFT JOIN project_participation              ON object_planner_release.planner_id = project_participation.id) LEFT JOIN project_participant                ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) LEFT JOIN organisation_person                ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                             ON organisation_person.person_id = person.id) LEFT JOIN person_variables                   ON person_variables.person_id = person.id) LEFT JOIN review_cycle_node_instance         ON document_version.active_node_instance_id = review_cycle_node_instance.id) LEFT JOIN review_cycle_node                  ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id) LEFT JOIN review_cycle_node_result           ON      review_cycle_node_result.review_cycle_node_id = review_cycle_node.id AND review_cycle_node_result.document_version_id = document_version.id) LEFT JOIN review_cycle_cell                  ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id) LEFT JOIN review_cycle_cell_result           ON      review_cycle_cell_result.review_cycle_cell_id = review_cycle_cell.id AND review_cycle_cell_result.document_version_id = document_version.id) LEFT JOIN review_cycle_result_option         ON review_cycle_cell_result.review_cycle_result_option_id = review_cycle_result_option.id) LEFT JOIN review_cycle_node_result node_result_five ON      node_result_five.review_cycle_cell_result_id = review_cycle_cell_result.id AND EXISTS (SELECT 1 FROM review_cycle_node local_node_five WHERE     node_result_five.review_cycle_node_id = local_node_five.id AND local_node_five.position = 5)) LEFT JOIN review_cycle_result_option node_result_option_five ON node_result_five.review_cycle_result_option_id = node_result_option_five.id) LEFT JOIN document_version_task select_document_version_task ON      select_document_version_task.document_version_id = document_version.id AND EXISTS (SELECT 1 FROM select_cell_connection_task WHERE select_cell_connection_task.task_id = select_document_version_task.task_id)) LEFT JOIN ((           review_cycle_node_instance_released JOIN review_cycle_cell_instance_released  ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id) JOIN review_cycle_instance_released       ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id) ON    review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id AND review_cycle_instance_released.id = object_planner_release.review_cycle_instance_id) WHERE document_version.id = ?";
        GenSelectCellTaskVersionJoin join = (GenSelectCellTaskVersionJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<GenSelectCellTaskVersionJoin>(){

            public GenSelectCellTaskVersionJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ResultSet resultSet = statement.executeQuery();
                Object join = null;
                ArrayList<GenSelectCellTaskVersionJoin> joins = new ArrayList<GenSelectCellTaskVersionJoin>();
                while (resultSet.next()) {
                    joins.add(AbstractJdbcDocumentVersionDAO.fillGenSelectCellTaskVersionJoinFromResultSet(resultSet));
                }
                if (joins.size() == 0) {
                    return null;
                }
                if (joins.size() == 1) {
                    return (GenSelectCellTaskVersionJoin)joins.get(0);
                }
                String message = "Found multiple instances of GenSelectCellTaskVersionJoin for documentVersionId = [" + documentVersionId + "], expected exactly one.";
                log.warn(message);
                ContainerHelper.logLongAttributeCompareStrings(log, joins, 2);
                throw new DAOException(message);
            }
        });
        return join;
    }

    @Override
    public List<DocumentVersion> getFormerVersions(final Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM        document_version base_version JOIN document_version                   ON base_version.document_id = document_version.document_id WHERE      base_version.id = ? AND document_version.uploaded < base_version.uploaded ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentVersion>>(){

            public List<DocumentVersion> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentVersion> ret = new ArrayList<DocumentVersion>();
                while (rs.next()) {
                    DocumentVersion documentVersion = JdbcDocumentVersionDAO.fillDocumentVersionFromResultSet(rs);
                    ret.add(documentVersion);
                }
                return ret;
            }
        });
    }

    @Override
    public List<DocumentVersion> getByDocumentName(Long documentId, String name) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "\n     FROM document_version\nLEFT JOIN document_version invalidation_version ON invalidation_version.document_id = document_version.document_id\n                                               AND invalidation_version.uploaded >= document_version.uploaded\n                                               AND invalidation_version.status = 5\nWHERE document_version.document_id = ?\nAND document_version.name = ?\nAND document_version.status != 7\nAND (invalidation_version.id IS NULL)\n";
        return (List)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
            statement.setString(currIndex++, name);
            ResultSet rs = statement.executeQuery();
            ArrayList<DocumentVersion> documentVersionsRaw = new ArrayList<DocumentVersion>();
            while (rs.next()) {
                DocumentVersion documentVersion = JdbcDocumentVersionDAO.fillDocumentVersionFromResultSet(rs);
                documentVersionsRaw.add(documentVersion);
            }
            Map idToDocumentVersions = ContainerHelper.groupById(documentVersionsRaw);
            ArrayList documentVersions = new ArrayList();
            documentVersions.addAll(idToDocumentVersions.values());
            return documentVersions;
        });
    }

    @Override
    public DocumentVersion getLatest(Long documentId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM document\nJOIN document_version ON document_version.document_id = document.id\nWHERE document.id = ?\nORDER BY document_version.uploaded DESC\n" + QueryHelper.getLimitClause((JdbcDAOSupport)this, "1") + "";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<DocumentVersion> getBySubProjectViaOriginal(Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "\nFROM original_document_order\nJOIN original_document_order_item  ON original_document_order_item.order_contract_id = original_document_order.id JOIN document_version              ON original_document_order_item.document_version_id = document_version.id WHERE original_document_order.sub_project_id = ? ";
        List<DocumentVersion> documentVersionsRaw = QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(subProjectId));
        Map<Long, DocumentVersion> idToDocumentVersions = ContainerHelper.groupById(documentVersionsRaw);
        ArrayList<DocumentVersion> documentVersions = new ArrayList<DocumentVersion>();
        documentVersions.addAll(idToDocumentVersions.values());
        return documentVersions;
    }

    @Override
    public List<DocumentVersion> getBySubProjectViaNonInvalidatedDocument(Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document JOIN document_version ON document_version.id = document.id WHERE document.invalidated = 0 AND document.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public List<DocumentVersion> getAllRevisedAndReleasedPositiveDocumentVersionsByDocument(Long documentId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM document_version\nWHERE document_version.document_id = ?\n  AND document_version.status = " + DocumentVersionStatus.RELEASEDPOSITIV.getValue() + "\n  AND EXISTS (SELECT * FROM document_version new WHERE new.revised_document_version_id = document_version.id)\n";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<DocumentVersion> getRevisedDocumentVersionSourcesSortedByUploaded(Long documentVersionId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document_version base_version JOIN document_version              ON document_version.revised_document_version_id = base_version.id WHERE base_version.id = ? ORDER BY document_version.uploaded ASC ";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentVersionId));
    }

    @Override
    public List<DocumentVersion> getNonDeletedVersionsForNonInvalidatedDocumentsByObject(Long objectId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document_version JOIN document            ON document_version.document_id = document.id JOIN object_planner      ON document.object_planner_id = object_planner.id WHERE document_version.status != 7 AND document.invalidated != 1 AND object_planner.object_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
        });
    }

    @Override
    public List<DocumentVersion> getNonDeletedVersionsForNonInvalidatedDocumentsByObjectPlanner(Long objectPlannerId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document_version JOIN document            ON document_version.document_id = document.id WHERE document_version.status != 7 AND document.invalidated != 1 AND document.object_planner_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
        });
    }

    @Override
    public List<DocumentVersion> getBySubProjectViaInstance(Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document_version JOIN review_cycle_node_instance ON document_version.active_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_cell_instance ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id JOIN review_cycle_instance      ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id WHERE review_cycle_instance.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public List<DocumentVersion> getByInstance(Long instanceId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getSelectClauseForDto() + "FROM document_version JOIN document                   ON document_version.document_id = document.id JOIN object_planner             ON document.object_planner_id = object_planner.id WHERE object_planner.review_cycle_instance_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)instanceId);
        });
    }

    @Override
    public List<ObjectReleaseDocumentVersionJoin> getObjectReleaseDVJoinsBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentVersionDAO.getObjectReleaseDocumentVersionJoinSelectClause() + "FROM document_version JOIN document                   ON document_version.document_id = document.id JOIN object_planner             ON document.object_planner_id = object_planner.id LEFT JOIN review_cycle_node_instance ON document_version.active_node_instance_id = review_cycle_node_instance.id LEFT JOIN review_cycle_cell_instance ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id LEFT JOIN review_cycle_instance      ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id LEFT JOIN review_cycle_cell_instance correct_cell_instance ON correct_cell_instance.review_cycle_instance_id = object_planner.review_cycle_instance_id AND correct_cell_instance.review_cycle_cell_id = review_cycle_cell_instance.review_cycle_cell_id LEFT JOIN review_cycle_node_instance correct_node_instance ON correct_node_instance.review_cycle_cell_instance_id = correct_cell_instance.id AND correct_node_instance.review_cycle_node_id = review_cycle_node_instance.review_cycle_node_id WHERE review_cycle_instance.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcDocumentVersionDAO::fillObjectReleaseDocumentVersionJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }
}

