/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.document;

import at.cdes.api.document.compositeDto.DocumentListData;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionInfo;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionNodeResultInfo;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionPositionResultInfo;
import at.cdes.api.document.compositeDto.DocumentListRow;
import at.cdes.api.document.compositeDto.StatementResultInfo;
import at.cdes.api.document.searchModel.DocumentSearchModel;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.SubProject;
import at.cdes.api.guiService.DocumentService;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.review.compositeDto.INodePositionReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleCellInstanceReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInstanceReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleNodeInstanceReleasedInfo;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectHolidayDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.document.DocumentPageXlsEntry;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import at.cdes.impl.util.holiday.HolidayCalculatorFactory;
import at.cdes.impl.util.i18n.I18nHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentPageXlsExporter {
    private ActionDAO actionDAO;
    private DocumentService documentService;
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectDAO projectDAO;
    private ProjectHolidayDAO projectHolidayDAO;
    private UtilService utilService;
    private SubProjectDAO subProjectDAO;
    private String tempDirName;
    private String timeZone;
    private static final Logger log = LoggerFactory.getLogger(DocumentPageXlsExporter.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectHolidayDAO(ProjectHolidayDAO projectHolidayDAO) {
        this.projectHolidayDAO = projectHolidayDAO;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public ScratchFile export(DocumentSearchModel searchModel, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        DocumentListData documentListData = this.documentService.getDocumentListJoinForXls(searchModel);
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        this.checkPrivileges(organisationPersonId, documentListData);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(orgPersonJoin.getPersonVariablesUserLocale());
        OdfSpreadsheetDocument document = DocumentFactory.constructSpreadsheetDocument((String)"export/emptyOdsTemplate.ods", DocumentPageXlsExporter.class, (Locale)ThreadLocalManager.getLoginLocale());
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        this.fillDocument(documentListData, context, resourceBundle, document, columnToWidth, columnSortSpecs, personVariablesUserLocale);
        String xlsFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Planverzeichnis_", (OdfSpreadsheetDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.MSEXCEL_2007_XML, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(xlsFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private void checkPrivileges(Long organisationPersonId, DocumentListData documentListData) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        List documentListRows = documentListData.getDocumentListRows();
        HashSet<Long> projectIds = new HashSet<Long>();
        for (DocumentListRow documentListRow : documentListRows) {
            projectIds.add(documentListRow.getProjectId());
        }
        Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.EXPORT_REVIEW_CYCLE_STATUS);
        for (Long projectId : projectIds) {
            Set<Action> actions = projectIdToActions.get(projectId);
            if (actions.contains(Action.EXPORT_REVIEW_CYCLE_STATUS)) continue;
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] does not have privilege [" + Action.EXPORT_REVIEW_CYCLE_STATUS + "] for exporting Project [" + projectId + "].  The xls export is not allowed.");
        }
    }

    private void fillDocument(DocumentListData documentListData, OdfContext context, ResourceBundle resourceBundle, OdfSpreadsheetDocument document, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, String personVariablesUserLocale) {
        List tableElements = document.getTables();
        TableTableElement tableElement = (TableTableElement)tableElements.get(0);
        TableFactory.cleanTableElementBeforeUsage((TableTableElement)tableElement);
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        String dataRowStyle = this.getDataRowStyle(contentAutomaticStyles);
        String dataCellStyle = this.getDataCellStyle(contentAutomaticStyles);
        String dataCellStyleNoWrap = this.getDataCellStyleNoWrap(contentAutomaticStyles);
        String dataBoldCellStyle = this.getDataBoldCellStyle(contentAutomaticStyles);
        String dataTextStyle = this.getDataTextStyle(contentAutomaticStyles, standardParagraphStyle);
        String dataTextBoldStyle = this.getDataTextBoldStyle(contentAutomaticStyles, standardParagraphStyle);
        this.appendGeneratedLabel(resourceBundle, tableElement, dataRowStyle, dataCellStyleNoWrap, dataTextStyle);
        boolean doContinue = this.appendProjectInfo(documentListData, resourceBundle, tableElement, dataRowStyle, dataCellStyleNoWrap, dataBoldCellStyle, dataTextStyle, dataTextBoldStyle);
        if (!doContinue) {
            return;
        }
        this.appendTable(documentListData, columnSortSpecs, tableElement, resourceBundle, context, standardParagraphStyle, dataRowStyle, dataCellStyle, dataTextStyle, personVariablesUserLocale);
    }

    private String getDataRowStyle(Styles contentAutomaticStyles) {
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        return dataRowStyle;
    }

    private String getDataCellStyle(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("wrap");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        return dataCellStyle;
    }

    private String getDataCellStyleNoWrap(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        return dataCellStyle;
    }

    private String getDataBoldCellStyle(Styles contentAutomaticStyles) {
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("wrap");
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithFontWeight("bold");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties, dataTextProperties});
        return dataCellStyle;
    }

    private String getDataTextStyle(Styles contentAutomaticStyles, String standardParagraphStyle) {
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null);
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        return dataTextStyle;
    }

    private String getDataTextBoldStyle(Styles contentAutomaticStyles, String standardParagraphStyle) {
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold");
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        return dataTextStyle;
    }

    private void appendGeneratedLabel(ResourceBundle resourceBundle, TableTableElement tableElement, String dataRowStyle, String dataCellStyle, String dataTextStyle) {
        String rawLabel = resourceBundle.getString("reviewProtocolPdfCentralFooterLabel");
        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
        Long utcMillis = System.currentTimeMillis();
        String dateAsString = DateHelper.formatUtcMillis(utcMillis, this.timeZone, dateFormatPattern);
        String label = MessageFormat.format(rawLabel, dateAsString);
        TableTableRowElement exportInfoRowElement = TableFactory.appendRow((TableTableElement)tableElement, (String)dataRowStyle);
        TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)exportInfoRowElement, (String[])new String[]{label});
    }

    private boolean appendProjectInfo(DocumentListData documentListData, ResourceBundle resourceBundle, TableTableElement tableElement, String dataRowStyle, String dataCellStyle, String dataBoldCellStyle, String dataTextStyle, String dataBoldTextStyle) {
        this.appendEmptyLine(tableElement, dataRowStyle, dataCellStyle, dataTextStyle);
        this.appendProjectLine(tableElement, dataRowStyle, dataCellStyle, dataBoldCellStyle, dataTextStyle, dataBoldTextStyle, resourceBundle.getString("documentListXlsCaption"), null);
        this.appendEmptyLine(tableElement, dataRowStyle, dataCellStyle, dataTextStyle);
        HashSet<Long> projectIds = new HashSet<Long>();
        HashSet<Long> subProjectIds = new HashSet<Long>();
        List documentListRows = documentListData.getDocumentListRows();
        for (DocumentListRow documentListRow : documentListRows) {
            projectIds.add(documentListRow.getProjectId());
            subProjectIds.add(documentListRow.getSubProjectId());
        }
        if (projectIds.size() > 1) {
            throw new RuntimeException("Found more than one projectId in DocumentListJoins: [" + projectIds + "]");
        }
        if (subProjectIds.size() > 1) {
            throw new RuntimeException("Found more than one subProjectId in DocumentListJoins: [" + subProjectIds + "]");
        }
        if (documentListRows.size() == 0) {
            this.appendProjectLine(tableElement, dataRowStyle, dataCellStyle, dataBoldCellStyle, dataTextStyle, dataBoldTextStyle, resourceBundle.getString("documentListNoData"), null);
            return false;
        }
        Project project = (Project)this.projectDAO.get((Serializable)projectIds.iterator().next());
        String code = project.getCode();
        String name = project.getName();
        String stretchName = project.getStretchName();
        Double kmFromDouble = project.getStretchKmFrom();
        Double kmToDouble = project.getStretchKmTo();
        String comment = project.getComment();
        String kmFrom = null;
        String kmTo = null;
        DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        kmFormat.applyPattern("###,###.###");
        kmFormat.setMinimumFractionDigits(3);
        kmFormat.setMaximumFractionDigits(3);
        if (kmFromDouble != null) {
            kmFrom = kmFormat.format(kmFromDouble);
        }
        if (kmToDouble != null) {
            kmTo = kmFormat.format(kmToDouble);
        }
        String km = (kmFrom != null ? kmFrom : "") + (kmFrom != null && kmTo != null ? " - " : "") + (kmTo != null ? kmTo : "");
        SubProject subProject = (SubProject)this.subProjectDAO.get((Serializable)subProjectIds.iterator().next());
        String subProjectString = subProject.getCode() + (subProject.getNumber() != null ? subProject.getNumber() : "") + " " + subProject.getName();
        this.appendProjectLine(tableElement, dataRowStyle, dataCellStyle, dataBoldCellStyle, dataTextStyle, dataBoldTextStyle, resourceBundle.getString("documentListXlsProject"), code + " " + name);
        this.appendProjectLine(tableElement, dataRowStyle, dataCellStyle, dataBoldCellStyle, dataTextStyle, dataBoldTextStyle, resourceBundle.getString("documentListXlsRoute"), stretchName);
        this.appendProjectLine(tableElement, dataRowStyle, dataCellStyle, dataBoldCellStyle, dataTextStyle, dataBoldTextStyle, resourceBundle.getString("documentListXlsKm"), km);
        this.appendProjectLine(tableElement, dataRowStyle, dataCellStyle, dataBoldCellStyle, dataTextStyle, dataBoldTextStyle, resourceBundle.getString("documentListXlsComment"), comment);
        this.appendProjectLine(tableElement, dataRowStyle, dataCellStyle, dataBoldCellStyle, dataTextStyle, dataBoldTextStyle, resourceBundle.getString("documentListXlsSubProject"), subProjectString);
        this.appendEmptyLine(tableElement, dataRowStyle, dataCellStyle, dataTextStyle);
        return true;
    }

    private void appendProjectLine(TableTableElement tableElement, String dataRowStyle, String dataCellStyle, String dataBoldCellStyle, String dataTextStyle, String dataBoldTextStyle, String caption, String content) {
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, (String)dataRowStyle);
        TableFactory.appendCell((String)dataBoldCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{caption});
        if (content != null) {
            TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{content});
        }
    }

    private void appendEmptyLine(TableTableElement tableElement, String rowStyle, String cellStyle, String textStyle) {
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, (String)rowStyle);
        TableFactory.appendEmptyCell((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement);
    }

    private void appendTable(DocumentListData documentListData, List<ColumnSortSpec> columnSortSpecs, TableTableElement tableElement, ResourceBundle resourceBundle, OdfContext context, String standardParagraphStyle, String dataRowStyle, String dataCellStyle, String dataTextStyle, String personVariablesUserLocale) {
        HolidayCalculator holidayCalculator = this.constructHolidayCalculator(documentListData);
        List<DocumentPageXlsEntry> entries = this.constructEntries(documentListData, resourceBundle, personVariablesUserLocale, holidayCalculator);
        List columns = this.constructColumns(documentListData, resourceBundle, dataCellStyle, dataTextStyle, personVariablesUserLocale);
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        headerCellProperties.setFoWrapOptionAttribute("wrap");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold");
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        HashMap<String, Double> columnToWidth = new HashMap<String, Double>();
        columnToWidth.put("versionedDocumentName", 6.0);
        columnToWidth.put("_documentVersionName", 5.0);
        columnToWidth.put("_documentContent", 5.0);
        columnToWidth.put("planner", 7.5);
        columnToWidth.put("objectRelease", 5.0);
        columnToWidth.put("objectPlannerRelease", 5.0);
        columnToWidth.put("reviewCycleInstanceReleased", 3.0);
        columnToWidth.put("documentVersionStatus", 3.0);
        columnToWidth.put("cellName", 3.0);
        columnToWidth.put("nodeName", 5.0);
        columnToWidth.put("releaseDate", 4.0);
        columnToWidth.put("uploadDate", 4.0);
        columnToWidth.put("type", 3.0);
        columnToWidth.put("reviewer", 7.5);
        columnToWidth.put("realm", 5.0);
        columnToWidth.put("reviewComment", 15.0);
        columnToWidth.put("signatureDate", 4.0);
        columnToWidth.put("result", 6.0);
        columnToWidth.put("effectiveStartDate", 4.0);
        columnToWidth.put("effectiveEndDate", 4.0);
        columnToWidth.put("plannedStartDate", 4.0);
        columnToWidth.put("plannedEndDate", 4.0);
        columnToWidth.put("effectiveDuration", 2.0);
        columnToWidth.put("plannedDuration", 2.0);
        columnToWidth.put("diff", 2.0);
        columnToWidth.put("plkStart", 4.0);
        columnToWidth.put("plkEnd", 4.0);
        columnSortSpecs = new ArrayList<ColumnSortSpec>();
        FancyOdfTable table = DocumentPageXlsExporter.constructFancyTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, dataRowStyle, null, columns, columnToWidth);
        table.setDataRowStyle(contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithOptimalRowHeight()}));
        table.renderIntoTableElement(tableElement, entries, columnSortSpecs, true);
    }

    private static <T> FancyOdfTable<T> constructFancyTable(Styles styles, String headerCellStyle, String headerTextStyle, String dataCellStyle, String dataTextStyle, String dataRowStyle, Double width, List<FancyOdfTableColumn<T>> columns, Map<String, Double> absoluteColumnWidths) {
        FancyOdfTable table = new FancyOdfTable(styles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, width, null, columns);
        table.setDataRowStyle(dataRowStyle);
        table.setAbsoluteColumnWidths(absoluteColumnWidths);
        return table;
    }

    private List<FancyOdfTableColumn<DocumentPageXlsEntry>> constructColumns(DocumentListData documentListData, ResourceBundle resourceBundle, String dataCellStyle, String dataTextStyle, String personVariablesUserLocale) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        ReviewCycleInfo cycleInfo = documentListData.getCycleInfo();
        ArrayList<FancyOdfTableColumn<DocumentPageXlsEntry>> columns = new ArrayList<FancyOdfTableColumn<DocumentPageXlsEntry>>();
        columns.add(this.constructDocumentNameColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructUnversionedDocumentNameColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructDocumentContentColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        columns.add(this.constructPlannerColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale, true, "planner", resourceBundle.getString("documentListXlsMainParticipantCaption")));
        columns.add(this.constructObjectReleaseColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructObjectPlannerReleaseColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructReviewCycleInstanceReleasedColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructDocumentVersionStatusColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructCellNameColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, cycleInfo, personVariablesUserLocale));
        columns.add(this.constructNodeNameColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, cycleInfo, personVariablesUserLocale));
        columns.add(this.constructReleaseDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructUploadedColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructTypeColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructReviewerColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructRealmColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        columns.add(this.constructReviewCommentColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructSignatureDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructResultColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        columns.add(this.constructPlannedStartDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructEffectiveStartDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructPlannedEndDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructEffectiveEndDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructEffectiveDurationColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructPlannedDurationColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructDiffColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructPLKStartColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(this.constructPLKEndColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        return columns;
    }

    private double getCurrentUtcSeconds() {
        return new Double(System.currentTimeMillis()) / 1000.0;
    }

    private String getString(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    private String getI18nString(String s, String personVariablesUserLocale) {
        if (s != null) {
            return I18nHelper.getLocaleString(s, personVariablesUserLocale);
        }
        return "";
    }

    private String getDateToSecond(Double date, ResourceBundle resourceBundle) {
        if (date != null) {
            String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
            return DateHelper.formatUtcSeconds(date, this.timeZone, dateFormatPattern);
        }
        return "";
    }

    private String getDateToDay(Double date, ResourceBundle resourceBundle) {
        if (date != null) {
            String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
            return DateHelper.formatUtcSeconds(date, this.timeZone, dateFormatPattern);
        }
        return "";
    }

    private String getIntString(Integer i) {
        if (i != null) {
            return i.toString();
        }
        return "";
    }

    private HolidayCalculator constructHolidayCalculator(DocumentListData documentListData) {
        DocumentListRow someRow;
        List documentListRows = documentListData.getDocumentListRows();
        DocumentListRow documentListRow = someRow = documentListRows.size() > 0 ? (DocumentListRow)documentListRows.get(0) : null;
        if (someRow != null) {
            Long projectId = someRow.getProjectId();
            List<ProjectHoliday> projectHolidays = this.projectHolidayDAO.getByProject(projectId);
            return HolidayCalculatorFactory.getInstance("at", projectHolidays);
        }
        return HolidayCalculatorFactory.getInstance("at", new ArrayList<ProjectHoliday>());
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructDocumentNameColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("versionedDocumentName", resourceBundle.getString("documentListXlsDocumentNameCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry documentPageXlsEntry) {
                String name = documentPageXlsEntry.getDocumentNumber();
                String nameString = DocumentPageXlsExporter.this.getString(name);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry rowOne, DocumentPageXlsEntry rowTwo, boolean descending) {
                String nameOne = rowOne.getDocumentNumber();
                String nameTwo = rowTwo.getDocumentNumber();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getDocumentVersionNameString(DocumentListRow documentListRow) {
        if (documentListRow.getDocumentVersionId() != null) {
            return documentListRow.getDocumentVersionName();
        }
        if (documentListRow.getDocumentReleaseId() != null) {
            return documentListRow.getDocumentReleaseName();
        }
        return documentListRow.getDocumentName();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructUnversionedDocumentNameColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("_documentVersionName", resourceBundle.getString("documentListXlsDocumentNameUnversionedCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry documentPageXlsEntry) {
                String name = documentPageXlsEntry.getUnversionedDocumentNumber();
                String nameString = DocumentPageXlsExporter.this.getString(name);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String nameOne = entryOne.getUnversionedDocumentNumber();
                String nameTwo = entryTwo.getUnversionedDocumentNumber();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getUnversionedDocumentNameString(DocumentListRow documentListRow) {
        if (documentListRow.getDocumentReleaseId() != null) {
            return documentListRow.getDocumentReleaseName();
        }
        return documentListRow.getDocumentName();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructDocumentContentColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, String personVariablesUserLocale) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("_documentContent", resourceBundle.getString("documentListXlsDocumentContentCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String content = entry.getDocumentContent();
                String contentString = DocumentPageXlsExporter.this.getString(content);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, contentString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String contentOne = entryOne.getDocumentContent();
                String contentTwo = entryTwo.getDocumentContent();
                return CompareHelper.defaultStringCompare(collator, contentOne, contentTwo, descending);
            }
        };
    }

    private String getDocumentContentString(DocumentListRow documentListRow, String personVariablesUserLocale) {
        String content = "";
        content = documentListRow.getDocumentReleaseId() != null ? documentListRow.getDocumentReleaseContent() : documentListRow.getDocumentContent();
        return I18nHelper.getLocaleString(content, personVariablesUserLocale);
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructPlannerColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, String personVariablesUserLocale, boolean considerDocument, String columnId, String caption) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>(columnId, caption){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String planner = entry.getPlannerName();
                String plannerString = DocumentPageXlsExporter.this.getString(planner);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, plannerString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String plannerOne = entryOne.getPlannerName();
                String plannerTwo = entryTwo.getPlannerName();
                return CompareHelper.defaultStringCompare(collator, plannerOne, plannerTwo, descending);
            }
        };
    }

    private String getPlannerString(DocumentListRow documentListRow, boolean considerDocument) {
        Long documentVersionId = documentListRow.getDocumentVersionId();
        Boolean mainParticipant = documentListRow.isPlannerMainParticipant();
        String organisationName = documentListRow.getPlannerOrganisationName();
        String personGivenName = documentListRow.getPlannerPersonGivenName();
        String personSurName = documentListRow.getPlannerPersonSurName();
        String mainPersonGivenName = documentListRow.getPlannerMainPersonGivenName();
        String mainPersonSurName = documentListRow.getPlannerMainPersonSurName();
        if (documentVersionId == null) {
            if (considerDocument) {
                return organisationName + " (" + mainPersonGivenName + " " + mainPersonSurName + ")";
            }
            return "";
        }
        if (mainParticipant == null) {
            return "---";
        }
        String prefix = organisationName + " (" + mainPersonGivenName + " " + mainPersonSurName + ")";
        if (mainParticipant.booleanValue()) {
            return prefix;
        }
        return prefix + " i.V. " + personGivenName + " " + personSurName;
    }

    public String getDocumentPlannerName(DocumentListRow row) {
        String organisationName = row.getPlannerOrganisationName();
        String givenName = row.getPlannerMainPersonGivenName();
        String surName = row.getPlannerMainPersonSurName();
        return organisationName + " (" + givenName + " " + surName + ")";
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructObjectReleaseColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("objectRelease", resourceBundle.getString("documentListXlsSystemCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String name = entry.getObjectText();
                String nameString = DocumentPageXlsExporter.this.getString(name);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String nameOne = entryOne.getObjectText();
                String nameTwo = entryTwo.getObjectText();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getObjectReleaseString(DocumentListRow documentListRow) {
        String objectReleaseTypeCode = documentListRow.getObjectReleaseObjectTypeCode();
        return documentListRow.getObjectReleaseCode() + (objectReleaseTypeCode != null ? objectReleaseTypeCode : "") + " " + documentListRow.getObjectReleaseName();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructObjectPlannerReleaseColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("objectPlannerRelease", resourceBundle.getString("documentListXlsSystemSheetCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String name = entry.getObjectPlannerText();
                String nameString = DocumentPageXlsExporter.this.getString(name);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String nameOne = entryOne.getObjectPlannerText();
                String nameTwo = entryTwo.getObjectPlannerText();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getObjectPlannerReleaseString(DocumentListRow documentListRow) {
        return documentListRow.getObjectPlannerReleaseCode() + " " + documentListRow.getObjectPlannerReleaseArea();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructReviewCycleInstanceReleasedColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("reviewCycleInstanceReleased", resourceBundle.getString("documentListXlsReviewCycleInstanceCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String name = entry.getReviewCycleInstanceText();
                String nameString = DocumentPageXlsExporter.this.getString(name);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String nameOne = entryOne.getReviewCycleInstanceText();
                String nameTwo = entryTwo.getReviewCycleInstanceText();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getReviewCycleInstanceString(DocumentListRow row) {
        return row.getReviewCycleInstanceReleasedName();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructDocumentVersionStatusColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("documentVersionStatus", resourceBundle.getString("documentListXlsStateCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String name = entry.getDocumentStatus();
                String nameString = DocumentPageXlsExporter.this.getString(name) + " ";
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String nameOne = entryOne.getDocumentStatus();
                String nameTwo = entryTwo.getDocumentStatus();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getDocumentVersionStatusString(DocumentListRow documentListRow, ResourceBundle resourceBundle, boolean checkForLastVersion) {
        if (checkForLastVersion && !documentListRow.isLastVersion()) {
            return null;
        }
        DocumentVersionStatus documentVersionStatus = documentListRow.getDocumentVersionStatus();
        if (documentVersionStatus == null) {
            return resourceBundle.getString("documentVersionStatusNoDocumentVersion");
        }
        return CodeHelper.getI18nDocumentVersionStatus(resourceBundle, documentVersionStatus.getValue());
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructCellNameColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("cellName", resourceBundle.getString("documentListXlsReviewCycleCellCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String name = entry.getCellName();
                String nameString = DocumentPageXlsExporter.this.getString(name);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String nameOne = entryOne.getCellName();
                String nameTwo = entryTwo.getCellName();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getCellConnectionResultCellName(DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        Long destCellId = documentListRow.getDestCellResultCellId();
        String cellName = cycleInfo.getCellName(destCellId);
        return I18nHelper.getLocaleString(cellName, personVariablesUserLocale);
    }

    private String getEntryResultCellName(DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        Long documentVersionId = documentListRow.getEntryResultDocumentVersionId();
        DocumentListOtherVersionInfo versionInfo = documentListRow.getOtherVersionInfoById(documentVersionId);
        Long nodeId = versionInfo.getActiveNodeInstanceNodeId();
        Long cellId = cycleInfo.getNodeCellId(nodeId);
        String cellName = cycleInfo.getCellName(cellId);
        return I18nHelper.getLocaleString(cellName, personVariablesUserLocale);
    }

    private String getEmptyResultCellName(ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo, String personVariablesUserLocale) {
        String cellName = cellInstanceReleasedInfo.getCellName();
        return I18nHelper.getLocaleString(cellName, personVariablesUserLocale);
    }

    private String getReviewResultCellName(ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo, String personVariablesUserLocale) {
        String cellName = cellInstanceReleasedInfo.getCellName();
        return I18nHelper.getLocaleString(cellName, personVariablesUserLocale);
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructNodeNameColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("nodeName", resourceBundle.getString("documentListXlsReviewCycleNodeCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String name = entry.getNodeName();
                String nameString = DocumentPageXlsExporter.this.getString(name);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, nameString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String nameOne = entryOne.getNodeName();
                String nameTwo = entryTwo.getNodeName();
                return CompareHelper.defaultStringCompare(collator, nameOne, nameTwo, descending);
            }
        };
    }

    private String getNodeNameStringForCellConnectionResult(DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        Long sourceDocumentVersionId = documentListRow.getCellConnectionResultSourceDocumentVersionId();
        DocumentListOtherVersionInfo versionInfo = documentListRow.getOtherVersionInfoById(sourceDocumentVersionId);
        if (versionInfo == null) {
            return "n/a";
        }
        Long nodeId = versionInfo.getActiveNodeInstanceNodeId();
        String nodeName = cycleInfo.getNodeName(nodeId);
        return I18nHelper.getLocaleString(nodeName, personVariablesUserLocale);
    }

    private String getNodeNameStringForEntryResult(DocumentListRow documentListRow, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        Long documentVersionId = documentListRow.getEntryResultDocumentVersionId();
        DocumentListOtherVersionInfo versionInfo = documentListRow.getOtherVersionInfoById(documentVersionId);
        Long nodeId = versionInfo.getActiveNodeInstanceNodeId();
        String nodeName = cycleInfo.getNodeName(nodeId);
        return I18nHelper.getLocaleString(nodeName, personVariablesUserLocale);
    }

    private String getEmptyOrOpenReviewResultNodeName(ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo, String personVariablesUserLocale) {
        String cellName = nodeInstanceReleasedInfo.getNodeName();
        return I18nHelper.getLocaleString(cellName, personVariablesUserLocale);
    }

    private String getReviewResultNodeName(DocumentListOtherVersionPositionResultInfo positionResultInfo, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        Long nodeId = positionResultInfo.getNodeId();
        String nodeName = cycleInfo.getNodeName(nodeId);
        return I18nHelper.getLocaleString(nodeName, personVariablesUserLocale);
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructReleaseDateColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("releaseDate", resourceBundle.getString("documentListXlsReleaseDate")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Double releaseDate = entry.getReleaseDate();
                String releaseDateString = DocumentPageXlsExporter.this.getDateToSecond(releaseDate, resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, releaseDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double releaseDateOne = entryOne.getReleaseDate();
                Double releaseDateTwo = entryTwo.getReleaseDate();
                return CompareHelper.defaultDoubleCompare(releaseDateOne, releaseDateTwo, descending);
            }
        };
    }

    private Double getReleaseDate(DocumentListRow documentListRow, ResourceBundle resourceBundle, Map<Long, ReviewCycleResultOption> idToResultOption) {
        Long documentVersionId = documentListRow.getDocumentVersionId();
        DocumentListOtherVersionInfo versionInfo = documentListRow.getOtherVersionInfoById(documentVersionId);
        if (versionInfo == null) {
            return null;
        }
        DocumentVersionStatus documentVersionStatus = documentListRow.getDocumentVersionStatus();
        DocumentListOtherVersionNodeResultInfo nodeResultInfo = versionInfo.getActiveNodeResultInfo();
        Double releaseDate = null;
        if (nodeResultInfo != null && documentVersionStatus != DocumentVersionStatus.INREVIEW) {
            if (!documentListRow.hasLatestPositionResult() && documentVersionStatus == DocumentVersionStatus.RELEASEDPOSITIV) {
                releaseDate = nodeResultInfo.getNodeResultArrivalDate();
            } else if (documentListRow.hasLatestPositionResult()) {
                DocumentVersionStatus latestPositionResultResultOptionStatus;
                Long latestPositionResultResultOptionId = documentListRow.getLatestPositionResultResultOptionId();
                ReviewCycleResultOption latestPositionResultResultOption = latestPositionResultResultOptionId != null ? idToResultOption.get(latestPositionResultResultOptionId) : null;
                DocumentVersionStatus documentVersionStatus2 = latestPositionResultResultOptionStatus = latestPositionResultResultOption != null ? DocumentVersionStatus.getByValue((Integer)latestPositionResultResultOption.getDocumentVersionStatus()) : null;
                if (latestPositionResultResultOptionStatus == DocumentVersionStatus.RELEASEDPOSITIV) {
                    releaseDate = documentListRow.getLatestPositionResultResultDate();
                }
            }
        }
        return releaseDate;
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructUploadedColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("uploadDate", resourceBundle.getString("documentListXlsUploadDate")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String uploadDateString = DocumentPageXlsExporter.this.getDateToSecond(entry.getUploadDate(), resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, uploadDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double uploadedOne = entryOne.getUploadDate();
                Double uploadedTwo = entryTwo.getUploadDate();
                return CompareHelper.defaultDoubleCompare(uploadedOne, uploadedTwo, descending);
            }
        };
    }

    private Double getUploadDate(DocumentListRow documentListRow) {
        return documentListRow.getDocumentVersionUploaded();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructTypeColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("type", resourceBundle.getString("documentListXlsTypeCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String type = entry.getType();
                String typeString = DocumentPageXlsExporter.this.getString(type);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, typeString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String typeOne = entryOne.getType();
                String typeTwo = entryTwo.getType();
                return CompareHelper.defaultStringCompare(collator, typeOne, typeTwo, descending);
            }
        };
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructReviewerColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("reviewer", resourceBundle.getString("documentListXlsReviewerCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String reviewer = entry.getReviewerName();
                String reviewerString = DocumentPageXlsExporter.this.getString(reviewer);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, reviewerString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String plannerOne = entryOne.getReviewerName();
                String plannerTwo = entryTwo.getReviewerName();
                return CompareHelper.defaultStringCompare(collator, plannerOne, plannerTwo, descending);
            }
        };
    }

    private String getReviewReviewerName(DocumentListOtherVersionPositionResultInfo positionResultInfo, ResourceBundle resourceBundle) {
        boolean mainParticipant = positionResultInfo.isReviewerMainParticipant();
        String organisationName = positionResultInfo.getReviewerOrganisationName();
        String personGivenName = positionResultInfo.getReviewerPersonGivenName();
        String personSurName = positionResultInfo.getReviewerPersonSurName();
        String mainPersonGivenName = positionResultInfo.getReviewerMainPersonGivenName();
        String mainPersonSurName = positionResultInfo.getReviewerMainPersonSurName();
        boolean isAttachedTask = positionResultInfo.isForAttachedTask();
        String prefix = organisationName + " (" + mainPersonGivenName + " " + mainPersonSurName + ")";
        String reviewerString = mainParticipant ? prefix : prefix + " i.V. " + personGivenName + " " + personSurName;
        if (isAttachedTask) {
            reviewerString = reviewerString + " [" + resourceBundle.getString("documentListXlsOptionalReview") + "]";
        }
        return reviewerString;
    }

    private String getOpenReviewReviewerName(INodePositionReleasedInfo nodePositionReleasedInfo, ResourceBundle resourceBundle) {
        String organisationName = nodePositionReleasedInfo.getOrganisationName();
        String personGivenName = nodePositionReleasedInfo.getPersonGivenName();
        String personSurName = nodePositionReleasedInfo.getPersonSurName();
        boolean attached = nodePositionReleasedInfo.isAttached();
        String reviewerString = organisationName + " (" + personGivenName + " " + personSurName + ")" + (attached ? " [" + resourceBundle.getString("documentListXlsOptionalReview") + "]" : "");
        return reviewerString;
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructRealmColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, final String personVariablesUserLocale) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("realm", resourceBundle.getString("documentListXlsRealmCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String realm = entry.getRealmName();
                String realmString = DocumentPageXlsExporter.this.getI18nString(realm, personVariablesUserLocale);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, realmString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String realmOne = DocumentPageXlsExporter.this.getI18nString(entryOne.getRealmName(), personVariablesUserLocale);
                String realmTwo = DocumentPageXlsExporter.this.getI18nString(entryTwo.getRealmName(), personVariablesUserLocale);
                return CompareHelper.defaultStringCompare(collator, realmOne, realmTwo, descending);
            }
        };
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructReviewCommentColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("reviewComment", resourceBundle.getString("documentListXlsReviewCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String comment = entry.getComment();
                if (comment != null) {
                    String[] tokens = comment.split("\\R");
                    comment = "  ";
                    for (int n = 0; n < tokens.length; ++n) {
                        String trimmedToken = tokens[n].trim();
                        if (trimmedToken.length() <= 0) continue;
                        trimmedToken = trimmedToken.replaceAll("\\s+", " ");
                        comment = comment + (n > 0 ? " " : "") + trimmedToken;
                    }
                }
                String commentString = DocumentPageXlsExporter.this.getString(comment);
                commentString = DocumentPageXlsExporter.this.utilService.getSafeHtml(commentString, true);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, commentString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String commentOne = entryOne.getComment();
                String commentTwo = entryTwo.getComment();
                return CompareHelper.defaultStringCompare(collator, commentOne, commentTwo, descending);
            }
        };
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructSignatureDateColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("signatureDate", resourceBundle.getString("documentListXlsDateCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String signatureDateString = DocumentPageXlsExporter.this.getDateToSecond(entry.getSignatureDate(), resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, signatureDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double signatureDateOne = entryOne.getSignatureDate();
                Double signatureDateTwo = entryTwo.getSignatureDate();
                return CompareHelper.defaultDoubleCompare(signatureDateOne, signatureDateTwo, descending);
            }
        };
    }

    private Double getSignatureDate(DocumentListRow documentListRow) {
        return documentListRow.getCellConnectionResultResultDate();
    }

    private Double getEntryResultSignatureDate(DocumentListRow documentListRow) {
        return documentListRow.getEntryResultResultDate();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructResultColumn(ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final String dataTextStyle, final String personVariablesUserLocale) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("result", resourceBundle.getString("documentListXlsResultCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                String result = entry.getReviewPositionResultText();
                String resultString = DocumentPageXlsExporter.this.getI18nString(result, personVariablesUserLocale);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, resultString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                String resultOne = entryOne.getReviewPositionResultText();
                resultOne = DocumentPageXlsExporter.this.getI18nString(resultOne, personVariablesUserLocale);
                String resultTwo = entryTwo.getReviewPositionResultText();
                resultTwo = DocumentPageXlsExporter.this.getI18nString(resultTwo, personVariablesUserLocale);
                return CompareHelper.defaultStringCompare(collator, resultOne, resultTwo, descending);
            }
        };
    }

    private String getReviewerPositionResultText(DocumentListOtherVersionPositionResultInfo positionResultInfo, ReviewCycleInfo cycleInfo, String personVariablesUserLocale) {
        Long resultOptionId = positionResultInfo.getResultOptionId();
        String resultOptionName = cycleInfo.getResultOptionName(resultOptionId);
        return I18nHelper.getLocaleString(resultOptionName, personVariablesUserLocale);
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructEffectiveStartDateColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("effectiveStartDate", resourceBundle.getString("documentListXlsActualStartCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Double effectiveStartDate = entry.getEffectiveStartDate();
                String effectiveStartDateString = DocumentPageXlsExporter.this.getDateToSecond(effectiveStartDate, resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, effectiveStartDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double effectiveStartDateOne = entryOne.getEffectiveStartDate();
                Double effectiveStartDateTwo = entryTwo.getEffectiveStartDate();
                return CompareHelper.defaultDoubleCompare(effectiveStartDateOne, effectiveStartDateTwo, descending);
            }
        };
    }

    private DocumentListOtherVersionNodeResultInfo getLastNodeResultInfo(DocumentListRow documentListRow) {
        Long sourceDocumentVersionId = documentListRow.getCellConnectionResultSourceDocumentVersionId();
        DocumentListOtherVersionInfo versionInfo = documentListRow.getOtherVersionInfoById(sourceDocumentVersionId);
        DocumentListOtherVersionNodeResultInfo lastNodeResultInfo = versionInfo != null ? versionInfo.getActiveNodeResultInfo() : null;
        return lastNodeResultInfo != null && lastNodeResultInfo.getNodeResultArrivalDate() != null ? lastNodeResultInfo : null;
    }

    private Double getEffectiveStartDate(DocumentListOtherVersionNodeResultInfo lastNodeResultInfo) {
        return lastNodeResultInfo != null ? lastNodeResultInfo.getNodeResultArrivalDate() : null;
    }

    private Double getEmptyResultEffectiveStartDate(DocumentListOtherVersionNodeResultInfo nodeResultInfo) {
        return nodeResultInfo.getNodeResultArrivalDate();
    }

    private Double getReviewerEffectiveStartDate(DocumentListOtherVersionNodeResultInfo lastNodeResultInfo) {
        return lastNodeResultInfo != null ? lastNodeResultInfo.getNodeResultArrivalDate() : null;
    }

    private Double getOpenReviewEffectiveStartDate(DocumentListOtherVersionNodeResultInfo lastNodeResultInfo) {
        return lastNodeResultInfo != null ? lastNodeResultInfo.getNodeResultArrivalDate() : null;
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructEffectiveEndDateColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("effectiveEndDate", resourceBundle.getString("documentListXlsActualEndCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Double effectiveEndDate = entry.getEffectiveEndDate();
                String effectiveEndDateString = DocumentPageXlsExporter.this.getDateToSecond(effectiveEndDate, resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, effectiveEndDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double effectiveEndDateOne = entryOne.getEffectiveEndDate();
                Double effectiveEndDateTwo = entryTwo.getEffectiveEndDate();
                return CompareHelper.defaultDoubleCompare(effectiveEndDateOne, effectiveEndDateTwo, descending);
            }
        };
    }

    private Double getReviewerEffectiveEndDate(DocumentListOtherVersionPositionResultInfo positionResultInfo) {
        return positionResultInfo.getPositionResultResultDate();
    }

    private Double getEffectiveEndDate(DocumentListRow documentListRow, DocumentListOtherVersionNodeResultInfo lastNodeResultInfo) {
        if (lastNodeResultInfo != null && documentListRow.hasCellConnectionResult()) {
            return documentListRow.getCellConnectionResultResultDate();
        }
        return null;
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructEffectiveDurationColumn(ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("effectiveDuration", resourceBundle.getString("documentListXlsActualLengthCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Integer effectiveDuration = entry.getEffectiveDuration();
                String effectiveDurationString = DocumentPageXlsExporter.this.getIntString(effectiveDuration != null ? effectiveDuration : 0);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, effectiveDurationString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Integer effectiveDurationOne = entryOne.getEffectiveDuration();
                Integer effectiveDurationTwo = entryTwo.getEffectiveDuration();
                return CompareHelper.defaultIntCompare(effectiveDurationOne, effectiveDurationTwo, descending);
            }
        };
    }

    private Integer getEffectiveDuration(Double effectiveStartDate, Double effectiveEndDate, HolidayCalculator holidayCalculator) {
        if (effectiveStartDate != null && effectiveEndDate != null) {
            return holidayCalculator.getWorkingDaysBetween(effectiveStartDate, effectiveEndDate, this.timeZone);
        }
        return null;
    }

    private Integer getEmptyResultEffectiveDuration(DocumentListOtherVersionNodeResultInfo nodeResultInfo, ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo, HolidayCalculator holidayCalculator) {
        Double startDate = this.getEmptyResultEffectiveStartDate(nodeResultInfo);
        Double endDate = this.getCurrentUtcSeconds();
        return holidayCalculator.getWorkingDaysBetween(startDate, endDate, this.timeZone);
    }

    private Integer getReviewerResultEffectiveDuration(DocumentListOtherVersionNodeResultInfo nodeResultInfo, DocumentListOtherVersionPositionResultInfo positionResultInfo, HolidayCalculator holidayCalculator) {
        Double startDate = this.getReviewerEffectiveStartDate(nodeResultInfo);
        Double endDate = this.getReviewerEffectiveEndDate(positionResultInfo);
        return holidayCalculator.getWorkingDaysBetween(startDate, endDate, this.timeZone);
    }

    private Integer getOpenReviewEffectiveDuration(DocumentListOtherVersionNodeResultInfo nodeResultInfo, HolidayCalculator holidayCalculator) {
        Double startDate = this.getOpenReviewEffectiveStartDate(nodeResultInfo);
        Double endDate = this.getCurrentUtcSeconds();
        return holidayCalculator.getWorkingDaysBetween(startDate, endDate, this.timeZone);
    }

    public Integer getDocumentEffectiveDuration(DocumentListRow documentListRow, HolidayCalculator holidayCalculator) {
        Double startDate = this.getDocumentPlannedStartDate(documentListRow);
        Double endDate = this.getCurrentUtcSeconds();
        return holidayCalculator.getWorkingDaysBetween(startDate, endDate, this.timeZone);
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructPlannedStartDateColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("plannedStartDate", resourceBundle.getString("documentListXlsExpectedStartCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Double plannedStartDate = entry.getPlannedStartDate();
                String plannedStartDateString = DocumentPageXlsExporter.this.getDateToSecond(plannedStartDate, resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, plannedStartDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double plannedStartDateOne = entryOne.getPlannedStartDate();
                Double plannedStartDateTwo = entryTwo.getPlannedStartDate();
                return CompareHelper.defaultDoubleCompare(plannedStartDateOne, plannedStartDateTwo, descending);
            }
        };
    }

    private Double getEmptyOrReviewerResultPlannedStartDate(DocumentListOtherVersionNodeResultInfo nodeResultInfo) {
        return nodeResultInfo.getNodeResultArrivalDate();
    }

    public Double getDocumentPlannedStartDate(DocumentListRow documentListRow) {
        return documentListRow.getDocumentStartDate();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructPlannedEndDateColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("plannedEndDate", resourceBundle.getString("documentListXlsExpectedEndCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Double plannedEndDate = entry.getPlannedEndDate();
                String plannedEndDateString = DocumentPageXlsExporter.this.getDateToDay(plannedEndDate, resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, plannedEndDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double plannedEndDateOne = entryOne.getPlannedEndDate();
                Double plannedEndDateTwo = entryTwo.getPlannedEndDate();
                return CompareHelper.defaultDoubleCompare(plannedEndDateOne, plannedEndDateTwo, descending);
            }
        };
    }

    private Double getPlannedEndDate(DocumentListRow documentListRow, DocumentListOtherVersionNodeResultInfo lastNodeResultInfo, Double effectiveStartDate, HolidayCalculator holidayCalculator) {
        Integer duration;
        if (lastNodeResultInfo == null) {
            return null;
        }
        Long lastNodeId = lastNodeResultInfo.getNodeId();
        ReviewCycleInstanceReleasedInfo instanceReleasedInfo = documentListRow.getInstanceReleasedInfo();
        ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo = instanceReleasedInfo.getByNodeId(lastNodeId);
        if (nodeInstanceReleasedInfo != null) {
            duration = nodeInstanceReleasedInfo.getNodeInstanceReleasedDuration();
        } else {
            Long sourceDocumentVersionId = documentListRow.getCellConnectionResultSourceDocumentVersionId();
            DocumentListOtherVersionInfo versionInfo = documentListRow.getOtherVersionInfoById(sourceDocumentVersionId);
            duration = versionInfo.getActiveNodeInstanceDuration();
        }
        return holidayCalculator.addWorkingDays(effectiveStartDate, duration, this.timeZone);
    }

    private Double getEmptyOrReviewerResultPlannedEndDate(DocumentListOtherVersionNodeResultInfo nodeResultInfo, ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo, HolidayCalculator holidayCalculator) {
        Double startDate = nodeResultInfo.getNodeResultArrivalDate();
        Integer duration = nodeInstanceReleasedInfo.getNodeInstanceReleasedDuration();
        return holidayCalculator.addWorkingDays(startDate, duration, this.timeZone);
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructPlannedDurationColumn(ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("plannedDuration", resourceBundle.getString("documentListXlsExpectedLengthCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Integer plannedDuration = entry.getPlannedDuration();
                String plannedDurationString = DocumentPageXlsExporter.this.getIntString(plannedDuration != null ? plannedDuration : 0);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, plannedDurationString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Integer plannedDurationOne = entryOne.getPlannedDuration();
                Integer plannedDurationTwo = entryTwo.getPlannedDuration();
                return CompareHelper.defaultIntCompare(plannedDurationOne, plannedDurationTwo, descending);
            }
        };
    }

    private Integer getPlannedDuration(Double plannedStartDate, Double plannedEndDate, HolidayCalculator holidayCalculator) {
        if (plannedStartDate != null && plannedEndDate != null) {
            return holidayCalculator.getWorkingDaysBetween(plannedStartDate, plannedEndDate, this.timeZone);
        }
        return null;
    }

    private Integer getEmptyOrReviewerResultPlannedDuration(DocumentListOtherVersionNodeResultInfo nodeResultInfo, ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo, HolidayCalculator holidayCalculator) {
        Double startDate = this.getEmptyOrReviewerResultPlannedStartDate(nodeResultInfo);
        Double endDate = this.getEmptyOrReviewerResultPlannedEndDate(nodeResultInfo, nodeInstanceReleasedInfo, holidayCalculator);
        return holidayCalculator.getWorkingDaysBetween(startDate, endDate, this.timeZone);
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructDiffColumn(ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("diff", resourceBundle.getString("documentListXlsDifferenceCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Integer diff = this.getDiff(entry);
                String diffString = DocumentPageXlsExporter.this.getIntString(diff);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, diffString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Integer diffOne = this.getDiff(entryOne);
                Integer diffTwo = this.getDiff(entryTwo);
                return CompareHelper.defaultIntCompare(diffOne, diffTwo, descending);
            }

            private Integer getDiff(DocumentPageXlsEntry entry) {
                int plannedDuration = entry.getPlannedDuration() != null ? entry.getPlannedDuration() : 0;
                int effectiveDuration = entry.getEffectiveDuration() != null ? entry.getEffectiveDuration() : 0;
                return plannedDuration - effectiveDuration;
            }
        };
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructPLKStartColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("plkStart", resourceBundle.getString("documentListXlsPlanDeliverCatalogueStartCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Double plkStartDate = entry.getPlanDeliverCatalogueStartDate();
                String plkStartDateString = DocumentPageXlsExporter.this.getDateToDay(plkStartDate, resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, plkStartDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double plkStartDateOne = entryOne.getPlanDeliverCatalogueStartDate();
                Double plkStartDateTwo = entryTwo.getPlanDeliverCatalogueStartDate();
                return CompareHelper.defaultDoubleCompare(plkStartDateOne, plkStartDateTwo, descending);
            }
        };
    }

    private Double getPlanDeliverCatalogueStartDate(DocumentListRow documentListRow) {
        if (documentListRow.getDocumentReleaseId() != null) {
            return documentListRow.getDocumentReleaseStartDate();
        }
        return documentListRow.getDocumentStartDate();
    }

    private FancyOdfTableColumn<DocumentPageXlsEntry> constructPLKEndColumn(final ResourceBundle resourceBundle, Collator collator, final String dataCellStyle, final String dataTextStyle) {
        return new FancyOdfTableColumn<DocumentPageXlsEntry>("plkEnd", resourceBundle.getString("documentListXlsPlanDeliverCatalogueEndCaption")){

            public void appendCell(TableTableRowElement rowElement, DocumentPageXlsEntry entry) {
                Double plkEndDate = entry.getPlanDeliverCatalogueEndDate();
                String plkEndDateString = DocumentPageXlsExporter.this.getDateToDay(plkEndDate, resourceBundle);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, plkEndDateString);
            }

            public int compare(DocumentPageXlsEntry entryOne, DocumentPageXlsEntry entryTwo, boolean descending) {
                Double plkEndDateOne = entryOne.getPlanDeliverCatalogueEndDate();
                Double plkEndDateTwo = entryTwo.getPlanDeliverCatalogueEndDate();
                return CompareHelper.defaultDoubleCompare(plkEndDateOne, plkEndDateTwo, descending);
            }
        };
    }

    private Double getPlanDeliverCatalogueEndDate(DocumentListRow documentListRow) {
        if (documentListRow.getDocumentReleaseId() != null) {
            return documentListRow.getDocumentReleaseEndDate();
        }
        return documentListRow.getDocumentEndDate();
    }

    private List<DocumentPageXlsEntry> constructEntries(DocumentListData data, ResourceBundle resourceBundle, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        ArrayList<DocumentPageXlsEntry> entries = new ArrayList<DocumentPageXlsEntry>();
        ReviewCycleInfo cycleInfo = data.getCycleInfo();
        List resultOptions = data.getResultOptions();
        Map<Long, ReviewCycleResultOption> idToResultOption = ContainerHelper.groupById(resultOptions);
        List rows = data.getDocumentListRows();
        Collections.sort(rows, new Comparator<DocumentListRow>(){

            @Override
            public int compare(DocumentListRow rowOne, DocumentListRow rowTwo) {
                String nameTwo;
                String nameOne;
                Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                int documentResult = CompareHelper.defaultStringCompare(collator, nameOne = rowOne.getDocumentReleaseId() != null ? rowOne.getDocumentReleaseName() : rowOne.getDocumentName(), nameTwo = rowTwo.getDocumentReleaseId() != null ? rowTwo.getDocumentReleaseName() : rowTwo.getDocumentName(), false);
                if (documentResult != 0) {
                    return documentResult;
                }
                Double uploadDateOne = rowOne.getDocumentVersionUploaded() != null ? rowOne.getDocumentVersionUploaded() : 0.0;
                Double uploadDateTwo = rowTwo.getDocumentVersionUploaded() != null ? rowTwo.getDocumentVersionUploaded() : 0.0;
                if (uploadDateOne < uploadDateTwo - 1.0E-12) {
                    return -1;
                }
                if (uploadDateOne > uploadDateTwo + 1.0E-12) {
                    return 1;
                }
                return 0;
            }
        });
        for (DocumentListRow row : rows) {
            if (row.hasDocumentVersion()) {
                if (row.getDocumentVersionId() != null) {
                    if (row.hasCellConnectionResult()) {
                        this.addCellConnectionResultEntries(entries, row, data, resourceBundle, idToResultOption, personVariablesUserLocale, holidayCalculator);
                    } else {
                        this.addEntryResultEntries(entries, row, data, resourceBundle, idToResultOption, personVariablesUserLocale, holidayCalculator);
                    }
                }
                Long cellInstanceId = row.getReviewCycleNodeInstanceCellInstanceId();
                Long rowNodeId = row.getReviewCycleNodeInstanceNodeId();
                ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo = row.getCellInstanceReleasedInfoByCellInstanceId(cellInstanceId);
                List nodeInstanceReleasedInfos = cellInstanceReleasedInfo.getAllNodeInstanceReleasedInfos();
                for (ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo : nodeInstanceReleasedInfos) {
                    Long nodeInstanceReleasedId = nodeInstanceReleasedInfo.getNodeInstanceReleasedId();
                    DocumentListOtherVersionNodeResultInfo nodeResultInfo = row.getOwnNodeResultInfoForInstanceReleased(nodeInstanceReleasedId);
                    if (nodeResultInfo == null) continue;
                    Long resultOptionId = nodeResultInfo.getNodeResultResultOptionId();
                    Long nodeResultNodeId = nodeResultInfo.getNodeId();
                    if (row.isLastVersion() && !nodeInstanceReleasedInfo.hasNodePositionReleasedInfos() && (resultOptionId != null && cycleInfo.getResultOptionValue(resultOptionId) != -8 || resultOptionId == null && nodeResultNodeId.longValue() == rowNodeId.longValue() && row.isInAction() && !row.isDeleted() || nodeResultInfo.isNodeFree())) {
                        this.addEmptyPosEntry(entries, row, cellInstanceReleasedInfo, nodeInstanceReleasedInfo, nodeResultInfo, data, resourceBundle, personVariablesUserLocale, holidayCalculator);
                        continue;
                    }
                    List positionResultInfos = nodeResultInfo.getAllPositionResultInfos();
                    for (DocumentListOtherVersionPositionResultInfo positionResultInfo : positionResultInfos) {
                        if (positionResultInfo.getResultOptionId() == null || !positionResultInfo.hasSignatureId()) continue;
                        this.addReviewEntry(entries, row, cellInstanceReleasedInfo, nodeInstanceReleasedInfo, nodeResultInfo, positionResultInfo, data, resourceBundle, idToResultOption, personVariablesUserLocale, holidayCalculator);
                    }
                    Long nodeReleasedNodeId = nodeInstanceReleasedInfo.getNodeId();
                    if (rowNodeId.longValue() != nodeReleasedNodeId.longValue() || row.isReleasedPositivOrNegativ() || row.isInvalidatedOrDeleted() || !row.isLastVersion()) continue;
                    List nodePositionReleasedInfos = nodeInstanceReleasedInfo.getNodePositionReleasedInfos();
                    nodePositionReleasedInfos.addAll(row.getAttachedNodePositionInfos());
                    for (INodePositionReleasedInfo nodePositionReleasedInfo : nodePositionReleasedInfos) {
                        if (nodeResultInfo.isFinished(nodePositionReleasedInfo)) continue;
                        this.addOpenReviewEntry(entries, row, cellInstanceReleasedInfo, nodeInstanceReleasedInfo, nodeResultInfo, nodePositionReleasedInfo, data, resourceBundle, idToResultOption, personVariablesUserLocale, holidayCalculator);
                    }
                }
                continue;
            }
            this.addDocumentOnlyEntry(entries, row, personVariablesUserLocale, resourceBundle, holidayCalculator);
        }
        return entries;
    }

    private void outputEntryInfoToLog(List<DocumentPageXlsEntry> entries, DocumentListRow row, String caseString) {
        if (log.isDebugEnabled()) {
            log.debug("Row [" + (12 + entries.size()) + "], Ref [" + row.getRefString() + "]: Case [" + caseString + "]");
        }
    }

    private void addCellConnectionResultEntries(List<DocumentPageXlsEntry> entries, DocumentListRow row, DocumentListData data, ResourceBundle resourceBundle, Map<Long, ReviewCycleResultOption> idToResultOption, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        ReviewCycleInfo cycleInfo = data.getCycleInfo();
        DocumentListOtherVersionNodeResultInfo lastNodeResultInfo = this.getLastNodeResultInfo(row);
        Double effectiveStartDate = this.getEffectiveStartDate(lastNodeResultInfo);
        Double effectiveEndDate = this.getEffectiveEndDate(row, lastNodeResultInfo);
        Double plannedStartDate = effectiveStartDate;
        Double plannedEndDate = this.getPlannedEndDate(row, lastNodeResultInfo, effectiveStartDate, holidayCalculator);
        this.outputEntryInfoToLog(entries, row, "CellConnectionResult");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getDocumentVersionNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(this.getPlannerString(row, false));
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(this.getDocumentVersionStatusString(row, resourceBundle, true));
        entry.setCellName(this.getCellConnectionResultCellName(row, cycleInfo, personVariablesUserLocale));
        entry.setNodeName(this.getNodeNameStringForCellConnectionResult(row, cycleInfo, personVariablesUserLocale));
        entry.setReleaseDate(this.getReleaseDate(row, resourceBundle, idToResultOption));
        entry.setUploadDate(this.getUploadDate(row));
        entry.setType(resourceBundle.getString("documentListXlsTypeCellConnectionResult"));
        entry.setReviewerName(this.getPlannerString(row, false));
        entry.setRealmName(null);
        entry.setComment(row.getCellConnectionResultComment());
        entry.setSignatureDate(this.getSignatureDate(row));
        entry.setReviewPositionResultText(null);
        entry.setPlannedStartDate(plannedStartDate);
        entry.setEffectiveStartDate(effectiveStartDate);
        entry.setPlannedEndDate(plannedEndDate);
        entry.setEffectiveEndDate(effectiveEndDate);
        entry.setEffectiveDuration(this.getEffectiveDuration(effectiveStartDate, effectiveEndDate, holidayCalculator));
        entry.setPlannedDuration(this.getPlannedDuration(plannedStartDate, plannedEndDate, holidayCalculator));
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
        ArrayList statementResultInfos = new ArrayList();
        for (StatementResultInfo statementResultInfo : statementResultInfos) {
            this.addCellConnectionStatementEntry(entries, row, entry, statementResultInfo, data, resourceBundle, personVariablesUserLocale, holidayCalculator);
        }
    }

    private void addCellConnectionStatementEntry(List<DocumentPageXlsEntry> entries, DocumentListRow row, DocumentPageXlsEntry refEntry, StatementResultInfo resultInfo, DocumentListData data, ResourceBundle resourceBundle, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        ReviewCycleInfo cycleInfo = data.getCycleInfo();
        this.outputEntryInfoToLog(entries, row, "CellConnectionStatement");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getDocumentVersionNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(this.getPlannerString(row, false));
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(this.getDocumentVersionStatusString(row, resourceBundle, true));
        entry.setCellName(this.getCellConnectionResultCellName(row, cycleInfo, personVariablesUserLocale));
        entry.setNodeName(refEntry.getNodeName());
        entry.setReleaseDate(refEntry.getReleaseDate());
        entry.setUploadDate(this.getUploadDate(row));
        entry.setType(resourceBundle.getString("documentListXlsTypeStatementResult"));
        entry.setReviewerName(this.getPlannerString(row, false));
        entry.setRealmName(resultInfo.getRealmName());
        entry.setComment(resultInfo.getCellConnectionComment());
        entry.setSignatureDate(this.getSignatureDate(row));
        entry.setReviewPositionResultText(resultInfo.getResultOptionName());
        entry.setPlannedStartDate(refEntry.getPlannedStartDate());
        entry.setEffectiveStartDate(refEntry.getEffectiveStartDate());
        entry.setPlannedEndDate(refEntry.getPlannedEndDate());
        entry.setEffectiveEndDate(refEntry.getEffectiveEndDate());
        entry.setEffectiveDuration(null);
        entry.setPlannedDuration(null);
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
    }

    private void addEntryResultEntries(List<DocumentPageXlsEntry> entries, DocumentListRow row, DocumentListData data, ResourceBundle resourceBundle, Map<Long, ReviewCycleResultOption> idToResultOption, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        ReviewCycleInfo cycleInfo = data.getCycleInfo();
        DocumentListOtherVersionNodeResultInfo lastNodeResultInfo = this.getLastNodeResultInfo(row);
        Double effectiveStartDate = row.getEntryResultResultDate();
        Double effectiveEndDate = this.getEffectiveEndDate(row, lastNodeResultInfo);
        Integer effectiveDuration = holidayCalculator.getWorkingDaysBetween(this.getPlanDeliverCatalogueStartDate(row), effectiveStartDate, this.timeZone);
        Double plannedStartDate = this.getPlanDeliverCatalogueStartDate(row);
        Double plannedEndDate = this.getPlannedEndDate(row, lastNodeResultInfo, effectiveStartDate, holidayCalculator);
        this.outputEntryInfoToLog(entries, row, "EntryResult");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getDocumentVersionNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(this.getPlannerString(row, false));
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(this.getDocumentVersionStatusString(row, resourceBundle, true));
        entry.setCellName(this.getEntryResultCellName(row, cycleInfo, personVariablesUserLocale));
        entry.setNodeName(this.getNodeNameStringForEntryResult(row, cycleInfo, personVariablesUserLocale));
        entry.setReleaseDate(this.getReleaseDate(row, resourceBundle, idToResultOption));
        entry.setUploadDate(this.getUploadDate(row));
        entry.setType(resourceBundle.getString("documentListXlsTypeEntryResult"));
        entry.setReviewerName(this.getPlannerString(row, false));
        entry.setRealmName(null);
        entry.setComment(row.getEntryResultComment());
        entry.setSignatureDate(this.getEntryResultSignatureDate(row));
        entry.setReviewPositionResultText(null);
        entry.setPlannedStartDate(plannedStartDate);
        entry.setEffectiveStartDate(effectiveStartDate);
        entry.setPlannedEndDate(plannedEndDate);
        entry.setEffectiveEndDate(effectiveEndDate);
        entry.setEffectiveDuration(effectiveDuration);
        entry.setPlannedDuration(null);
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
        ArrayList statementResultInfos = new ArrayList();
        for (StatementResultInfo statementResultInfo : statementResultInfos) {
            this.addEntryResultStatementEntry(entries, row, entry, statementResultInfo, data, resourceBundle, personVariablesUserLocale, holidayCalculator);
        }
    }

    private void addEntryResultStatementEntry(List<DocumentPageXlsEntry> entries, DocumentListRow row, DocumentPageXlsEntry refEntry, StatementResultInfo resultInfo, DocumentListData data, ResourceBundle resourceBundle, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        ReviewCycleInfo cycleInfo = data.getCycleInfo();
        this.outputEntryInfoToLog(entries, row, "EntryStatement");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getDocumentVersionNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(null);
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(this.getDocumentVersionStatusString(row, resourceBundle, true));
        entry.setCellName(this.getEntryResultCellName(row, cycleInfo, personVariablesUserLocale));
        entry.setNodeName(null);
        entry.setReleaseDate(refEntry.getReleaseDate());
        entry.setUploadDate(this.getUploadDate(row));
        entry.setType(resourceBundle.getString("documentListXlsTypeStatementResult"));
        entry.setReviewerName(null);
        entry.setRealmName(resultInfo.getRealmName());
        entry.setComment(resultInfo.getEntryComment());
        entry.setSignatureDate(this.getEntryResultSignatureDate(row));
        entry.setReviewPositionResultText(resultInfo.getResultOptionName());
        entry.setPlannedStartDate(refEntry.getPlannedStartDate());
        entry.setEffectiveStartDate(refEntry.getEffectiveStartDate());
        entry.setPlannedEndDate(refEntry.getPlannedEndDate());
        entry.setEffectiveEndDate(refEntry.getEffectiveEndDate());
        entry.setEffectiveDuration(null);
        entry.setPlannedDuration(null);
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
    }

    private void addEmptyPosEntry(List<DocumentPageXlsEntry> entries, DocumentListRow row, ReviewCycleCellInstanceReleasedInfo cellReleasedInfo, ReviewCycleNodeInstanceReleasedInfo nodeReleasedInfo, DocumentListOtherVersionNodeResultInfo nodeResultInfo, DocumentListData data, ResourceBundle resourceBundle, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        this.outputEntryInfoToLog(entries, row, "EmptyPosition");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getDocumentVersionNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(this.getPlannerString(row, false));
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(this.getDocumentVersionStatusString(row, resourceBundle, true));
        entry.setCellName(this.getEmptyResultCellName(cellReleasedInfo, personVariablesUserLocale));
        entry.setNodeName(this.getEmptyOrOpenReviewResultNodeName(nodeReleasedInfo, personVariablesUserLocale));
        entry.setReleaseDate(null);
        entry.setUploadDate(this.getUploadDate(row));
        entry.setType(resourceBundle.getString("documentListXlsTypeEmptyResult"));
        entry.setReviewerName(null);
        entry.setRealmName(null);
        entry.setComment(null);
        entry.setSignatureDate(null);
        entry.setReviewPositionResultText(null);
        entry.setPlannedStartDate(this.getEmptyOrReviewerResultPlannedStartDate(nodeResultInfo));
        entry.setEffectiveStartDate(this.getEmptyResultEffectiveStartDate(nodeResultInfo));
        entry.setPlannedEndDate(this.getEmptyOrReviewerResultPlannedEndDate(nodeResultInfo, nodeReleasedInfo, holidayCalculator));
        entry.setEffectiveEndDate(nodeResultInfo.getNodeResultDepartureDate());
        entry.setEffectiveDuration(this.getEmptyResultEffectiveDuration(nodeResultInfo, nodeReleasedInfo, holidayCalculator));
        entry.setPlannedDuration(this.getEmptyOrReviewerResultPlannedDuration(nodeResultInfo, nodeReleasedInfo, holidayCalculator));
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
    }

    private void addReviewEntry(List<DocumentPageXlsEntry> entries, DocumentListRow row, ReviewCycleCellInstanceReleasedInfo cellReleasedInfo, ReviewCycleNodeInstanceReleasedInfo nodeReleasedInfo, DocumentListOtherVersionNodeResultInfo nodeResultInfo, DocumentListOtherVersionPositionResultInfo positionResultInfo, DocumentListData data, ResourceBundle resourceBundle, Map<Long, ReviewCycleResultOption> idToResultOption, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        ReviewCycleInfo cycleInfo = data.getCycleInfo();
        this.outputEntryInfoToLog(entries, row, "Review");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getDocumentVersionNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(this.getPlannerString(row, false));
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(this.getDocumentVersionStatusString(row, resourceBundle, true));
        entry.setCellName(this.getReviewResultCellName(cellReleasedInfo, personVariablesUserLocale));
        entry.setNodeName(this.getReviewResultNodeName(positionResultInfo, cycleInfo, personVariablesUserLocale));
        entry.setReleaseDate(this.getReleaseDate(row, resourceBundle, idToResultOption));
        entry.setUploadDate(this.getUploadDate(row));
        entry.setType(resourceBundle.getString("documentListXlsTypeReview"));
        entry.setReviewerName(this.getReviewReviewerName(positionResultInfo, resourceBundle));
        entry.setRealmName(positionResultInfo.getRealmName());
        entry.setComment(positionResultInfo.getComment());
        entry.setSignatureDate(positionResultInfo.getPositionResultResultDate());
        entry.setReviewPositionResultText(this.getReviewerPositionResultText(positionResultInfo, cycleInfo, personVariablesUserLocale));
        entry.setPlannedStartDate(this.getEmptyOrReviewerResultPlannedStartDate(nodeResultInfo));
        entry.setEffectiveStartDate(this.getReviewerEffectiveStartDate(nodeResultInfo));
        entry.setPlannedEndDate(this.getEmptyOrReviewerResultPlannedEndDate(nodeResultInfo, nodeReleasedInfo, holidayCalculator));
        entry.setEffectiveEndDate(this.getReviewerEffectiveEndDate(positionResultInfo));
        entry.setEffectiveDuration(this.getReviewerResultEffectiveDuration(nodeResultInfo, positionResultInfo, holidayCalculator));
        entry.setPlannedDuration(this.getEmptyOrReviewerResultPlannedDuration(nodeResultInfo, nodeReleasedInfo, holidayCalculator));
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
    }

    private void addOpenReviewEntry(List<DocumentPageXlsEntry> entries, DocumentListRow row, ReviewCycleCellInstanceReleasedInfo cellReleasedInfo, ReviewCycleNodeInstanceReleasedInfo nodeReleasedInfo, DocumentListOtherVersionNodeResultInfo nodeResultInfo, INodePositionReleasedInfo nodePositionReleasedInfo, DocumentListData data, ResourceBundle resourceBundle, Map<Long, ReviewCycleResultOption> idToResultOption, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        this.outputEntryInfoToLog(entries, row, "OpenReview");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getDocumentVersionNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(this.getPlannerString(row, false));
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(this.getDocumentVersionStatusString(row, resourceBundle, false));
        entry.setCellName(this.getReviewResultCellName(cellReleasedInfo, personVariablesUserLocale));
        entry.setNodeName(this.getEmptyOrOpenReviewResultNodeName(nodeReleasedInfo, personVariablesUserLocale));
        entry.setReleaseDate(this.getReleaseDate(row, resourceBundle, idToResultOption));
        entry.setUploadDate(this.getUploadDate(row));
        entry.setType(resourceBundle.getString("documentListXlsTypeOpenReview"));
        entry.setReviewerName(this.getOpenReviewReviewerName(nodePositionReleasedInfo, resourceBundle));
        entry.setRealmName(nodePositionReleasedInfo.getRealmName());
        entry.setComment(null);
        entry.setSignatureDate(null);
        entry.setReviewPositionResultText(null);
        entry.setPlannedStartDate(this.getEmptyOrReviewerResultPlannedStartDate(nodeResultInfo));
        entry.setEffectiveStartDate(this.getOpenReviewEffectiveStartDate(nodeResultInfo));
        entry.setPlannedEndDate(this.getEmptyOrReviewerResultPlannedEndDate(nodeResultInfo, nodeReleasedInfo, holidayCalculator));
        entry.setEffectiveEndDate(null);
        entry.setEffectiveDuration(this.getOpenReviewEffectiveDuration(nodeResultInfo, holidayCalculator));
        entry.setPlannedDuration(this.getEmptyOrReviewerResultPlannedDuration(nodeResultInfo, nodeReleasedInfo, holidayCalculator));
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
    }

    private void addDocumentOnlyEntry(List<DocumentPageXlsEntry> entries, DocumentListRow row, String personVariablesUserLocale, ResourceBundle resourceBundle, HolidayCalculator holidayCalculator) {
        this.outputEntryInfoToLog(entries, row, "DocumentOnly");
        DocumentPageXlsEntry entry = new DocumentPageXlsEntry();
        entry.setDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setUnversionedDocumentNumber(this.getUnversionedDocumentNameString(row));
        entry.setDocumentContent(this.getDocumentContentString(row, personVariablesUserLocale));
        entry.setPlannerName(this.getDocumentPlannerName(row));
        entry.setObjectText(this.getObjectReleaseString(row));
        entry.setObjectPlannerText(this.getObjectPlannerReleaseString(row));
        entry.setReviewCycleInstanceText(this.getReviewCycleInstanceString(row));
        entry.setDocumentStatus(resourceBundle.getString("documentListXlsTypeNotUploaded"));
        entry.setCellName(null);
        entry.setNodeName(null);
        entry.setReleaseDate(null);
        entry.setUploadDate(null);
        entry.setType(resourceBundle.getString("documentListXlsTypeNotUploaded"));
        entry.setReviewerName(null);
        entry.setRealmName(null);
        entry.setComment(null);
        entry.setSignatureDate(null);
        entry.setReviewPositionResultText(null);
        entry.setPlannedStartDate(this.getDocumentPlannedStartDate(row));
        entry.setEffectiveStartDate(null);
        entry.setPlannedEndDate(null);
        entry.setEffectiveEndDate(null);
        entry.setEffectiveDuration(this.getDocumentEffectiveDuration(row, holidayCalculator));
        entry.setPlannedDuration(null);
        entry.setPlanDeliverCatalogueStartDate(this.getPlanDeliverCatalogueStartDate(row));
        entry.setPlanDeliverCatalogueEndDate(this.getPlanDeliverCatalogueEndDate(row));
        entries.add(entry);
    }
}

