/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;

public class CertificateHelper {
    private static final CertificateFactory certificateFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getX509Certificate(byte[] certificate) throws CertificateException, IOException {
        if (certificate != null && certificate.length >= 2 && certificate[0] == 48 && certificate[1] == -126) {
            X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificate));
            return cert;
        }
        String certificateAsString = new String(certificate, "UTF-8");
        try (PEMParser pr = null;){
            pr = new PEMParser((Reader)new StringReader(certificateAsString));
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)pr.readObject();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            return x509Certificate;
        }
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

