/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.email;

import at.cdes.api.dto.Email;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.joinDto.AttachmentMailJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.ProjectParticipantJoin;
import at.cdes.api.joinDto.ProjectParticipationJoin;
import at.cdes.api.joinDto.TaskJoin;
import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.api.voc.MailStatus;
import at.cdes.impl.dao.EmailDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.email.EmailHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.i18n.I18nHelper;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private String applicationName;
    private VisitlessMimeSource documentVersionMimeSource;
    public EmailDAO emailDAO;
    private Long maxEmailAttachmentFileSize;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private TaskDAO taskDAO;
    private static final Logger log = LoggerFactory.getLogger(EmailUtils.class);

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setDocumentVersionMimeSource(VisitlessMimeSource documentVersionMimeSource) {
        this.documentVersionMimeSource = documentVersionMimeSource;
    }

    public void setEmailDAO(EmailDAO emailDAO) {
        this.emailDAO = emailDAO;
    }

    public void setMaxEmailAttachmentFileSize(Long maxEmailAttachmentFileSize) {
        this.maxEmailAttachmentFileSize = maxEmailAttachmentFileSize;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public boolean checkDocumentVersionAttachmentSizeAndSendWarnMailIfNecessary(Long attachmentFileSize, AttachmentMailJoin attachmentMailJoin) {
        Long documentVersionId = attachmentMailJoin.getDocumentVersionId();
        String toMailName = PersonHelper.getCommonName(attachmentMailJoin.getPerson());
        String toMailAddress = attachmentMailJoin.getOrganisationPersonEmailAddress();
        if (attachmentFileSize > this.maxEmailAttachmentFileSize) {
            if (log.isInfoEnabled()) {
                log.error("Maximum file size [" + this.maxEmailAttachmentFileSize + "] exceeded when trying to create attachment email to [" + toMailName + "] with address [" + toMailAddress + "] for documentVersionId [" + documentVersionId + "].  Observed file size: [" + attachmentFileSize + "]");
            }
            Long projectParticipationId = attachmentMailJoin.getProjectParticipationId();
            List<ProjectParticipationJoin> participationJoins = this.projectParticipationDAO.getParticipationJoins(projectParticipationId);
            for (ProjectParticipationJoin participationJoin : participationJoins) {
                if (participationJoin.getOrganisationPersonRetiredFlag() != null && participationJoin.getOrganisationPersonRetiredFlag().booleanValue()) continue;
                String documentVersionName = attachmentMailJoin.getDocumentVersionName();
                String locale = participationJoin.getPersonVariablesUserLocale();
                ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
                String unformattedMessage = resourceBundle.getString("requestOriginalsFileTooLargeMessageText");
                String realSizeString = String.valueOf(attachmentFileSize / 1000000L);
                String sizeLimitString = String.valueOf(this.maxEmailAttachmentFileSize / 1000000L);
                String formattedMessage = MessageFormat.format(unformattedMessage, documentVersionName, realSizeString, sizeLimitString, this.applicationName);
                String contextString = this.getMailContextString(resourceBundle, attachmentMailJoin);
                OrganisationPerson receiver = participationJoin.getOrganisationPerson();
                Person receiverPerson = participationJoin.getPerson();
                String subject = resourceBundle.getString("requestOriginalsFileTooLargeMessageCaption");
                this.createMail(receiver, receiverPerson, subject, formattedMessage + contextString, null, null, null);
            }
            return false;
        }
        return true;
    }

    public String getMailContextString(ResourceBundle resourceBundle, AttachmentMailJoin baseJoin) {
        String rawString = resourceBundle.getString("requestOriginalsMailContext");
        String formattedString = MessageFormat.format(rawString, baseJoin.getNetworkName(), baseJoin.getProjectCode(), baseJoin.getProjectName(), baseJoin.getSubProjectCode(), baseJoin.getSubProjectName(), baseJoin.getObjectCode(), baseJoin.getObjectName(), baseJoin.getObjectPlannerCode(), baseJoin.getObjectPlannerArea(), baseJoin.getDocumentVersionName());
        return formattedString;
    }

    public Long getDocumentVersionAttachmentMailSize(Long documentVersionId) {
        IMimeInputStream mimeStream = null;
        Long attachmentFileSize = null;
        try {
            mimeStream = this.documentVersionMimeSource.getMimeStream(new Object[]{documentVersionId});
            attachmentFileSize = mimeStream.getStreamSize();
        }
        catch (PreviewException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (mimeStream != null) {
                try {
                    mimeStream.close();
                }
                catch (Throwable e) {
                    log.warn("Error closing attachment stream", e);
                }
            }
        }
        return attachmentFileSize;
    }

    public void createLateTaskEmail(Long organisationPersonId, Long participantId) {
        OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        OrganisationPerson receiverOrganisationPerson = organisationPersonJoin.getOrganisationPerson();
        Person receiverPerson = organisationPersonJoin.getPerson();
        String locale = organisationPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        ProjectParticipantJoin participantJoin = this.projectParticipantDAO.getParticipantJoinById(participantId);
        Long projectId = participantJoin.getProjectId();
        List<TaskJoin> taskJoins = this.taskDAO.getLateTaskJoins(projectId);
        String subject = resourceBundle.getString("mailUtilsCreateLateTaskEmailCaption");
        String projectCode = participantJoin.getProjectCode();
        String projectName = participantJoin.getProjectName();
        String networkName = participantJoin.getNetworkName();
        String automaticGeneratedRaw = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyAutomaticGenerated");
        String projectRaw = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyProject");
        String automaticGeneratedString = MessageFormat.format(automaticGeneratedRaw, this.applicationName);
        String followingDelayedString = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyFollowingDelayed");
        String projectString = MessageFormat.format(projectRaw, projectCode, projectName, networkName);
        String body = automaticGeneratedString + followingDelayedString + projectString;
        String documentLineRaw = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyDocumentLine");
        String taskNameLineRaw = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyTaskNameLine");
        String nodeLineRaw = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyNodeLine");
        String dateLineRaw = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyDateLine");
        String responsibleLineRaw = resourceBundle.getString("mailUtilsCreateLateTaskEmailBodyResonsibleLine");
        for (TaskJoin taskJoin : taskJoins) {
            String documentName = taskJoin.getDocumentVersionId() != null ? taskJoin.getDocumentVersionName() : taskJoin.getDocumentName();
            String documentContent = taskJoin.getDocumentContent();
            String documentLine = MessageFormat.format(documentLineRaw, documentName, documentContent);
            String taskNodeLine = null;
            taskNodeLine = taskJoin.getDocumentVersionId() != null ? MessageFormat.format(nodeLineRaw, I18nHelper.getLocaleStringFromDatabase(taskJoin.getReviewCycleCellName(), locale), I18nHelper.getLocaleStringFromDatabase(taskJoin.getReviewCycleNodeName(), locale)) : MessageFormat.format(taskNameLineRaw, taskJoin.getTaskName());
            String endDateString = DateHelper.formatUtcSeconds(taskJoin.getTaskEndDate(), "Europe/Vienna", resourceBundle.getString("yearToSecondFormat"));
            String dateLine = MessageFormat.format(dateLineRaw, endDateString);
            String responsibleLine = MessageFormat.format(responsibleLineRaw, taskJoin.getOrganisationName(), taskJoin.getPersonGivenName(), taskJoin.getPersonSurName());
            body = body + documentLine + taskNodeLine + dateLine + responsibleLine;
        }
        this.createMail(receiverOrganisationPerson, receiverPerson, subject, body, null, null, null);
    }

    public List<Email> createMail(OrganisationPerson receiver, Person receiverPerson, String subject, String body, String replyTo, String recipientCC, String recipientBCC) {
        List<String> addresses = EmailHelper.extractMailAddresses(receiver.getEmailAddress());
        ArrayList<Email> mails = new ArrayList<Email>();
        for (String address : addresses) {
            Email email = new Email();
            email.setStatus(Integer.valueOf(MailStatus.MAIL_STATUS_TOSEND.getValue()));
            email.setToAdr(address);
            email.setToName(PersonHelper.getCommonName(receiverPerson));
            if (recipientCC != null && recipientCC.length() > 0) {
                email.setToCCAdr(recipientCC);
            }
            if (recipientBCC != null && recipientBCC.length() > 0) {
                email.setToBCCAdr(recipientBCC);
            }
            email.setSubject(subject);
            email.setBody(body);
            email.setOrganisationPersonId(receiver.getId());
            email.setReplytoAdr(replyTo);
            email.setCreationDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            email.setErrorcount(Integer.valueOf(0));
            email.setLasterrortext("");
            mails.add(email);
        }
        return this.emailDAO.saveBatch(mails);
    }

    public List<Email> createMail(DebugContext debugContext, String toName, String toAddress, Long receiverOrgPersonId, String subject, String body, String replyTo, String recipientCC, String recipientBCC) {
        debugContext.openDebugNode("EmailUtils.createMail");
        List<String> addresses = EmailHelper.extractMailAddresses(toAddress);
        List<Email> mails = new ArrayList();
        for (String address : addresses) {
            Email email = new Email();
            email.setStatus(Integer.valueOf(MailStatus.MAIL_STATUS_TOSEND.getValue()));
            email.setToAdr(address);
            email.setToName(toName);
            if (recipientCC != null && recipientCC.length() > 0) {
                email.setToCCAdr(recipientCC);
            }
            if (recipientBCC != null && recipientBCC.length() > 0) {
                email.setToBCCAdr(recipientBCC);
            }
            email.setSubject(subject);
            email.setBody(body);
            email.setOrganisationPersonId(receiverOrgPersonId);
            email.setReplytoAdr(replyTo);
            email.setCreationDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            email.setErrorcount(Integer.valueOf(0));
            email.setLasterrortext("");
            mails.add(email);
        }
        mails = this.emailDAO.saveBatch(mails);
        for (Email mail : mails) {
            debugContext.addSaveEmailMessage(mail);
        }
        debugContext.closeDebugNode();
        return mails;
    }
}

