/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export;

import java.io.File;
import java.util.List;
import org.clazzes.odf.util.file.ConversionHelper;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public class CdesExportHelper {
    public static String saveAndConvert(String dirName, String prefix, OdfTextDocument document, OOoFileConversionTicket.TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout) {
        File odtFile = OdfFileHelper.save((String)dirName, (String)prefix, (OdfTextDocument)document);
        String targetFileName = ConversionHelper.convert((File)odtFile, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)oooFileEngine, (Long)timeout);
        return targetFileName;
    }

    public static String saveAndConvert(String dirName, String prefix, OdfSpreadsheetDocument document, OOoFileConversionTicket.TargetFileType targetFileType, OOoFileEngine oooFileEngine, Long timeout) {
        File odtFile = OdfFileHelper.save((String)dirName, (String)prefix, (OdfSpreadsheetDocument)document);
        String targetFileName = ConversionHelper.convert((File)odtFile, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.MSEXCEL_2007_XML, (OOoFileEngine)oooFileEngine);
        return targetFileName;
    }

    public static TableTableCellElement appendTextSpanCell(TableTableRowElement rowElement, String cellStyle, String ... textStylesAndContents) {
        if (textStylesAndContents.length % 2 != 0) {
            throw new IllegalArgumentException("The last parameter must consist of alternate textStyle and content.");
        }
        TableTableCellElement cell = TableFactory.appendEmptyCell((String)cellStyle, null, (TableTableRowElement)rowElement);
        TextPElement node = TextFactory.constructTextNode((Node)cell, (String)"", null);
        for (int n = 0; n < textStylesAndContents.length; n += 2) {
            String textStyle = textStylesAndContents[n];
            String content = textStylesAndContents[n + 1];
            TextFactory.constructTextSpan((Node)node, (String)content, (String)textStyle);
        }
        return cell;
    }

    public static void appendCellWithLineBreaks(String dataCellStyle, String dataTextStyle, TableTableRowElement rowElement, String data) {
        TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
        if (data != null) {
            String[] tokens = data.split("\n");
            for (int n = 0; n < tokens.length; ++n) {
                String token = tokens[n];
                TextFactory.constructTextNode((Node)cellElement, (String)token, (String)dataTextStyle);
            }
        }
    }

    public static void appendCellWithLineBreaks(String dataCellStyle, String dataTextStyle, TableTableRowElement rowElement, List<String> values) {
        TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
        for (String value : values) {
            String[] tokens = value.split("\n");
            for (int n = 0; n < tokens.length; ++n) {
                String token = tokens[n];
                TextFactory.constructTextNode((Node)cellElement, (String)token, (String)dataTextStyle);
            }
        }
    }

    public static void constructTextNodeWithLineBreaks(OdfElement parentElement, String data, String textStyle) {
        if (data != null) {
            String[] tokens = data.split("\n");
            for (int n = 0; n < tokens.length; ++n) {
                String token = tokens[n];
                TextPElement addressElement = TextFactory.constructTextNode((Node)parentElement, (String)"", (String)textStyle);
                TextFactory.constructTextSpan((Node)addressElement, (String)token, (String)textStyle);
            }
        }
    }
}

