/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.compositeDto.PlanningNotificationOrderInfo;
import at.cdes.api.compositeDto.PlanningNotificationOrderReferenceInfo;
import at.cdes.api.compositeDto.WorkflowActivityResultInfo;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.joinDto.PlanningNotificationOrderJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.joinDto.WorkflowActivityPositionResultJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CellTextStyles;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.export.planning.PlanningExportHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.CodeHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PlanningReviewProtocolExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private String tempDirName;
    private PersonVariablesDAO personVariablesDAO;
    private UtilService utilService;
    private static final Logger log = LoggerFactory.getLogger(PlanningReviewProtocolExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    private CellTextStyles constructNormalTextStyles(String standardParagraphStyle, Styles contentAutomaticStyles) {
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#FF0000", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        return new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle);
    }

    private CellTextStyles constructInvalidatedTextStyles(String standardParagraphStyle, Styles contentAutomaticStyles) {
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", null)});
        return new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle);
    }

    public ScratchFile export(WorkflowActivityResultInfo resultInfo, Map<String, Double> orderColumnToWidth, Map<String, Double> historyColumnToWidth, List<ColumnSortSpec> orderSortSpecs, List<ColumnSortSpec> historySortSpecs, boolean enableCustomerLogo) throws Exception {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(personId);
        PersonVariables personVariables = personVariablesList.get(0);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariables.getUserLocale());
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        ClassLoader classLoader = PlanningReviewProtocolExporter.class.getClassLoader();
        URL logoUrl = classLoader.getResource("export/logos/OeBB_INFRA_black_eps_small.png");
        URI logoUri = logoUrl.toURI();
        OfficeTextElement officeText = document.getContentRoot();
        officeText.setTextUseSoftPageBreaksAttribute(Boolean.valueOf(true));
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("reviewProtocolFooterGeneratedString");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw, null, null, resourceBundle);
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000")});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        CellTextStyles normalTextStyles = this.constructNormalTextStyles(standardParagraphStyle, contentAutomaticStyles);
        CellTextStyles invalidatedTextStyles = this.constructInvalidatedTextStyles(standardParagraphStyle, contentAutomaticStyles);
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        TextHElement textHElementOrder = officeText.newTextHElement(2);
        textHElementOrder.setTextContent(resourceBundle.getString("reviewProtocolOrderCaption"));
        orderSortSpecs = this.translateOrderSortColumns(orderSortSpecs);
        ArrayList<PlanningNotificationOrderInfo> orderInfos = new ArrayList<PlanningNotificationOrderInfo>();
        orderInfos.add(resultInfo.getOrderInfo());
        FancyOdfTable<PlanningNotificationOrderInfo> orderTable = this.constructPlanningNotificationOrderTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, normalTextStyles, invalidatedTextStyles, orderColumnToWidth);
        orderTable.setDataRowStyle(dataRowStyle);
        orderTable.render((Node)officeText, orderInfos, orderSortSpecs);
        TextHElement textHElementHistory = officeText.newTextHElement(2);
        textHElementHistory.setTextContent(resourceBundle.getString("reviewProtocolHistoryCaption"));
        historySortSpecs = this.translateHistorySortColumns(historySortSpecs);
        List resultJoins = resultInfo.getResultJoins();
        Map workflowActivityIdToBaulose = resultInfo.getWorkflowActivityIdToBaulose();
        Map workflowActivityIdToAttachments = resultInfo.getWorkflowActivityIdToAttachments();
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        FancyOdfTable<WorkflowActivityPositionResultJoin> historyTable = PlanningExportHelper.constructHistoryTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, rowStyle, null, historyColumnToWidth, workflowActivityIdToBaulose, workflowActivityIdToAttachments, false, this.utilService);
        historyTable.setDataRowStyle(dataRowStyle);
        historyTable.render((Node)officeText, resultJoins, historySortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_BUEK_Pruefprotokoll_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private static CellTextStyles getCellTextStyles(PlanningNotificationOrderInfo data, CellTextStyles normalTextStyles, CellTextStyles invalidatedTextStyles) {
        PlanningNotificationOrderJoin orderJoin = data.getOrderJoin();
        Boolean invalidated = orderJoin.getWorkflowEntityInvalidated();
        if (invalidated != null && invalidated.booleanValue()) {
            return invalidatedTextStyles;
        }
        return normalTextStyles;
    }

    private FancyOdfTable<PlanningNotificationOrderInfo> constructPlanningNotificationOrderTable(final ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final String dataCellStyle, String dataTextStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles, Map<String, Double> relativeColumnWidths) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("serialNumber", resourceBundle.getString("planningNotificationOrderListSerialNumberColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{data.getOrderJoin().getPlanningNotificationOrderSerialNumber() != null ? data.getOrderJoin().getPlanningNotificationOrderSerialNumber().toString() : "\u2015"});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getOrderJoin().getPlanningNotificationOrderSerialNumber(), (Long)dataTwo.getOrderJoin().getPlanningNotificationOrderSerialNumber(), (boolean)descending);
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("text", resourceBundle.getString("planningNotificationOrderListTextColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, cellTextStyles.getDataTextStyle(), rowElement, data.getOrderJoin().getPlanningNotificationOrderText());
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, dataOne.getOrderJoin().getPlanningNotificationOrderText(), dataTwo.getOrderJoin().getPlanningNotificationOrderText(), descending);
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("planningNotification", resourceBundle.getString("planningNotificationOrderListPlanningNotificationColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, cellTextStyles.getDataTextStyle(), rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private List<String> getOutput(PlanningNotificationOrderInfo orderInfo) {
                ArrayList<String> output = new ArrayList<String>();
                output.add(orderInfo.getOrderJoin().getPlanningNotificationTitle());
                List baulose = orderInfo.getBaulosMetaInformations();
                for (int n = 0; n < baulose.size(); ++n) {
                    output.add(((PlanningNotificationTextMetaInformation)baulose.get(n)).getValue());
                }
                return output;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("project", resourceBundle.getString("planningNotificationOrderProjectColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private List<String> getOutput(PlanningNotificationOrderInfo orderInfo) {
                ArrayList<String> output = new ArrayList<String>();
                for (ProjectJoin projectJoin : orderInfo.getProjectJoins()) {
                    output.add(projectJoin.getProjectCode());
                    output.add(projectJoin.getProjectName());
                }
                return output;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("authorizedInspector", resourceBundle.getString("planningNotificationOrderAuthorizedInspectorColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderAuthorizedInspector();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("reference", resourceBundle.getString("planningNotificationOrderReferenceColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String referenceString = "";
                List referenceInfos = orderInfo.getReferenceInfos();
                Collections.sort(referenceInfos, new Comparator<PlanningNotificationOrderReferenceInfo>(){

                    @Override
                    public int compare(PlanningNotificationOrderReferenceInfo referenceInfoOne, PlanningNotificationOrderReferenceInfo referenceInfoTwo) {
                        return (int)((referenceInfoOne.getPlanningNotificationOrder() != null && referenceInfoOne.getPlanningNotificationOrder().getSerialNumber() != null ? referenceInfoOne.getPlanningNotificationOrder().getSerialNumber() : 0L) - (referenceInfoTwo.getPlanningNotificationOrder() != null && referenceInfoTwo.getPlanningNotificationOrder().getSerialNumber() != null ? referenceInfoTwo.getPlanningNotificationOrder().getSerialNumber() : 0L));
                    }
                });
                for (int n = 0; n < referenceInfos.size(); ++n) {
                    PlanningNotificationOrderReferenceInfo referenceInfo = (PlanningNotificationOrderReferenceInfo)referenceInfos.get(n);
                    Long serialNumber = referenceInfo.getPlanningNotificationOrder().getSerialNumber();
                    String serialNumberString = serialNumber != null ? serialNumber.toString() : "---";
                    referenceString = referenceString + serialNumberString;
                    referenceString = referenceString + (n < referenceInfos.size() - 1 ? ", " : "");
                }
                return referenceString;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("statutoryDuty", resourceBundle.getString("planningNotificationOrderListStatutoryDutyColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getStatutoryDutyName();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("documentPosition", resourceBundle.getString("planningNotificationOrderListDocumentPositionColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderDocumentPosition();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("workflowNode", resourceBundle.getString("planningNotificationOrderListWorkflowNodeColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private List<String> getOutput(PlanningNotificationOrderInfo orderInfo) {
                String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                List workflowNodeJoins = orderInfo.getWorkflowNodeJoins();
                Collections.sort(workflowNodeJoins, new Comparator<WorkflowNodeJoin>(){

                    @Override
                    public int compare(WorkflowNodeJoin joinOne, WorkflowNodeJoin joinTwo) {
                        return joinOne.getWorkflowNodeTemplatePosition() - joinTwo.getWorkflowNodeTemplatePosition();
                    }
                });
                ArrayList<String> tokens = new ArrayList<String>();
                for (WorkflowNodeJoin workflowNodeJoin : workflowNodeJoins) {
                    tokens.add(workflowNodeJoin.getWorkflowNodeTemplateName());
                    List positionJoins = (List)orderInfo.getWorkflowNodeIdToPositions().get(workflowNodeJoin.getWorkflowNodeId());
                    if (positionJoins == null || positionJoins.size() == 0) {
                        tokens.add(resourceBundle.getString("workflowNodeNoPositions"));
                        continue;
                    }
                    for (WorkflowNodeJoin positionJoin : positionJoins) {
                        Long workflowNodePositionId = positionJoin.getWorkflowNodePositionId();
                        String inverseCommonName = PersonHelper.getInverseCommonName(positionJoin.getPerson());
                        Double dueDate = positionJoin.getWorkflowNodePositionDueDate();
                        String dueDateRemark = CodeHelper.getI18nDueDateRemark(resourceBundle, positionJoin.getWorkflowNodePositionDueDateRemark());
                        Double optionalDueDate = positionJoin.getWorkflowNodePositionOptionalDueDate();
                        String dueDateString = dueDate != null ? DateHelper.formatUtcSeconds(dueDate, "Europe/Vienna", dateFormatPattern) : resourceBundle.getString("nothing");
                        String optionalDueDateString = optionalDueDate != null ? DateHelper.formatUtcSeconds(optionalDueDate, "Europe/Vienna", dateFormatPattern) : resourceBundle.getString("nothing");
                        List baulose = (List)orderInfo.getWorkflowNodePositionIdToBaulose().get(workflowNodePositionId);
                        if (baulose == null || baulose.size() == 0) {
                            if (optionalDueDate == null) {
                                tokens.add(inverseCommonName + " " + (dueDate != null ? dueDateString : (dueDateRemark != null ? dueDateRemark : "")));
                                continue;
                            }
                            tokens.add(inverseCommonName + " " + optionalDueDateString);
                            continue;
                        }
                        for (PlanningNotificationTextMetaInformation baulos : baulose) {
                            String baulosString = baulos.getValue();
                            if (optionalDueDate == null) {
                                tokens.add(inverseCommonName + " [" + baulosString + "] " + (dueDate != null ? dueDateString : (dueDateRemark != null ? dueDateRemark : "")));
                                continue;
                            }
                            tokens.add(inverseCommonName + " [" + baulosString + "] " + optionalDueDateString);
                        }
                    }
                }
                return tokens;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("state", resourceBundle.getString("planningNotificationOrderListStateColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningReviewProtocolExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String workflowEntityStatusName = orderInfo.getOrderJoin().getWorkflowEntityStatusName();
                if (orderInfo.getOrderJoin().getWorkflowEntityInvalidated().booleanValue()) {
                    return resourceBundle.getString("workflowStatusInvalidated");
                }
                if (workflowEntityStatusName == null) {
                    return resourceBundle.getString("workflowStatusNotInitialized");
                }
                return workflowEntityStatusName;
            }
        });
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private List<ColumnSortSpec> translateOrderSortColumns(List<ColumnSortSpec> columnSortSpecs) {
        ArrayList<ColumnSortSpec> newColumnSortSpecs = new ArrayList<ColumnSortSpec>();
        for (ColumnSortSpec columnSortSpec : columnSortSpecs) {
            String property = columnSortSpec.getProperty();
            Boolean descending = columnSortSpec.getDescending();
            if ("planningNotificationOrderSerialNumber".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("serialNumber", descending));
                continue;
            }
            if ("planningNotificationOrderText".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("text", descending));
                continue;
            }
            if ("_planningNotification".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("planningNotification", descending));
                continue;
            }
            if ("_project".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("project", descending));
                continue;
            }
            if ("planningNotificationOrderAuthorizedInspector".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("authorizedInspector", descending));
                continue;
            }
            if ("statutoryDutyName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDuty", descending));
                continue;
            }
            if ("_workflowNode".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("workflowNode", descending));
                continue;
            }
            if ("workflowEntityStatusName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("state", descending));
                continue;
            }
            if ("planningNotificationOrderDocumentPosition".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentPosition", descending));
                continue;
            }
            log.warn("Unknown column [" + property + "] delivered from client.");
        }
        return newColumnSortSpecs;
    }

    private List<ColumnSortSpec> translateHistorySortColumns(List<ColumnSortSpec> columnSortSpecs) {
        ArrayList<ColumnSortSpec> newColumnSortSpecs = new ArrayList<ColumnSortSpec>();
        for (ColumnSortSpec columnSortSpec : columnSortSpecs) {
            String property = columnSortSpec.getProperty();
            Boolean descending = columnSortSpec.getDescending();
            if ("workflowActivityWorkflowNodeName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("workflowNodeName", descending));
                continue;
            }
            if ("_baulos".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("baulos", descending));
                continue;
            }
            if ("workflowActivityTokenInitiator".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("tokenInitiator", descending));
                continue;
            }
            if ("workflowActivityPositionResultReviewer".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("reviewer", descending));
                continue;
            }
            if ("workflowActivityIssued".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("issued", descending));
                continue;
            }
            if ("workflowActivityPositionResultComment".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("comment", descending));
                continue;
            }
            if ("workflowActivityPositionResultResult".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("result", descending));
                continue;
            }
            if ("workflowActivityId".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("attachment", descending));
                continue;
            }
            log.warn("Unknown column [" + property + "] delivered from client.");
        }
        return newColumnSortSpecs;
    }
}

