/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Ca;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.joinDto.CaJoin;
import at.cdes.impl.dao.GenCaDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcCaDAO
extends AbstrIdDAO<Ca>
implements GenCaDAO {
    public AbstractJdbcCaDAO() {
        super(Ca.class, "id", "ca", new String[]{"id", "organisation_person_id", "ca_cert_id", "subject_dn", "certificate", "cert_serial", "cert_ca_dn", "cert_valid_from", "cert_valid_to", "may_issue", "may_authenticate", "network_id", "private_key"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcCaDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "ca_cert_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "subject_dn") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "certificate") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_serial") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_ca_dn") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_valid_from") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_valid_to") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "may_issue") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "may_authenticate") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "private_key") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcCaDAO.getSelectClauseForDto("ca", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcCaDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".organisation_person_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + "," + entityLocalName + ".ca_cert_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "ca_cert_id") + "," + entityLocalName + ".subject_dn" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "subject_dn") + "," + entityLocalName + ".certificate" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "certificate") + "," + entityLocalName + ".cert_serial" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_serial") + "," + entityLocalName + ".cert_ca_dn" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_ca_dn") + "," + entityLocalName + ".cert_valid_from" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_valid_from") + "," + entityLocalName + ".cert_valid_to" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cert_valid_to") + "," + entityLocalName + ".may_issue" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "may_issue") + "," + entityLocalName + ".may_authenticate" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "may_authenticate") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".private_key" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "private_key") + " ";
    }

    protected Ca fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Ca ca = new Ca();
        ca.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        ca.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        ca.setCaCertId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        ca.setSubjectDn(AbstractJdbcCaDAO.getStringWithoutException(rs.getBytes(++columnIndex)));
        ca.setCertificate(rs.getBytes(++columnIndex));
        ca.setCertSerial(rs.getString(++columnIndex));
        ca.setCertCaDn(rs.getBytes(++columnIndex));
        ca.setCertValidFrom(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        ca.setCertValidTo(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        ca.setMayIssue(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        ca.setMayAuthenticate(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        ca.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        ca.setPrivateKey(rs.getBytes(++columnIndex));
        return ca;
    }

    public static Ca fillCaFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Ca ca = new Ca();
        ca.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setCaCertId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setSubjectDn(AbstractJdbcCaDAO.getStringWithoutException(rs.getBytes(columnIndex.incrementAndGet())));
        ca.setCertificate(rs.getBytes(columnIndex.incrementAndGet()));
        ca.setCertSerial(rs.getString(columnIndex.incrementAndGet()));
        ca.setCertCaDn(rs.getBytes(columnIndex.incrementAndGet()));
        ca.setCertValidFrom(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setCertValidTo(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setMayIssue(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setMayAuthenticate(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        ca.setPrivateKey(rs.getBytes(columnIndex.incrementAndGet()));
        return ca;
    }

    public static Ca fillCaFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcCaDAO.fillCaFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 13;
    }

    public static CaJoin fillCaJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        CaJoin caJoin = new CaJoin();
        caJoin.setCaId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaCaCertId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaSubjectDn(AbstractJdbcCaDAO.getStringWithoutException(rs.getBytes(++columnIndex)));
        caJoin.setCaCertificate(rs.getBytes(++columnIndex));
        caJoin.setCaCertSerial(rs.getString(++columnIndex));
        caJoin.setCaCertCaDn(rs.getBytes(++columnIndex));
        caJoin.setCaCertValidFrom(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaCertValidTo(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaMayIssue(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaMayAuthenticate(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setCaPrivateKey(rs.getBytes(++columnIndex));
        caJoin.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        caJoin.setPersonGivenName(rs.getString(++columnIndex));
        caJoin.setPersonSurName(rs.getString(++columnIndex));
        return caJoin;
    }

    public static int getNumberOfCaJoinAttributes() {
        return 17;
    }

    protected String getSelectClauseForCaJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("ca") ? result + "ca.id, ca.organisation_person_id, ca.ca_cert_id, ca.subject_dn, ca.certificate, ca.cert_serial, ca.cert_ca_dn, ca.cert_valid_from, ca.cert_valid_to, ca.may_issue, ca.may_authenticate, ca.network_id, ca.private_key" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("organisationPerson") ? result + "organisation_person.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        return result;
    }

    public int update(Ca dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Ca> dtos) {
        Iterator<Ca> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getCaJoinSelectClause() {
        return "ca.id, ca.organisation_person_id, ca.ca_cert_id, ca.subject_dn, ca.certificate, ca.cert_serial, ca.cert_ca_dn, ca.cert_valid_from, ca.cert_valid_to, ca.may_issue, ca.may_authenticate, ca.network_id, ca.private_key, organisation_person.id, person.id, person.givenName, person.surName ";
    }

    public static String getPrefixedCaJoinSelectClause() {
        return "ca.id AS ca_id, ca.organisation_person_id AS ca_organisation_person_id, ca.ca_cert_id AS ca_ca_cert_id, ca.subject_dn AS ca_subject_dn, ca.certificate AS ca_certificate, ca.cert_serial AS ca_cert_serial, ca.cert_ca_dn AS ca_cert_ca_dn, ca.cert_valid_from AS ca_cert_valid_from, ca.cert_valid_to AS ca_cert_valid_to, ca.may_issue AS ca_may_issue, ca.may_authenticate AS ca_may_authenticate, ca.network_id AS ca_network_id, ca.private_key AS ca_private_key, organisation_person.id AS organisation_person_id, person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Ca ca) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)ca.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)ca.getOrganisationPersonId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)ca.getCaCertId());
        statement.setBytes(4, ca.getSubjectDn() == null ? null : AbstractJdbcCaDAO.getBytesWithoutException(ca.getSubjectDn()));
        statement.setBytes(5, ca.getCertificate());
        statement.setString(6, ca.getCertSerial());
        statement.setBytes(7, ca.getCertCaDn());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)8, (Double)ca.getCertValidFrom());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)9, (Double)ca.getCertValidTo());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)10, (Boolean)ca.getMayIssue());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)11, (Boolean)ca.getMayAuthenticate());
        JDBCHelper.setLong((PreparedStatement)statement, (int)12, (Number)ca.getNetworkId());
        statement.setBytes(13, ca.getPrivateKey());
    }

    @Override
    public List<Ca> getByOrganisationPerson(OrganisationPerson organisationPerson) {
        return this.getByOrganisationPerson(organisationPerson.getId());
    }

    @Override
    public List<Ca> getByOrganisationPerson(final Long organisationPersonId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationPersonId);
            }
        });
    }

    @Override
    public List<Ca> getByCaCert(Ca ca) {
        return this.getByCaCert(ca.getId());
    }

    @Override
    public List<Ca> getByCaCert(final Long caId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"ca_cert_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, caId);
            }
        });
    }

    @Override
    public List<Ca> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<Ca> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<Ca> getByOrganisationPersons(Collection<Long> organisationPersonId) {
        if (organisationPersonId.isEmpty()) {
            return new ArrayList<Ca>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationPersonId.size()];
        int n = 0;
        Iterator<Long> it = organisationPersonId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Ca> getByCaCerts(Collection<Long> caId) {
        if (caId.isEmpty()) {
            return new ArrayList<Ca>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[caId.size()];
        int n = 0;
        Iterator<Long> it = caId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"ca_cert_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Ca> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<Ca>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

