/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.PlottOrderTemplate;
import at.cdes.api.joinDto.PlotOrderTemplateJoin;
import at.cdes.api.joinDto.PlotOrderTemplatePageJoin;
import at.cdes.api.plot.compositeDto.PlotOrderTemplateSearchModel;
import at.cdes.impl.dao.PlottOrderTemplateDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcPlottOrderTemplateDAO;
import at.cdes.impl.dao.unionComponent.PlotOrderTemplateSearchComponent;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcPlottOrderTemplateDAO
extends AbstractJdbcPlottOrderTemplateDAO
implements PlottOrderTemplateDAO {
    @Override
    public List<PlotOrderTemplatePageJoin> getPlotOrderTemplatePageJoins(PlotOrderTemplateSearchModel searchModel) {
        String sql = "SELECT " + JdbcPlottOrderTemplateDAO.getPlotOrderTemplatePageJoinSelectClause() + "FROM plott_order_template \nLEFT JOIN project_participation \nplotter_project_participation ON plott_order_template.plotter_id = plotter_project_participation.id \nLEFT JOIN organisation plotter_organisation  ON plotter_project_participation.organisation_id = plotter_organisation.id \nLEFT JOIN countries plotter_country          ON plotter_organisation.country_id = plotter_country.id \nLEFT JOIN order_address billing_address      ON plott_order_template.billing_address_id = billing_address.id \nLEFT JOIN countries billing_country          ON billing_address.country_id = billing_country.id \nLEFT JOIN plott_order_item_template          ON     plott_order_item_template.order_contract_id = plott_order_template.id \nAND plott_order_item_template.invalidated = 0 \nLEFT JOIN plott_properties                   ON plott_order_item_template.plott_properties_id = plott_properties.id \nLEFT JOIN project_participation delivery_participation ON plott_order_item_template.delivery_address_id = delivery_participation.id \nLEFT JOIN project_participant delivery_participant ON delivery_participant.participation_id = delivery_participation.id AND delivery_participant.main_participant_flag = 1 AND delivery_participant.inactive_flag = 0 \nLEFT JOIN organisation_person delivery_organisation_person ON delivery_participant.organisation_person_id = delivery_organisation_person.id \nLEFT JOIN organisation delivery_organisation ON delivery_organisation_person.organisation_id = delivery_organisation.id \nLEFT JOIN person delivery_person             ON delivery_organisation_person.person_id = delivery_person.id \nLEFT JOIN review_cycle_node                  ON plott_order_item_template.delivery_address_id = review_cycle_node.id \nLEFT JOIN review_cycle_cell                  ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id \nLEFT JOIN review_cycle                       ON review_cycle_cell.review_cycle_id = review_cycle.id WHERE 1=1 \n";
        final Long id = searchModel.getPlotOrderTemplateId();
        final Long projectId = searchModel.getProjectId();
        sql = id != null ? sql + "AND plott_order_template.id = ? " : sql + "AND plott_order_template.invalidated = 0 ";
        if (projectId != null) {
            sql = sql + "AND plott_order_template.project_id = ? \n";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderTemplatePageJoin>>(){

            public List<PlotOrderTemplatePageJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (id != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)id);
                }
                if (projectId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderTemplatePageJoin> joins = new ArrayList<PlotOrderTemplatePageJoin>();
                while (rs.next()) {
                    joins.add(JdbcPlottOrderTemplateDAO.fillPlotOrderTemplatePageJoinFromResultSet(rs));
                }
                return joins;
            }
        });
    }

    @Override
    public List<PlotOrderTemplateJoin> getPlotOrderTemplateJoins(final PlotOrderTemplateSearchModel searchModel) {
        String whereClause = "AND plott_order_template.invalidated = 0 ";
        if (searchModel.getProjectId() != null) {
            whereClause = whereClause + "AND plott_order_template.project_id = ? ";
        }
        if (searchModel.getPlotOrderTemplateId() != null) {
            whereClause = whereClause + "AND plott_order_template.id = ? ";
        }
        if (searchModel.getTemplateResolver() != null) {
            whereClause = whereClause + "AND plott_order_template.template_resolver = ? ";
        }
        String sql = "SELECT " + this.getPlotOrderTemplateSearchUnionSelectClause(PlotOrderTemplateSearchComponent.PLOT_ORDER, "plottOrderTemplate", "plotterOrganisation", "plotterCountry", "billingAddress", "billingCountry") + "FROM ((((( plott_order_template JOIN project_participation plotter_project_participation ON plott_order_template.plotter_id = plotter_project_participation.id) JOIN organisation plotter_organisation  ON plotter_project_participation.organisation_id = plotter_organisation.id) JOIN countries plotter_country          ON plotter_organisation.country_id = plotter_country.id) JOIN order_address billing_address      ON plott_order_template.billing_address_id = billing_address.id) JOIN countries billing_country          ON billing_address.country_id = billing_country.id) WHERE 1=1 " + whereClause + "UNION ALL SELECT " + this.getPlotOrderTemplateSearchUnionSelectClause(PlotOrderTemplateSearchComponent.PLOT_ORDER_ITEM, "plottOrderItemTemplate", "plottProperties") + "FROM ( plott_order_item_template JOIN plott_properties                   ON plott_order_item_template.plott_properties_id = plott_properties.id) WHERE EXISTS (SELECT 1 FROM plott_order_template WHERE plott_order_item_template.order_contract_id = plott_order_template.id " + whereClause + ") ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<PlotOrderTemplateJoin>>(){

            public List<PlotOrderTemplateJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (searchModel.getProjectId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getProjectId());
                }
                if (searchModel.getPlotOrderTemplateId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getPlotOrderTemplateId());
                }
                if (searchModel.getTemplateResolver() != null) {
                    statement.setString(currIndex++, searchModel.getTemplateResolver());
                }
                if (searchModel.getProjectId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getProjectId());
                }
                if (searchModel.getPlotOrderTemplateId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getPlotOrderTemplateId());
                }
                if (searchModel.getTemplateResolver() != null) {
                    statement.setString(currIndex++, searchModel.getTemplateResolver());
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<PlotOrderTemplateJoin> joins = new ArrayList<PlotOrderTemplateJoin>();
                while (rs.next()) {
                    PlotOrderTemplateJoin joinDto = AbstractJdbcPlottOrderTemplateDAO.fillPlotOrderTemplateJoinFromResultSet(rs);
                    currIndex = AbstractJdbcPlottOrderTemplateDAO.getNumberOfPlotOrderTemplateJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    joins.add(joinDto);
                }
                return joins;
            }
        });
    }

    private String getPlotOrderTemplateSearchUnionSelectClause(PlotOrderTemplateSearchComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForPlotOrderTemplateJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public PlotOrderTemplateJoin getSignPlotOrdersJoin(final Long plotOrderTemplateId, final Long projectId) {
        String sql = "SELECT " + this.getPlotOrderTemplateSearchUnionSelectClause(PlotOrderTemplateSearchComponent.PLOT_ORDER, "plottOrderTemplate", "plotterOrganisation", "plotterCountry", "plotterPersonVariables", "billingAddress", "billingCountry", "plottOrder") + "FROM (((((((((( plott_order_template JOIN project_participation plotter_project_participation        ON plott_order_template.plotter_id = plotter_project_participation.id) JOIN organisation plotter_organisation         ON plotter_project_participation.organisation_id = plotter_organisation.id) JOIN countries plotter_country                 ON plotter_organisation.country_id = plotter_country.id) LEFT JOIN project_participant plotter_participant   ON (     plotter_participant.participation_id = plotter_project_participation.id AND plotter_participant.main_participant_flag = 1 AND plotter_participant.inactive_flag = 0)) LEFT JOIN organisation_person plotter_org_person    ON       plotter_participant.organisation_person_id = plotter_org_person.id AND plotter_org_person.retired_flag = 0) LEFT JOIN person plotter_person                     ON plotter_org_person.person_id = plotter_person.id) LEFT JOIN person_variables plotter_person_variables ON plotter_person_variables.person_id = plotter_person.id) JOIN order_address billing_address             ON plott_order_template.billing_address_id = billing_address.id) JOIN countries billing_country                 ON billing_address.country_id = billing_country.id) LEFT JOIN plott_order                               ON plott_order.id = (SELECT max(local_plott_order.id) FROM ( plott_order local_plott_order JOIN order_step local_order_step   ON local_plott_order.acceptance_id = local_order_step.id) WHERE local_plott_order.template_id = plott_order_template.id AND local_plott_order.plotter_id = plotter_organisation.id AND local_plott_order.billing_address_id = billing_address.id AND local_order_step.id IS NOT NULL AND local_order_step.finished IS NULL AND local_plott_order.project_id = ?)) WHERE plott_order_template.id = ? ";
        return (PlotOrderTemplateJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<PlotOrderTemplateJoin>(){

            public PlotOrderTemplateJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)plotOrderTemplateId);
                ResultSet rs = statement.executeQuery();
                PlotOrderTemplateJoin join = null;
                while (rs.next()) {
                    if (join == null) {
                        join = AbstractJdbcPlottOrderTemplateDAO.fillPlotOrderTemplateJoinFromResultSet(rs);
                        continue;
                    }
                    throw new DAOException("Found multiple occurrences of PlotOrderTemplateJoin for projectId = [" + projectId + "] and plotOrderTemplateId [" + plotOrderTemplateId + "]");
                }
                return join;
            }
        });
    }

    @Override
    public boolean isDirectPlotPossibleByObject(final Long objectId) {
        String sql = "SELECT 1 FROM ((( object JOIN object_list          ON object.object_list_id = object_list.id) JOIN sub_project          ON object_list.sub_project_id = sub_project.id) JOIN plott_order_template ON plott_order_template.project_id = sub_project.project_id) WHERE object.id = ? AND plott_order_template.template_resolver = ? AND plott_order_template.invalidated = 0 AND EXISTS (SELECT 1 FROM plott_order_item_template WHERE plott_order_item_template.order_contract_id = plott_order_template.id) AND plott_order_template.plotter_id IS NOT NULL AND plott_order_template.billing_address_id IS NOT NULL ";
        return (Boolean)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Boolean>(){

            public Boolean perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
                statement.setString(currIndex++, "ManualPlotTemplate");
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public boolean isDirectPlotPossibleBySubProject(final Long subProjectId) {
        String sql = "SELECT 1 FROM ( sub_project JOIN plott_order_template ON plott_order_template.project_id = sub_project.project_id) WHERE sub_project.id = ? AND plott_order_template.template_resolver = ? AND plott_order_template.invalidated = 0 AND EXISTS (SELECT 1 FROM plott_order_item_template WHERE plott_order_item_template.order_contract_id = plott_order_template.id) AND plott_order_template.plotter_id IS NOT NULL AND plott_order_template.billing_address_id IS NOT NULL ";
        return (Boolean)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Boolean>(){

            public Boolean perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                statement.setString(currIndex++, "ManualPlotTemplate");
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public List<PlottOrderTemplate> getActiveTemplatesByProject(Long projectId, Boolean ignoringManualTemplates, List<Long> addressIds) {
        String sql = "SELECT " + JdbcPlottOrderTemplateDAO.getSelectClauseForDto() + "FROM ((( plott_order_template JOIN plott_order_item_template on plott_order_item_template.order_contract_id = plott_order_template.id) LEFT JOIN review_cycle_node on review_cycle_node.id = plott_order_item_template.delivery_address_id) LEFT JOIN project_participation on project_participation.id = plott_order_item_template.delivery_address_id) WHERE plott_order_template.invalidated = 0 AND plott_order_template.project_id = ? AND plott_order_template.billing_address_id IS NOT NULL AND plott_order_template.plotter_id IS NOT NULL AND plott_order_item_template.id IS NOT NULL ";
        if (ignoringManualTemplates.booleanValue()) {
            sql = sql + "AND plott_order_template.template_resolver != 'ManualPlotTemplate' ";
        }
        sql = sql + "AND plott_order_item_template.delivery_address_id IN (" + QueryHelper.getPlaceHolderSequence(addressIds.size()) + ")";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
            currIndex = QueryHelper.setIdsToStatement(statement, currIndex, addressIds);
        });
    }
}

