/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Search;
import at.cdes.api.joinDto.SearchJoin;
import at.cdes.impl.dao.SearchDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcSearchDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSearchDAO
extends AbstractJdbcSearchDAO
implements SearchDAO {
    @Override
    public List<Search> getByNetworkAndPage(Long networkId, String pageName) {
        return this.getSearchesInternal(null, networkId, null, null, pageName);
    }

    @Override
    public List<Search> getByPersonNetworkAndPage(Long personId, Long networkId, String pageName) {
        return this.getSearchesInternal(personId, networkId, null, null, pageName);
    }

    @Override
    public List<Search> getByPersonProjectAndPage(Long personId, Long projectId, String pageName) {
        return this.getSearchesInternal(personId, null, projectId, null, pageName);
    }

    @Override
    public List<Search> getByPersonProjectPageAndName(Long personId, Long projectId, String pageName, String name) {
        return this.getSearchesInternal(personId, null, projectId, name, pageName);
    }

    private List<Search> getSearchesInternal(final Long personId, final Long networkId, final Long projectId, final String name, final String pageName) {
        String sql = "SELECT " + JdbcSearchDAO.getSelectClauseForDto() + "FROM search WHERE 1=1 ";
        if (personId != null) {
            sql = sql + "AND search.person_id = ? ";
        }
        if (networkId != null) {
            sql = sql + "AND search.network_id = ? ";
        }
        if (projectId != null) {
            sql = sql + "AND search.project = ? ";
        }
        if (name != null) {
            sql = sql + "AND search.name = ? ";
        }
        if (pageName != null) {
            sql = sql + "AND search.page_name = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Search>>(){

            public List<Search> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (personId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                }
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                if (projectId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                }
                if (name != null) {
                    statement.setString(currIndex++, name);
                }
                if (pageName != null) {
                    statement.setString(currIndex++, pageName);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<Search> ret = new ArrayList<Search>();
                while (rs.next()) {
                    Search joinDto = JdbcSearchDAO.this.fillDtoFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<SearchJoin> getSearchJoinsByProjectAndPage(Long personId, Long projectId, String pageName) {
        return this.getSearchJoinsInternal(personId, null, projectId, null, pageName);
    }

    @Override
    public List<SearchJoin> getSearchJoinsByNetworkAndPage(Long networkId, String pageName) {
        return this.getSearchJoinsInternal(null, networkId, null, null, pageName);
    }

    private List<SearchJoin> getSearchJoinsInternal(final Long personId, final Long networkId, final Long projectId, final String name, final String pageName) {
        String sql = "SELECT " + JdbcSearchDAO.getSearchJoinSelectClause() + "FROM search JOIN person ON search.person_id = person.id WHERE 1=1 ";
        if (personId != null) {
            sql = sql + "AND search.person_id = ? ";
        }
        if (networkId != null) {
            sql = sql + "AND search.network_id = ? ";
        }
        if (projectId != null) {
            sql = sql + "AND search.project = ? ";
        }
        if (name != null) {
            sql = sql + "AND search.name = ? ";
        }
        if (pageName != null) {
            sql = sql + "AND search.page_name = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<SearchJoin>>(){

            public List<SearchJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (personId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                }
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                if (projectId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                }
                if (name != null) {
                    statement.setString(currIndex++, name);
                }
                if (pageName != null) {
                    statement.setString(currIndex++, pageName);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<SearchJoin> ret = new ArrayList<SearchJoin>();
                while (rs.next()) {
                    SearchJoin joinDto = JdbcSearchDAO.fillSearchJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }
}

