/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.document.util;

import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.joinDto.DocumentListJoin;
import at.cdes.api.voc.DocumentVersionStatus;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DocumentVersionHelper {
    public static boolean isInvalidatedOrDeleted(DocumentVersion documentVersion) {
        DocumentVersionStatus status = DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus());
        return status == DocumentVersionStatus.INVALIDATEDVERSION || status == DocumentVersionStatus.INVALIDATEDALL || status == DocumentVersionStatus.DELETED || status == DocumentVersionStatus.ABORTED;
    }

    public static boolean isInAction(DocumentVersion documentVersion) {
        DocumentVersionStatus status = DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus());
        return status == DocumentVersionStatus.INREVIEW || status == DocumentVersionStatus.INVALIDATEDVERSION || status == DocumentVersionStatus.RELEASEDNEGATIV || status == DocumentVersionStatus.DELETED;
    }

    public static boolean isDeleted(DocumentVersion documentVersion) {
        DocumentVersionStatus status = DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus());
        return status == DocumentVersionStatus.DELETED;
    }

    public static void sortDocumentListJoinsByUploaded(List<DocumentListJoin> allJoins) {
        allJoins.sort(new Comparator<DocumentListJoin>(){

            @Override
            public int compare(DocumentListJoin o1, DocumentListJoin o2) {
                double uploadedTwo;
                double uploadedOne = o1.getDocumentVersionUploaded() != null ? o1.getDocumentVersionUploaded() : 0.0;
                double d = uploadedTwo = o2.getDocumentVersionUploaded() != null ? o2.getDocumentVersionUploaded() : 0.0;
                if (uploadedOne < uploadedTwo) {
                    return -1;
                }
                if (uploadedOne > uploadedTwo) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<DocumentListJoin> getDocumentListJoinsSortedByUploaded(Map<Long, DocumentListJoin> idToJoin) {
        ArrayList<DocumentListJoin> allJoins = new ArrayList<DocumentListJoin>();
        allJoins.addAll(idToJoin.values());
        DocumentVersionHelper.sortDocumentListJoinsByUploaded(allJoins);
        return allJoins;
    }

    public static void sortDocumentListJoinsByPosition(List<DocumentListJoin> allJoins) {
        allJoins.sort(new Comparator<DocumentListJoin>(){

            @Override
            public int compare(DocumentListJoin o1, DocumentListJoin o2) {
                int positionOne = o1.getReviewCycleNodePosition() != null ? o1.getReviewCycleNodePosition() : 0;
                int positionTwo = o2.getReviewCycleNodePosition() != null ? o2.getReviewCycleNodePosition() : 0;
                return positionOne - positionTwo;
            }
        });
    }

    public static List<DocumentListJoin> getNodeResultJoinsSortedByPosition(Map<Long, DocumentListJoin> idToJoin, Long filterCellResultId) {
        ArrayList<DocumentListJoin> joins = new ArrayList<DocumentListJoin>();
        for (DocumentListJoin join : idToJoin.values()) {
            Long candidateCellResultId = join.getReviewCycleNodeResultReviewCycleCellResultId();
            if (filterCellResultId != null && candidateCellResultId.longValue() != filterCellResultId.longValue()) continue;
            joins.add(join);
        }
        DocumentVersionHelper.sortDocumentListJoinsByPosition(joins);
        return joins;
    }

    public static boolean isLastDocumentVersion(DocumentListJoin documentListJoin, Map<Long, DocumentListJoin> idToJoin) {
        Long reactivatedId;
        DocumentListJoin lastJoin;
        ArrayList<DocumentListJoin> allJoins = new ArrayList<DocumentListJoin>();
        allJoins.addAll(idToJoin.values());
        DocumentVersionHelper.sortDocumentListJoinsByUploaded(allJoins);
        DocumentListJoin documentListJoin2 = lastJoin = allJoins.size() > 0 ? (DocumentListJoin)allJoins.get(allJoins.size() - 1) : null;
        if (lastJoin != null && (reactivatedId = lastJoin.getDocumentVersionReactivatedDocumentVersionId()) != null) {
            lastJoin = idToJoin.get(reactivatedId);
        }
        return lastJoin != null && lastJoin.getDocumentVersionId().longValue() == documentListJoin.getDocumentVersionId().longValue();
    }
}

