/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.i18n;

import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.util.SearchHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class I18nHelper {
    private static String FROM_TOKEN = "[";
    private static String TO_TOKEN = "]";

    public static Map<String, String> parseI18nJsonString(String jsonString, String projectLocale) {
        HashMap<String, String> localeToTranslation = new HashMap<String, String>();
        if (jsonString != null && jsonString.trim().startsWith("{")) {
            try {
                JsonParser jsonParser = new JsonParser();
                Set entrySet = jsonParser.parse(jsonString).getAsJsonObject().entrySet();
                for (Map.Entry entry : entrySet) {
                    String locale = (String)entry.getKey();
                    String translation = ((JsonElement)entry.getValue()).getAsString();
                    localeToTranslation.put(locale, translation);
                }
            }
            catch (JsonParseException e) {
                localeToTranslation.put(projectLocale, jsonString);
            }
        } else {
            localeToTranslation.put(projectLocale, jsonString);
        }
        return localeToTranslation;
    }

    public static boolean isAnyLanguageFilled(String jsonString) {
        if (jsonString == null) {
            return false;
        }
        Map<String, String> localeToTranslation = I18nHelper.parseI18nJsonString(jsonString, "default");
        boolean anyTranslationFound = false;
        for (String locale : localeToTranslation.keySet()) {
            String translation = localeToTranslation.get(locale);
            anyTranslationFound |= SearchHelper.isStringFilled(translation);
        }
        return anyTranslationFound;
    }

    public static String getLocaleString(String jsonString, String locale) {
        Map<String, String> localeToTranslation = I18nHelper.parseI18nJsonString(jsonString, locale);
        if (localeToTranslation.containsKey(locale)) {
            return localeToTranslation.get(locale);
        }
        return "";
    }

    public static String getLocaleStringFromDatabase(String databaseString, String locale, List<String> contentLocales) {
        String jsString = I18nHelper.convertDatabaseToJs(databaseString, locale, contentLocales);
        String retValue = I18nHelper.getLocaleString(jsString, locale);
        return retValue;
    }

    public static String getLocaleStringFromDatabase(String databaseString, String locale) {
        ArrayList<String> contentLocales = new ArrayList<String>();
        contentLocales.add(locale);
        String jsString = I18nHelper.convertDatabaseToJs(databaseString, locale, contentLocales);
        String retValue = I18nHelper.getLocaleString(jsString, locale);
        return retValue;
    }

    public static String convertDatabaseToJs(String databaseString, String projectLocale, List<String> contentLocales) {
        if (databaseString == null) {
            return null;
        }
        Map<String, String> localeToTranslation = I18nHelper.parseI18nJsonString(databaseString, projectLocale);
        for (String locale : localeToTranslation.keySet()) {
            String databaseTranslation = localeToTranslation.get(locale);
            String openToken = locale + FROM_TOKEN;
            String closeToken = TO_TOKEN + locale;
            String jsTranslation = databaseTranslation.replace(openToken, "").replace(closeToken, "");
            localeToTranslation.put(locale, jsTranslation);
        }
        if (contentLocales == null || contentLocales.size() == 0) {
            String defaultTranslation = localeToTranslation.get(projectLocale);
            return defaultTranslation != null ? defaultTranslation : "";
        }
        Gson gson = new Gson();
        String jsString = gson.toJson(localeToTranslation);
        return jsString;
    }

    public static String convertJsToDatabase(String jsString, String projectLocale) {
        if (jsString != null && jsString.trim().startsWith("{")) {
            Map<String, String> localeToTranslation = I18nHelper.parseI18nJsonString(jsString, projectLocale);
            for (String locale : localeToTranslation.keySet()) {
                String jsTranslation = localeToTranslation.get(locale);
                String openToken = locale + FROM_TOKEN;
                String closeToken = TO_TOKEN + locale;
                String databaseTranslation = openToken + jsTranslation + closeToken;
                localeToTranslation.put(locale, databaseTranslation);
            }
            Gson gson = new Gson();
            String databaseString = gson.toJson(localeToTranslation);
            return databaseString;
        }
        return jsString;
    }

    public static String getLocaleAwareWhereClause(String locale, String queriedString) {
        String openToken = locale + FROM_TOKEN;
        String closeToken = TO_TOKEN + locale;
        return "%" + openToken + queriedString + closeToken + "%";
    }

    public static List<String> getContentLocalesByProject(ProjectDAO projectDAO, Long projectId) {
        ProjectLocalisationJoin localisationJoin = projectDAO.getLocalisationJoinByProject(projectId);
        return I18nHelper.getContentLocales(localisationJoin);
    }

    public static List<String> getContentLocales(ProjectDAO projectDAO, Long subProjectId) {
        ProjectLocalisationJoin localisationJoin = projectDAO.getLocalisationJoinBySubProject(subProjectId);
        return I18nHelper.getContentLocales(localisationJoin);
    }

    public static List<String> getContentLocales(ProjectLocalisationJoin localisationJoin) {
        ArrayList<String> contentLocales = null;
        String contentLocalesString = localisationJoin.getProjectConfigContentLocales();
        if (contentLocalesString != null) {
            contentLocales = new ArrayList<String>();
            String projectLocale = I18nHelper.getProjectLocale(localisationJoin);
            contentLocales.add(projectLocale);
            contentLocales.add(contentLocalesString);
        }
        return contentLocales;
    }

    public static String getProjectLocale(ProjectLocalisationJoin localisationJoin) {
        String countryCode2 = localisationJoin.getCountryCode2().toLowerCase();
        if ("at".equals(countryCode2) || "ch".equals(countryCode2)) {
            countryCode2 = "de";
        }
        return countryCode2;
    }
}

