/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.impl.dao.ReviewCycleNodeDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcReviewCycleNodeDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcReviewCycleNodeDAO
extends AbstractJdbcReviewCycleNodeDAO
implements ReviewCycleNodeDAO {
    @Override
    public ReviewCycleNode getActiveByDocumentVersion(Long documentVersionId) {
        String sql = "SELECT " + JdbcReviewCycleNodeDAO.getSelectClauseForDto() + "\nFROM document_version\nJOIN review_cycle_node_instance          ON document_version.active_node_instance_id = review_cycle_node_instance.id\nJOIN review_cycle_node                   ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id\nWHERE document_version.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentVersionId));
    }

    @Override
    public ReviewCycleNode getSiblingByPosition(final Long reviewCycleNodeId, final Integer position) {
        String sql = "SELECT " + JdbcReviewCycleNodeDAO.getSelectClauseForDto() + "FROM       review_cycle_node start_node JOIN review_cycle_node               ON start_node.review_cycle_cell_id = review_cycle_node.review_cycle_cell_id WHERE start_node.id = ? AND review_cycle_node.position = ? ";
        ReviewCycleNode reviewCycleNode = (ReviewCycleNode)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ReviewCycleNode>(){

            public ReviewCycleNode perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)position);
                ResultSet resultSet = statement.executeQuery();
                ReviewCycleNode reviewCycleNode = null;
                while (resultSet.next()) {
                    if (reviewCycleNode == null) {
                        reviewCycleNode = JdbcReviewCycleNodeDAO.this.fillDtoFromResultSet(resultSet);
                        continue;
                    }
                    throw new DAOException("Found multiple instances of ReviewCycleNode for start node [" + reviewCycleNodeId + "] and position [" + position + "]");
                }
                return reviewCycleNode;
            }
        });
        return reviewCycleNode;
    }

    @Override
    public ReviewCycleNode getFirst(Long reviewCycleCellId) {
        String sql = "SELECT " + JdbcReviewCycleNodeDAO.getSelectClauseForDto() + "\nFROM review_cycle_node\nWHERE review_cycle_node.review_cycle_cell_id = ?\nAND review_cycle_node.free = 0\nORDER BY review_cycle_node.position\n" + QueryHelper.getLimitClause((JdbcDAOSupport)this, "1") + "";
        return (ReviewCycleNode)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleCellId);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                return this.fillDtoFromResultSet(rs);
            }
            return null;
        });
    }
}

