/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.compositeDto.PlanningNotificationOrderInfo;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.PlanningNotificationOrderTag;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.joinDto.PlanningNotificationOrderJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CellTextStyles;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.export.planning.PlanningExportHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PlanningNotificationOrderListExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private String tempDirName;
    private PersonVariablesDAO personVariablesDAO;
    private static final Logger log = LoggerFactory.getLogger(PlanningNotificationOrderListExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    private CellTextStyles constructNormalTextStyles(String standardParagraphStyle, Styles contentAutomaticStyles) {
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#FF0000", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null)});
        return new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle);
    }

    private CellTextStyles constructInvalidatedTextStyles(String standardParagraphStyle, Styles contentAutomaticStyles) {
        String dataCaptionTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "bold")});
        String dataBoldTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "bold")});
        String dataItalicTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", "italic")});
        String dataRedTextStyle = contentAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", null)});
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructStrikeThroughTextPropertiesWithColorFontAndHyphenation("#BBBBBB", "Arial", "9pt", null)});
        return new CellTextStyles(dataTextStyle, dataBoldTextStyle, dataItalicTextStyle, dataCaptionTextStyle, dataRedTextStyle);
    }

    public ScratchFile export(List<PlanningNotificationOrderInfo> planningNotificationOrderInfos, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = loginPrincipal.getPersonId();
        List<PersonVariables> personVariablesList = this.personVariablesDAO.getByPerson(personId);
        PersonVariables personVariables = personVariablesList.get(0);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariables.getUserLocale());
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        ClassLoader classLoader = PlanningNotificationOrderListExporter.class.getClassLoader();
        URL logoUrl = classLoader.getResource("export/logos/OeBB_INFRA_black_eps_small.png");
        URI logoUri = logoUrl.toURI();
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("planningNotificationOrderListFooterGeneratedString");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw, null, null, resourceBundle);
        TextHElement textHElement = officeText.newTextHElement(2);
        textHElement.setTextContent(resourceBundle.getString("planningNotificationOrderListExportCaption"));
        officeText.newTextPElement();
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000")});
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold")});
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000")});
        CellTextStyles normalTextStyles = this.constructNormalTextStyles(standardParagraphStyle, contentAutomaticStyles);
        CellTextStyles invalidatedTextStyles = this.constructInvalidatedTextStyles(standardParagraphStyle, contentAutomaticStyles);
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        columnSortSpecs = this.translateSortColumns(columnSortSpecs);
        FancyOdfTable<PlanningNotificationOrderInfo> odfTable = this.constructPlanningNotificationOrderTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, normalTextStyles, invalidatedTextStyles, columnToWidth);
        odfTable.setDataRowStyle(dataRowStyle);
        odfTable.render((Node)officeText, planningNotificationOrderInfos, columnSortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_BUEK_Vorgaben_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private static CellTextStyles getCellTextStyles(PlanningNotificationOrderInfo data, CellTextStyles normalTextStyles, CellTextStyles invalidatedTextStyles) {
        PlanningNotificationOrderJoin orderJoin = data.getOrderJoin();
        Boolean invalidated = orderJoin.getWorkflowEntityInvalidated();
        if (invalidated != null && invalidated.booleanValue()) {
            return invalidatedTextStyles;
        }
        return normalTextStyles;
    }

    private FancyOdfTable<PlanningNotificationOrderInfo> constructPlanningNotificationOrderTable(final ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final String dataCellStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles, Map<String, Double> relativeColumnWidths) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("serialNumber", resourceBundle.getString("planningNotificationOrderListSerialNumberColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getOrderJoin().getPlanningNotificationOrderSerialNumber(), (Long)dataTwo.getOrderJoin().getPlanningNotificationOrderSerialNumber(), (boolean)descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                Long serialNumber = orderInfo.getOrderJoin().getPlanningNotificationOrderSerialNumber();
                return serialNumber != null ? serialNumber.toString() : "";
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("text", resourceBundle.getString("planningNotificationOrderListTextColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, cellTextStyles.getDataTextStyle(), rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderText();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("planningNotification", resourceBundle.getString("planningNotificationOrderListPlanningNotificationColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, cellTextStyles.getDataTextStyle(), rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String baulosString = "";
                List baulosMetaInformations = orderInfo.getBaulosMetaInformations();
                if (baulosMetaInformations != null && baulosMetaInformations.size() > 0) {
                    Collections.sort(baulosMetaInformations, new Comparator<PlanningNotificationTextMetaInformation>(){

                        @Override
                        public int compare(PlanningNotificationTextMetaInformation referenceInfoOne, PlanningNotificationTextMetaInformation referenceInfoTwo) {
                            return referenceInfoOne.getValue().compareTo(referenceInfoTwo.getValue());
                        }
                    });
                    for (int n = 0; n < baulosMetaInformations.size(); ++n) {
                        baulosString = baulosString + ((PlanningNotificationTextMetaInformation)baulosMetaInformations.get(n)).getValue();
                        if (n >= baulosMetaInformations.size() - 1) continue;
                        baulosString = baulosString + ", ";
                    }
                }
                return orderInfo.getOrderJoin().getPlanningNotificationTitle() + (baulosString.length() > 0 ? ": " + baulosString : "");
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("project", resourceBundle.getString("planningNotificationOrderProjectColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo orderInfo) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(orderInfo, normalCellTextStyles, invalidatedCellTextStyles);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                TextPElement textPElement = (TextPElement)((OdfFileDom)cellElement.getOwnerDocument()).newOdfElement(TextPElement.class);
                textPElement.setTextStyleNameAttribute(cellTextStyles.getDataTextStyle());
                cellElement.appendChild((Node)textPElement);
                List projectJoins = orderInfo.getProjectJoins();
                for (int n = 0; n < projectJoins.size(); ++n) {
                    ProjectJoin projectJoin = (ProjectJoin)projectJoins.get(n);
                    PlanningNotificationOrderListExporter.constructTextSpanNode((Node)textPElement, "(" + projectJoin.getProjectCode() + ")", cellTextStyles.getDataBoldTextStyle());
                    PlanningNotificationOrderListExporter.constructTextSpanNode((Node)textPElement, " " + projectJoin.getProjectName(), null);
                }
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String projectString = "";
                List projectJoins = orderInfo.getProjectJoins();
                for (int n = 0; n < projectJoins.size(); ++n) {
                    projectString = projectString + ((ProjectJoin)projectJoins.get(n)).getProjectCode() + " " + ((ProjectJoin)projectJoins.get(n)).getProjectName() + (n < projectJoins.size() - 1 ? ", " : "");
                }
                return projectString;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("documentPosition", resourceBundle.getString("planningNotificationOrderDocumentPositionColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderDocumentPosition();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("documentPage", resourceBundle.getString("planningNotificationOrderDocumentPageColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderDocumentPage();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("subjectArea", resourceBundle.getString("planningNotificationOrderSubjectAreaColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getSubjectAreaName();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("authorizedInspector", resourceBundle.getString("planningNotificationOrderAuthorizedInspectorColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderAuthorizedInspector();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("reference", resourceBundle.getString("planningNotificationOrderReferenceColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                List referenceInfos = orderInfo.getReferenceInfos();
                return PlanningExportHelper.getReferenceOutput(referenceInfos);
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("source", resourceBundle.getString("planningNotificationOrderSourceColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, cellTextStyles.getDataTextStyle(), rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderSource();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("submitAuthority", resourceBundle.getString("planningNotificationOrderSubmitAuthorityColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                Boolean submitAuthority = orderInfo.getOrderJoin().getPlanningNotificationOrderSubmitAuthority();
                return submitAuthority != null && submitAuthority == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("tag", resourceBundle.getString("planningNotificationOrderTagColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String tagString = "";
                List tags = orderInfo.getTags();
                for (int n = 0; n < tags.size(); ++n) {
                    tagString = tagString + ((PlanningNotificationOrderTag)tags.get(n)).getLabel();
                    if (n >= tags.size() - 1) continue;
                    tagString = tagString + ", ";
                }
                return tagString;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("invalidated", resourceBundle.getString("planningNotificationOrderInvalidatedColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                Boolean invalidated = orderInfo.getOrderJoin().getWorkflowEntityInvalidated();
                return invalidated != null && invalidated == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("statutoryDuty", resourceBundle.getString("planningNotificationOrderStatutoryDutyColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getStatutoryDutyName();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("personInCharge", resourceBundle.getString("planningNotificationOrderPersonInChargeColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPersonInChargeName();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("statutoryDutyFrom", resourceBundle.getString("planningNotificationOrderStatutoryDutyFromColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getOrderJoin().getPlanningNotificationOrderStatutoryDutyFrom(), (Long)dataTwo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyFrom(), (boolean)descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                Long utcMillis = orderInfo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyFrom();
                return utcMillis != null ? DateHelper.formatUtcSeconds(utcMillis.doubleValue(), "Europe/Vienna", dateFormatPattern) : "";
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("statutoryDutyTo", resourceBundle.getString("planningNotificationOrderStatutoryDutyToColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getOrderJoin().getPlanningNotificationOrderStatutoryDutyTo(), (Long)dataTwo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyTo(), (boolean)descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                Long utcMillis = orderInfo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyTo();
                return utcMillis != null ? DateHelper.formatUtcSeconds(utcMillis.doubleValue(), "Europe/Vienna", dateFormatPattern) : "";
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("statutoryDutyInterval", resourceBundle.getString("planningNotificationOrderStatutoryDutyIntervalColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                Integer intervalOne = dataOne.getOrderJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                Integer intervalTwo = dataTwo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)(intervalOne != null ? Long.valueOf(intervalOne.longValue()) : null), (Long)(intervalTwo != null ? Long.valueOf(intervalTwo.longValue()) : null), (boolean)descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                Integer interval = orderInfo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                return interval != null ? interval.toString() : "";
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("statutoryDutyLeadTime", resourceBundle.getString("planningNotificationOrderStatutoryDutyLeadTimeColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                Integer leadTimeOne = dataOne.getOrderJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                Integer leadTimeTwo = dataTwo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)(leadTimeOne != null ? Long.valueOf(leadTimeOne.longValue()) : null), (Long)(leadTimeTwo != null ? Long.valueOf(leadTimeTwo.longValue()) : null), (boolean)descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                Integer leadTime = orderInfo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                return leadTime != null ? leadTime.toString() : "";
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("statutoryDutyExpired", resourceBundle.getString("planningNotificationOrderStatutoryDutyExpiredColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                Boolean expired = orderInfo.getOrderJoin().getPlanningNotificationOrderStatutoryDutyExpired();
                return expired != null && expired == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("workflowNode", resourceBundle.getString("planningNotificationOrderWorkflowNodeColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo orderInfo) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(orderInfo, normalCellTextStyles, invalidatedCellTextStyles);
                List<WorkflowNodeJoin> workflowNodeJoins = this.getWorkflowNodeJoins(orderInfo);
                PlanningExportHelper.appendWorkflowNodeCell(rowElement, resourceBundle, workflowNodeJoins, orderInfo.getWorkflowNodeIdToPositions(), orderInfo.getWorkflowNodePositionIdToBaulose(), dataCellStyle, cellTextStyles.getDataTextStyle(), cellTextStyles.getDataItalicTextStyle(), cellTextStyles.getDataRedTextStyle(), cellTextStyles.getDataCaptionTextStyle());
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private List<WorkflowNodeJoin> getWorkflowNodeJoins(PlanningNotificationOrderInfo orderInfo) {
                List workflowNodeJoins = orderInfo.getWorkflowNodeJoins();
                if (workflowNodeJoins != null) {
                    Collections.sort(workflowNodeJoins, new Comparator<WorkflowNodeJoin>(){

                        @Override
                        public int compare(WorkflowNodeJoin joinOne, WorkflowNodeJoin joinTwo) {
                            return joinOne.getWorkflowNodeTemplatePosition() - joinTwo.getWorkflowNodeTemplatePosition();
                        }
                    });
                    return workflowNodeJoins;
                }
                return new ArrayList<WorkflowNodeJoin>();
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return "Not implemented.";
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("state", resourceBundle.getString("planningNotificationOrderStateColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                String workflowEntityStatusName = orderInfo.getOrderJoin().getWorkflowEntityStatusName();
                if (orderInfo.getOrderJoin().getWorkflowEntityInvalidated().booleanValue()) {
                    return resourceBundle.getString("workflowStatusInvalidated");
                }
                if (workflowEntityStatusName == null) {
                    return resourceBundle.getString("workflowStatusNotInitialized");
                }
                return workflowEntityStatusName;
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("orderComment", resourceBundle.getString("planningNotificationOrderCommentColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, cellTextStyles.getDataTextStyle(), rowElement, this.getOutput(data));
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return CompareHelper.defaultStringCompare(collator, this.getOutput(dataOne), this.getOutput(dataTwo), descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                return orderInfo.getOrderJoin().getPlanningNotificationOrderComment();
            }
        });
        columns.add(new FancyOdfTableColumn<PlanningNotificationOrderInfo>("environmentallyRelevant", resourceBundle.getString("planningNotificationOrderEnvironmentallyRelevantColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, PlanningNotificationOrderInfo data) {
                CellTextStyles cellTextStyles = PlanningNotificationOrderListExporter.getCellTextStyles(data, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
            }

            public int compare(PlanningNotificationOrderInfo dataOne, PlanningNotificationOrderInfo dataTwo, boolean descending) {
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
            }

            private String getOutput(PlanningNotificationOrderInfo orderInfo) {
                Boolean environmentallyRelevant = orderInfo.getOrderJoin().getPlanningNotificationOrderEnvironmentallyRelevant();
                return environmentallyRelevant != null && environmentallyRelevant == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
            }
        });
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        String dataTextStyle = normalCellTextStyles.getDataTextStyle();
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private List<ColumnSortSpec> translateSortColumns(List<ColumnSortSpec> columnSortSpecs) {
        ArrayList<ColumnSortSpec> newColumnSortSpecs = new ArrayList<ColumnSortSpec>();
        for (ColumnSortSpec columnSortSpec : columnSortSpecs) {
            String property = columnSortSpec.getProperty();
            Boolean descending = columnSortSpec.getDescending();
            if ("planningNotificationOrderSerialNumber".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("serialNumber", descending));
                continue;
            }
            if ("planningNotificationOrderText".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("text", descending));
                continue;
            }
            if ("_planningNotification".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("planningNotification", descending));
                continue;
            }
            if ("_project".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("project", descending));
                continue;
            }
            if ("subjectAreaName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("subjectArea", descending));
                continue;
            }
            if ("planningNotificationOrderAuthorizedInspector".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("authorizedInspector", descending));
                continue;
            }
            if ("_reference".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("reference", descending));
                continue;
            }
            if ("statutoryDutyName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDuty", descending));
                continue;
            }
            if ("workflowEntityInvalidated".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("invalidated", descending));
                continue;
            }
            if ("planningNotificationOrderDocumentPosition".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentPosition", descending));
                continue;
            }
            if ("planningNotificationOrderDocumentPage".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("documentPage", descending));
                continue;
            }
            if ("planningNotificationOrderSource".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("source", descending));
                continue;
            }
            if ("personInChargeName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("personInCharge", descending));
                continue;
            }
            if ("planningNotificationOrderStatutoryDutyFrom".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDutyFrom", descending));
                continue;
            }
            if ("planningNotificationOrderStatutoryDutyTo".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDutyTo", descending));
                continue;
            }
            if ("planningNotificationOrderStatutoryDutyInterval".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDutyInterval", descending));
                continue;
            }
            if ("planningNotificationOrderStatutoryDutyLeadTime".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDutyLeadTime", descending));
                continue;
            }
            if ("planningNotificationOrderStatutoryDutyExpired".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("statutoryDutyExpired", descending));
                continue;
            }
            if ("planningNotificationOrderSubmitAuthority".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("submitAuthority", descending));
                continue;
            }
            if ("_tagString".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("tag", descending));
                continue;
            }
            if ("planningNotificationOrderComment".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("comment", descending));
                continue;
            }
            if ("_workflowNode".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("workflowNode", descending));
                continue;
            }
            if ("_workflowEntityStatusName".equals(property)) {
                newColumnSortSpecs.add(new ColumnSortSpec("state", descending));
                continue;
            }
            log.warn("Unknown column [" + property + "] delivered from client.");
        }
        return newColumnSortSpecs;
    }

    private static TextSpanElement constructTextSpanNode(Node parentNode, String textContent, String textStyle) {
        TextSpanElement textElement = (TextSpanElement)((OdfFileDom)parentNode.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        if (textContent != null) {
            textElement.setTextContent(textContent);
        }
        if (textStyle != null) {
            textElement.setTextStyleNameAttribute(textStyle);
        }
        parentNode.appendChild((Node)textElement);
        return textElement;
    }
}

