/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.imp;

import at.cdes.api.compositeDto.ImportDocument;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentType;
import at.cdes.impl.dao.DocumentNumberPartDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.document.DocumentNumberCalculator;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.i18n.I18nHelper;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.clazzes.util.datetime.UtcTimestamp;
import org.clazzes.util.sched.impl.HasLoggingCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDocumentCsvCallable
extends HasLoggingCallable<List<ImportDocument>> {
    private static final Logger log = LoggerFactory.getLogger(NewDocumentCsvCallable.class);
    private static final String SEPARATOR = ";";
    private static final String TIMEZONE = "Europe/Vienna";
    private byte[] data;
    private Long projectId;
    private DocumentTypeDAO documentTypeDAO;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private ProjectDAO projectDAO;

    public NewDocumentCsvCallable(byte[] data, Long projectId, DocumentTypeDAO documentTypeDAO, ProjectDAO projectDAO, DocumentNumberPartDAO documentNumberPartDAO) {
        this.data = data;
        this.projectId = projectId;
        this.documentTypeDAO = documentTypeDAO;
        this.documentNumberPartDAO = documentNumberPartDAO;
        this.projectDAO = projectDAO;
    }

    private static Double getDate(String fullDateString, String timeZone) {
        if (fullDateString == null) {
            return null;
        }
        try {
            String[] tokens = fullDateString.split("\\.");
            String dateString = tokens[0];
            String monthString = tokens[1];
            String yearString = tokens[2];
            int date = Integer.parseInt(dateString);
            int month = Integer.parseInt(monthString);
            int year = Integer.parseInt(yearString);
            UtcTimestamp utcTimestamp = new UtcTimestamp();
            utcTimestamp.setDateTime(year, month, date, 0, TimeZone.getTimeZone(timeZone));
            return new Double((double)utcTimestamp.getUtcMillis().longValue() / 1000.0);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Date could not be parsed: [" + fullDateString + "]");
        }
    }

    public List<ImportDocument> call() throws Exception {
        String line;
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        ArrayList<ImportDocument> importDocuments = new ArrayList<ImportDocument>();
        String content = this.data.length > 3 && this.data[0] == -17 && this.data[1] == -69 && this.data[2] == -65 ? new String(this.data, 3, this.data.length - 3, "UTF-8") : new String(this.data, "CP1252");
        ArrayList<String> lines = new ArrayList<String>();
        StringReader reader = new StringReader(content);
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            lines.add(line);
        }
        if (lines.size() == 0) {
            importDocuments.add(ImportDocument.constructError((Integer)1, (String)resourceBundle.getString("newDocumentCsvImportNoHeaderError")));
            return importDocuments;
        }
        int documentTypeIndex = -1;
        int numberIndex = -1;
        int partIndex = -1;
        int titleIndex = -1;
        int titleTranslationIndex = -1;
        int scaleIndex = -1;
        int startIndex = -1;
        int endIndex = -1;
        int commentIndex = -1;
        String headerLine = (String)lines.get(0);
        String[] headerTokens = headerLine.split(SEPARATOR);
        for (int n = 0; n < headerTokens.length; ++n) {
            String headerToken = headerTokens[n].trim();
            if ("$DTYPE".equals(headerToken)) {
                documentTypeIndex = n;
                continue;
            }
            if ("$NUMBER".equals(headerToken)) {
                numberIndex = n;
                continue;
            }
            if ("$PART".equals(headerToken)) {
                partIndex = n;
                continue;
            }
            if ("$TITLE".equals(headerToken)) {
                titleIndex = n;
                continue;
            }
            if ("$TITLE_TRANSLATION".equals(headerToken)) {
                titleTranslationIndex = n;
                continue;
            }
            if ("$SCALE".equals(headerToken)) {
                scaleIndex = n;
                continue;
            }
            if ("$START".equals(headerToken)) {
                startIndex = n;
                continue;
            }
            if ("$END".equals(headerToken)) {
                endIndex = n;
                continue;
            }
            if ("$COMM".equals(headerToken)) {
                commentIndex = n;
                continue;
            }
            String message = MessageFormat.format(resourceBundle.getString("newDocumentCsvImportIllegalHeaderToken"), headerToken);
            importDocuments.add(ImportDocument.constructError((Integer)1, (String)message));
            return importDocuments;
        }
        String documentTypeCodeFormat = null;
        List<DocumentNumberPart> documentNumberParts = this.documentNumberPartDAO.getDocumentNumberPartsForProject(this.projectId);
        for (DocumentNumberPart documentNumberPart : documentNumberParts) {
            if (!documentNumberPart.getOgnlRule().contains("documentType.code")) continue;
            documentTypeCodeFormat = documentNumberPart.getFormat();
        }
        List<DocumentType> documentTypes = this.documentTypeDAO.getByProject(this.projectId);
        log.info("processing codeToDocumentTypes: size= " + documentTypes.size() + " for project= " + this.projectId);
        HashMap<String, DocumentType> codeToDocumentType = new HashMap<String, DocumentType>();
        for (DocumentType documentType : documentTypes) {
            codeToDocumentType.put(documentType.getCode(), documentType);
        }
        for (int n = 1; n < lines.size(); ++n) {
            ImportDocument importDocument = new ImportDocument();
            String line2 = (String)lines.get(n);
            String[] lineTokens = line2.split(SEPARATOR);
            String documentTypeCode = null;
            if (documentTypeIndex != -1 && documentTypeIndex < lineTokens.length) {
                documentTypeCode = lineTokens[documentTypeIndex];
                if (documentTypeCodeFormat != null && documentTypeCodeFormat.length() > 0) {
                    documentTypeCode = DocumentNumberCalculator.format(documentTypeCodeFormat, documentTypeCode);
                }
            }
            String numberCode = numberIndex != -1 && numberIndex < lineTokens.length ? lineTokens[numberIndex] : null;
            String partCode = partIndex != -1 && partIndex < lineTokens.length ? lineTokens[partIndex] : null;
            String title = titleIndex != -1 && titleIndex < lineTokens.length ? lineTokens[titleIndex] : null;
            String titleTranslation = titleTranslationIndex != -1 && titleTranslationIndex < lineTokens.length ? lineTokens[titleTranslationIndex] : null;
            String scale = scaleIndex != -1 && scaleIndex < lineTokens.length ? lineTokens[scaleIndex] : null;
            String start = startIndex != -1 && startIndex < lineTokens.length ? lineTokens[startIndex] : null;
            String end = endIndex != -1 && endIndex < lineTokens.length ? lineTokens[endIndex] : null;
            String comment = commentIndex != -1 && commentIndex < lineTokens.length ? lineTokens[commentIndex] : null;
            Document document = new Document();
            if (documentTypeCode != null) {
                DocumentType documentType = (DocumentType)codeToDocumentType.get(documentTypeCode);
                if (documentType == null) {
                    Object code2;
                    ArrayList<String> documentTypeList = new ArrayList<String>();
                    for (Object code2 : codeToDocumentType.keySet()) {
                        documentTypeList.add((String)code2);
                    }
                    Collections.sort(documentTypeList);
                    String legalDocumentTypes = "";
                    code2 = documentTypeList.iterator();
                    while (code2.hasNext()) {
                        String legalDocumentType = (String)code2.next();
                        legalDocumentTypes = legalDocumentTypes + legalDocumentType + " ";
                    }
                    String message = MessageFormat.format(resourceBundle.getString("newDocumentCsvImportUnknownDocumentType"), documentTypeCode, legalDocumentTypes);
                    importDocuments.add(ImportDocument.constructError((Integer)(n + 1), (String)message));
                    continue;
                }
                document.setDocumentTypeId(documentType.getId());
            } else {
                document.setDocumentTypeId(null);
            }
            if (numberCode != null) {
                Integer number = Integer.parseInt(numberCode);
                document.setNumber(number);
            } else {
                document.setNumber(null);
            }
            if (partCode != null && partCode.length() > 0) {
                Integer part = Integer.parseInt(partCode);
                document.setPart(part);
            } else {
                document.setPart(null);
            }
            List<String> contentLocales = I18nHelper.getContentLocalesByProject(this.projectDAO, this.projectId);
            if (titleTranslation != null && titleTranslation.length() > 0) {
                String l1 = contentLocales.get(0);
                String l2 = contentLocales.get(1);
                String jsContentString = "{\"" + l1 + "\":\"" + title + "\",\"" + l2 + "\":\"" + titleTranslation + "\"}";
                document.setContent(jsContentString);
            } else {
                document.setContent(title);
            }
            document.setScale(scale);
            if (start != null && start.length() > 0) {
                Double startDate = NewDocumentCsvCallable.getDate(start, TIMEZONE);
                document.setStartDate(startDate);
            } else {
                document.setStartDate(null);
            }
            if (end != null && end.length() > 0) {
                Double endDate = NewDocumentCsvCallable.getDate(end, TIMEZONE);
                document.setEndDate(endDate);
            } else {
                document.setEndDate(null);
            }
            document.setComment(comment);
            importDocument.setDocument(document);
            importDocument.setError(Boolean.valueOf(false));
            importDocument.setLineNumber(Integer.valueOf(n));
            importDocument.setMessage(null);
            importDocuments.add(importDocument);
        }
        return importDocuments;
    }
}

