/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Workflow;
import at.cdes.api.dto.WorkflowEntity;
import at.cdes.api.dto.WorkflowEntityStatus;
import at.cdes.impl.dao.GenWorkflowEntityDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcWorkflowEntityDAO
extends AbstrIdDAO<WorkflowEntity>
implements GenWorkflowEntityDAO {
    public AbstractJdbcWorkflowEntityDAO() {
        super(WorkflowEntity.class, "id", "workflow_entity", new String[]{"id", "workflow_id", "workflow_entity_status_id", "invalidated", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcWorkflowEntityDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_entity_status_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "invalidated") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcWorkflowEntityDAO.getSelectClauseForDto("workflow_entity", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcWorkflowEntityDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".workflow_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_id") + "," + entityLocalName + ".workflow_entity_status_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_entity_status_id") + "," + entityLocalName + ".invalidated" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "invalidated") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected WorkflowEntity fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        WorkflowEntity workflowEntity = new WorkflowEntity();
        workflowEntity.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowEntity.setWorkflowId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowEntity.setWorkflowEntityStatusId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowEntity.setInvalidated(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        workflowEntity.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowEntity.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowEntity.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return workflowEntity;
    }

    public static WorkflowEntity fillWorkflowEntityFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        WorkflowEntity workflowEntity = new WorkflowEntity();
        workflowEntity.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowEntity.setWorkflowId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowEntity.setWorkflowEntityStatusId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowEntity.setInvalidated(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowEntity.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowEntity.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowEntity.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return workflowEntity;
    }

    public static WorkflowEntity fillWorkflowEntityFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcWorkflowEntityDAO.fillWorkflowEntityFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 7;
    }

    public int update(WorkflowEntity dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<WorkflowEntity> dtos) {
        Iterator<WorkflowEntity> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, WorkflowEntity workflowEntity) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)workflowEntity.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)workflowEntity.getWorkflowId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)workflowEntity.getWorkflowEntityStatusId());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)4, (Boolean)workflowEntity.getInvalidated());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)(workflowEntity.getCreateTrx() != null ? workflowEntity.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)System.currentTimeMillis());
    }

    @Override
    public List<WorkflowEntity> getByWorkflow(Workflow workflow) {
        return this.getByWorkflow(workflow.getId());
    }

    @Override
    public List<WorkflowEntity> getByWorkflow(final Long workflowId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, workflowId);
            }
        });
    }

    @Override
    public List<WorkflowEntity> getByWorkflowEntityStatus(WorkflowEntityStatus workflowEntityStatus) {
        return this.getByWorkflowEntityStatus(workflowEntityStatus.getId());
    }

    @Override
    public List<WorkflowEntity> getByWorkflowEntityStatus(final Long workflowEntityStatusId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_entity_status_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, workflowEntityStatusId);
            }
        });
    }

    @Override
    public List<WorkflowEntity> getByWorkflows(Collection<Long> workflowId) {
        if (workflowId.isEmpty()) {
            return new ArrayList<WorkflowEntity>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[workflowId.size()];
        int n = 0;
        Iterator<Long> it = workflowId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<WorkflowEntity> getByWorkflowEntityStatuss(Collection<Long> workflowEntityStatusId) {
        if (workflowEntityStatusId.isEmpty()) {
            return new ArrayList<WorkflowEntity>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[workflowEntityStatusId.size()];
        int n = 0;
        Iterator<Long> it = workflowEntityStatusId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_entity_status_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

