/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.OrderAddress;
import at.cdes.api.plot.voc.OrderAddressType;
import at.cdes.impl.dao.OrderAddressDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcOrderAddressDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcOrderAddressDAO
extends AbstractJdbcOrderAddressDAO
implements OrderAddressDAO {
    @Override
    public List<OrderAddress> getByNetworkAndType(final Long networkId, final OrderAddressType orderAddressType) {
        String sql = "SELECT " + JdbcOrderAddressDAO.getSelectClauseForDto() + "FROM order_address WHERE 1=1 ";
        if (networkId != null) {
            sql = sql + "AND order_address.network_id = ? \n";
        }
        if (orderAddressType != null) {
            sql = sql + "AND order_address.type = ? \n";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrderAddress>>(){

            public List<OrderAddress> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                if (orderAddressType != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)orderAddressType.getValue());
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<OrderAddress> ret = new ArrayList<OrderAddress>();
                while (rs.next()) {
                    OrderAddress orderAddress = JdbcOrderAddressDAO.fillOrderAddressFromResultSet(rs);
                    ret.add(orderAddress);
                }
                return ret;
            }
        });
    }
}

