/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.OriginalDocumentOrder;
import at.cdes.api.dto.OriginalDocumentTask;
import at.cdes.impl.dao.OriginalDocumentTaskDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcOriginalDocumentTaskDAO
extends AbstrIdDAO<OriginalDocumentTask>
implements OriginalDocumentTaskDAO {
    public JdbcOriginalDocumentTaskDAO() {
        super(OriginalDocumentTask.class, "taskId", "original_document_task", new String[]{"task_id", "order_step_id", "order_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcOriginalDocumentTaskDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcOriginalDocumentTaskDAO.getSelectClauseForDto("original_document_task", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcOriginalDocumentTaskDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".task_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + "," + entityLocalName + ".order_step_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + "," + entityLocalName + ".order_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_id") + " ";
    }

    protected OriginalDocumentTask fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        OriginalDocumentTask originalDocumentTask = new OriginalDocumentTask();
        originalDocumentTask.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        originalDocumentTask.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        originalDocumentTask.setOrderId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return originalDocumentTask;
    }

    public static OriginalDocumentTask fillOriginalDocumentTaskFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        OriginalDocumentTask originalDocumentTask = new OriginalDocumentTask();
        originalDocumentTask.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        originalDocumentTask.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        originalDocumentTask.setOrderId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return originalDocumentTask;
    }

    public static OriginalDocumentTask fillOriginalDocumentTaskFromResultSet(ResultSet rs) throws SQLException {
        return JdbcOriginalDocumentTaskDAO.fillOriginalDocumentTaskFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 3;
    }

    public int update(OriginalDocumentTask dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<OriginalDocumentTask> dtos) {
        Iterator<OriginalDocumentTask> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, OriginalDocumentTask originalDocumentTask) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)originalDocumentTask.getTaskId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)originalDocumentTask.getOrderStepId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)originalDocumentTask.getOrderId());
    }

    @Override
    public List<OriginalDocumentTask> getByTask(DocumentVersionTask documentVersionTask) {
        return this.getByTask(documentVersionTask.getTaskId());
    }

    @Override
    public List<OriginalDocumentTask> getByTask(final Long documentVersionTaskId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentVersionTaskId);
            }
        });
    }

    @Override
    public List<OriginalDocumentTask> getByOrderStep(OrderStep orderStep) {
        return this.getByOrderStep(orderStep.getId());
    }

    @Override
    public List<OriginalDocumentTask> getByOrderStep(final Long orderStepId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, orderStepId);
            }
        });
    }

    @Override
    public List<OriginalDocumentTask> getByOrder(OriginalDocumentOrder originalDocumentOrder) {
        return this.getByOrder(originalDocumentOrder.getId());
    }

    @Override
    public List<OriginalDocumentTask> getByOrder(final Long originalDocumentOrderId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, originalDocumentOrderId);
            }
        });
    }

    @Override
    public List<OriginalDocumentTask> getByTasks(Collection<Long> documentVersionTaskId) {
        if (documentVersionTaskId.isEmpty()) {
            return new ArrayList<OriginalDocumentTask>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentVersionTaskId.size()];
        int n = 0;
        Iterator<Long> it = documentVersionTaskId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<OriginalDocumentTask> getByOrderSteps(Collection<Long> orderStepId) {
        if (orderStepId.isEmpty()) {
            return new ArrayList<OriginalDocumentTask>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[orderStepId.size()];
        int n = 0;
        Iterator<Long> it = orderStepId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<OriginalDocumentTask> getByOrders(Collection<Long> originalDocumentOrderId) {
        if (originalDocumentOrderId.isEmpty()) {
            return new ArrayList<OriginalDocumentTask>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[originalDocumentOrderId.size()];
        int n = 0;
        Iterator<Long> it = originalDocumentOrderId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

