/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.masterData;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.api.masterData.MasterDataItem;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.MasterDataSetDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.masterData.MasterDataPdfCols;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.odf.util.voc.StyleFamily;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.w3c.dom.Node;

public class MasterDataPdfExporter {
    private MasterDataSetDAO masterDataSetDAO;
    private NetworkDAO networkDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private String odfStylePrefix;
    private OOoFileEngine oooFileEngine;
    private Long odfTimeout;
    private PersonVariablesDAO personVariablesDAO;
    private String tempDir;
    private Boolean enableCustomerLogo;
    private String costumerLabel;

    public void setMasterDataSetDAO(MasterDataSetDAO masterDataSetDAO) {
        this.masterDataSetDAO = masterDataSetDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public ScratchFile export(Long organisationPersonId, Long networkId, List<MasterDataItem> items, String caption, Long masterDataSetId, boolean withCode, boolean withDescription) throws Exception {
        String personVariablesUserLocale = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        Network network = (Network)this.networkDAO.get(networkId);
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles contentOfficeStyles = context.getContentOfficeStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, this.enableCustomerLogo);
        String leftFooterLabel = caption + " \u2015 " + resourceBundle.getString("network") + " " + network.getName();
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", null);
        String dataParagraphStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{dataTextProperties});
        StyleTextPropertiesElement textPropertiesElement = stylesAutomaticStyles.constructTextPropertiesWithFontWeight("bold");
        String leftFooterTextStyle = stylesAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{textPropertiesElement});
        StyleParagraphPropertiesElement paragraphProperties = OdfHelper.constructStandardParagraphProperties(stylesOfficeStyles);
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabel, leftFooterTextStyle, dataParagraphStyle, resourceBundle);
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", "bold");
        String headerParagraphStyle = contentAutomaticStyles.getParagraphStyle(new OdfStylePropertiesBase[]{headerTextProperties});
        TextHElement textHElement = officeText.newTextHElement(1);
        textHElement.setTextContent(caption);
        if (masterDataSetId != null) {
            this.constructMasterDataSetTable(officeText, network, masterDataSetId, resourceBundle, contentAutomaticStyles, headerParagraphStyle, dataParagraphStyle);
        }
        officeText.newTextPElement();
        this.appendDataTable(officeText, items, resourceBundle, (Styles)stylesAutomaticStyles, contentAutomaticStyles, standardParagraphStyle, withCode, withDescription);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDir, (String)("cdes_" + caption + ""), (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = caption;
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private TableTableElement constructMasterDataSetTable(OfficeTextElement parentElement, Network network, Long masterDataSetId, ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerTextStyle, String dataTextStyle) {
        MasterDataSet masterDataSet = (MasterDataSet)this.masterDataSetDAO.get(masterDataSetId);
        String networkName = network.getName();
        String masterDataSetName = masterDataSet.getName();
        String masterDataSetDescription = masterDataSet.getDescription() != null ? masterDataSet.getDescription() : "";
        TableTableElement tableElement = this.constructEmptyTable((Node)parentElement, contentAutomaticStyles);
        this.constructRow(tableElement, resourceBundle.getString("network"), networkName, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("masterDataSet"), masterDataSetName, headerTextStyle, dataTextStyle);
        this.constructRow(tableElement, resourceBundle.getString("description"), masterDataSetDescription, headerTextStyle, dataTextStyle);
        return tableElement;
    }

    private TableTableElement constructEmptyTable(Node parentElement, Styles contentAutomaticStyles) {
        TableTableElement tableElement = TableFactory.constructTableElement((Node)parentElement, null);
        TableFactory.appendColumnWithRelativeSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"225*");
        TableFactory.appendColumnWithRelativeSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"775*");
        return tableElement;
    }

    private TableTableRowElement constructRow(TableTableElement parentElement, String header, String text, String headerTextStyle, String dataTextStyle) {
        if (text == null) {
            text = "";
        }
        TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)parentElement, null);
        TableFactory.appendTextStyledCell((String)headerTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{header + " "});
        TableFactory.appendTextStyledCell((String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{text});
        return rowElement;
    }

    private void appendDataTable(OfficeTextElement officeText, List<MasterDataItem> items, ResourceBundle resourceBundle, Styles stylesAutomaticStyles, Styles contentAutomaticStyles, String standardParagraphStyle, boolean withCodeColumn, boolean withDescriptionColumn) {
        String headerCellStyle = OdfHelper.getDataTableHeaderCellStyle(contentAutomaticStyles);
        String headerTextStyle = OdfHelper.getDataTableHeaderTextStyle(contentAutomaticStyles, standardParagraphStyle);
        String dataTextStyle = OdfHelper.getDataTableDataTextStyle(contentAutomaticStyles, standardParagraphStyle);
        StyleTextPropertiesElement dataTextPropertiesCaption = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", "bold");
        String dataTextStyleCaption = contentAutomaticStyles.getStyleWithParent(StyleFamily.TABLE_CELL.getValue(), standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextPropertiesCaption});
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("no-wrap");
        dataCellProperties.setStyleVerticalAlignAttribute("top");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        StyleTableCellPropertiesElement dataCellPropertiesCaption = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#C0C0C0", "0.097cm", "0.05pt solid #000000");
        dataCellPropertiesCaption.setFoWrapOptionAttribute("no-wrap");
        dataCellPropertiesCaption.setStyleVerticalAlignAttribute("top");
        String dataCellStyleCaption = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellPropertiesCaption});
        ArrayList columnSortSpecs = new ArrayList();
        boolean withGrouping = false;
        for (MasterDataItem item : items) {
            if (item.getParentId() == null) continue;
            withGrouping = true;
        }
        FancyOdfTable<MasterDataItem> odfTable = this.constructTable(resourceBundle, stylesAutomaticStyles, contentAutomaticStyles, standardParagraphStyle, headerCellStyle, headerTextStyle, dataCellStyle, dataCellStyleCaption, dataTextStyle, dataTextStyleCaption, withCodeColumn, withDescriptionColumn, withGrouping);
        odfTable.render((Node)officeText, items, columnSortSpecs);
    }

    private FancyOdfTable<MasterDataItem> constructTable(ResourceBundle resourceBundle, Styles stylesAutomaticStyles, Styles contentAutomaticStyles, String standardParagraphStyle, String headerCellStyle, String headerTextStyle, String dataCellStyle, String dataCellStyleCaption, String dataTextStyle, String dataTextStyleCaption, boolean withCodeColumn, boolean withDescriptionColumn, boolean withGrouping) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        List<FancyOdfTableColumn<MasterDataItem>> columns = this.constructDataColumns(resourceBundle, collator, contentAutomaticStyles, standardParagraphStyle, dataCellStyle, dataCellStyleCaption, dataTextStyle, dataTextStyleCaption, withCodeColumn, withDescriptionColumn, withGrouping);
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        Map<String, Double> columnIdToRelativeWidth = this.constructRelativeColumnWidths();
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), columnIdToRelativeWidth, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private Map<String, Double> constructRelativeColumnWidths() {
        HashMap<String, Double> columnIdToRelativeWidth = new HashMap<String, Double>();
        columnIdToRelativeWidth.put(MasterDataPdfCols.CODE.getValue(), 0.2);
        columnIdToRelativeWidth.put(MasterDataPdfCols.NAME.getValue(), 0.4);
        columnIdToRelativeWidth.put(MasterDataPdfCols.DESCRIPTION.getValue(), 0.4);
        return columnIdToRelativeWidth;
    }

    private List<FancyOdfTableColumn<MasterDataItem>> constructDataColumns(ResourceBundle resourceBundle, final Collator collator, Styles contentAutomaticStyles, String standardParagraphStyle, final String dataCellStyle, final String dataCellStyleCaption, final String dataTextStyle, final String dataTextStyleCaption, boolean withCodeColumn, boolean withDescriptionColumn, final boolean withGrouping) {
        ArrayList<FancyOdfTableColumn<MasterDataItem>> columns = new ArrayList<FancyOdfTableColumn<MasterDataItem>>();
        if (withCodeColumn) {
            columns.add(new FancyOdfTableColumn<MasterDataItem>(MasterDataPdfCols.CODE.getValue(), resourceBundle.getString("code")){

                public void appendCell(TableTableRowElement rowElement, MasterDataItem item) {
                    String cellStyle = withGrouping && item.getParentId() == null ? dataCellStyleCaption : dataCellStyle;
                    String textStyle = withGrouping && item.getParentId() == null ? dataTextStyleCaption : dataTextStyle;
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement);
                    String text = this.getText(item);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, (String)dataTextStyle);
                }

                public int compare(MasterDataItem itemOne, MasterDataItem itemTwo, boolean descending) {
                    String textOne = this.getText(itemOne);
                    String textTwo = this.getText(itemTwo);
                    return CompareHelper.defaultStringCompare(collator, textOne, textTwo, descending);
                }

                private String getText(MasterDataItem item) {
                    return item.getCode();
                }
            });
        }
        columns.add(new FancyOdfTableColumn<MasterDataItem>(MasterDataPdfCols.NAME.getValue(), resourceBundle.getString("name")){

            public void appendCell(TableTableRowElement rowElement, MasterDataItem item) {
                String cellStyle = withGrouping && item.getParentId() == null ? dataCellStyleCaption : dataCellStyle;
                String textStyle = withGrouping && item.getParentId() == null ? dataTextStyleCaption : dataTextStyle;
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement);
                String text = this.getText(item);
                TextFactory.constructTextNode((Node)cellElement, (String)text, (String)dataTextStyle);
            }

            public int compare(MasterDataItem itemOne, MasterDataItem itemTwo, boolean descending) {
                String textOne = this.getText(itemOne);
                String textTwo = this.getText(itemTwo);
                return CompareHelper.defaultStringCompare(collator, textOne, textTwo, descending);
            }

            private String getText(MasterDataItem item) {
                return item.getName();
            }
        });
        if (withDescriptionColumn) {
            columns.add(new FancyOdfTableColumn<MasterDataItem>(MasterDataPdfCols.DESCRIPTION.getValue(), resourceBundle.getString("description")){

                public void appendCell(TableTableRowElement rowElement, MasterDataItem item) {
                    String cellStyle = withGrouping && item.getParentId() == null ? dataCellStyleCaption : dataCellStyle;
                    String textStyle = withGrouping && item.getParentId() == null ? dataTextStyleCaption : dataTextStyle;
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement);
                    String text = this.getText(item);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, (String)dataTextStyle);
                }

                public int compare(MasterDataItem itemOne, MasterDataItem itemTwo, boolean descending) {
                    String textOne = this.getText(itemOne);
                    String textTwo = this.getText(itemTwo);
                    return CompareHelper.defaultStringCompare(collator, textOne, textTwo, descending);
                }

                private String getText(MasterDataItem item) {
                    return item.getDescription();
                }
            });
        }
        return columns;
    }
}

