/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.joinDto.ReviewProtocolBaseJoin;
import at.cdes.api.joinDto.ReviewProtocolVersionJoin;
import at.cdes.impl.util.holiday.HolidayCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ReviewProtocolContext {
    private ReviewProtocolBaseJoin baseJoin;
    private Map<Long, ReviewProtocolVersionJoin> documentVersionIdToVersionJoin;
    private Map<Long, ReviewProtocolVersionJoin> cellResultIdToResultJoin;
    private Map<Long, ReviewProtocolVersionJoin> nodeResultIdToResultJoin;
    private Map<Long, Map<Long, ReviewProtocolVersionJoin>> cellResultIdToNodeResultIdToNodeResult;
    private Map<Long, Map<Long, ReviewProtocolVersionJoin>> nodeResultIdToPositionResultIdToPositionResult;
    private Map<Long, ReviewProtocolVersionJoin> idToResultOptionJoin;
    private Map<Long, List<ReviewProtocolVersionJoin>> positionTypeIdToResultOptionJoins;
    private Map<Long, ReviewProtocolVersionJoin> idToCellInstanceReleasedJoin;
    private Map<Long, List<ReviewProtocolVersionJoin>> cellInstanceReleasedIdToNodeJoins;
    private HolidayCalculator holidayCalculator;

    public ReviewProtocolBaseJoin getBaseJoin() {
        return this.baseJoin;
    }

    public void setBaseJoin(ReviewProtocolBaseJoin baseJoin) {
        this.baseJoin = baseJoin;
    }

    public Map<Long, ReviewProtocolVersionJoin> getDocumentVersionIdToVersionJoin() {
        return this.documentVersionIdToVersionJoin;
    }

    public void setDocumentVersionIdToVersionJoin(Map<Long, ReviewProtocolVersionJoin> documentVersionIdToVersionJoin) {
        this.documentVersionIdToVersionJoin = documentVersionIdToVersionJoin;
    }

    public Map<Long, ReviewProtocolVersionJoin> getCellResultIdToResultJoin() {
        return this.cellResultIdToResultJoin;
    }

    public void setCellResultIdToResultJoin(Map<Long, ReviewProtocolVersionJoin> cellResultIdToResultJoin) {
        this.cellResultIdToResultJoin = cellResultIdToResultJoin;
    }

    public Map<Long, ReviewProtocolVersionJoin> getNodeResultIdToResultJoin() {
        return this.nodeResultIdToResultJoin;
    }

    public void setNodeResultIdToResultJoin(Map<Long, ReviewProtocolVersionJoin> nodeResultIdToResultJoin) {
        this.nodeResultIdToResultJoin = nodeResultIdToResultJoin;
    }

    public Map<Long, Map<Long, ReviewProtocolVersionJoin>> getCellResultIdToNodeResultIdToNodeResult() {
        return this.cellResultIdToNodeResultIdToNodeResult;
    }

    public void setCellResultIdToNodeResultIdToNodeResult(Map<Long, Map<Long, ReviewProtocolVersionJoin>> cellResultIdToNodeResultIdToNodeResult) {
        this.cellResultIdToNodeResultIdToNodeResult = cellResultIdToNodeResultIdToNodeResult;
    }

    public Map<Long, Map<Long, ReviewProtocolVersionJoin>> getNodeResultIdToPositionResultIdToPositionResult() {
        return this.nodeResultIdToPositionResultIdToPositionResult;
    }

    public void setNodeResultIdToPositionResultIdToPositionResult(Map<Long, Map<Long, ReviewProtocolVersionJoin>> nodeResultIdToPositionResultIdToPositionResult) {
        this.nodeResultIdToPositionResultIdToPositionResult = nodeResultIdToPositionResultIdToPositionResult;
    }

    public Collection<ReviewProtocolVersionJoin> getNodeResultsForCellResult(Long reviewCycleCellResultId) {
        return this.cellResultIdToNodeResultIdToNodeResult.get(reviewCycleCellResultId).values();
    }

    public ReviewProtocolVersionJoin getVersionJoinByDocumentVersion(Long documentVersionId) {
        return this.documentVersionIdToVersionJoin.get(documentVersionId);
    }

    public ReviewProtocolVersionJoin getLastDocumentVersionJoin() {
        ReviewProtocolVersionJoin lastVersionJoin = null;
        for (ReviewProtocolVersionJoin versionJoin : this.documentVersionIdToVersionJoin.values()) {
            if (versionJoin.getDocumentVersionUploaded() == null || lastVersionJoin != null && !(versionJoin.getDocumentVersionUploaded() > lastVersionJoin.getDocumentVersionUploaded())) continue;
            lastVersionJoin = versionJoin;
        }
        return lastVersionJoin;
    }

    public List<ReviewProtocolVersionJoin> getCellResultJoinsSortedByUploaded() {
        ArrayList<ReviewProtocolVersionJoin> cellResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
        cellResultJoins.addAll(this.getCellResultIdToResultJoin().values());
        Collections.sort(cellResultJoins, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo) {
                Double uploadedOne = versionJoinOne.getDocumentVersionUploaded() != null ? versionJoinOne.getDocumentVersionUploaded() : 0.0;
                Double uploadedTwo = versionJoinTwo.getDocumentVersionUploaded() != null ? versionJoinTwo.getDocumentVersionUploaded() : 0.0;
                if (uploadedOne < uploadedTwo) {
                    return -1;
                }
                if (uploadedOne > uploadedTwo) {
                    return 1;
                }
                return 0;
            }
        });
        return cellResultJoins;
    }

    public List<ReviewProtocolVersionJoin> getNodeResultJoinsSortedByPosition(Long cellResultId) {
        Map<Long, ReviewProtocolVersionJoin> nodeResultIdToJoins = this.cellResultIdToNodeResultIdToNodeResult.get(cellResultId);
        ArrayList<ReviewProtocolVersionJoin> nodeResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
        nodeResultJoins.addAll(nodeResultIdToJoins.values());
        Collections.sort(nodeResultJoins, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo) {
                Integer positionOne = versionJoinOne.getReviewCycleNodePosition() != null ? versionJoinOne.getReviewCycleNodePosition() : 0;
                Integer positionTwo = versionJoinTwo.getReviewCycleNodePosition() != null ? versionJoinTwo.getReviewCycleNodePosition() : 0;
                if (positionOne < positionTwo) {
                    return -1;
                }
                if (positionOne > positionTwo) {
                    return 1;
                }
                return 0;
            }
        });
        return nodeResultJoins;
    }

    public List<ReviewProtocolVersionJoin> getPositionResultJoinsSortedByResultDate(Long nodeResultId) {
        Map<Long, ReviewProtocolVersionJoin> positionResultIdToJoins = this.nodeResultIdToPositionResultIdToPositionResult.get(nodeResultId);
        ArrayList<ReviewProtocolVersionJoin> positionResultJoins = new ArrayList<ReviewProtocolVersionJoin>();
        if (positionResultIdToJoins == null || positionResultIdToJoins.size() == 0) {
            return new ArrayList<ReviewProtocolVersionJoin>();
        }
        positionResultJoins.addAll(positionResultIdToJoins.values());
        Collections.sort(positionResultJoins, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin positionResultJoinOne, ReviewProtocolVersionJoin positionResultJoinTwo) {
                Double resultDateOne = positionResultJoinOne.getReviewCyclePositionResultResultDate();
                Double resultDateTwo = positionResultJoinTwo.getReviewCyclePositionResultResultDate();
                if (resultDateOne == null) {
                    resultDateOne = Double.MAX_VALUE;
                }
                if (resultDateTwo == null) {
                    resultDateTwo = Double.MAX_VALUE;
                }
                if (resultDateOne < resultDateTwo) {
                    return -1;
                }
                if (resultDateOne > resultDateTwo) {
                    return 1;
                }
                return 0;
            }
        });
        return positionResultJoins;
    }

    public Map<Long, ReviewProtocolVersionJoin> getIdToResultOptionJoin() {
        return this.idToResultOptionJoin;
    }

    public void setIdToResultOptionJoin(Map<Long, ReviewProtocolVersionJoin> idToResultOptionJoin) {
        this.idToResultOptionJoin = idToResultOptionJoin;
    }

    public ReviewProtocolVersionJoin getResultOptionJoin(Long reviewCycleResultOptionId) {
        return this.idToResultOptionJoin.get(reviewCycleResultOptionId);
    }

    public Map<Long, List<ReviewProtocolVersionJoin>> getPositionTypeIdToResultOptionJoins() {
        return this.positionTypeIdToResultOptionJoins;
    }

    public void setPositionTypeIdToResultOptionJoins(Map<Long, List<ReviewProtocolVersionJoin>> positionTypeIdToResultOptionJoins) {
        this.positionTypeIdToResultOptionJoins = positionTypeIdToResultOptionJoins;
    }

    public int getNumberOfPositionTypeResultOptions(Long positionTypeId) {
        if (!this.positionTypeIdToResultOptionJoins.containsKey(positionTypeId)) {
            return 0;
        }
        return this.positionTypeIdToResultOptionJoins.get(positionTypeId).size();
    }

    public boolean isEndPositionType(Long positionTypeId) {
        return this.getNumberOfPositionTypeResultOptions(positionTypeId) == 0;
    }

    public Map<Long, ReviewProtocolVersionJoin> getIdToCellInstanceReleasedJoin() {
        return this.idToCellInstanceReleasedJoin;
    }

    public void setIdToCellInstanceReleasedJoin(Map<Long, ReviewProtocolVersionJoin> idToCellInstanceReleasedJoin) {
        this.idToCellInstanceReleasedJoin = idToCellInstanceReleasedJoin;
    }

    public Map<Long, List<ReviewProtocolVersionJoin>> getCellInstanceReleasedIdToNodeJoins() {
        return this.cellInstanceReleasedIdToNodeJoins;
    }

    public void setCellInstanceReleasedIdToNodeJoins(Map<Long, List<ReviewProtocolVersionJoin>> cellInstanceReleasedIdToNodeJoins) {
        this.cellInstanceReleasedIdToNodeJoins = cellInstanceReleasedIdToNodeJoins;
    }

    public List<ReviewProtocolVersionJoin> getAllCellInstanceReleasedJoinsSortedByPosition() {
        Collection<ReviewProtocolVersionJoin> backedJoinsCollection = this.idToCellInstanceReleasedJoin.values();
        ArrayList<ReviewProtocolVersionJoin> joinsList = new ArrayList<ReviewProtocolVersionJoin>();
        joinsList.addAll(backedJoinsCollection);
        Collections.sort(joinsList, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo) {
                Integer positionOne = versionJoinOne.getReviewCycleCellPosition() != null ? versionJoinOne.getReviewCycleCellPosition() : Integer.MAX_VALUE;
                Integer positionTwo = versionJoinTwo.getReviewCycleCellPosition() != null ? versionJoinTwo.getReviewCycleCellPosition() : Integer.MAX_VALUE;
                if (positionOne < positionTwo) {
                    return -1;
                }
                if (positionOne > positionTwo) {
                    return 1;
                }
                return 0;
            }
        });
        return joinsList;
    }

    public List<ReviewProtocolVersionJoin> getNodeInstanceReleasedJoinsSortedByPosition(Long reviewCycleCellInstanceReleasedId) {
        List<ReviewProtocolVersionJoin> backedNodeInstanceReleasedJoins = this.cellInstanceReleasedIdToNodeJoins.get(reviewCycleCellInstanceReleasedId);
        if (backedNodeInstanceReleasedJoins == null) {
            return new ArrayList<ReviewProtocolVersionJoin>();
        }
        ArrayList<ReviewProtocolVersionJoin> nodeInstanceReleasedJoins = new ArrayList<ReviewProtocolVersionJoin>();
        nodeInstanceReleasedJoins.addAll(backedNodeInstanceReleasedJoins);
        Collections.sort(nodeInstanceReleasedJoins, new Comparator<ReviewProtocolVersionJoin>(){

            @Override
            public int compare(ReviewProtocolVersionJoin versionJoinOne, ReviewProtocolVersionJoin versionJoinTwo) {
                Integer positionOne = versionJoinOne.getReviewCycleNodePosition() != null ? versionJoinOne.getReviewCycleNodePosition() : 0;
                Integer positionTwo = versionJoinTwo.getReviewCycleNodePosition() != null ? versionJoinTwo.getReviewCycleNodePosition() : 0;
                if (positionOne < positionTwo) {
                    return -1;
                }
                if (positionOne > positionTwo) {
                    return 1;
                }
                return 0;
            }
        });
        return nodeInstanceReleasedJoins;
    }

    public HolidayCalculator getHolidayCalculator() {
        return this.holidayCalculator;
    }

    public void setHolidayCalculator(HolidayCalculator holidayCalculator) {
        this.holidayCalculator = holidayCalculator;
    }
}

