/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestList;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.log4j.Logger;

public abstract class ReviewResultDigestCalculator
implements DigestCalculator {
    static Logger logger = Logger.getLogger(ReviewResultDigestCalculator.class);

    public abstract String getPositionResultHash(ReviewCyclePositionResult var1) throws DigestCalculatorException;

    @Override
    public String getSignableContent(Object o) throws DigestCalculatorException {
        DigestList<String> list = new DigestList<String>();
        this.getSignableContentIteration(o, list);
        return list.toString();
    }

    public void getSignableContentIteration(Object o, DigestList<String> list) throws DigestCalculatorException {
        if (o instanceof ReviewCyclePositionResult) {
            ReviewCyclePositionResult object = (ReviewCyclePositionResult)o;
            if (object.getDigest() == null) {
                this.getPositionResultHash(object);
            } else {
                list.add(object.getDigest());
            }
        } else {
            throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation (ReviewResultDigestCalculator)");
        }
    }

    protected MessageDigest getMessageDigest() throws DigestCalculatorException {
        try {
            return MessageDigest.getInstance("SHA1", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
        catch (NoSuchProviderException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
    }

    @Override
    public String getDigest(Object o) throws DigestCalculatorException {
        if (o instanceof ReviewCyclePositionResult) {
            return this.getPositionResultHash((ReviewCyclePositionResult)o);
        }
        throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation (ReviewResultDigestCalculator)");
    }

    @Override
    public boolean validate(byte[] digest, Object o) throws DigestCalculatorException {
        byte[] newDigest = this.getDigest(o).getBytes();
        return MessageDigest.isEqual(newDigest, digest);
    }
}

