/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.spring;

import at.cdes.spring.RunnableInvocation;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

public class InterceptedRunnable
implements Runnable,
Destroyable {
    private static final Logger log = Logger.getLogger(InterceptedRunnable.class);
    private final MethodInvocation invocation;
    private final MethodInterceptor interceptor;

    public InterceptedRunnable(MethodInvocation invocation, MethodInterceptor interceptor) {
        this.invocation = invocation;
        this.interceptor = interceptor;
    }

    public InterceptedRunnable(Runnable runnable, MethodInterceptor interceptor) {
        this.invocation = new RunnableInvocation(runnable);
        this.interceptor = interceptor;
    }

    @Override
    public void run() {
        try {
            this.interceptor.invoke(this.invocation);
        }
        catch (Throwable e) {
            log.error((Object)"Caught exception in intercepted method runnable", e);
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (this.invocation instanceof Destroyable) {
            ((Destroyable)this.invocation).destroy();
        }
    }

    @Override
    public boolean isDestroyed() {
        if (this.invocation instanceof Destroyable) {
            return ((Destroyable)this.invocation).isDestroyed();
        }
        return true;
    }
}

